
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "grl_metakernel_misc.h"

#include "genxml/gen_macros.h"
#include "genxml/genX_pack.h"
#include "genxml/genX_rt_pack.h"

/* We reserve :
 *    - GPR 14 for secondary command buffer returns
 *    - GPR 15 for conditional rendering
 */
#define MI_BUILDER_NUM_ALLOC_GPRS 14
#define __gen_get_batch_dwords anv_batch_emit_dwords
#define __gen_address_offset anv_address_add
#define __gen_get_batch_address(b, a) anv_batch_address(b, a)
#include "common/mi_builder.h"

#define MI_PREDICATE_RESULT mi_reg32(0x2418)
#define DISPATCHDIM_X mi_reg32(0x2500)
#define DISPATCHDIM_Y mi_reg32(0x2504)
#define DISPATCHDIM_Z mi_reg32(0x2508)
static const uint64_t COPY_MOCK_GROUP_SIZE = 16;
void
genX(grl_misc_batched_init_globals)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t p_data,
    uint32_t numWgs)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { numWgs, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = p_data },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_BATCHED_INIT_GLOBALS,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instances)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescsBuffer,
    uint64_t totalSizeToCopy,
    uint32_t numThreads)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { numThreads, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescsBuffer },
            { .u64 = totalSizeToCopy },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCES,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instances_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescsBuffer,
    uint64_t indirectBuildRangeInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp0 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp1 = mi_ushr_imm(&b, _tmp0, 2);
    struct mi_value _tmp2 = mi_iadd(&b, _tmp1, mi_imm(3));
    struct mi_value _tmp3 = mi_value_half(_tmp2, false);
    mi_store(&b, DISPATCHDIM_X, _tmp3);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescsBuffer },
            { .u64 = indirectBuildRangeInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCES_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instance_ptrs)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescPtrsBuffer,
    uint64_t totalSizeToCopy,
    uint32_t numThreads)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { numThreads, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescPtrsBuffer },
            { .u64 = totalSizeToCopy },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instance_ptrs_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescPtrsBuffer,
    uint64_t indirectBuildRangeInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp4 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp5 = mi_ushr_imm(&b, _tmp4, 2);
    struct mi_value _tmp6 = mi_iadd(&b, _tmp5, mi_imm(3));
    struct mi_value _tmp7 = mi_value_half(_tmp6, false);
    mi_store(&b, DISPATCHDIM_X, _tmp7);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescPtrsBuffer },
            { .u64 = indirectBuildRangeInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instances_base_ptr)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescsBuffer,
    uint64_t totalSizeToCopy,
    uint32_t numThreads)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { numThreads, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescsBuffer },
            { .u64 = totalSizeToCopy },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instances_base_ptr_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescsBuffer,
    uint64_t indirectBuildRangeInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp8 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp9 = mi_ushr_imm(&b, _tmp8, 2);
    struct mi_value _tmp10 = mi_iadd(&b, _tmp9, mi_imm(3));
    struct mi_value _tmp11 = mi_value_half(_tmp10, false);
    mi_store(&b, DISPATCHDIM_X, _tmp11);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescsBuffer },
            { .u64 = indirectBuildRangeInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instance_ptrs_base_ptr)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescPtrsBuffer,
    uint64_t totalSizeToCopy,
    uint32_t numThreads)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { numThreads, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescPtrsBuffer },
            { .u64 = totalSizeToCopy },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_instance_ptrs_base_ptr_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t instanceDescPtrsBuffer,
    uint64_t indirectBuildRangeInfo)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp12 = mi_mem32(anv_address_from_u64(indirectBuildRangeInfo));
    struct mi_value _tmp13 = mi_ushr_imm(&b, _tmp12, 2);
    struct mi_value _tmp14 = mi_iadd(&b, _tmp13, mi_imm(3));
    struct mi_value _tmp15 = mi_value_half(_tmp14, false);
    mi_store(&b, DISPATCHDIM_X, _tmp15);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = instanceDescPtrsBuffer },
            { .u64 = indirectBuildRangeInfo },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_geo_descs)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t private_dest,
    uint64_t transient_src,
    uint64_t indirectBuildRangeInfo,
    uint32_t numGeometries)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp16 = (numGeometries + 16);
    uint64_t _tmp17 = (_tmp16 - 1);
    uint64_t _tmp18 = (_tmp17 / 16);
    {
        const uint32_t _group_size[3] = { _tmp18, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = private_dest },
            { .u64 = transient_src },
            { .u64 = indirectBuildRangeInfo },
            { .u64 = numGeometries },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_GEO_DESCS_INDIRECT_BUILD,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_geo_meta_data)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t bvh_buffer,
    uint64_t geomdesc_buffer,
    uint64_t totalSizeToCopy,
    uint32_t numThreads)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { numThreads, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = bvh_buffer },
            { .u64 = geomdesc_buffer },
            { .u64 = totalSizeToCopy },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_GEO_META_DATA,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_copy_mock)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint32_t size)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp19 = (size + COPY_MOCK_GROUP_SIZE);
    uint64_t _tmp20 = (_tmp19 - 1);
    uint64_t _tmp21 = (_tmp20 / COPY_MOCK_GROUP_SIZE);
    {
        const uint32_t _group_size[3] = { _tmp21, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = src },
            { .u64 = size },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_COPY_MOCK,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_memset)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint32_t byte,
    uint32_t size)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    uint64_t _tmp22 = (size + 32);
    uint64_t _tmp23 = (_tmp22 - 1);
    uint64_t _tmp24 = (_tmp23 / 32);
    {
        const uint32_t _group_size[3] = { _tmp24, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = byte },
            { .u64 = size },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_MEM_SET,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_misc_memset_size_ptr)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint32_t byte,
    uint64_t sizePtr)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp25 = mi_mem32(anv_address_from_u64(sizePtr));
    struct mi_value _tmp26 = mi_iadd(&b, _tmp25, mi_imm(32));
    struct mi_value _tmp27 = mi_isub(&b, _tmp26, mi_imm(1));
    struct mi_value _tmp28 = mi_ushr_imm(&b, _tmp27, 4);
    struct mi_value _tmp29 = mi_ushr_imm(&b, _tmp28, 1);
    struct mi_value _tmp30 = mi_value_half(_tmp29, false);
    mi_store(&b, DISPATCHDIM_X, _tmp30);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = byte },
            { .u64 = sizePtr },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_MISC_MEM_SET_SIZE_PTR,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}