
/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "grl_metakernel_copy.h"

#include "genxml/gen_macros.h"
#include "genxml/genX_pack.h"
#include "genxml/genX_rt_pack.h"

/* We reserve :
 *    - GPR 14 for secondary command buffer returns
 *    - GPR 15 for conditional rendering
 */
#define MI_BUILDER_NUM_ALLOC_GPRS 14
#define __gen_get_batch_dwords anv_batch_emit_dwords
#define __gen_address_offset anv_address_add
#define __gen_get_batch_address(b, a) anv_batch_address(b, a)
#include "common/mi_builder.h"

#define MI_PREDICATE_RESULT mi_reg32(0x2418)
#define DISPATCHDIM_X mi_reg32(0x2500)
#define DISPATCHDIM_Y mi_reg32(0x2504)
#define DISPATCHDIM_Z mi_reg32(0x2508)
void
genX(grl_copy_clone_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint64_t srcBVHsizedwordAddr)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp0 = mi_mem32(anv_address_from_u64(srcBVHsizedwordAddr));
    struct mi_value _tmp1 = mi_ushr_imm(&b, _tmp0, 8);
    struct mi_value _tmp2 = mi_iadd(&b, _tmp1, mi_imm(4));
    struct mi_value _tmp3 = mi_value_half(_tmp2, false);
    mi_store(&b, DISPATCHDIM_X, _tmp3);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = src },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_COPY_CLONE_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_copy_compact)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { 32, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = src },
            { .u64 = 32 },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_COPY_COMPACT,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_copy_serialize_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint64_t driverID,
    uint64_t srcBVHsizedwordAddr)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp4 = mi_mem32(anv_address_from_u64(srcBVHsizedwordAddr));
    struct mi_value _tmp5 = mi_ushr_imm(&b, _tmp4, 8);
    struct mi_value _tmp6 = mi_iadd(&b, _tmp5, mi_imm(4));
    struct mi_value _tmp7 = mi_value_half(_tmp6, false);
    mi_store(&b, DISPATCHDIM_X, _tmp7);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = src },
            { .u64 = driverID },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_COPY_SERIALIZE_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_copy_serialize_for_input_dump_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t batchPtrs,
    uint64_t dstOffset,
    uint64_t src,
    uint64_t driverID,
    uint64_t srcBVHsizedwordAddr)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp8 = mi_mem32(anv_address_from_u64(srcBVHsizedwordAddr));
    struct mi_value _tmp9 = mi_ushr_imm(&b, _tmp8, 8);
    struct mi_value _tmp10 = mi_iadd(&b, _tmp9, mi_imm(4));
    struct mi_value _tmp11 = mi_value_half(_tmp10, false);
    mi_store(&b, DISPATCHDIM_X, _tmp11);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = batchPtrs },
            { .u64 = dstOffset },
            { .u64 = src },
            { .u64 = driverID },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_COPY_SERIALIZE_FOR_INPUT_DUMP_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_copy_deserialize_indirect)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src,
    uint64_t srcBVHsizedwordAddr)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    struct mi_value _tmp12 = mi_mem32(anv_address_from_u64(srcBVHsizedwordAddr));
    struct mi_value _tmp13 = mi_ushr_imm(&b, _tmp12, 8);
    struct mi_value _tmp14 = mi_iadd(&b, _tmp13, mi_imm(4));
    struct mi_value _tmp15 = mi_value_half(_tmp14, false);
    mi_store(&b, DISPATCHDIM_X, _tmp15);
    mi_store(&b, DISPATCHDIM_Y, mi_imm(1));
    mi_store(&b, DISPATCHDIM_Z, mi_imm(1));
    {
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = src },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_COPY_DESERIALIZE_INDIRECT,
                           NULL, ARRAY_SIZE(_args), _args);
    }
}
void
genX(grl_copy_dxr_decode)(
    struct anv_cmd_buffer *cmd_buffer,
    uint64_t dest,
    uint64_t src)
{
    struct mi_builder b;
    mi_builder_init(&b, cmd_buffer->device->info, &cmd_buffer->batch);
    /* TODO: use anv_mocs? */
    const uint32_t mocs = isl_mocs(&cmd_buffer->device->isl_dev, 0, false);
    mi_builder_set_mocs(&b, mocs);
    
    
    
    {
        const uint32_t _group_size[3] = { 1, 1, 1 };
        const struct anv_kernel_arg _args[] = {
            { .u64 = dest },
            { .u64 = src },
        };
        genX(grl_dispatch)(cmd_buffer, GRL_CL_KERNEL_BVH_COPY_DXR_DECODE,
                           _group_size, ARRAY_SIZE(_args), _args);
    }
}