/*
 * Copyright 2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/* This file generated from grl_cl_kernel_gen.py, don't edit directly. */

#include "grl_cl_kernel.h"

#include "gfx125_bvh_build_BFS_BFS_pass1_indexed.h"
#include "gfx125_bvh_build_BFS_BFS_pass1_indexed_batchable.h"
#include "gfx125_bvh_build_BFS_BFS_pass1_initial.h"
#include "gfx125_bvh_build_BFS_BFS_pass1_initial_batchable.h"
#include "gfx125_bvh_build_BFS_BFS_pass2_indexed.h"
#include "gfx125_bvh_build_BFS_BFS_pass2_indexed_batchable.h"
#include "gfx125_bvh_build_BFS_BFS_pass2_initial.h"
#include "gfx125_bvh_build_BFS_BFS_pass2_initial_batchable.h"
#include "gfx125_bvh_build_BFS_DFS.h"
#include "gfx125_bvh_build_BFS_begin.h"
#include "gfx125_bvh_build_BFS_begin_batchable.h"
#include "gfx125_bvh_build_BFS_build_qnodes_begin_batchable.h"
#include "gfx125_bvh_build_BFS_build_qnodes_init_scheduler_batched.h"
#include "gfx125_bvh_build_BFS_build_qnodes_pc_amplify.h"
#include "gfx125_bvh_build_BFS_build_qnodes_pc_amplify_batched.h"
#include "gfx125_bvh_build_BFS_build_qnodes_pc_kickoff.h"
#include "gfx125_bvh_build_BFS_build_qnodes_scheduler.h"
#include "gfx125_bvh_build_BFS_build_qnodes_try_to_fill_grb_batched.h"
#include "gfx125_bvh_build_BFS_categorize_builds_and_init_scheduler.h"
#include "gfx125_bvh_build_BFS_scheduler.h"
#include "gfx125_bvh_build_DFS_DFS.h"
#include "gfx125_bvh_build_DFS_DFS_single_wg.h"
#include "gfx125_bvh_build_DFS_DFS_single_wg_batchable.h"
#include "gfx125_bvh_build_DFS_DFS_trivial.h"
#include "gfx125_bvh_build_DFS_DFS_trivial_batchable.h"
#include "gfx125_bvh_build_leaf_create_HW_instance_nodes.h"
#include "gfx125_bvh_build_leaf_create_HW_instance_nodes_pointers.h"
#include "gfx125_bvh_build_leaf_primref_to_procedurals.h"
#include "gfx125_bvh_build_leaf_primref_to_quads.h"
#include "gfx125_bvh_build_primref_primrefs_from_DXR_instances.h"
#include "gfx125_bvh_build_primref_primrefs_from_DXR_instances_indirect.h"
#include "gfx125_bvh_build_primref_primrefs_from_DXR_instances_pointers.h"
#include "gfx125_bvh_build_primref_primrefs_from_DXR_instances_pointers_indirect.h"
#include "gfx125_bvh_build_primref_procedurals_to_primrefs.h"
#include "gfx125_bvh_build_primref_procedurals_to_primrefs_indirect.h"
#include "gfx125_bvh_build_primref_triangles_to_primrefs.h"
#include "gfx125_bvh_build_primref_triangles_to_primrefs_indirect.h"
#include "gfx125_bvh_copy_clone_indirect.h"
#include "gfx125_bvh_copy_compact.h"
#include "gfx125_bvh_copy_deserialize_indirect.h"
#include "gfx125_bvh_copy_dxr_decode.h"
#include "gfx125_bvh_copy_serialize_for_input_dump_indirect.h"
#include "gfx125_bvh_copy_serialize_indirect.h"
#include "gfx125_bvh_postbuild_info_compacted_size.h"
#include "gfx125_bvh_postbuild_info_current_size.h"
#include "gfx125_bvh_postbuild_info_decoded_size.h"
#include "gfx125_bvh_postbuild_info_serialized_size.h"
#include "gfx125_misc_batched_init_globals.h"
#include "gfx125_misc_copy_geo_descs_indirect_build.h"
#include "gfx125_misc_copy_geo_meta_data.h"
#include "gfx125_misc_copy_instance_ptrs.h"
#include "gfx125_misc_copy_instance_ptrs_base_ptr.h"
#include "gfx125_misc_copy_instance_ptrs_base_ptr_indirect.h"
#include "gfx125_misc_copy_instance_ptrs_indirect.h"
#include "gfx125_misc_copy_instances.h"
#include "gfx125_misc_copy_instances_base_ptr.h"
#include "gfx125_misc_copy_instances_base_ptr_indirect.h"
#include "gfx125_misc_copy_instances_indirect.h"
#include "gfx125_misc_copy_mock.h"
#include "gfx125_misc_mem_set.h"
#include "gfx125_misc_mem_set_size_ptr.h"

const char *
genX(grl_cl_kernel_name)(enum grl_cl_kernel kernel)
{
    switch (kernel) {
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED: return "bvh_build_BFS_BFS_pass1_indexed";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED_BATCHABLE: return "bvh_build_BFS_BFS_pass1_indexed_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL: return "bvh_build_BFS_BFS_pass1_initial";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL_BATCHABLE: return "bvh_build_BFS_BFS_pass1_initial_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED: return "bvh_build_BFS_BFS_pass2_indexed";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED_BATCHABLE: return "bvh_build_BFS_BFS_pass2_indexed_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL: return "bvh_build_BFS_BFS_pass2_initial";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL_BATCHABLE: return "bvh_build_BFS_BFS_pass2_initial_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_DFS: return "bvh_build_BFS_DFS";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN: return "bvh_build_BFS_begin";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN_BATCHABLE: return "bvh_build_BFS_begin_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_BEGIN_BATCHABLE: return "bvh_build_BFS_build_qnodes_begin_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_INIT_SCHEDULER_BATCHED: return "bvh_build_BFS_build_qnodes_init_scheduler_batched";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY: return "bvh_build_BFS_build_qnodes_pc_amplify";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY_BATCHED: return "bvh_build_BFS_build_qnodes_pc_amplify_batched";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_KICKOFF: return "bvh_build_BFS_build_qnodes_pc_kickoff";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_SCHEDULER: return "bvh_build_BFS_build_qnodes_scheduler";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_TRY_TO_FILL_GRB_BATCHED: return "bvh_build_BFS_build_qnodes_try_to_fill_grb_batched";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_CATEGORIZE_BUILDS_AND_INIT_SCHEDULER: return "bvh_build_BFS_categorize_builds_and_init_scheduler";
    case GRL_CL_KERNEL_BVH_BUILD_BFS_SCHEDULER: return "bvh_build_BFS_scheduler";
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS: return "bvh_build_DFS_DFS";
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG: return "bvh_build_DFS_DFS_single_wg";
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG_BATCHABLE: return "bvh_build_DFS_DFS_single_wg_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL: return "bvh_build_DFS_DFS_trivial";
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL_BATCHABLE: return "bvh_build_DFS_DFS_trivial_batchable";
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES: return "bvh_build_leaf_create_HW_instance_nodes";
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES_POINTERS: return "bvh_build_leaf_create_HW_instance_nodes_pointers";
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_PROCEDURALS: return "bvh_build_leaf_primref_to_procedurals";
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_QUADS: return "bvh_build_leaf_primref_to_quads";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES: return "bvh_build_primref_primrefs_from_DXR_instances";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_INDIRECT: return "bvh_build_primref_primrefs_from_DXR_instances_indirect";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS: return "bvh_build_primref_primrefs_from_DXR_instances_pointers";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS_INDIRECT: return "bvh_build_primref_primrefs_from_DXR_instances_pointers_indirect";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS: return "bvh_build_primref_procedurals_to_primrefs";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS_INDIRECT: return "bvh_build_primref_procedurals_to_primrefs_indirect";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS: return "bvh_build_primref_triangles_to_primrefs";
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS_INDIRECT: return "bvh_build_primref_triangles_to_primrefs_indirect";
    case GRL_CL_KERNEL_BVH_COPY_CLONE_INDIRECT: return "bvh_copy_clone_indirect";
    case GRL_CL_KERNEL_BVH_COPY_COMPACT: return "bvh_copy_compact";
    case GRL_CL_KERNEL_BVH_COPY_DESERIALIZE_INDIRECT: return "bvh_copy_deserialize_indirect";
    case GRL_CL_KERNEL_BVH_COPY_DXR_DECODE: return "bvh_copy_dxr_decode";
    case GRL_CL_KERNEL_BVH_COPY_SERIALIZE_FOR_INPUT_DUMP_INDIRECT: return "bvh_copy_serialize_for_input_dump_indirect";
    case GRL_CL_KERNEL_BVH_COPY_SERIALIZE_INDIRECT: return "bvh_copy_serialize_indirect";
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_COMPACTED_SIZE: return "bvh_postbuild_info_compacted_size";
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_CURRENT_SIZE: return "bvh_postbuild_info_current_size";
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_DECODED_SIZE: return "bvh_postbuild_info_decoded_size";
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_SERIALIZED_SIZE: return "bvh_postbuild_info_serialized_size";
    case GRL_CL_KERNEL_MISC_BATCHED_INIT_GLOBALS: return "misc_batched_init_globals";
    case GRL_CL_KERNEL_MISC_COPY_GEO_DESCS_INDIRECT_BUILD: return "misc_copy_geo_descs_indirect_build";
    case GRL_CL_KERNEL_MISC_COPY_GEO_META_DATA: return "misc_copy_geo_meta_data";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS: return "misc_copy_instance_ptrs";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR: return "misc_copy_instance_ptrs_base_ptr";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR_INDIRECT: return "misc_copy_instance_ptrs_base_ptr_indirect";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_INDIRECT: return "misc_copy_instance_ptrs_indirect";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES: return "misc_copy_instances";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR: return "misc_copy_instances_base_ptr";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR_INDIRECT: return "misc_copy_instances_base_ptr_indirect";
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_INDIRECT: return "misc_copy_instances_indirect";
    case GRL_CL_KERNEL_MISC_COPY_MOCK: return "misc_copy_mock";
    case GRL_CL_KERNEL_MISC_MEM_SET: return "misc_mem_set";
    case GRL_CL_KERNEL_MISC_MEM_SET_SIZE_PTR: return "misc_mem_set_size_ptr";
    default: return "unknown";
    }
}

const char *
genX(grl_get_cl_kernel_sha1)(enum grl_cl_kernel id)
{
    switch (id) {
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED: return gfx125_bvh_build_BFS_BFS_pass1_indexed_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED_BATCHABLE: return gfx125_bvh_build_BFS_BFS_pass1_indexed_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL: return gfx125_bvh_build_BFS_BFS_pass1_initial_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL_BATCHABLE: return gfx125_bvh_build_BFS_BFS_pass1_initial_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED: return gfx125_bvh_build_BFS_BFS_pass2_indexed_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED_BATCHABLE: return gfx125_bvh_build_BFS_BFS_pass2_indexed_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL: return gfx125_bvh_build_BFS_BFS_pass2_initial_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL_BATCHABLE: return gfx125_bvh_build_BFS_BFS_pass2_initial_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_DFS: return gfx125_bvh_build_BFS_DFS_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN: return gfx125_bvh_build_BFS_begin_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN_BATCHABLE: return gfx125_bvh_build_BFS_begin_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_BEGIN_BATCHABLE: return gfx125_bvh_build_BFS_build_qnodes_begin_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_INIT_SCHEDULER_BATCHED: return gfx125_bvh_build_BFS_build_qnodes_init_scheduler_batched_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY: return gfx125_bvh_build_BFS_build_qnodes_pc_amplify_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY_BATCHED: return gfx125_bvh_build_BFS_build_qnodes_pc_amplify_batched_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_KICKOFF: return gfx125_bvh_build_BFS_build_qnodes_pc_kickoff_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_SCHEDULER: return gfx125_bvh_build_BFS_build_qnodes_scheduler_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_TRY_TO_FILL_GRB_BATCHED: return gfx125_bvh_build_BFS_build_qnodes_try_to_fill_grb_batched_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_CATEGORIZE_BUILDS_AND_INIT_SCHEDULER: return gfx125_bvh_build_BFS_categorize_builds_and_init_scheduler_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_SCHEDULER: return gfx125_bvh_build_BFS_scheduler_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS: return gfx125_bvh_build_DFS_DFS_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG: return gfx125_bvh_build_DFS_DFS_single_wg_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG_BATCHABLE: return gfx125_bvh_build_DFS_DFS_single_wg_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL: return gfx125_bvh_build_DFS_DFS_trivial_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL_BATCHABLE: return gfx125_bvh_build_DFS_DFS_trivial_batchable_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES: return gfx125_bvh_build_leaf_create_HW_instance_nodes_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES_POINTERS: return gfx125_bvh_build_leaf_create_HW_instance_nodes_pointers_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_PROCEDURALS: return gfx125_bvh_build_leaf_primref_to_procedurals_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_QUADS: return gfx125_bvh_build_leaf_primref_to_quads_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES: return gfx125_bvh_build_primref_primrefs_from_DXR_instances_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_INDIRECT: return gfx125_bvh_build_primref_primrefs_from_DXR_instances_indirect_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS: return gfx125_bvh_build_primref_primrefs_from_DXR_instances_pointers_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS_INDIRECT: return gfx125_bvh_build_primref_primrefs_from_DXR_instances_pointers_indirect_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS: return gfx125_bvh_build_primref_procedurals_to_primrefs_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS_INDIRECT: return gfx125_bvh_build_primref_procedurals_to_primrefs_indirect_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS: return gfx125_bvh_build_primref_triangles_to_primrefs_sha1;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS_INDIRECT: return gfx125_bvh_build_primref_triangles_to_primrefs_indirect_sha1;
    case GRL_CL_KERNEL_BVH_COPY_CLONE_INDIRECT: return gfx125_bvh_copy_clone_indirect_sha1;
    case GRL_CL_KERNEL_BVH_COPY_COMPACT: return gfx125_bvh_copy_compact_sha1;
    case GRL_CL_KERNEL_BVH_COPY_DESERIALIZE_INDIRECT: return gfx125_bvh_copy_deserialize_indirect_sha1;
    case GRL_CL_KERNEL_BVH_COPY_DXR_DECODE: return gfx125_bvh_copy_dxr_decode_sha1;
    case GRL_CL_KERNEL_BVH_COPY_SERIALIZE_FOR_INPUT_DUMP_INDIRECT: return gfx125_bvh_copy_serialize_for_input_dump_indirect_sha1;
    case GRL_CL_KERNEL_BVH_COPY_SERIALIZE_INDIRECT: return gfx125_bvh_copy_serialize_indirect_sha1;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_COMPACTED_SIZE: return gfx125_bvh_postbuild_info_compacted_size_sha1;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_CURRENT_SIZE: return gfx125_bvh_postbuild_info_current_size_sha1;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_DECODED_SIZE: return gfx125_bvh_postbuild_info_decoded_size_sha1;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_SERIALIZED_SIZE: return gfx125_bvh_postbuild_info_serialized_size_sha1;
    case GRL_CL_KERNEL_MISC_BATCHED_INIT_GLOBALS: return gfx125_misc_batched_init_globals_sha1;
    case GRL_CL_KERNEL_MISC_COPY_GEO_DESCS_INDIRECT_BUILD: return gfx125_misc_copy_geo_descs_indirect_build_sha1;
    case GRL_CL_KERNEL_MISC_COPY_GEO_META_DATA: return gfx125_misc_copy_geo_meta_data_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS: return gfx125_misc_copy_instance_ptrs_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR: return gfx125_misc_copy_instance_ptrs_base_ptr_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR_INDIRECT: return gfx125_misc_copy_instance_ptrs_base_ptr_indirect_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_INDIRECT: return gfx125_misc_copy_instance_ptrs_indirect_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES: return gfx125_misc_copy_instances_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR: return gfx125_misc_copy_instances_base_ptr_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR_INDIRECT: return gfx125_misc_copy_instances_base_ptr_indirect_sha1;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_INDIRECT: return gfx125_misc_copy_instances_indirect_sha1;
    case GRL_CL_KERNEL_MISC_COPY_MOCK: return gfx125_misc_copy_mock_sha1;
    case GRL_CL_KERNEL_MISC_MEM_SET: return gfx125_misc_mem_set_sha1;
    case GRL_CL_KERNEL_MISC_MEM_SET_SIZE_PTR: return gfx125_misc_mem_set_size_ptr_sha1;
    default:
        unreachable("Invalid GRL kernel enum");
    }
};

void
gfx125_grl_get_cl_kernel(struct brw_kernel *kernel, enum grl_cl_kernel id)
{
    switch (id) {
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED:
        *kernel = gfx125_bvh_build_BFS_BFS_pass1_indexed;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INDEXED_BATCHABLE:
        *kernel = gfx125_bvh_build_BFS_BFS_pass1_indexed_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL:
        *kernel = gfx125_bvh_build_BFS_BFS_pass1_initial;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS1_INITIAL_BATCHABLE:
        *kernel = gfx125_bvh_build_BFS_BFS_pass1_initial_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED:
        *kernel = gfx125_bvh_build_BFS_BFS_pass2_indexed;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INDEXED_BATCHABLE:
        *kernel = gfx125_bvh_build_BFS_BFS_pass2_indexed_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL:
        *kernel = gfx125_bvh_build_BFS_BFS_pass2_initial;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BFS_PASS2_INITIAL_BATCHABLE:
        *kernel = gfx125_bvh_build_BFS_BFS_pass2_initial_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_DFS:
        *kernel = gfx125_bvh_build_BFS_DFS;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN:
        *kernel = gfx125_bvh_build_BFS_begin;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BEGIN_BATCHABLE:
        *kernel = gfx125_bvh_build_BFS_begin_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_BEGIN_BATCHABLE:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_begin_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_INIT_SCHEDULER_BATCHED:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_init_scheduler_batched;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_pc_amplify;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_AMPLIFY_BATCHED:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_pc_amplify_batched;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_PC_KICKOFF:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_pc_kickoff;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_SCHEDULER:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_scheduler;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_BUILD_QNODES_TRY_TO_FILL_GRB_BATCHED:
        *kernel = gfx125_bvh_build_BFS_build_qnodes_try_to_fill_grb_batched;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_CATEGORIZE_BUILDS_AND_INIT_SCHEDULER:
        *kernel = gfx125_bvh_build_BFS_categorize_builds_and_init_scheduler;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_BFS_SCHEDULER:
        *kernel = gfx125_bvh_build_BFS_scheduler;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS:
        *kernel = gfx125_bvh_build_DFS_DFS;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG:
        *kernel = gfx125_bvh_build_DFS_DFS_single_wg;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_SINGLE_WG_BATCHABLE:
        *kernel = gfx125_bvh_build_DFS_DFS_single_wg_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL:
        *kernel = gfx125_bvh_build_DFS_DFS_trivial;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_DFS_DFS_TRIVIAL_BATCHABLE:
        *kernel = gfx125_bvh_build_DFS_DFS_trivial_batchable;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES:
        *kernel = gfx125_bvh_build_leaf_create_HW_instance_nodes;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_CREATE_HW_INSTANCE_NODES_POINTERS:
        *kernel = gfx125_bvh_build_leaf_create_HW_instance_nodes_pointers;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_PROCEDURALS:
        *kernel = gfx125_bvh_build_leaf_primref_to_procedurals;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_LEAF_PRIMREF_TO_QUADS:
        *kernel = gfx125_bvh_build_leaf_primref_to_quads;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES:
        *kernel = gfx125_bvh_build_primref_primrefs_from_DXR_instances;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_INDIRECT:
        *kernel = gfx125_bvh_build_primref_primrefs_from_DXR_instances_indirect;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS:
        *kernel = gfx125_bvh_build_primref_primrefs_from_DXR_instances_pointers;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PRIMREFS_FROM_DXR_INSTANCES_POINTERS_INDIRECT:
        *kernel = gfx125_bvh_build_primref_primrefs_from_DXR_instances_pointers_indirect;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS:
        *kernel = gfx125_bvh_build_primref_procedurals_to_primrefs;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_PROCEDURALS_TO_PRIMREFS_INDIRECT:
        *kernel = gfx125_bvh_build_primref_procedurals_to_primrefs_indirect;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS:
        *kernel = gfx125_bvh_build_primref_triangles_to_primrefs;
        break;
    case GRL_CL_KERNEL_BVH_BUILD_PRIMREF_TRIANGLES_TO_PRIMREFS_INDIRECT:
        *kernel = gfx125_bvh_build_primref_triangles_to_primrefs_indirect;
        break;
    case GRL_CL_KERNEL_BVH_COPY_CLONE_INDIRECT:
        *kernel = gfx125_bvh_copy_clone_indirect;
        break;
    case GRL_CL_KERNEL_BVH_COPY_COMPACT:
        *kernel = gfx125_bvh_copy_compact;
        break;
    case GRL_CL_KERNEL_BVH_COPY_DESERIALIZE_INDIRECT:
        *kernel = gfx125_bvh_copy_deserialize_indirect;
        break;
    case GRL_CL_KERNEL_BVH_COPY_DXR_DECODE:
        *kernel = gfx125_bvh_copy_dxr_decode;
        break;
    case GRL_CL_KERNEL_BVH_COPY_SERIALIZE_FOR_INPUT_DUMP_INDIRECT:
        *kernel = gfx125_bvh_copy_serialize_for_input_dump_indirect;
        break;
    case GRL_CL_KERNEL_BVH_COPY_SERIALIZE_INDIRECT:
        *kernel = gfx125_bvh_copy_serialize_indirect;
        break;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_COMPACTED_SIZE:
        *kernel = gfx125_bvh_postbuild_info_compacted_size;
        break;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_CURRENT_SIZE:
        *kernel = gfx125_bvh_postbuild_info_current_size;
        break;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_DECODED_SIZE:
        *kernel = gfx125_bvh_postbuild_info_decoded_size;
        break;
    case GRL_CL_KERNEL_BVH_POSTBUILD_INFO_SERIALIZED_SIZE:
        *kernel = gfx125_bvh_postbuild_info_serialized_size;
        break;
    case GRL_CL_KERNEL_MISC_BATCHED_INIT_GLOBALS:
        *kernel = gfx125_misc_batched_init_globals;
        break;
    case GRL_CL_KERNEL_MISC_COPY_GEO_DESCS_INDIRECT_BUILD:
        *kernel = gfx125_misc_copy_geo_descs_indirect_build;
        break;
    case GRL_CL_KERNEL_MISC_COPY_GEO_META_DATA:
        *kernel = gfx125_misc_copy_geo_meta_data;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS:
        *kernel = gfx125_misc_copy_instance_ptrs;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR:
        *kernel = gfx125_misc_copy_instance_ptrs_base_ptr;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_BASE_PTR_INDIRECT:
        *kernel = gfx125_misc_copy_instance_ptrs_base_ptr_indirect;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCE_PTRS_INDIRECT:
        *kernel = gfx125_misc_copy_instance_ptrs_indirect;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES:
        *kernel = gfx125_misc_copy_instances;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR:
        *kernel = gfx125_misc_copy_instances_base_ptr;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_BASE_PTR_INDIRECT:
        *kernel = gfx125_misc_copy_instances_base_ptr_indirect;
        break;
    case GRL_CL_KERNEL_MISC_COPY_INSTANCES_INDIRECT:
        *kernel = gfx125_misc_copy_instances_indirect;
        break;
    case GRL_CL_KERNEL_MISC_COPY_MOCK:
        *kernel = gfx125_misc_copy_mock;
        break;
    case GRL_CL_KERNEL_MISC_MEM_SET:
        *kernel = gfx125_misc_mem_set;
        break;
    case GRL_CL_KERNEL_MISC_MEM_SET_SIZE_PTR:
        *kernel = gfx125_misc_mem_set_size_ptr;
        break;
    default:
        unreachable("Invalid GRL kernel enum");
    }
}
