/* automatically generated by rust-bindgen 0.69.4 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const PIPE_BUF: u32 = 4096;
pub const PIPE_ATOMIC: &[u8; 20] = b"GCC Sync Intrinsics\0";
pub const PIPE_MASK_R: u32 = 1;
pub const PIPE_MASK_G: u32 = 2;
pub const PIPE_MASK_B: u32 = 4;
pub const PIPE_MASK_A: u32 = 8;
pub const PIPE_MASK_RGBA: u32 = 15;
pub const PIPE_MASK_Z: u32 = 16;
pub const PIPE_MASK_S: u32 = 32;
pub const PIPE_MASK_ZS: u32 = 48;
pub const PIPE_MASK_RGBAZS: u32 = 63;
pub const SHA1_BLOCK_LENGTH: u32 = 64;
pub const SHA1_DIGEST_LENGTH: u32 = 20;
pub const SHA1_DIGEST_STRING_LENGTH: u32 = 41;
pub const NIR_DEBUG_CLONE: u32 = 1;
pub const NIR_DEBUG_SERIALIZE: u32 = 2;
pub const NIR_DEBUG_NOVALIDATE: u32 = 4;
pub const NIR_DEBUG_VALIDATE_SSA_DOMINANCE: u32 = 8;
pub const NIR_DEBUG_TGSI: u32 = 16;
pub const NIR_DEBUG_PRINT_VS: u32 = 32;
pub const NIR_DEBUG_PRINT_TCS: u32 = 64;
pub const NIR_DEBUG_PRINT_TES: u32 = 128;
pub const NIR_DEBUG_PRINT_GS: u32 = 256;
pub const NIR_DEBUG_PRINT_FS: u32 = 512;
pub const NIR_DEBUG_PRINT_CS: u32 = 1024;
pub const NIR_DEBUG_PRINT_TS: u32 = 2048;
pub const NIR_DEBUG_PRINT_MS: u32 = 4096;
pub const NIR_DEBUG_PRINT_RGS: u32 = 8192;
pub const NIR_DEBUG_PRINT_AHS: u32 = 16384;
pub const NIR_DEBUG_PRINT_CHS: u32 = 32768;
pub const NIR_DEBUG_PRINT_MHS: u32 = 65536;
pub const NIR_DEBUG_PRINT_IS: u32 = 131072;
pub const NIR_DEBUG_PRINT_CBS: u32 = 262144;
pub const NIR_DEBUG_PRINT_KS: u32 = 524288;
pub const NIR_DEBUG_PRINT_NO_INLINE_CONSTS: u32 = 1048576;
pub const NIR_DEBUG_PRINT_INTERNAL: u32 = 2097152;
pub const NIR_DEBUG_PRINT_PASS_FLAGS: u32 = 4194304;
pub const NIR_DEBUG_PRINT: u32 = 1048544;
pub const SHA1_DIGEST_LENGTH32: u32 = 5;
pub const PIPE_BLENDFACTOR_INVERT_BIT: u32 = 16;
pub const OS_TIMEOUT_INFINITE: i32 = -1;
pub const PIPE_FACE_NONE: u32 = 0;
pub const PIPE_FACE_FRONT: u32 = 1;
pub const PIPE_FACE_BACK: u32 = 2;
pub const PIPE_FACE_FRONT_AND_BACK: u32 = 3;
pub const PIPE_CLEAR_DEPTH: u32 = 1;
pub const PIPE_CLEAR_STENCIL: u32 = 2;
pub const PIPE_CLEAR_COLOR0: u32 = 4;
pub const PIPE_CLEAR_COLOR1: u32 = 8;
pub const PIPE_CLEAR_COLOR2: u32 = 16;
pub const PIPE_CLEAR_COLOR3: u32 = 32;
pub const PIPE_CLEAR_COLOR4: u32 = 64;
pub const PIPE_CLEAR_COLOR5: u32 = 128;
pub const PIPE_CLEAR_COLOR6: u32 = 256;
pub const PIPE_CLEAR_COLOR7: u32 = 512;
pub const PIPE_CLEAR_COLOR: u32 = 1020;
pub const PIPE_CLEAR_DEPTHSTENCIL: u32 = 3;
pub const PIPE_DUMP_DEVICE_STATUS_REGISTERS: u32 = 1;
pub const PIPE_CONTEXT_COMPUTE_ONLY: u32 = 1;
pub const PIPE_CONTEXT_DEBUG: u32 = 2;
pub const PIPE_CONTEXT_ROBUST_BUFFER_ACCESS: u32 = 4;
pub const PIPE_CONTEXT_PREFER_THREADED: u32 = 8;
pub const PIPE_CONTEXT_HIGH_PRIORITY: u32 = 16;
pub const PIPE_CONTEXT_LOW_PRIORITY: u32 = 32;
pub const PIPE_CONTEXT_LOSE_CONTEXT_ON_RESET: u32 = 64;
pub const PIPE_CONTEXT_PROTECTED: u32 = 128;
pub const PIPE_CONTEXT_NO_LOD_BIAS: u32 = 256;
pub const PIPE_CONTEXT_MEDIA_ONLY: u32 = 512;
pub const PIPE_BARRIER_MAPPED_BUFFER: u32 = 1;
pub const PIPE_BARRIER_SHADER_BUFFER: u32 = 2;
pub const PIPE_BARRIER_QUERY_BUFFER: u32 = 4;
pub const PIPE_BARRIER_VERTEX_BUFFER: u32 = 8;
pub const PIPE_BARRIER_INDEX_BUFFER: u32 = 16;
pub const PIPE_BARRIER_CONSTANT_BUFFER: u32 = 32;
pub const PIPE_BARRIER_INDIRECT_BUFFER: u32 = 64;
pub const PIPE_BARRIER_TEXTURE: u32 = 128;
pub const PIPE_BARRIER_IMAGE: u32 = 256;
pub const PIPE_BARRIER_FRAMEBUFFER: u32 = 512;
pub const PIPE_BARRIER_STREAMOUT_BUFFER: u32 = 1024;
pub const PIPE_BARRIER_GLOBAL_BUFFER: u32 = 2048;
pub const PIPE_BARRIER_UPDATE_BUFFER: u32 = 4096;
pub const PIPE_BARRIER_UPDATE_TEXTURE: u32 = 8192;
pub const PIPE_BARRIER_ALL: u32 = 16383;
pub const PIPE_BARRIER_UPDATE: u32 = 12288;
pub const PIPE_TEXTURE_BARRIER_SAMPLER: u32 = 1;
pub const PIPE_TEXTURE_BARRIER_FRAMEBUFFER: u32 = 2;
pub const PIPE_BIND_DEPTH_STENCIL: u32 = 1;
pub const PIPE_BIND_RENDER_TARGET: u32 = 2;
pub const PIPE_BIND_BLENDABLE: u32 = 4;
pub const PIPE_BIND_SAMPLER_VIEW: u32 = 8;
pub const PIPE_BIND_VERTEX_BUFFER: u32 = 16;
pub const PIPE_BIND_INDEX_BUFFER: u32 = 32;
pub const PIPE_BIND_CONSTANT_BUFFER: u32 = 64;
pub const PIPE_BIND_DISPLAY_TARGET: u32 = 128;
pub const PIPE_BIND_VERTEX_STATE: u32 = 256;
pub const PIPE_BIND_STREAM_OUTPUT: u32 = 1024;
pub const PIPE_BIND_CURSOR: u32 = 2048;
pub const PIPE_BIND_CUSTOM: u32 = 4096;
pub const PIPE_BIND_GLOBAL: u32 = 8192;
pub const PIPE_BIND_SHADER_BUFFER: u32 = 16384;
pub const PIPE_BIND_SHADER_IMAGE: u32 = 32768;
pub const PIPE_BIND_COMPUTE_RESOURCE: u32 = 65536;
pub const PIPE_BIND_COMMAND_ARGS_BUFFER: u32 = 131072;
pub const PIPE_BIND_QUERY_BUFFER: u32 = 262144;
pub const PIPE_BIND_SCANOUT: u32 = 524288;
pub const PIPE_BIND_SHARED: u32 = 1048576;
pub const PIPE_BIND_LINEAR: u32 = 2097152;
pub const PIPE_BIND_PROTECTED: u32 = 4194304;
pub const PIPE_BIND_SAMPLER_REDUCTION_MINMAX: u32 = 8388608;
pub const PIPE_BIND_PRIME_BLIT_DST: u32 = 16777216;
pub const PIPE_BIND_USE_FRONT_RENDERING: u32 = 33554432;
pub const PIPE_BIND_CONST_BW: u32 = 67108864;
pub const PIPE_RESOURCE_FLAG_MAP_PERSISTENT: u32 = 1;
pub const PIPE_RESOURCE_FLAG_MAP_COHERENT: u32 = 2;
pub const PIPE_RESOURCE_FLAG_TEXTURING_MORE_LIKELY: u32 = 4;
pub const PIPE_RESOURCE_FLAG_SPARSE: u32 = 8;
pub const PIPE_RESOURCE_FLAG_SINGLE_THREAD_USE: u32 = 16;
pub const PIPE_RESOURCE_FLAG_ENCRYPTED: u32 = 32;
pub const PIPE_RESOURCE_FLAG_DONT_OVER_ALLOCATE: u32 = 64;
pub const PIPE_RESOURCE_FLAG_DONT_MAP_DIRECTLY: u32 = 128;
pub const PIPE_RESOURCE_FLAG_UNMAPPABLE: u32 = 256;
pub const PIPE_RESOURCE_FLAG_DRV_PRIV: u32 = 512;
pub const PIPE_RESOURCE_FLAG_FRONTEND_PRIV: u32 = 16777216;
pub const PIPE_HANDLE_USAGE_EXPLICIT_FLUSH: u32 = 1;
pub const PIPE_HANDLE_USAGE_FRAMEBUFFER_WRITE: u32 = 2;
pub const PIPE_HANDLE_USAGE_SHADER_WRITE: u32 = 4;
pub const PIPE_IMAGE_ACCESS_READ: u32 = 1;
pub const PIPE_IMAGE_ACCESS_WRITE: u32 = 2;
pub const PIPE_IMAGE_ACCESS_READ_WRITE: u32 = 3;
pub const PIPE_IMAGE_ACCESS_COHERENT: u32 = 4;
pub const PIPE_IMAGE_ACCESS_VOLATILE: u32 = 8;
pub const PIPE_IMAGE_ACCESS_TEX2D_FROM_BUFFER: u32 = 16;
pub const PIPE_IMAGE_ACCESS_DRIVER_INTERNAL: u32 = 32;
pub const PIPE_CONTEXT_PRIORITY_LOW: u32 = 1;
pub const PIPE_CONTEXT_PRIORITY_MEDIUM: u32 = 2;
pub const PIPE_CONTEXT_PRIORITY_HIGH: u32 = 4;
pub const PIPE_DRIVER_QUERY_FLAG_BATCH: u32 = 1;
pub const PIPE_DRIVER_QUERY_FLAG_DONT_LIST: u32 = 2;
pub const PIPE_UUID_SIZE: u32 = 16;
pub const PIPE_LUID_SIZE: u32 = 8;
pub const WINSYS_HANDLE_TYPE_SHARED: u32 = 0;
pub const WINSYS_HANDLE_TYPE_KMS: u32 = 1;
pub const WINSYS_HANDLE_TYPE_FD: u32 = 2;
pub const WINSYS_HANDLE_TYPE_WIN32_HANDLE: u32 = 2;
pub const WINSYS_HANDLE_TYPE_SHMID: u32 = 3;
pub const WINSYS_HANDLE_TYPE_D3D12_RES: u32 = 4;
pub const WINSYS_HANDLE_TYPE_WIN32_NAME: u32 = 5;
pub const WINSYS_HANDLE_TYPE_UNBACKED: u32 = 5;
pub const PIPE_MAX_ATTRIBS: u32 = 32;
pub const PIPE_MAX_CLIP_PLANES: u32 = 8;
pub const PIPE_MAX_COLOR_BUFS: u32 = 8;
pub const PIPE_MAX_CONSTANT_BUFFERS: u32 = 32;
pub const PIPE_MAX_SAMPLERS: u32 = 32;
pub const PIPE_MAX_SHADER_INPUTS: u32 = 80;
pub const PIPE_MAX_SHADER_OUTPUTS: u32 = 80;
pub const PIPE_MAX_SHADER_SAMPLER_VIEWS: u32 = 128;
pub const PIPE_MAX_SHADER_BUFFERS: u32 = 32;
pub const PIPE_MAX_SHADER_IMAGES: u32 = 64;
pub const PIPE_MAX_TEXTURE_LEVELS: u32 = 16;
pub const PIPE_MAX_SO_BUFFERS: u32 = 4;
pub const PIPE_MAX_SO_OUTPUTS: u32 = 128;
pub const PIPE_MAX_VIEWPORTS: u32 = 16;
pub const PIPE_MAX_CLIP_OR_CULL_DISTANCE_COUNT: u32 = 8;
pub const PIPE_MAX_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: u32 = 2;
pub const PIPE_MAX_WINDOW_RECTANGLES: u32 = 8;
pub const PIPE_MAX_SAMPLE_LOCATION_GRID_SIZE: u32 = 4;
pub const PIPE_MAX_HW_ATOMIC_BUFFERS: u32 = 32;
pub const PIPE_MAX_VERTEX_STREAMS: u32 = 4;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __gnuc_va_list = __builtin_va_list;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    const UNINIT: ::std::mem::MaybeUninit<_IO_FILE> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_ptr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_end) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_base) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_base) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_ptr) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_end) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_base) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_end) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_base) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_backup_base) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_end) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._markers) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._chain) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._fileno) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags2) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._old_offset) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._cur_column) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._vtable_offset) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._shortbuf) as usize - ptr as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._lock) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._offset) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._codecvt) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._wide_data) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_list) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_buf) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad5) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._mode) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._unused2) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type va_list = __gnuc_va_list;
pub type uint = ::std::os::raw::c_uint;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_debug_type {
    UTIL_DEBUG_TYPE_OUT_OF_MEMORY = 1,
    UTIL_DEBUG_TYPE_ERROR = 2,
    UTIL_DEBUG_TYPE_SHADER_INFO = 3,
    UTIL_DEBUG_TYPE_PERF_INFO = 4,
    UTIL_DEBUG_TYPE_INFO = 5,
    UTIL_DEBUG_TYPE_FALLBACK = 6,
    UTIL_DEBUG_TYPE_CONFORMANCE = 7,
}
#[doc = " Structure that contains a callback for debug messages from the driver back\n to the gallium frontend."]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_debug_callback {
    #[doc = " When set to \\c true, the callback may be called asynchronously from a\n driver-created thread."]
    pub async_: bool,
    #[doc = " Callback for the driver to report debug/performance/etc information back\n to the gallium frontend.\n\n \\param data       user-supplied data pointer\n \\param id         message type identifier, if pointed value is 0, then a\n                   new id is assigned\n \\param type       UTIL_DEBUG_TYPE_*\n \\param format     printf-style format string\n \\param args       args for format string"]
    pub debug_message: ::std::option::Option<
        unsafe extern "C" fn(
            data: *mut ::std::os::raw::c_void,
            id: *mut ::std::os::raw::c_uint,
            type_: util_debug_type,
            fmt: *const ::std::os::raw::c_char,
            args: *mut va_list,
        ),
    >,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_util_debug_callback() {
    const UNINIT: ::std::mem::MaybeUninit<util_debug_callback> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<util_debug_callback>(),
        24usize,
        concat!("Size of: ", stringify!(util_debug_callback))
    );
    assert_eq!(
        ::std::mem::align_of::<util_debug_callback>(),
        8usize,
        concat!("Alignment of ", stringify!(util_debug_callback))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).async_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(util_debug_callback),
            "::",
            stringify!(async_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).debug_message) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(util_debug_callback),
            "::",
            stringify!(debug_message)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(util_debug_callback),
            "::",
            stringify!(data)
        )
    );
}
impl Default for util_debug_callback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl pipe_shader_type {
    pub const PIPE_SHADER_VERTEX: pipe_shader_type = pipe_shader_type::MESA_SHADER_VERTEX;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_TESS_CTRL: pipe_shader_type = pipe_shader_type::MESA_SHADER_TESS_CTRL;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_TESS_EVAL: pipe_shader_type = pipe_shader_type::MESA_SHADER_TESS_EVAL;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_GEOMETRY: pipe_shader_type = pipe_shader_type::MESA_SHADER_GEOMETRY;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_FRAGMENT: pipe_shader_type = pipe_shader_type::MESA_SHADER_FRAGMENT;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_COMPUTE: pipe_shader_type = pipe_shader_type::MESA_SHADER_COMPUTE;
}
impl pipe_shader_type {
    pub const MESA_SHADER_TASK: pipe_shader_type = pipe_shader_type::PIPE_SHADER_TYPES;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_TASK: pipe_shader_type = pipe_shader_type::PIPE_SHADER_TYPES;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_MESH: pipe_shader_type = pipe_shader_type::MESA_SHADER_MESH;
}
impl pipe_shader_type {
    pub const MESA_SHADER_RAYGEN: pipe_shader_type = pipe_shader_type::PIPE_SHADER_MESH_TYPES;
}
#[repr(i32)]
#[doc = " Shader stages.\n\n The order must match how shaders are ordered in the pipeline.\n The GLSL linker assumes that if i<j, then the j-th shader is\n executed later than the i-th shader."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_shader_type {
    MESA_SHADER_NONE = -1,
    MESA_SHADER_VERTEX = 0,
    MESA_SHADER_TESS_CTRL = 1,
    MESA_SHADER_TESS_EVAL = 2,
    MESA_SHADER_GEOMETRY = 3,
    MESA_SHADER_FRAGMENT = 4,
    MESA_SHADER_COMPUTE = 5,
    PIPE_SHADER_TYPES = 6,
    MESA_SHADER_MESH = 7,
    PIPE_SHADER_MESH_TYPES = 8,
    MESA_SHADER_ANY_HIT = 9,
    MESA_SHADER_CLOSEST_HIT = 10,
    MESA_SHADER_MISS = 11,
    MESA_SHADER_INTERSECTION = 12,
    MESA_SHADER_CALLABLE = 13,
    MESA_SHADER_KERNEL = 14,
}
#[doc = " Shader stages.\n\n The order must match how shaders are ordered in the pipeline.\n The GLSL linker assumes that if i<j, then the j-th shader is\n executed later than the i-th shader."]
pub use self::pipe_shader_type as gl_shader_stage;
pub type gl_state_index16 = ::std::os::raw::c_short;
impl gl_varying_slot {
    pub const VARYING_SLOT_PRIMITIVE_SHADING_RATE: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_FACE;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_PRIMITIVE_COUNT: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_TESS_LEVEL_OUTER;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_PRIMITIVE_INDICES: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_TESS_LEVEL_INNER;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_TASK_COUNT: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_BOUNDING_BOX0;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_CULL_PRIMITIVE: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_BOUNDING_BOX0;
}
#[repr(u32)]
#[doc = " Indexes for vertex shader outputs, geometry shader inputs/outputs, and\n fragment shader inputs.\n\n Note that some of these values are not available to all pipeline stages.\n\n When this enum is updated, the following code must be updated too:\n - vertResults (in prog_print.c's arb_output_attrib_string())\n - fragAttribs (in prog_print.c's arb_input_attrib_string())\n - _mesa_varying_slot_in_fs()\n - gl_varying_slot_name_for_stage()"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_varying_slot {
    VARYING_SLOT_POS = 0,
    VARYING_SLOT_COL0 = 1,
    VARYING_SLOT_COL1 = 2,
    VARYING_SLOT_FOGC = 3,
    VARYING_SLOT_TEX0 = 4,
    VARYING_SLOT_TEX1 = 5,
    VARYING_SLOT_TEX2 = 6,
    VARYING_SLOT_TEX3 = 7,
    VARYING_SLOT_TEX4 = 8,
    VARYING_SLOT_TEX5 = 9,
    VARYING_SLOT_TEX6 = 10,
    VARYING_SLOT_TEX7 = 11,
    VARYING_SLOT_PSIZ = 12,
    VARYING_SLOT_BFC0 = 13,
    VARYING_SLOT_BFC1 = 14,
    VARYING_SLOT_EDGE = 15,
    VARYING_SLOT_CLIP_VERTEX = 16,
    VARYING_SLOT_CLIP_DIST0 = 17,
    VARYING_SLOT_CLIP_DIST1 = 18,
    VARYING_SLOT_CULL_DIST0 = 19,
    VARYING_SLOT_CULL_DIST1 = 20,
    VARYING_SLOT_PRIMITIVE_ID = 21,
    VARYING_SLOT_LAYER = 22,
    VARYING_SLOT_VIEWPORT = 23,
    VARYING_SLOT_FACE = 24,
    VARYING_SLOT_PNTC = 25,
    VARYING_SLOT_TESS_LEVEL_OUTER = 26,
    VARYING_SLOT_TESS_LEVEL_INNER = 27,
    VARYING_SLOT_BOUNDING_BOX0 = 28,
    VARYING_SLOT_BOUNDING_BOX1 = 29,
    VARYING_SLOT_VIEW_INDEX = 30,
    VARYING_SLOT_VIEWPORT_MASK = 31,
    VARYING_SLOT_VAR0 = 32,
    VARYING_SLOT_VAR1 = 33,
    VARYING_SLOT_VAR2 = 34,
    VARYING_SLOT_VAR3 = 35,
    VARYING_SLOT_VAR4 = 36,
    VARYING_SLOT_VAR5 = 37,
    VARYING_SLOT_VAR6 = 38,
    VARYING_SLOT_VAR7 = 39,
    VARYING_SLOT_VAR8 = 40,
    VARYING_SLOT_VAR9 = 41,
    VARYING_SLOT_VAR10 = 42,
    VARYING_SLOT_VAR11 = 43,
    VARYING_SLOT_VAR12 = 44,
    VARYING_SLOT_VAR13 = 45,
    VARYING_SLOT_VAR14 = 46,
    VARYING_SLOT_VAR15 = 47,
    VARYING_SLOT_VAR16 = 48,
    VARYING_SLOT_VAR17 = 49,
    VARYING_SLOT_VAR18 = 50,
    VARYING_SLOT_VAR19 = 51,
    VARYING_SLOT_VAR20 = 52,
    VARYING_SLOT_VAR21 = 53,
    VARYING_SLOT_VAR22 = 54,
    VARYING_SLOT_VAR23 = 55,
    VARYING_SLOT_VAR24 = 56,
    VARYING_SLOT_VAR25 = 57,
    VARYING_SLOT_VAR26 = 58,
    VARYING_SLOT_VAR27 = 59,
    VARYING_SLOT_VAR28 = 60,
    VARYING_SLOT_VAR29 = 61,
    VARYING_SLOT_VAR30 = 62,
    VARYING_SLOT_VAR31 = 63,
    VARYING_SLOT_PATCH0 = 64,
    VARYING_SLOT_PATCH1 = 65,
    VARYING_SLOT_PATCH2 = 66,
    VARYING_SLOT_PATCH3 = 67,
    VARYING_SLOT_PATCH4 = 68,
    VARYING_SLOT_PATCH5 = 69,
    VARYING_SLOT_PATCH6 = 70,
    VARYING_SLOT_PATCH7 = 71,
    VARYING_SLOT_PATCH8 = 72,
    VARYING_SLOT_PATCH9 = 73,
    VARYING_SLOT_PATCH10 = 74,
    VARYING_SLOT_PATCH11 = 75,
    VARYING_SLOT_PATCH12 = 76,
    VARYING_SLOT_PATCH13 = 77,
    VARYING_SLOT_PATCH14 = 78,
    VARYING_SLOT_PATCH15 = 79,
    VARYING_SLOT_PATCH16 = 80,
    VARYING_SLOT_PATCH17 = 81,
    VARYING_SLOT_PATCH18 = 82,
    VARYING_SLOT_PATCH19 = 83,
    VARYING_SLOT_PATCH20 = 84,
    VARYING_SLOT_PATCH21 = 85,
    VARYING_SLOT_PATCH22 = 86,
    VARYING_SLOT_PATCH23 = 87,
    VARYING_SLOT_PATCH24 = 88,
    VARYING_SLOT_PATCH25 = 89,
    VARYING_SLOT_PATCH26 = 90,
    VARYING_SLOT_PATCH27 = 91,
    VARYING_SLOT_PATCH28 = 92,
    VARYING_SLOT_PATCH29 = 93,
    VARYING_SLOT_PATCH30 = 94,
    VARYING_SLOT_PATCH31 = 95,
    VARYING_SLOT_VAR0_16BIT = 96,
    VARYING_SLOT_VAR1_16BIT = 97,
    VARYING_SLOT_VAR2_16BIT = 98,
    VARYING_SLOT_VAR3_16BIT = 99,
    VARYING_SLOT_VAR4_16BIT = 100,
    VARYING_SLOT_VAR5_16BIT = 101,
    VARYING_SLOT_VAR6_16BIT = 102,
    VARYING_SLOT_VAR7_16BIT = 103,
    VARYING_SLOT_VAR8_16BIT = 104,
    VARYING_SLOT_VAR9_16BIT = 105,
    VARYING_SLOT_VAR10_16BIT = 106,
    VARYING_SLOT_VAR11_16BIT = 107,
    VARYING_SLOT_VAR12_16BIT = 108,
    VARYING_SLOT_VAR13_16BIT = 109,
    VARYING_SLOT_VAR14_16BIT = 110,
    VARYING_SLOT_VAR15_16BIT = 111,
    NUM_TOTAL_VARYING_SLOTS = 112,
}
#[repr(u32)]
#[doc = " If the gl_register_file is PROGRAM_SYSTEM_VALUE, the register index will be\n one of these values.  If a NIR variable's mode is nir_var_system_value, it\n will be one of these values."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_system_value {
    #[doc = " From the GL_ARB_shader-ballot spec:\n\n    \"A sub-group is a collection of invocations which execute in lockstep.\n     The variable <gl_SubGroupSizeARB> is the maximum number of\n     invocations in a sub-group. The maximum <gl_SubGroupSizeARB>\n     supported in this extension is 64.\"\n\n The spec defines this as a uniform. However, it's highly unlikely that\n implementations actually treat it as a uniform (which is loaded from a\n constant buffer). Most likely, this is an implementation-wide constant,\n or perhaps something that depends on the shader stage."]
    SYSTEM_VALUE_SUBGROUP_SIZE = 0,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The variable <gl_SubGroupInvocationARB> holds the index of the\n     invocation within sub-group. This variable is in the range 0 to\n     <gl_SubGroupSizeARB>-1, where <gl_SubGroupSizeARB> is the total\n     number of invocations in a sub-group.\""]
    SYSTEM_VALUE_SUBGROUP_INVOCATION = 1,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_EQ_MASK = 2,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_GE_MASK = 3,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_GT_MASK = 4,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_LE_MASK = 5,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_LT_MASK = 6,
    SYSTEM_VALUE_NUM_SUBGROUPS = 7,
    SYSTEM_VALUE_SUBGROUP_ID = 8,
    #[doc = " OpenGL-style vertex ID.\n\n Section 2.11.7 (Shader Execution), subsection Shader Inputs, of the\n OpenGL 3.3 core profile spec says:\n\n     \"gl_VertexID holds the integer index i implicitly passed by\n     DrawArrays or one of the other drawing commands defined in section\n     2.8.3.\"\n\n Section 2.8.3 (Drawing Commands) of the same spec says:\n\n     \"The commands....are equivalent to the commands with the same base\n     name (without the BaseVertex suffix), except that the ith element\n     transferred by the corresponding draw call will be taken from\n     element indices[i] + basevertex of each enabled array.\"\n\n Additionally, the overview in the GL_ARB_shader_draw_parameters spec\n says:\n\n     \"In unextended GL, vertex shaders have inputs named gl_VertexID and\n     gl_InstanceID, which contain, respectively the index of the vertex\n     and instance. The value of gl_VertexID is the implicitly passed\n     index of the vertex being processed, which includes the value of\n     baseVertex, for those commands that accept it.\"\n\n gl_VertexID gets basevertex added in.  This differs from DirectX where\n SV_VertexID does \\b not get basevertex added in.\n\n \\note\n If all system values are available, \\c SYSTEM_VALUE_VERTEX_ID will be\n equal to \\c SYSTEM_VALUE_VERTEX_ID_ZERO_BASE plus\n \\c SYSTEM_VALUE_BASE_VERTEX.\n\n \\sa SYSTEM_VALUE_VERTEX_ID_ZERO_BASE, SYSTEM_VALUE_BASE_VERTEX"]
    SYSTEM_VALUE_VERTEX_ID = 9,
    #[doc = " Instanced ID as supplied to gl_InstanceID\n\n Values assigned to gl_InstanceID always begin with zero, regardless of\n the value of baseinstance.\n\n Section 11.1.3.9 (Shader Inputs) of the OpenGL 4.4 core profile spec\n says:\n\n     \"gl_InstanceID holds the integer instance number of the current\n     primitive in an instanced draw call (see section 10.5).\"\n\n Through a big chain of pseudocode, section 10.5 describes that\n baseinstance is not counted by gl_InstanceID.  In that section, notice\n\n     \"If an enabled vertex attribute array is instanced (it has a\n     non-zero divisor as specified by VertexAttribDivisor), the element\n     index that is transferred to the GL, for all vertices, is given by\n\n         floor(instance/divisor) + baseinstance\n\n     If an array corresponding to an attribute required by a vertex\n     shader is not enabled, then the corresponding element is taken from\n     the current attribute state (see section 10.2).\"\n\n Note that baseinstance is \\b not included in the value of instance."]
    SYSTEM_VALUE_INSTANCE_ID = 10,
    #[doc = " Vulkan InstanceIndex.\n\n InstanceIndex = gl_InstanceID + gl_BaseInstance"]
    SYSTEM_VALUE_INSTANCE_INDEX = 11,
    #[doc = " DirectX-style vertex ID.\n\n Unlike \\c SYSTEM_VALUE_VERTEX_ID, this system value does \\b not include\n the value of basevertex.\n\n \\sa SYSTEM_VALUE_VERTEX_ID, SYSTEM_VALUE_BASE_VERTEX"]
    SYSTEM_VALUE_VERTEX_ID_ZERO_BASE = 12,
    #[doc = " Value of \\c basevertex passed to \\c glDrawElementsBaseVertex and similar\n functions.\n\n \\sa SYSTEM_VALUE_VERTEX_ID, SYSTEM_VALUE_VERTEX_ID_ZERO_BASE"]
    SYSTEM_VALUE_BASE_VERTEX = 13,
    #[doc = " Depending on the type of the draw call (indexed or non-indexed),\n is the value of \\c basevertex passed to \\c glDrawElementsBaseVertex and\n similar, or is the value of \\c first passed to \\c glDrawArrays and\n similar.\n\n \\note\n It can be used to calculate the \\c SYSTEM_VALUE_VERTEX_ID as\n \\c SYSTEM_VALUE_VERTEX_ID_ZERO_BASE plus \\c SYSTEM_VALUE_FIRST_VERTEX.\n\n \\sa SYSTEM_VALUE_VERTEX_ID_ZERO_BASE, SYSTEM_VALUE_VERTEX_ID"]
    SYSTEM_VALUE_FIRST_VERTEX = 14,
    #[doc = " If the Draw command used to start the rendering was an indexed draw\n or not (~0/0). Useful to calculate \\c SYSTEM_VALUE_BASE_VERTEX as\n \\c SYSTEM_VALUE_IS_INDEXED_DRAW & \\c SYSTEM_VALUE_FIRST_VERTEX."]
    SYSTEM_VALUE_IS_INDEXED_DRAW = 15,
    #[doc = " Value of \\c baseinstance passed to instanced draw entry points\n\n \\sa SYSTEM_VALUE_INSTANCE_ID"]
    SYSTEM_VALUE_BASE_INSTANCE = 16,
    #[doc = " From _ARB_shader_draw_parameters:\n\n   \"Additionally, this extension adds a further built-in variable,\n    gl_DrawID to the shading language. This variable contains the index\n    of the draw currently being processed by a Multi* variant of a\n    drawing command (such as MultiDrawElements or\n    MultiDrawArraysIndirect).\"\n\n If GL_ARB_multi_draw_indirect is not supported, this is always 0."]
    SYSTEM_VALUE_DRAW_ID = 17,
    #[doc = "< (Also in Tessellation Control shader)"]
    SYSTEM_VALUE_INVOCATION_ID = 18,
    SYSTEM_VALUE_FRAG_COORD = 19,
    SYSTEM_VALUE_POINT_COORD = 20,
    #[doc = "< Coord along axis perpendicular to line"]
    SYSTEM_VALUE_LINE_COORD = 21,
    SYSTEM_VALUE_FRONT_FACE = 22,
    SYSTEM_VALUE_SAMPLE_ID = 23,
    SYSTEM_VALUE_SAMPLE_POS = 24,
    SYSTEM_VALUE_SAMPLE_POS_OR_CENTER = 25,
    SYSTEM_VALUE_SAMPLE_MASK_IN = 26,
    SYSTEM_VALUE_LAYER_ID = 27,
    SYSTEM_VALUE_HELPER_INVOCATION = 28,
    SYSTEM_VALUE_COLOR0 = 29,
    SYSTEM_VALUE_COLOR1 = 30,
    SYSTEM_VALUE_TESS_COORD = 31,
    #[doc = "< Tessellation vertices in input patch"]
    SYSTEM_VALUE_VERTICES_IN = 32,
    SYSTEM_VALUE_PRIMITIVE_ID = 33,
    #[doc = "< TES input"]
    SYSTEM_VALUE_TESS_LEVEL_OUTER = 34,
    #[doc = "< TES input"]
    SYSTEM_VALUE_TESS_LEVEL_INNER = 35,
    #[doc = "< TCS input for passthru TCS"]
    SYSTEM_VALUE_TESS_LEVEL_OUTER_DEFAULT = 36,
    #[doc = "< TCS input for passthru TCS"]
    SYSTEM_VALUE_TESS_LEVEL_INNER_DEFAULT = 37,
    SYSTEM_VALUE_LOCAL_INVOCATION_ID = 38,
    SYSTEM_VALUE_LOCAL_INVOCATION_INDEX = 39,
    SYSTEM_VALUE_GLOBAL_INVOCATION_ID = 40,
    SYSTEM_VALUE_BASE_GLOBAL_INVOCATION_ID = 41,
    SYSTEM_VALUE_GLOBAL_INVOCATION_INDEX = 42,
    SYSTEM_VALUE_WORKGROUP_ID = 43,
    SYSTEM_VALUE_WORKGROUP_INDEX = 44,
    SYSTEM_VALUE_NUM_WORKGROUPS = 45,
    SYSTEM_VALUE_WORKGROUP_SIZE = 46,
    SYSTEM_VALUE_GLOBAL_GROUP_SIZE = 47,
    SYSTEM_VALUE_WORK_DIM = 48,
    SYSTEM_VALUE_USER_DATA_AMD = 49,
    #[doc = " Required for VK_KHR_device_group"]
    SYSTEM_VALUE_DEVICE_INDEX = 50,
    #[doc = " Required for VK_KHX_multiview"]
    SYSTEM_VALUE_VIEW_INDEX = 51,
    #[doc = " Driver internal vertex-count, used (for example) for drivers to\n calculate stride for stream-out outputs.  Not externally visible."]
    SYSTEM_VALUE_VERTEX_CNT = 52,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_PIXEL = 53,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_SAMPLE = 54,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_CENTROID = 55,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_CENTER_RHW = 56,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_PIXEL = 57,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_CENTROID = 58,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_SAMPLE = 59,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PULL_MODEL = 60,
    SYSTEM_VALUE_BARYCENTRIC_PERSP_COORD = 61,
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_COORD = 62,
    SYSTEM_VALUE_RAY_LAUNCH_ID = 63,
    SYSTEM_VALUE_RAY_LAUNCH_SIZE = 64,
    SYSTEM_VALUE_RAY_WORLD_ORIGIN = 65,
    SYSTEM_VALUE_RAY_WORLD_DIRECTION = 66,
    SYSTEM_VALUE_RAY_OBJECT_ORIGIN = 67,
    SYSTEM_VALUE_RAY_OBJECT_DIRECTION = 68,
    SYSTEM_VALUE_RAY_T_MIN = 69,
    SYSTEM_VALUE_RAY_T_MAX = 70,
    SYSTEM_VALUE_RAY_OBJECT_TO_WORLD = 71,
    SYSTEM_VALUE_RAY_WORLD_TO_OBJECT = 72,
    SYSTEM_VALUE_RAY_HIT_KIND = 73,
    SYSTEM_VALUE_RAY_FLAGS = 74,
    SYSTEM_VALUE_RAY_GEOMETRY_INDEX = 75,
    SYSTEM_VALUE_RAY_INSTANCE_CUSTOM_INDEX = 76,
    SYSTEM_VALUE_CULL_MASK = 77,
    SYSTEM_VALUE_RAY_TRIANGLE_VERTEX_POSITIONS = 78,
    SYSTEM_VALUE_MESH_VIEW_COUNT = 79,
    SYSTEM_VALUE_MESH_VIEW_INDICES = 80,
    #[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
    SYSTEM_VALUE_GS_HEADER_IR3 = 81,
    #[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
    SYSTEM_VALUE_TCS_HEADER_IR3 = 82,
    #[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
    SYSTEM_VALUE_REL_PATCH_ID_IR3 = 83,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FRAG_SHADING_RATE = 84,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FULLY_COVERED = 85,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FRAG_SIZE = 86,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FRAG_INVOCATION_COUNT = 87,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_SHADER_INDEX = 88,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_COALESCED_INPUT_COUNT = 89,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_WARPS_PER_SM_NV = 90,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_SM_COUNT_NV = 91,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_WARP_ID_NV = 92,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_SM_ID_NV = 93,
    #[doc = "< Number of values"]
    SYSTEM_VALUE_MAX = 94,
}
#[repr(u32)]
#[doc = " The possible interpolation qualifiers that can be applied to a fragment\n shader input in GLSL.\n\n Note: INTERP_MODE_NONE must be 0 so that memsetting the\n ir_variable data structure to 0 causes the default behavior."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_interp_mode {
    INTERP_MODE_NONE = 0,
    INTERP_MODE_SMOOTH = 1,
    INTERP_MODE_FLAT = 2,
    INTERP_MODE_NOPERSPECTIVE = 3,
    INTERP_MODE_EXPLICIT = 4,
    #[doc = "< Number of interpolation qualifiers"]
    INTERP_MODE_COUNT = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_interface_packing {
    GLSL_INTERFACE_PACKING_STD140 = 0,
    GLSL_INTERFACE_PACKING_SHARED = 1,
    GLSL_INTERFACE_PACKING_PACKED = 2,
    GLSL_INTERFACE_PACKING_STD430 = 3,
}
extern "C" {
    pub fn glsl_interp_mode_name(qual: glsl_interp_mode) -> *const ::std::os::raw::c_char;
}
#[repr(u32)]
#[doc = " \\brief Layout qualifiers for gl_FragDepth.\n\n Extension AMD_conservative_depth allows gl_FragDepth to be redeclared with\n a layout qualifier.\n\n \\see enum ir_depth_layout"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_frag_depth_layout {
    #[doc = "< No layout is specified."]
    FRAG_DEPTH_LAYOUT_NONE = 0,
    FRAG_DEPTH_LAYOUT_ANY = 1,
    FRAG_DEPTH_LAYOUT_GREATER = 2,
    FRAG_DEPTH_LAYOUT_LESS = 3,
    FRAG_DEPTH_LAYOUT_UNCHANGED = 4,
}
#[repr(u32)]
#[doc = " \\brief Layout qualifiers for AMD_shader_early_and_late_fragment_tests."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_frag_stencil_layout {
    #[doc = "< No layout is specified."]
    FRAG_STENCIL_LAYOUT_NONE = 0,
    FRAG_STENCIL_LAYOUT_ANY = 1,
    FRAG_STENCIL_LAYOUT_GREATER = 2,
    FRAG_STENCIL_LAYOUT_LESS = 3,
    FRAG_STENCIL_LAYOUT_UNCHANGED = 4,
}
impl gl_access_qualifier {
    #[doc = " This means that the memory scope is the current device. It indicates\n that reads and writes are coherent with reads and writes from other\n shader invocations and other workgroups."]
    pub const ACCESS_COHERENT: gl_access_qualifier = gl_access_qualifier(1);
}
impl gl_access_qualifier {
    #[doc = " This means non-aliased. It indicates that the accessed address is not\n accessible through any other memory resource in the shader."]
    pub const ACCESS_RESTRICT: gl_access_qualifier = gl_access_qualifier(2);
}
impl gl_access_qualifier {
    #[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
    pub const ACCESS_VOLATILE: gl_access_qualifier = gl_access_qualifier(4);
}
impl gl_access_qualifier {
    #[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
    pub const ACCESS_NON_READABLE: gl_access_qualifier = gl_access_qualifier(8);
}
impl gl_access_qualifier {
    #[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
    pub const ACCESS_NON_WRITEABLE: gl_access_qualifier = gl_access_qualifier(16);
}
impl gl_access_qualifier {
    #[doc = " The access may use a non-uniform buffer or image index.\n\n This is not allowed in either OpenGL or OpenGL ES, or Vulkan unless\n VK_EXT_descriptor_indexing is supported and the appropriate capability is\n enabled.\n\n Some GL spec archaeology justifying this:\n\n Up through at least GLSL ES 3.20 and GLSL 4.50,  \"Opaque Types\" says \"When\n aggregated into arrays within a shader, opaque types can only be indexed\n with a dynamically uniform integral expression (see section 3.9.3) unless\n otherwise noted; otherwise, results are undefined.\"\n\n The original GL_AB_shader_image_load_store specification for desktop GL\n didn't have this restriction (\"Images may be aggregated into arrays within\n a shader (using square brackets [ ]) and can be indexed with general\n integer expressions.\")  At the same time,\n GL_ARB_shader_storage_buffer_objects *did* have the uniform restriction\n (\"A uniform or shader storage block array can only be indexed with a\n dynamically uniform integral expression, otherwise results are\n undefined\"), just like ARB_gpu_shader5 did when it first introduced a\n non-constant indexing of an opaque type with samplers.  So, we assume that\n this was an oversight in the original image_load_store spec, and was\n considered a correction in the merge to core."]
    pub const ACCESS_NON_UNIFORM: gl_access_qualifier = gl_access_qualifier(32);
}
impl gl_access_qualifier {
    #[doc = " The access may use a non-uniform buffer or image index.\n\n This is not allowed in either OpenGL or OpenGL ES, or Vulkan unless\n VK_EXT_descriptor_indexing is supported and the appropriate capability is\n enabled.\n\n Some GL spec archaeology justifying this:\n\n Up through at least GLSL ES 3.20 and GLSL 4.50,  \"Opaque Types\" says \"When\n aggregated into arrays within a shader, opaque types can only be indexed\n with a dynamically uniform integral expression (see section 3.9.3) unless\n otherwise noted; otherwise, results are undefined.\"\n\n The original GL_AB_shader_image_load_store specification for desktop GL\n didn't have this restriction (\"Images may be aggregated into arrays within\n a shader (using square brackets [ ]) and can be indexed with general\n integer expressions.\")  At the same time,\n GL_ARB_shader_storage_buffer_objects *did* have the uniform restriction\n (\"A uniform or shader storage block array can only be indexed with a\n dynamically uniform integral expression, otherwise results are\n undefined\"), just like ARB_gpu_shader5 did when it first introduced a\n non-constant indexing of an opaque type with samplers.  So, we assume that\n this was an oversight in the original image_load_store spec, and was\n considered a correction in the merge to core."]
    pub const ACCESS_CAN_REORDER: gl_access_qualifier = gl_access_qualifier(64);
}
impl gl_access_qualifier {
    #[doc = " Hints that the accessed address is not likely to be accessed again\n in the near future. This reduces data retention in caches."]
    pub const ACCESS_NON_TEMPORAL: gl_access_qualifier = gl_access_qualifier(128);
}
impl gl_access_qualifier {
    #[doc = " Execute instruction also in helpers."]
    pub const ACCESS_INCLUDE_HELPERS: gl_access_qualifier = gl_access_qualifier(256);
}
impl gl_access_qualifier {
    #[doc = " Whether the address bits are swizzled by the hw. This practically means\n that loads can't be vectorized and must be exactly 32 bits on some chips.\n The swizzle amount is determined by the descriptor."]
    pub const ACCESS_IS_SWIZZLED_AMD: gl_access_qualifier = gl_access_qualifier(512);
}
impl gl_access_qualifier {
    #[doc = " Whether an AMD-specific buffer intrinsic uses a format conversion.\n\n If unset, the intrinsic will access raw memory without any conversion.\n\n If set, the memory opcode performs a format conversion according to\n the format determined by the descriptor (in a manner identical to image\n buffers and sampler buffers)."]
    pub const ACCESS_USES_FORMAT_AMD: gl_access_qualifier = gl_access_qualifier(1024);
}
impl gl_access_qualifier {
    #[doc = " Whether a multi sample image load intrinsic uses sample index extracted\n from fragment mask buffer."]
    pub const ACCESS_FMASK_LOWERED_AMD: gl_access_qualifier = gl_access_qualifier(2048);
}
impl gl_access_qualifier {
    #[doc = " Whether it is safe to speculatively execute this load. This allows\n hoisting loads out of conditional control flow (including out of software\n bounds checks). Setting this optimally depends on knowledge of the\n hardware. Speculation is safe if out-of-bounds access does not trigger\n undefined behaviour (even though the returned value of the speculated load\n is bogus). This is the case if there is hardware-level bounds checking, or\n if MMU faults are suppressed for the load."]
    pub const ACCESS_CAN_SPECULATE: gl_access_qualifier = gl_access_qualifier(4096);
}
impl ::std::ops::BitOr<gl_access_qualifier> for gl_access_qualifier {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        gl_access_qualifier(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for gl_access_qualifier {
    #[inline]
    fn bitor_assign(&mut self, rhs: gl_access_qualifier) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<gl_access_qualifier> for gl_access_qualifier {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        gl_access_qualifier(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for gl_access_qualifier {
    #[inline]
    fn bitand_assign(&mut self, rhs: gl_access_qualifier) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[doc = " \\brief Memory access qualifiers"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct gl_access_qualifier(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum tess_primitive_mode {
    TESS_PRIMITIVE_UNSPECIFIED = 0,
    TESS_PRIMITIVE_TRIANGLES = 1,
    TESS_PRIMITIVE_QUADS = 2,
    TESS_PRIMITIVE_ISOLINES = 3,
}
impl mesa_prim {
    pub const MESA_PRIM_MAX: mesa_prim = mesa_prim::MESA_PRIM_PATCHES;
}
#[repr(u8)]
#[doc = " Mesa primitive types for both GL and Vulkan:"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum mesa_prim {
    MESA_PRIM_POINTS = 0,
    MESA_PRIM_LINES = 1,
    MESA_PRIM_LINE_LOOP = 2,
    MESA_PRIM_LINE_STRIP = 3,
    MESA_PRIM_TRIANGLES = 4,
    MESA_PRIM_TRIANGLE_STRIP = 5,
    MESA_PRIM_TRIANGLE_FAN = 6,
    MESA_PRIM_QUADS = 7,
    MESA_PRIM_QUAD_STRIP = 8,
    MESA_PRIM_POLYGON = 9,
    MESA_PRIM_LINES_ADJACENCY = 10,
    MESA_PRIM_LINE_STRIP_ADJACENCY = 11,
    MESA_PRIM_TRIANGLES_ADJACENCY = 12,
    MESA_PRIM_TRIANGLE_STRIP_ADJACENCY = 13,
    MESA_PRIM_PATCHES = 14,
    MESA_PRIM_COUNT = 15,
    MESA_PRIM_UNKNOWN = 28,
}
#[repr(u32)]
#[doc = " A compare function enum for use in compiler lowering passes.  This is in\n the same order as GL's compare functions (shifted down by GL_NEVER), and is\n exactly the same as gallium's PIPE_FUNC_*."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum compare_func {
    COMPARE_FUNC_NEVER = 0,
    COMPARE_FUNC_LESS = 1,
    COMPARE_FUNC_EQUAL = 2,
    COMPARE_FUNC_LEQUAL = 3,
    COMPARE_FUNC_GREATER = 4,
    COMPARE_FUNC_NOTEQUAL = 5,
    COMPARE_FUNC_GEQUAL = 6,
    COMPARE_FUNC_ALWAYS = 7,
}
#[repr(u32)]
#[doc = " Arrangements for grouping invocations from NV_compute_shader_derivatives.\n\n   The extension provides new layout qualifiers that support two different\n   arrangements of compute shader invocations for the purpose of derivative\n   computation.  When specifying\n\n     layout(derivative_group_quadsNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation ID values follow the pattern:\n\n       +-----------------+------------------+\n       | (2x+0, 2y+0, z) |  (2x+1, 2y+0, z) |\n       +-----------------+------------------+\n       | (2x+0, 2y+1, z) |  (2x+1, 2y+1, z) |\n       +-----------------+------------------+\n\n   where Y increases from bottom to top.  When specifying\n\n     layout(derivative_group_linearNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation index values follow the pattern:\n\n       +------+------+\n       | 4n+0 | 4n+1 |\n       +------+------+\n       | 4n+2 | 4n+3 |\n       +------+------+\n\n   If neither layout qualifier is specified, derivatives in compute shaders\n   return zero, which is consistent with the handling of built-in texture\n   functions like texture() in GLSL 4.50 compute shaders."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_derivative_group {
    DERIVATIVE_GROUP_NONE = 0,
    DERIVATIVE_GROUP_QUADS = 1,
    DERIVATIVE_GROUP_LINEAR = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum float_controls {
    FLOAT_CONTROLS_DEFAULT_FLOAT_CONTROL_MODE = 0,
    FLOAT_CONTROLS_DENORM_PRESERVE_FP16 = 1,
    FLOAT_CONTROLS_DENORM_PRESERVE_FP32 = 2,
    FLOAT_CONTROLS_DENORM_PRESERVE_FP64 = 4,
    FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP16 = 8,
    FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP32 = 16,
    FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP64 = 32,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP16 = 64,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP32 = 128,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP64 = 256,
    FLOAT_CONTROLS_INF_PRESERVE_FP16 = 512,
    FLOAT_CONTROLS_INF_PRESERVE_FP32 = 1024,
    FLOAT_CONTROLS_INF_PRESERVE_FP64 = 2048,
    FLOAT_CONTROLS_NAN_PRESERVE_FP16 = 4096,
    FLOAT_CONTROLS_NAN_PRESERVE_FP32 = 8192,
    FLOAT_CONTROLS_NAN_PRESERVE_FP64 = 16384,
    FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP16 = 32768,
    FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP32 = 65536,
    FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP64 = 131072,
    FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP16 = 262144,
    FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP32 = 524288,
    FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP64 = 1048576,
    FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP16 = 4672,
    FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP32 = 9344,
    FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP64 = 18688,
}
pub mod cl_sampler_addressing_mode {
    #[doc = " Enums to describe sampler properties used by OpenCL's inline constant samplers.\n These values match the meanings described in the SPIR-V spec."]
    pub type Type = ::std::os::raw::c_uint;
    pub const SAMPLER_ADDRESSING_MODE_NONE: Type = 0;
    pub const SAMPLER_ADDRESSING_MODE_CLAMP_TO_EDGE: Type = 1;
    pub const SAMPLER_ADDRESSING_MODE_CLAMP: Type = 2;
    pub const SAMPLER_ADDRESSING_MODE_REPEAT: Type = 3;
    pub const SAMPLER_ADDRESSING_MODE_REPEAT_MIRRORED: Type = 4;
}
pub mod cl_sampler_filter_mode {
    pub type Type = ::std::os::raw::c_uint;
    pub const SAMPLER_FILTER_MODE_NEAREST: Type = 0;
    pub const SAMPLER_FILTER_MODE_LINEAR: Type = 1;
}
#[repr(u8)]
#[doc = " An enum representing what kind of input gl_SubgroupSize is."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_subgroup_size {
    #[doc = " Actual subgroup size, whatever that happens to be"]
    SUBGROUP_SIZE_VARYING = 0,
    #[doc = " Subgroup size must appear to be draw or dispatch-uniform\n\n This is the OpenGL behavior"]
    SUBGROUP_SIZE_UNIFORM = 1,
    #[doc = " Subgroup size must appear to be the API advertised constant\n\n This is the default Vulkan 1.1 behavior"]
    SUBGROUP_SIZE_API_CONSTANT = 2,
    #[doc = " Subgroup size must actually be the API advertised constant\n\n Not only must the subgroup size match the API advertised constant as\n with SUBGROUP_SIZE_API_CONSTANT but it must also be dispatched such that\n all the subgroups are full if there are enough invocations."]
    SUBGROUP_SIZE_FULL_SUBGROUPS = 3,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_8 = 8,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_16 = 16,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_32 = 32,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_64 = 64,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_128 = 128,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum mesa_scope {
    SCOPE_NONE = 0,
    SCOPE_INVOCATION = 1,
    SCOPE_SUBGROUP = 2,
    SCOPE_SHADER_CALL = 3,
    SCOPE_WORKGROUP = 4,
    SCOPE_QUEUE_FAMILY = 5,
    SCOPE_DEVICE = 6,
}
extern "C" {
    pub fn mesa_scope_name(scope: mesa_scope) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct blob {
    pub data: *mut u8,
    #[doc = " Number of bytes that have been allocated for \\c data."]
    pub allocated: usize,
    #[doc = " The number of bytes that have actual data written to them."]
    pub size: usize,
    #[doc = " True if \\c data a fixed allocation that we cannot resize\n\n \\see blob_init_fixed"]
    pub fixed_allocation: bool,
    #[doc = " True if we've ever failed to realloc or if we go past the end of a fixed\n allocation blob."]
    pub out_of_memory: bool,
}
#[test]
fn bindgen_test_layout_blob() {
    const UNINIT: ::std::mem::MaybeUninit<blob> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blob>(),
        32usize,
        concat!("Size of: ", stringify!(blob))
    );
    assert_eq!(
        ::std::mem::align_of::<blob>(),
        8usize,
        concat!("Alignment of ", stringify!(blob))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blob),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).allocated) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blob),
            "::",
            stringify!(allocated)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blob),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fixed_allocation) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blob),
            "::",
            stringify!(fixed_allocation)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).out_of_memory) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(blob),
            "::",
            stringify!(out_of_memory)
        )
    );
}
impl Default for blob {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct blob_reader {
    pub data: *const u8,
    pub end: *const u8,
    pub current: *const u8,
    pub overrun: bool,
}
#[test]
fn bindgen_test_layout_blob_reader() {
    const UNINIT: ::std::mem::MaybeUninit<blob_reader> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blob_reader>(),
        32usize,
        concat!("Size of: ", stringify!(blob_reader))
    );
    assert_eq!(
        ::std::mem::align_of::<blob_reader>(),
        8usize,
        concat!("Alignment of ", stringify!(blob_reader))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blob_reader),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blob_reader),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).current) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blob_reader),
            "::",
            stringify!(current)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overrun) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blob_reader),
            "::",
            stringify!(overrun)
        )
    );
}
impl Default for blob_reader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[doc = " Init a new, empty blob."]
    pub fn blob_init(blob: *mut blob);
}
extern "C" {
    #[doc = " Init a new, fixed-size blob.\n\n A fixed-size blob has a fixed block of data that will not be freed on\n blob_finish and will never be grown.  If we hit the end, we simply start\n returning false from the write functions.\n\n If a fixed-size blob has a NULL data pointer then the data is written but\n it otherwise operates normally.  This can be used to determine the size\n that will be required to write a given data structure."]
    pub fn blob_init_fixed(blob: *mut blob, data: *mut ::std::os::raw::c_void, size: usize);
}
extern "C" {
    pub fn blob_finish_get_buffer(
        blob: *mut blob,
        buffer: *mut *mut ::std::os::raw::c_void,
        size: *mut usize,
    );
}
extern "C" {
    #[doc = " Aligns the blob to the given alignment.\n\n \\see blob_reader_align\n\n \\return True unless allocation fails"]
    pub fn blob_align(blob: *mut blob, alignment: usize) -> bool;
}
extern "C" {
    #[doc = " Add some unstructured, fixed-size data to a blob.\n\n \\return True unless allocation failed."]
    pub fn blob_write_bytes(
        blob: *mut blob,
        bytes: *const ::std::os::raw::c_void,
        to_write: usize,
    ) -> bool;
}
extern "C" {
    #[doc = " Reserve space in \\blob for a number of bytes.\n\n Space will be allocated within the blob for these byes, but the bytes will\n be left uninitialized. The caller is expected to use \\sa\n blob_overwrite_bytes to write to these bytes.\n\n \\return An offset to space allocated within \\blob to which \\to_write bytes\n can be written, (or -1 in case of any allocation error)."]
    pub fn blob_reserve_bytes(blob: *mut blob, to_write: usize) -> isize;
}
extern "C" {
    #[doc = " Similar to \\sa blob_reserve_bytes, but only reserves an uint32_t worth of\n space. Note that this must be used if later reading with \\sa\n blob_read_uint32, since it aligns the offset correctly."]
    pub fn blob_reserve_uint32(blob: *mut blob) -> isize;
}
extern "C" {
    #[doc = " Similar to \\sa blob_reserve_bytes, but only reserves an intptr_t worth of\n space. Note that this must be used if later reading with \\sa\n blob_read_intptr, since it aligns the offset correctly."]
    pub fn blob_reserve_intptr(blob: *mut blob) -> isize;
}
extern "C" {
    #[doc = " Overwrite some data previously written to the blob.\n\n Writes data to an existing portion of the blob at an offset of \\offset.\n This data range must have previously been written to the blob by one of the\n blob_write_* calls.\n\n For example usage, see blob_overwrite_uint32\n\n \\return True unless the requested offset or offset+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_bytes(
        blob: *mut blob,
        offset: usize,
        bytes: *const ::std::os::raw::c_void,
        to_write: usize,
    ) -> bool;
}
extern "C" {
    #[doc = " Add a uint8_t to a blob.\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint8(blob: *mut blob, value: u8) -> bool;
}
extern "C" {
    #[doc = " Overwrite a uint8_t previously written to the blob.\n\n Writes a uint8_t value to an existing portion of the blob at an offset of\n \\offset.  This data range must have previously been written to the blob by\n one of the blob_write_* calls.\n\n \\return True unless the requested position or position+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_uint8(blob: *mut blob, offset: usize, value: u8) -> bool;
}
extern "C" {
    #[doc = " Add a uint16_t to a blob.\n\n \\note This function will only write to a uint16_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint16(blob: *mut blob, value: u16) -> bool;
}
extern "C" {
    #[doc = " Add a uint32_t to a blob.\n\n \\note This function will only write to a uint32_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint32(blob: *mut blob, value: u32) -> bool;
}
extern "C" {
    #[doc = " Overwrite a uint32_t previously written to the blob.\n\n Writes a uint32_t value to an existing portion of the blob at an offset of\n \\offset.  This data range must have previously been written to the blob by\n one of the blob_write_* calls.\n\n\n The expected usage is something like the following pattern:\n\n\tsize_t offset;\n\n\toffset = blob_reserve_uint32(blob);\n\t... various blob write calls, writing N items ...\n\tblob_overwrite_uint32 (blob, offset, N);\n\n \\return True unless the requested position or position+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_uint32(blob: *mut blob, offset: usize, value: u32) -> bool;
}
extern "C" {
    #[doc = " Add a uint64_t to a blob.\n\n \\note This function will only write to a uint64_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint64(blob: *mut blob, value: u64) -> bool;
}
extern "C" {
    #[doc = " Add an intptr_t to a blob.\n\n \\note This function will only write to an intptr_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_intptr(blob: *mut blob, value: isize) -> bool;
}
extern "C" {
    #[doc = " Overwrite an intptr_t previously written to the blob.\n\n Writes a intptr_t value to an existing portion of the blob at an offset of\n \\offset.  This data range must have previously been written to the blob by\n one of the blob_write_* calls.\n\n For example usage, see blob_overwrite_uint32\n\n \\return True unless the requested position or position+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_intptr(blob: *mut blob, offset: usize, value: isize) -> bool;
}
extern "C" {
    #[doc = " Add a NULL-terminated string to a blob, (including the NULL terminator).\n\n \\return True unless allocation failed."]
    pub fn blob_write_string(blob: *mut blob, str_: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    #[doc = " Start reading a blob, (initializing the contents of \\blob for reading).\n\n After this call, the caller can use the various blob_read_* functions to\n read elements from the data array.\n\n For all of the blob_read_* functions, if there is insufficient data\n remaining, the functions will do nothing, (perhaps returning default values\n such as 0). The caller can detect this by noting that the blob_reader's\n current value is unchanged before and after the call."]
    pub fn blob_reader_init(
        blob: *mut blob_reader,
        data: *const ::std::os::raw::c_void,
        size: usize,
    );
}
extern "C" {
    #[doc = " Align the current offset of the blob reader to the given alignment.\n\n This may be useful if you need the result of blob_read_bytes to have a\n particular alignment.  Note that this only aligns relative to blob->data\n and the alignment of the resulting pointer is only guaranteed if blob->data\n is also aligned to the requested alignment."]
    pub fn blob_reader_align(blob: *mut blob_reader, alignment: usize);
}
extern "C" {
    #[doc = " Read some unstructured, fixed-size data from the current location, (and\n update the current location to just past this data).\n\n \\note The memory returned belongs to the data underlying the blob reader. The\n caller must copy the data in order to use it after the lifetime of the data\n underlying the blob reader.\n\n \\return The bytes read (see note above about memory lifetime)."]
    pub fn blob_read_bytes(blob: *mut blob_reader, size: usize) -> *const ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Read some unstructured, fixed-size data from the current location, copying\n it to \\dest (and update the current location to just past this data)"]
    pub fn blob_copy_bytes(blob: *mut blob_reader, dest: *mut ::std::os::raw::c_void, size: usize);
}
extern "C" {
    #[doc = " Skip \\size bytes within the blob."]
    pub fn blob_skip_bytes(blob: *mut blob_reader, size: usize);
}
extern "C" {
    #[doc = " Read a uint8_t from the current location, (and update the current location\n to just past this uint8_t).\n\n \\return The uint8_t read"]
    pub fn blob_read_uint8(blob: *mut blob_reader) -> u8;
}
extern "C" {
    #[doc = " Read a uint16_t from the current location, (and update the current location\n to just past this uint16_t).\n\n \\note This function will only read from a uint16_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The uint16_t read"]
    pub fn blob_read_uint16(blob: *mut blob_reader) -> u16;
}
extern "C" {
    #[doc = " Read a uint32_t from the current location, (and update the current location\n to just past this uint32_t).\n\n \\note This function will only read from a uint32_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The uint32_t read"]
    pub fn blob_read_uint32(blob: *mut blob_reader) -> u32;
}
extern "C" {
    #[doc = " Read a uint64_t from the current location, (and update the current location\n to just past this uint64_t).\n\n \\note This function will only read from a uint64_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The uint64_t read"]
    pub fn blob_read_uint64(blob: *mut blob_reader) -> u64;
}
extern "C" {
    #[doc = " Read an intptr_t value from the current location, (and update the\n current location to just past this intptr_t).\n\n \\note This function will only read from an intptr_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The intptr_t read"]
    pub fn blob_read_intptr(blob: *mut blob_reader) -> isize;
}
extern "C" {
    #[doc = " Read a NULL-terminated string from the current location, (and update the\n current location to just past this string).\n\n \\note The memory returned belongs to the data underlying the blob reader. The\n caller must copy the string in order to use the string after the lifetime\n of the data underlying the blob reader.\n\n \\return The string read (see note above about memory lifetime). However, if\n there is no NULL byte remaining within the blob, this function returns\n NULL."]
    pub fn blob_read_string(blob: *mut blob_reader) -> *mut ::std::os::raw::c_char;
}
#[repr(u32)]
#[doc = " Formats for textures, surfaces and vertex data"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_format {
    PIPE_FORMAT_NONE = 0,
    #[doc = "< raw doubles (ARB_vertex_attrib_64bit)"]
    PIPE_FORMAT_R64_UINT = 1,
    PIPE_FORMAT_R64G64_UINT = 2,
    PIPE_FORMAT_R64G64B64_UINT = 3,
    PIPE_FORMAT_R64G64B64A64_UINT = 4,
    PIPE_FORMAT_R64_SINT = 5,
    PIPE_FORMAT_R64G64_SINT = 6,
    PIPE_FORMAT_R64G64B64_SINT = 7,
    PIPE_FORMAT_R64G64B64A64_SINT = 8,
    #[doc = "< doubles converted to float"]
    PIPE_FORMAT_R64_FLOAT = 9,
    PIPE_FORMAT_R64G64_FLOAT = 10,
    PIPE_FORMAT_R64G64B64_FLOAT = 11,
    PIPE_FORMAT_R64G64B64A64_FLOAT = 12,
    PIPE_FORMAT_R32_FLOAT = 13,
    PIPE_FORMAT_R32G32_FLOAT = 14,
    PIPE_FORMAT_R32G32B32_FLOAT = 15,
    PIPE_FORMAT_R32G32B32A32_FLOAT = 16,
    PIPE_FORMAT_R32_UNORM = 17,
    PIPE_FORMAT_R32G32_UNORM = 18,
    PIPE_FORMAT_R32G32B32_UNORM = 19,
    PIPE_FORMAT_R32G32B32A32_UNORM = 20,
    PIPE_FORMAT_R32_USCALED = 21,
    PIPE_FORMAT_R32G32_USCALED = 22,
    PIPE_FORMAT_R32G32B32_USCALED = 23,
    PIPE_FORMAT_R32G32B32A32_USCALED = 24,
    PIPE_FORMAT_R32_SNORM = 25,
    PIPE_FORMAT_R32G32_SNORM = 26,
    PIPE_FORMAT_R32G32B32_SNORM = 27,
    PIPE_FORMAT_R32G32B32A32_SNORM = 28,
    PIPE_FORMAT_R32_SSCALED = 29,
    PIPE_FORMAT_R32G32_SSCALED = 30,
    PIPE_FORMAT_R32G32B32_SSCALED = 31,
    PIPE_FORMAT_R32G32B32A32_SSCALED = 32,
    PIPE_FORMAT_R16_UNORM = 33,
    PIPE_FORMAT_R16G16_UNORM = 34,
    PIPE_FORMAT_R16G16B16_UNORM = 35,
    PIPE_FORMAT_R16G16B16A16_UNORM = 36,
    PIPE_FORMAT_R16_USCALED = 37,
    PIPE_FORMAT_R16G16_USCALED = 38,
    PIPE_FORMAT_R16G16B16_USCALED = 39,
    PIPE_FORMAT_R16G16B16A16_USCALED = 40,
    PIPE_FORMAT_R16_SNORM = 41,
    PIPE_FORMAT_R16G16_SNORM = 42,
    PIPE_FORMAT_R16G16B16_SNORM = 43,
    PIPE_FORMAT_R16G16B16A16_SNORM = 44,
    PIPE_FORMAT_R16_SSCALED = 45,
    PIPE_FORMAT_R16G16_SSCALED = 46,
    PIPE_FORMAT_R16G16B16_SSCALED = 47,
    PIPE_FORMAT_R16G16B16A16_SSCALED = 48,
    PIPE_FORMAT_R8_UNORM = 49,
    PIPE_FORMAT_R8G8_UNORM = 50,
    PIPE_FORMAT_R8G8B8_UNORM = 51,
    PIPE_FORMAT_B8G8R8_UNORM = 52,
    PIPE_FORMAT_R8G8B8A8_UNORM = 53,
    PIPE_FORMAT_B8G8R8A8_UNORM = 54,
    PIPE_FORMAT_R8_USCALED = 55,
    PIPE_FORMAT_R8G8_USCALED = 56,
    PIPE_FORMAT_R8G8B8_USCALED = 57,
    PIPE_FORMAT_B8G8R8_USCALED = 58,
    PIPE_FORMAT_R8G8B8A8_USCALED = 59,
    PIPE_FORMAT_B8G8R8A8_USCALED = 60,
    PIPE_FORMAT_A8B8G8R8_USCALED = 61,
    PIPE_FORMAT_R8_SNORM = 62,
    PIPE_FORMAT_R8G8_SNORM = 63,
    PIPE_FORMAT_R8G8B8_SNORM = 64,
    PIPE_FORMAT_B8G8R8_SNORM = 65,
    PIPE_FORMAT_R8G8B8A8_SNORM = 66,
    PIPE_FORMAT_B8G8R8A8_SNORM = 67,
    PIPE_FORMAT_R8_SSCALED = 68,
    PIPE_FORMAT_R8G8_SSCALED = 69,
    PIPE_FORMAT_R8G8B8_SSCALED = 70,
    PIPE_FORMAT_B8G8R8_SSCALED = 71,
    PIPE_FORMAT_R8G8B8A8_SSCALED = 72,
    PIPE_FORMAT_B8G8R8A8_SSCALED = 73,
    PIPE_FORMAT_A8B8G8R8_SSCALED = 74,
    PIPE_FORMAT_A8R8G8B8_UNORM = 75,
    PIPE_FORMAT_R32_FIXED = 76,
    PIPE_FORMAT_R32G32_FIXED = 77,
    PIPE_FORMAT_R32G32B32_FIXED = 78,
    PIPE_FORMAT_R32G32B32A32_FIXED = 79,
    PIPE_FORMAT_R16_FLOAT = 80,
    PIPE_FORMAT_R16G16_FLOAT = 81,
    PIPE_FORMAT_R16G16B16_FLOAT = 82,
    PIPE_FORMAT_R16G16B16A16_FLOAT = 83,
    PIPE_FORMAT_R8_UINT = 84,
    PIPE_FORMAT_R8G8_UINT = 85,
    PIPE_FORMAT_R8G8B8_UINT = 86,
    PIPE_FORMAT_B8G8R8_UINT = 87,
    PIPE_FORMAT_R8G8B8A8_UINT = 88,
    PIPE_FORMAT_B8G8R8A8_UINT = 89,
    PIPE_FORMAT_R8_SINT = 90,
    PIPE_FORMAT_R8G8_SINT = 91,
    PIPE_FORMAT_R8G8B8_SINT = 92,
    PIPE_FORMAT_B8G8R8_SINT = 93,
    PIPE_FORMAT_R8G8B8A8_SINT = 94,
    PIPE_FORMAT_B8G8R8A8_SINT = 95,
    PIPE_FORMAT_R16_UINT = 96,
    PIPE_FORMAT_R16G16_UINT = 97,
    PIPE_FORMAT_R16G16B16_UINT = 98,
    PIPE_FORMAT_R16G16B16A16_UINT = 99,
    PIPE_FORMAT_R16_SINT = 100,
    PIPE_FORMAT_R16G16_SINT = 101,
    PIPE_FORMAT_R16G16B16_SINT = 102,
    PIPE_FORMAT_R16G16B16A16_SINT = 103,
    PIPE_FORMAT_R32_UINT = 104,
    PIPE_FORMAT_R32G32_UINT = 105,
    PIPE_FORMAT_R32G32B32_UINT = 106,
    PIPE_FORMAT_R32G32B32A32_UINT = 107,
    PIPE_FORMAT_R32_SINT = 108,
    PIPE_FORMAT_R32G32_SINT = 109,
    PIPE_FORMAT_R32G32B32_SINT = 110,
    PIPE_FORMAT_R32G32B32A32_SINT = 111,
    PIPE_FORMAT_R10G10B10A2_UNORM = 112,
    PIPE_FORMAT_R10G10B10A2_SNORM = 113,
    PIPE_FORMAT_R10G10B10A2_USCALED = 114,
    PIPE_FORMAT_R10G10B10A2_SSCALED = 115,
    PIPE_FORMAT_B10G10R10A2_UNORM = 116,
    PIPE_FORMAT_B10G10R10A2_SNORM = 117,
    PIPE_FORMAT_B10G10R10A2_USCALED = 118,
    PIPE_FORMAT_B10G10R10A2_SSCALED = 119,
    PIPE_FORMAT_R11G11B10_FLOAT = 120,
    PIPE_FORMAT_R10G10B10A2_UINT = 121,
    PIPE_FORMAT_R10G10B10A2_SINT = 122,
    PIPE_FORMAT_B10G10R10A2_UINT = 123,
    PIPE_FORMAT_B10G10R10A2_SINT = 124,
    PIPE_FORMAT_B8G8R8X8_UNORM = 125,
    PIPE_FORMAT_X8B8G8R8_UNORM = 126,
    PIPE_FORMAT_X8R8G8B8_UNORM = 127,
    PIPE_FORMAT_B5G5R5A1_UNORM = 128,
    PIPE_FORMAT_R4G4B4A4_UNORM = 129,
    PIPE_FORMAT_B4G4R4A4_UNORM = 130,
    PIPE_FORMAT_R5G6B5_UNORM = 131,
    PIPE_FORMAT_B5G6R5_UNORM = 132,
    #[doc = "< ubyte luminance"]
    PIPE_FORMAT_L8_UNORM = 133,
    #[doc = "< ubyte alpha"]
    PIPE_FORMAT_A8_UNORM = 134,
    #[doc = "< ubyte intensity"]
    PIPE_FORMAT_I8_UNORM = 135,
    #[doc = "< ubyte alpha, luminance"]
    PIPE_FORMAT_L8A8_UNORM = 136,
    #[doc = "< ushort luminance"]
    PIPE_FORMAT_L16_UNORM = 137,
    PIPE_FORMAT_UYVY = 138,
    PIPE_FORMAT_VYUY = 139,
    PIPE_FORMAT_YUYV = 140,
    PIPE_FORMAT_YVYU = 141,
    PIPE_FORMAT_Z16_UNORM = 142,
    PIPE_FORMAT_Z16_UNORM_S8_UINT = 143,
    PIPE_FORMAT_Z32_UNORM = 144,
    PIPE_FORMAT_Z32_FLOAT = 145,
    PIPE_FORMAT_Z24_UNORM_S8_UINT = 146,
    PIPE_FORMAT_S8_UINT_Z24_UNORM = 147,
    PIPE_FORMAT_Z24X8_UNORM = 148,
    PIPE_FORMAT_X8Z24_UNORM = 149,
    #[doc = "< ubyte stencil"]
    PIPE_FORMAT_S8_UINT = 150,
    PIPE_FORMAT_L8_SRGB = 151,
    PIPE_FORMAT_R8_SRGB = 152,
    PIPE_FORMAT_L8A8_SRGB = 153,
    PIPE_FORMAT_R8G8_SRGB = 154,
    PIPE_FORMAT_R8G8B8_SRGB = 155,
    PIPE_FORMAT_B8G8R8_SRGB = 156,
    PIPE_FORMAT_A8B8G8R8_SRGB = 157,
    PIPE_FORMAT_X8B8G8R8_SRGB = 158,
    PIPE_FORMAT_B8G8R8A8_SRGB = 159,
    PIPE_FORMAT_B8G8R8X8_SRGB = 160,
    PIPE_FORMAT_A8R8G8B8_SRGB = 161,
    PIPE_FORMAT_X8R8G8B8_SRGB = 162,
    PIPE_FORMAT_R8G8B8A8_SRGB = 163,
    PIPE_FORMAT_DXT1_RGB = 164,
    PIPE_FORMAT_DXT1_RGBA = 165,
    PIPE_FORMAT_DXT3_RGBA = 166,
    PIPE_FORMAT_DXT5_RGBA = 167,
    PIPE_FORMAT_DXT1_SRGB = 168,
    PIPE_FORMAT_DXT1_SRGBA = 169,
    PIPE_FORMAT_DXT3_SRGBA = 170,
    PIPE_FORMAT_DXT5_SRGBA = 171,
    PIPE_FORMAT_RGTC1_UNORM = 172,
    PIPE_FORMAT_RGTC1_SNORM = 173,
    PIPE_FORMAT_RGTC2_UNORM = 174,
    PIPE_FORMAT_RGTC2_SNORM = 175,
    PIPE_FORMAT_R8G8_B8G8_UNORM = 176,
    PIPE_FORMAT_G8R8_G8B8_UNORM = 177,
    PIPE_FORMAT_R8SG8SB8UX8U_NORM = 178,
    PIPE_FORMAT_R5SG5SB6U_NORM = 179,
    PIPE_FORMAT_A8B8G8R8_UNORM = 180,
    PIPE_FORMAT_B5G5R5X1_UNORM = 181,
    PIPE_FORMAT_R9G9B9E5_FLOAT = 182,
    PIPE_FORMAT_Z32_FLOAT_S8X24_UINT = 183,
    PIPE_FORMAT_R1_UNORM = 184,
    PIPE_FORMAT_R10G10B10X2_USCALED = 185,
    PIPE_FORMAT_R10G10B10X2_SNORM = 186,
    PIPE_FORMAT_L4A4_UNORM = 187,
    PIPE_FORMAT_A2R10G10B10_UNORM = 188,
    PIPE_FORMAT_A2B10G10R10_UNORM = 189,
    PIPE_FORMAT_R10SG10SB10SA2U_NORM = 190,
    PIPE_FORMAT_R8G8Bx_SNORM = 191,
    PIPE_FORMAT_R8G8B8X8_UNORM = 192,
    PIPE_FORMAT_B4G4R4X4_UNORM = 193,
    PIPE_FORMAT_X24S8_UINT = 194,
    PIPE_FORMAT_S8X24_UINT = 195,
    PIPE_FORMAT_X32_S8X24_UINT = 196,
    PIPE_FORMAT_R3G3B2_UNORM = 197,
    PIPE_FORMAT_B2G3R3_UNORM = 198,
    PIPE_FORMAT_L16A16_UNORM = 199,
    PIPE_FORMAT_A16_UNORM = 200,
    PIPE_FORMAT_I16_UNORM = 201,
    PIPE_FORMAT_LATC1_UNORM = 202,
    PIPE_FORMAT_LATC1_SNORM = 203,
    PIPE_FORMAT_LATC2_UNORM = 204,
    PIPE_FORMAT_LATC2_SNORM = 205,
    PIPE_FORMAT_A8_SNORM = 206,
    PIPE_FORMAT_L8_SNORM = 207,
    PIPE_FORMAT_L8A8_SNORM = 208,
    PIPE_FORMAT_I8_SNORM = 209,
    PIPE_FORMAT_A16_SNORM = 210,
    PIPE_FORMAT_L16_SNORM = 211,
    PIPE_FORMAT_L16A16_SNORM = 212,
    PIPE_FORMAT_I16_SNORM = 213,
    PIPE_FORMAT_A16_FLOAT = 214,
    PIPE_FORMAT_L16_FLOAT = 215,
    PIPE_FORMAT_L16A16_FLOAT = 216,
    PIPE_FORMAT_I16_FLOAT = 217,
    PIPE_FORMAT_A32_FLOAT = 218,
    PIPE_FORMAT_L32_FLOAT = 219,
    PIPE_FORMAT_L32A32_FLOAT = 220,
    PIPE_FORMAT_I32_FLOAT = 221,
    PIPE_FORMAT_YV12 = 222,
    PIPE_FORMAT_YV16 = 223,
    #[doc = "< aka I420"]
    PIPE_FORMAT_IYUV = 224,
    PIPE_FORMAT_NV12 = 225,
    PIPE_FORMAT_NV21 = 226,
    PIPE_FORMAT_Y8_400_UNORM = 227,
    PIPE_FORMAT_Y8_U8_V8_422_UNORM = 228,
    PIPE_FORMAT_Y8_U8V8_422_UNORM = 229,
    PIPE_FORMAT_Y8_U8_V8_444_UNORM = 230,
    PIPE_FORMAT_Y16_U16_V16_420_UNORM = 231,
    PIPE_FORMAT_Y16_U16_V16_422_UNORM = 232,
    PIPE_FORMAT_Y16_U16V16_422_UNORM = 233,
    PIPE_FORMAT_Y16_U16_V16_444_UNORM = 234,
    PIPE_FORMAT_A4R4_UNORM = 235,
    PIPE_FORMAT_R4A4_UNORM = 236,
    PIPE_FORMAT_R8A8_UNORM = 237,
    PIPE_FORMAT_A8R8_UNORM = 238,
    PIPE_FORMAT_A8_UINT = 239,
    PIPE_FORMAT_I8_UINT = 240,
    PIPE_FORMAT_L8_UINT = 241,
    PIPE_FORMAT_L8A8_UINT = 242,
    PIPE_FORMAT_A8_SINT = 243,
    PIPE_FORMAT_I8_SINT = 244,
    PIPE_FORMAT_L8_SINT = 245,
    PIPE_FORMAT_L8A8_SINT = 246,
    PIPE_FORMAT_A16_UINT = 247,
    PIPE_FORMAT_I16_UINT = 248,
    PIPE_FORMAT_L16_UINT = 249,
    PIPE_FORMAT_L16A16_UINT = 250,
    PIPE_FORMAT_A16_SINT = 251,
    PIPE_FORMAT_I16_SINT = 252,
    PIPE_FORMAT_L16_SINT = 253,
    PIPE_FORMAT_L16A16_SINT = 254,
    PIPE_FORMAT_A32_UINT = 255,
    PIPE_FORMAT_I32_UINT = 256,
    PIPE_FORMAT_L32_UINT = 257,
    PIPE_FORMAT_L32A32_UINT = 258,
    PIPE_FORMAT_A32_SINT = 259,
    PIPE_FORMAT_I32_SINT = 260,
    PIPE_FORMAT_L32_SINT = 261,
    PIPE_FORMAT_L32A32_SINT = 262,
    PIPE_FORMAT_A8R8G8B8_UINT = 263,
    PIPE_FORMAT_A8B8G8R8_UINT = 264,
    PIPE_FORMAT_A2R10G10B10_UINT = 265,
    PIPE_FORMAT_A2B10G10R10_UINT = 266,
    PIPE_FORMAT_R5G6B5_UINT = 267,
    PIPE_FORMAT_B5G6R5_UINT = 268,
    PIPE_FORMAT_R5G5B5A1_UINT = 269,
    PIPE_FORMAT_B5G5R5A1_UINT = 270,
    PIPE_FORMAT_A1R5G5B5_UINT = 271,
    PIPE_FORMAT_A1B5G5R5_UINT = 272,
    PIPE_FORMAT_R4G4B4A4_UINT = 273,
    PIPE_FORMAT_B4G4R4A4_UINT = 274,
    PIPE_FORMAT_A4R4G4B4_UINT = 275,
    PIPE_FORMAT_A4B4G4R4_UINT = 276,
    PIPE_FORMAT_R3G3B2_UINT = 277,
    PIPE_FORMAT_B2G3R3_UINT = 278,
    PIPE_FORMAT_ETC1_RGB8 = 279,
    PIPE_FORMAT_R8G8_R8B8_UNORM = 280,
    PIPE_FORMAT_R8B8_R8G8_UNORM = 281,
    PIPE_FORMAT_G8R8_B8R8_UNORM = 282,
    PIPE_FORMAT_B8R8_G8R8_UNORM = 283,
    PIPE_FORMAT_G8B8_G8R8_UNORM = 284,
    PIPE_FORMAT_B8G8_R8G8_UNORM = 285,
    PIPE_FORMAT_R8G8B8X8_SNORM = 286,
    PIPE_FORMAT_R8G8B8X8_SRGB = 287,
    PIPE_FORMAT_R8G8B8X8_UINT = 288,
    PIPE_FORMAT_R8G8B8X8_SINT = 289,
    PIPE_FORMAT_B10G10R10X2_UNORM = 290,
    PIPE_FORMAT_R16G16B16X16_UNORM = 291,
    PIPE_FORMAT_R16G16B16X16_SNORM = 292,
    PIPE_FORMAT_R16G16B16X16_FLOAT = 293,
    PIPE_FORMAT_R16G16B16X16_UINT = 294,
    PIPE_FORMAT_R16G16B16X16_SINT = 295,
    PIPE_FORMAT_R32G32B32X32_FLOAT = 296,
    PIPE_FORMAT_R32G32B32X32_UINT = 297,
    PIPE_FORMAT_R32G32B32X32_SINT = 298,
    PIPE_FORMAT_R8A8_SNORM = 299,
    PIPE_FORMAT_R16A16_UNORM = 300,
    PIPE_FORMAT_R16A16_SNORM = 301,
    PIPE_FORMAT_R16A16_FLOAT = 302,
    PIPE_FORMAT_R32A32_FLOAT = 303,
    PIPE_FORMAT_R8A8_UINT = 304,
    PIPE_FORMAT_R8A8_SINT = 305,
    PIPE_FORMAT_R16A16_UINT = 306,
    PIPE_FORMAT_R16A16_SINT = 307,
    PIPE_FORMAT_R32A32_UINT = 308,
    PIPE_FORMAT_R32A32_SINT = 309,
    PIPE_FORMAT_B5G6R5_SRGB = 310,
    PIPE_FORMAT_BPTC_RGBA_UNORM = 311,
    PIPE_FORMAT_BPTC_SRGBA = 312,
    PIPE_FORMAT_BPTC_RGB_FLOAT = 313,
    PIPE_FORMAT_BPTC_RGB_UFLOAT = 314,
    PIPE_FORMAT_G8R8_UNORM = 315,
    PIPE_FORMAT_G8R8_SNORM = 316,
    PIPE_FORMAT_G16R16_UNORM = 317,
    PIPE_FORMAT_G16R16_SNORM = 318,
    PIPE_FORMAT_A8B8G8R8_SNORM = 319,
    PIPE_FORMAT_X8B8G8R8_SNORM = 320,
    PIPE_FORMAT_ETC2_RGB8 = 321,
    PIPE_FORMAT_ETC2_SRGB8 = 322,
    PIPE_FORMAT_ETC2_RGB8A1 = 323,
    PIPE_FORMAT_ETC2_SRGB8A1 = 324,
    PIPE_FORMAT_ETC2_RGBA8 = 325,
    PIPE_FORMAT_ETC2_SRGBA8 = 326,
    PIPE_FORMAT_ETC2_R11_UNORM = 327,
    PIPE_FORMAT_ETC2_R11_SNORM = 328,
    PIPE_FORMAT_ETC2_RG11_UNORM = 329,
    PIPE_FORMAT_ETC2_RG11_SNORM = 330,
    PIPE_FORMAT_ASTC_4x4 = 331,
    PIPE_FORMAT_ASTC_5x4 = 332,
    PIPE_FORMAT_ASTC_5x5 = 333,
    PIPE_FORMAT_ASTC_6x5 = 334,
    PIPE_FORMAT_ASTC_6x6 = 335,
    PIPE_FORMAT_ASTC_8x5 = 336,
    PIPE_FORMAT_ASTC_8x6 = 337,
    PIPE_FORMAT_ASTC_8x8 = 338,
    PIPE_FORMAT_ASTC_10x5 = 339,
    PIPE_FORMAT_ASTC_10x6 = 340,
    PIPE_FORMAT_ASTC_10x8 = 341,
    PIPE_FORMAT_ASTC_10x10 = 342,
    PIPE_FORMAT_ASTC_12x10 = 343,
    PIPE_FORMAT_ASTC_12x12 = 344,
    PIPE_FORMAT_ASTC_4x4_SRGB = 345,
    PIPE_FORMAT_ASTC_5x4_SRGB = 346,
    PIPE_FORMAT_ASTC_5x5_SRGB = 347,
    PIPE_FORMAT_ASTC_6x5_SRGB = 348,
    PIPE_FORMAT_ASTC_6x6_SRGB = 349,
    PIPE_FORMAT_ASTC_8x5_SRGB = 350,
    PIPE_FORMAT_ASTC_8x6_SRGB = 351,
    PIPE_FORMAT_ASTC_8x8_SRGB = 352,
    PIPE_FORMAT_ASTC_10x5_SRGB = 353,
    PIPE_FORMAT_ASTC_10x6_SRGB = 354,
    PIPE_FORMAT_ASTC_10x8_SRGB = 355,
    PIPE_FORMAT_ASTC_10x10_SRGB = 356,
    PIPE_FORMAT_ASTC_12x10_SRGB = 357,
    PIPE_FORMAT_ASTC_12x12_SRGB = 358,
    PIPE_FORMAT_ASTC_3x3x3 = 359,
    PIPE_FORMAT_ASTC_4x3x3 = 360,
    PIPE_FORMAT_ASTC_4x4x3 = 361,
    PIPE_FORMAT_ASTC_4x4x4 = 362,
    PIPE_FORMAT_ASTC_5x4x4 = 363,
    PIPE_FORMAT_ASTC_5x5x4 = 364,
    PIPE_FORMAT_ASTC_5x5x5 = 365,
    PIPE_FORMAT_ASTC_6x5x5 = 366,
    PIPE_FORMAT_ASTC_6x6x5 = 367,
    PIPE_FORMAT_ASTC_6x6x6 = 368,
    PIPE_FORMAT_ASTC_3x3x3_SRGB = 369,
    PIPE_FORMAT_ASTC_4x3x3_SRGB = 370,
    PIPE_FORMAT_ASTC_4x4x3_SRGB = 371,
    PIPE_FORMAT_ASTC_4x4x4_SRGB = 372,
    PIPE_FORMAT_ASTC_5x4x4_SRGB = 373,
    PIPE_FORMAT_ASTC_5x5x4_SRGB = 374,
    PIPE_FORMAT_ASTC_5x5x5_SRGB = 375,
    PIPE_FORMAT_ASTC_6x5x5_SRGB = 376,
    PIPE_FORMAT_ASTC_6x6x5_SRGB = 377,
    PIPE_FORMAT_ASTC_6x6x6_SRGB = 378,
    PIPE_FORMAT_FXT1_RGB = 379,
    PIPE_FORMAT_FXT1_RGBA = 380,
    PIPE_FORMAT_P010 = 381,
    PIPE_FORMAT_P012 = 382,
    PIPE_FORMAT_P016 = 383,
    PIPE_FORMAT_P030 = 384,
    PIPE_FORMAT_Y210 = 385,
    PIPE_FORMAT_Y212 = 386,
    PIPE_FORMAT_Y216 = 387,
    PIPE_FORMAT_Y410 = 388,
    PIPE_FORMAT_Y412 = 389,
    PIPE_FORMAT_Y416 = 390,
    PIPE_FORMAT_R10G10B10X2_UNORM = 391,
    PIPE_FORMAT_A1R5G5B5_UNORM = 392,
    PIPE_FORMAT_A1B5G5R5_UNORM = 393,
    PIPE_FORMAT_X1B5G5R5_UNORM = 394,
    PIPE_FORMAT_R5G5B5A1_UNORM = 395,
    PIPE_FORMAT_A4R4G4B4_UNORM = 396,
    PIPE_FORMAT_A4B4G4R4_UNORM = 397,
    PIPE_FORMAT_G8R8_SINT = 398,
    PIPE_FORMAT_A8B8G8R8_SINT = 399,
    PIPE_FORMAT_X8B8G8R8_SINT = 400,
    PIPE_FORMAT_ATC_RGB = 401,
    PIPE_FORMAT_ATC_RGBA_EXPLICIT = 402,
    PIPE_FORMAT_ATC_RGBA_INTERPOLATED = 403,
    PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8 = 404,
    PIPE_FORMAT_AYUV = 405,
    PIPE_FORMAT_XYUV = 406,
    PIPE_FORMAT_R8_G8B8_420_UNORM = 407,
    PIPE_FORMAT_R8_B8G8_420_UNORM = 408,
    PIPE_FORMAT_G8_B8R8_420_UNORM = 409,
    PIPE_FORMAT_R8_G8_B8_420_UNORM = 410,
    PIPE_FORMAT_R8_B8_G8_420_UNORM = 411,
    PIPE_FORMAT_G8_B8_R8_420_UNORM = 412,
    PIPE_FORMAT_R8_G8_B8_UNORM = 413,
    PIPE_FORMAT_Y8_UNORM = 414,
    PIPE_FORMAT_B8G8R8X8_SNORM = 415,
    PIPE_FORMAT_B8G8R8X8_UINT = 416,
    PIPE_FORMAT_B8G8R8X8_SINT = 417,
    PIPE_FORMAT_A8R8G8B8_SNORM = 418,
    PIPE_FORMAT_A8R8G8B8_SINT = 419,
    PIPE_FORMAT_X8R8G8B8_SNORM = 420,
    PIPE_FORMAT_X8R8G8B8_SINT = 421,
    PIPE_FORMAT_R5G5B5X1_UNORM = 422,
    PIPE_FORMAT_X1R5G5B5_UNORM = 423,
    PIPE_FORMAT_R4G4B4X4_UNORM = 424,
    PIPE_FORMAT_B10G10R10X2_SNORM = 425,
    PIPE_FORMAT_R5G6B5_SRGB = 426,
    PIPE_FORMAT_R10G10B10X2_SINT = 427,
    PIPE_FORMAT_B10G10R10X2_SINT = 428,
    PIPE_FORMAT_G16R16_SINT = 429,
    PIPE_FORMAT_COUNT = 430,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pipe_color_union {
    pub f: [::std::os::raw::c_float; 4usize],
    pub i: [::std::os::raw::c_int; 4usize],
    pub ui: [::std::os::raw::c_uint; 4usize],
}
#[test]
fn bindgen_test_layout_pipe_color_union() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_color_union> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_color_union>(),
        16usize,
        concat!("Size of: ", stringify!(pipe_color_union))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_color_union>(),
        4usize,
        concat!("Alignment of ", stringify!(pipe_color_union))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).f) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_color_union),
            "::",
            stringify!(f)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_color_union),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ui) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_color_union),
            "::",
            stringify!(ui)
        )
    );
}
impl Default for pipe_color_union {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[doc = " Describe how to pack/unpack pixels into/from the prescribed format.\n\n XXX: This could be renamed to something like util_format_pack, or broke down\n in flags inside util_format_block that said exactly what we want."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_format_layout {
    #[doc = " Formats with util_format_block::width == util_format_block::height == 1\n that can be described as an ordinary data structure."]
    UTIL_FORMAT_LAYOUT_PLAIN = 0,
    #[doc = " Formats with sub-sampled channels.\n\n This is for formats like YVYU where there is less than one sample per\n pixel."]
    UTIL_FORMAT_LAYOUT_SUBSAMPLED = 1,
    #[doc = " S3 Texture Compression formats."]
    UTIL_FORMAT_LAYOUT_S3TC = 2,
    #[doc = " Red-Green Texture Compression formats."]
    UTIL_FORMAT_LAYOUT_RGTC = 3,
    #[doc = " Ericsson Texture Compression"]
    UTIL_FORMAT_LAYOUT_ETC = 4,
    #[doc = " BC6/7 Texture Compression"]
    UTIL_FORMAT_LAYOUT_BPTC = 5,
    #[doc = " BC6/7 Texture Compression"]
    UTIL_FORMAT_LAYOUT_ASTC = 6,
    #[doc = " BC6/7 Texture Compression"]
    UTIL_FORMAT_LAYOUT_ATC = 7,
    #[doc = " Formats with 2 or more planes."]
    UTIL_FORMAT_LAYOUT_PLANAR2 = 8,
    #[doc = " Formats with 2 or more planes."]
    UTIL_FORMAT_LAYOUT_PLANAR3 = 9,
    #[doc = " Formats with 2 or more planes."]
    UTIL_FORMAT_LAYOUT_FXT1 = 10,
    #[doc = " Everything else that doesn't fit in any of the above layouts."]
    UTIL_FORMAT_LAYOUT_OTHER = 11,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_block {
    #[doc = " Block width in pixels"]
    pub width: ::std::os::raw::c_uint,
    #[doc = " Block height in pixels"]
    pub height: ::std::os::raw::c_uint,
    #[doc = " Block depth in pixels"]
    pub depth: ::std::os::raw::c_uint,
    #[doc = " Block size in bits"]
    pub bits: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_util_format_block() {
    const UNINIT: ::std::mem::MaybeUninit<util_format_block> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<util_format_block>(),
        16usize,
        concat!("Size of: ", stringify!(util_format_block))
    );
    assert_eq!(
        ::std::mem::align_of::<util_format_block>(),
        4usize,
        concat!("Alignment of ", stringify!(util_format_block))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).width) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_block),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).height) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_block),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).depth) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_block),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bits) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_block),
            "::",
            stringify!(bits)
        )
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_format_type {
    UTIL_FORMAT_TYPE_VOID = 0,
    UTIL_FORMAT_TYPE_UNSIGNED = 1,
    UTIL_FORMAT_TYPE_SIGNED = 2,
    UTIL_FORMAT_TYPE_FIXED = 3,
    UTIL_FORMAT_TYPE_FLOAT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_format_colorspace {
    UTIL_FORMAT_COLORSPACE_RGB = 0,
    UTIL_FORMAT_COLORSPACE_SRGB = 1,
    UTIL_FORMAT_COLORSPACE_YUV = 2,
    UTIL_FORMAT_COLORSPACE_ZS = 3,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_channel_description {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_util_format_channel_description() {
    assert_eq!(
        ::std::mem::size_of::<util_format_channel_description>(),
        4usize,
        concat!("Size of: ", stringify!(util_format_channel_description))
    );
    assert_eq!(
        ::std::mem::align_of::<util_format_channel_description>(),
        4usize,
        concat!("Alignment of ", stringify!(util_format_channel_description))
    );
}
impl util_format_channel_description {
    #[inline]
    pub fn type_(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn normalized(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_normalized(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pure_integer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pure_integer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_size(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn shift(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_shift(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: ::std::os::raw::c_uint,
        normalized: ::std::os::raw::c_uint,
        pure_integer: ::std::os::raw::c_uint,
        size: ::std::os::raw::c_uint,
        shift: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 5u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let normalized: u32 = unsafe { ::std::mem::transmute(normalized) };
            normalized as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pure_integer: u32 = unsafe { ::std::mem::transmute(pure_integer) };
            pure_integer as u64
        });
        __bindgen_bitfield_unit.set(7usize, 9u8, {
            let size: u32 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let shift: u32 = unsafe { ::std::mem::transmute(shift) };
            shift as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_description {
    pub format: pipe_format,
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Short name, striped of the prefix, lower case."]
    pub short_name: *const ::std::os::raw::c_char,
    #[doc = " Pixel block dimensions."]
    pub block: util_format_block,
    pub layout: util_format_layout,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Input channel description, in the order XYZW.\n\n Only valid for UTIL_FORMAT_LAYOUT_PLAIN formats.\n\n If each channel is accessed as an individual N-byte value, X is always\n at the lowest address in memory, Y is always next, and so on.  For all\n currently-defined formats, the N-byte value has native endianness.\n\n If instead a group of channels is accessed as a single N-byte value,\n the order of the channels within that value depends on endianness.\n For big-endian targets, X is the most significant subvalue,\n otherwise it is the least significant one.\n\n For example, if X is 8 bits and Y is 24 bits, the memory order is:\n\n                 0  1  2  3\n  little-endian: X  Yl Ym Yu    (l = lower, m = middle, u = upper)\n  big-endian:    X  Yu Ym Yl\n\n If X is 5 bits, Y is 5 bits, Z is 5 bits and W is 1 bit, the layout is:\n\n                        0        1\n                 msb  lsb msb  lsb\n  little-endian: YYYXXXXX WZZZZZYY\n  big-endian:    XXXXXYYY YYZZZZZW"]
    pub channel: [util_format_channel_description; 4usize],
    #[doc = " Output channel swizzle.\n\n The order is either:\n - RGBA\n - YUV(A)\n - ZS\n depending on the colorspace."]
    pub swizzle: [::std::os::raw::c_uchar; 4usize],
    #[doc = " Colorspace transformation."]
    pub colorspace: util_format_colorspace,
}
#[test]
fn bindgen_test_layout_util_format_description() {
    const UNINIT: ::std::mem::MaybeUninit<util_format_description> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<util_format_description>(),
        72usize,
        concat!("Size of: ", stringify!(util_format_description))
    );
    assert_eq!(
        ::std::mem::align_of::<util_format_description>(),
        8usize,
        concat!("Alignment of ", stringify!(util_format_description))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).short_name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(short_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(block)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).layout) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).channel) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(channel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).swizzle) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(swizzle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).colorspace) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_description),
            "::",
            stringify!(colorspace)
        )
    );
}
impl Default for util_format_description {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl util_format_description {
    #[inline]
    pub fn nr_channels(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_nr_channels(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn is_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_bitmask(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bitmask(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_mixed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_mixed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_unorm(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_unorm(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_snorm(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_snorm(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nr_channels: ::std::os::raw::c_uint,
        is_array: ::std::os::raw::c_uint,
        is_bitmask: ::std::os::raw::c_uint,
        is_mixed: ::std::os::raw::c_uint,
        is_unorm: ::std::os::raw::c_uint,
        is_snorm: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let nr_channels: u32 = unsafe { ::std::mem::transmute(nr_channels) };
            nr_channels as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_array: u32 = unsafe { ::std::mem::transmute(is_array) };
            is_array as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_bitmask: u32 = unsafe { ::std::mem::transmute(is_bitmask) };
            is_bitmask as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_mixed: u32 = unsafe { ::std::mem::transmute(is_mixed) };
            is_mixed as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let is_unorm: u32 = unsafe { ::std::mem::transmute(is_unorm) };
            is_unorm as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let is_snorm: u32 = unsafe { ::std::mem::transmute(is_snorm) };
            is_snorm as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_pack_description {
    #[doc = " Pack pixel blocks from R8G8B8A8_UNORM.\n Note: strides are in bytes.\n\n Only defined for non-depth-stencil formats."]
    pub pack_rgba_8unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixel blocks from R32G32B32A32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for non-depth-stencil formats."]
    pub pack_rgba_float: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const ::std::os::raw::c_float,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixels from Z32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub pack_z_32unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u32,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixels from Z32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub pack_z_float: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const ::std::os::raw::c_float,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixels from S8_UINT.\n Note: strides are in bytes.\n\n Only defined for stencil formats."]
    pub pack_s_8uint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    pub pack_rgba_uint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u32,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    pub pack_rgba_sint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const i32,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
}
#[test]
fn bindgen_test_layout_util_format_pack_description() {
    const UNINIT: ::std::mem::MaybeUninit<util_format_pack_description> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<util_format_pack_description>(),
        56usize,
        concat!("Size of: ", stringify!(util_format_pack_description))
    );
    assert_eq!(
        ::std::mem::align_of::<util_format_pack_description>(),
        8usize,
        concat!("Alignment of ", stringify!(util_format_pack_description))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_rgba_8unorm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_rgba_8unorm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_rgba_float) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_rgba_float)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_z_32unorm) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_z_32unorm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_z_float) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_z_float)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_s_8uint) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_s_8uint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_rgba_uint) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_rgba_uint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_rgba_sint) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_pack_description),
            "::",
            stringify!(pack_rgba_sint)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_unpack_description {
    #[doc = " Unpack pixel blocks to R8G8B8A8_UNORM.\n Note: strides are in bytes.\n\n Only defined for non-block non-depth-stencil formats."]
    pub unpack_rgba_8unorm: ::std::option::Option<
        unsafe extern "C" fn(dst: *mut u8, src: *const u8, width: ::std::os::raw::c_uint),
    >,
    #[doc = " Unpack pixel blocks to R8G8B8A8_UNORM.\n Note: strides are in bytes.\n\n Only defined for block non-depth-stencil formats."]
    pub unpack_rgba_8unorm_rect: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Fetch a single pixel (i, j) from a block.\n\n XXX: Only defined for a very few select formats."]
    pub fetch_rgba_8unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            src: *const u8,
            i: ::std::os::raw::c_uint,
            j: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixel blocks to R32G32B32A32_UINT/_INT_FLOAT based on whether the\n type is pure uint, int, or other.\n\n Note: strides are in bytes.\n\n Only defined for non-block non-depth-stencil formats."]
    pub unpack_rgba: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut ::std::os::raw::c_void,
            src: *const u8,
            width: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixel blocks to R32G32B32A32_UINT/_INT_FLOAT based on whether the\n type is pure uint, int, or other.\n\n Note: strides are in bytes.\n\n Only defined for block non-depth-stencil formats."]
    pub unpack_rgba_rect: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut ::std::os::raw::c_void,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixels to Z32_UNORM.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub unpack_z_32unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u32,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixels to Z32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub unpack_z_float: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut ::std::os::raw::c_float,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixels to S8_UINT.\n Note: strides are in bytes.\n\n Only defined for stencil formats."]
    pub unpack_s_8uint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
}
#[test]
fn bindgen_test_layout_util_format_unpack_description() {
    const UNINIT: ::std::mem::MaybeUninit<util_format_unpack_description> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<util_format_unpack_description>(),
        64usize,
        concat!("Size of: ", stringify!(util_format_unpack_description))
    );
    assert_eq!(
        ::std::mem::align_of::<util_format_unpack_description>(),
        8usize,
        concat!("Alignment of ", stringify!(util_format_unpack_description))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_rgba_8unorm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_rgba_8unorm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_rgba_8unorm_rect) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_rgba_8unorm_rect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fetch_rgba_8unorm) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(fetch_rgba_8unorm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_rgba) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_rgba)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_rgba_rect) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_rgba_rect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_z_32unorm) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_z_32unorm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_z_float) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_z_float)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_s_8uint) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(util_format_unpack_description),
            "::",
            stringify!(unpack_s_8uint)
        )
    );
}
pub type util_format_fetch_rgba_func_ptr = ::std::option::Option<
    unsafe extern "C" fn(
        dst: *mut ::std::os::raw::c_void,
        src: *const u8,
        i: ::std::os::raw::c_uint,
        j: ::std::os::raw::c_uint,
    ),
>;
extern "C" {
    pub fn util_format_description(format: pipe_format) -> *const util_format_description;
}
extern "C" {
    pub fn util_format_pack_description(format: pipe_format)
        -> *const util_format_pack_description;
}
extern "C" {
    pub fn util_format_unpack_description(
        format: pipe_format,
    ) -> *const util_format_unpack_description;
}
extern "C" {
    pub fn util_format_unpack_description_generic(
        format: pipe_format,
    ) -> *const util_format_unpack_description;
}
extern "C" {
    pub fn util_format_unpack_description_neon(
        format: pipe_format,
    ) -> *const util_format_unpack_description;
}
extern "C" {
    #[doc = " Returns a function to fetch a single pixel (i, j) from a block.\n\n Only defined for non-depth-stencil and non-integer formats."]
    pub fn util_format_fetch_rgba_func(format: pipe_format) -> util_format_fetch_rgba_func_ptr;
}
extern "C" {
    pub fn util_format_is_float(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_has_alpha(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_has_alpha1(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_luminance(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_alpha(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_luminance_alpha(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_red_alpha(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_red_green(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_intensity(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_subsampled_422(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_pure_integer(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_pure_sint(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_pure_uint(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_snorm(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_unorm(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_snorm8(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_is_scaled(format: pipe_format) -> bool;
}
extern "C" {
    pub fn util_format_read_4(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn util_format_write_4(
        format: pipe_format,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn util_format_read_4ub(
        format: pipe_format,
        dst: *mut u8,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn util_format_write_4ub(
        format: pipe_format,
        src: *const u8,
        src_stride: ::std::os::raw::c_uint,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn util_format_unpack_rgba_rect(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn util_format_unpack_rgba_8unorm_rect(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn util_format_fits_8unorm(format_desc: *const util_format_description) -> bool;
}
extern "C" {
    pub fn util_format_translate(
        dst_format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        dst_x: ::std::os::raw::c_uint,
        dst_y: ::std::os::raw::c_uint,
        src_format: pipe_format,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        src_x: ::std::os::raw::c_uint,
        src_y: ::std::os::raw::c_uint,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn util_format_translate_3d(
        dst_format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        dst_slice_stride: u64,
        dst_x: ::std::os::raw::c_uint,
        dst_y: ::std::os::raw::c_uint,
        dst_z: ::std::os::raw::c_uint,
        src_format: pipe_format,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        src_slice_stride: u64,
        src_x: ::std::os::raw::c_uint,
        src_y: ::std::os::raw::c_uint,
        src_z: ::std::os::raw::c_uint,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        depth: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn util_format_compose_swizzles(
        swz1: *const [::std::os::raw::c_uchar; 4usize],
        swz2: *const [::std::os::raw::c_uchar; 4usize],
        dst: *mut [::std::os::raw::c_uchar; 4usize],
    );
}
extern "C" {
    pub fn util_format_apply_color_swizzle(
        dst: *mut pipe_color_union,
        src: *const pipe_color_union,
        swz: *const [::std::os::raw::c_uchar; 4usize],
        is_integer: bool,
    );
}
extern "C" {
    pub fn pipe_swizzle_4f(
        dst: *mut ::std::os::raw::c_float,
        src: *const ::std::os::raw::c_float,
        swz: *const [::std::os::raw::c_uchar; 4usize],
    );
}
extern "C" {
    pub fn util_format_unswizzle_4f(
        dst: *mut ::std::os::raw::c_float,
        src: *const ::std::os::raw::c_float,
        swz: *const [::std::os::raw::c_uchar; 4usize],
    );
}
extern "C" {
    pub fn util_format_snorm_to_sint(format: pipe_format) -> pipe_format;
}
extern "C" {
    #[doc = " If the format is RGB, return BGR. If the format is BGR, return RGB.\n This may fail by returning PIPE_FORMAT_NONE."]
    pub fn util_format_rgb_to_bgr(format: pipe_format) -> pipe_format;
}
extern "C" {
    pub fn util_format_snorm_to_unorm(format: pipe_format) -> pipe_format;
}
extern "C" {
    pub fn util_format_rgbx_to_rgba(format: pipe_format) -> pipe_format;
}
extern "C" {
    pub fn util_format_get_array(
        type_: util_format_type,
        bits: ::std::os::raw::c_uint,
        nr_components: ::std::os::raw::c_uint,
        normalized: bool,
        pure_integer: bool,
    ) -> pipe_format;
}
extern "C" {
    pub fn util_format_get_last_component(format: pipe_format) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn util_format_get_largest_non_void_channel(format: pipe_format) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn util_format_get_max_channel_size(format: pipe_format) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_type_singleton_init_or_ref();
}
extern "C" {
    pub fn glsl_type_singleton_decref();
}
pub type glsl_type_size_align_func = ::std::option::Option<
    unsafe extern "C" fn(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        alignment: *mut ::std::os::raw::c_uint,
    ),
>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_base_type {
    GLSL_TYPE_UINT = 0,
    GLSL_TYPE_INT = 1,
    GLSL_TYPE_FLOAT = 2,
    GLSL_TYPE_FLOAT16 = 3,
    GLSL_TYPE_DOUBLE = 4,
    GLSL_TYPE_UINT8 = 5,
    GLSL_TYPE_INT8 = 6,
    GLSL_TYPE_UINT16 = 7,
    GLSL_TYPE_INT16 = 8,
    GLSL_TYPE_UINT64 = 9,
    GLSL_TYPE_INT64 = 10,
    GLSL_TYPE_BOOL = 11,
    GLSL_TYPE_COOPERATIVE_MATRIX = 12,
    GLSL_TYPE_SAMPLER = 13,
    GLSL_TYPE_TEXTURE = 14,
    GLSL_TYPE_IMAGE = 15,
    GLSL_TYPE_ATOMIC_UINT = 16,
    GLSL_TYPE_STRUCT = 17,
    GLSL_TYPE_INTERFACE = 18,
    GLSL_TYPE_ARRAY = 19,
    GLSL_TYPE_VOID = 20,
    GLSL_TYPE_SUBROUTINE = 21,
    GLSL_TYPE_ERROR = 22,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_sampler_dim {
    GLSL_SAMPLER_DIM_1D = 0,
    GLSL_SAMPLER_DIM_2D = 1,
    GLSL_SAMPLER_DIM_3D = 2,
    GLSL_SAMPLER_DIM_CUBE = 3,
    GLSL_SAMPLER_DIM_RECT = 4,
    GLSL_SAMPLER_DIM_BUF = 5,
    GLSL_SAMPLER_DIM_EXTERNAL = 6,
    GLSL_SAMPLER_DIM_MS = 7,
    GLSL_SAMPLER_DIM_SUBPASS = 8,
    GLSL_SAMPLER_DIM_SUBPASS_MS = 9,
}
extern "C" {
    pub fn glsl_get_sampler_dim_coordinate_components(
        dim: glsl_sampler_dim,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct glsl_cmat_description {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub rows: u8,
    pub cols: u8,
    pub use_: u8,
}
#[test]
fn bindgen_test_layout_glsl_cmat_description() {
    const UNINIT: ::std::mem::MaybeUninit<glsl_cmat_description> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<glsl_cmat_description>(),
        4usize,
        concat!("Size of: ", stringify!(glsl_cmat_description))
    );
    assert_eq!(
        ::std::mem::align_of::<glsl_cmat_description>(),
        1usize,
        concat!("Alignment of ", stringify!(glsl_cmat_description))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rows) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_cmat_description),
            "::",
            stringify!(rows)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cols) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_cmat_description),
            "::",
            stringify!(cols)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_cmat_description),
            "::",
            stringify!(use_)
        )
    );
}
impl glsl_cmat_description {
    #[inline]
    pub fn element_type(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u8) }
    }
    #[inline]
    pub fn set_element_type(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn scope(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_scope(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(element_type: u8, scope: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 5u8, {
            let element_type: u8 = unsafe { ::std::mem::transmute(element_type) };
            element_type as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let scope: u8 = unsafe { ::std::mem::transmute(scope) };
            scope as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn glsl_get_type_name(type_: *const glsl_type) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct glsl_type {
    pub gl_type: u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub cmat_desc: glsl_cmat_description,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = "< 1, 2, 3, or 4 vector elements."]
    pub vector_elements: u8,
    #[doc = "< 1, 2, 3, or 4 matrix columns."]
    pub matrix_columns: u8,
    #[doc = " For \\c GLSL_TYPE_ARRAY, this is the length of the array.  For\n \\c GLSL_TYPE_STRUCT or \\c GLSL_TYPE_INTERFACE, it is the number of\n elements in the structure and the number of values pointed to by\n \\c fields.structure (below)."]
    pub length: ::std::os::raw::c_uint,
    #[doc = " Identifier to the name of the data type\n\n Use glsl_get_type_name() to access the actual name."]
    pub name_id: usize,
    #[doc = " Explicit array, matrix, or vector stride.  This is used to communicate\n explicit array layouts from SPIR-V.  Should be 0 if the type has no\n explicit stride."]
    pub explicit_stride: ::std::os::raw::c_uint,
    #[doc = " Explicit alignment. This is used to communicate explicit alignment\n constraints. Should be 0 if the type has no explicit alignment\n constraint."]
    pub explicit_alignment: ::std::os::raw::c_uint,
    pub fields: glsl_type__bindgen_ty_1,
}
#[doc = " Subtype of composite data types."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union glsl_type__bindgen_ty_1 {
    #[doc = "< Type of array elements."]
    pub array: *const glsl_type,
    #[doc = "< List of struct fields."]
    pub structure: *const glsl_struct_field,
}
#[test]
fn bindgen_test_layout_glsl_type__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<glsl_type__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<glsl_type__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(glsl_type__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<glsl_type__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(glsl_type__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).array) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type__bindgen_ty_1),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).structure) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type__bindgen_ty_1),
            "::",
            stringify!(structure)
        )
    );
}
impl Default for glsl_type__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_glsl_type() {
    const UNINIT: ::std::mem::MaybeUninit<glsl_type> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<glsl_type>(),
        48usize,
        concat!("Size of: ", stringify!(glsl_type))
    );
    assert_eq!(
        ::std::mem::align_of::<glsl_type>(),
        8usize,
        concat!("Alignment of ", stringify!(glsl_type))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gl_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(gl_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cmat_desc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(cmat_desc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vector_elements) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(vector_elements)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).matrix_columns) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(matrix_columns)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name_id) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(name_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).explicit_stride) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(explicit_stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).explicit_alignment) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(explicit_alignment)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_type),
            "::",
            stringify!(fields)
        )
    );
}
impl Default for glsl_type {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl glsl_type {
    #[inline]
    pub fn base_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_base_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn sampled_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sampled_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn sampler_dimensionality(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_dimensionality(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn sampler_shadow(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_shadow(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sampler_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn interface_packing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interface_packing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn interface_row_major(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interface_row_major(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        base_type: glsl_base_type,
        sampled_type: glsl_base_type,
        sampler_dimensionality: ::std::os::raw::c_uint,
        sampler_shadow: ::std::os::raw::c_uint,
        sampler_array: ::std::os::raw::c_uint,
        interface_packing: ::std::os::raw::c_uint,
        interface_row_major: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let base_type: u32 = unsafe { ::std::mem::transmute(base_type) };
            base_type as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let sampled_type: u32 = unsafe { ::std::mem::transmute(sampled_type) };
            sampled_type as u64
        });
        __bindgen_bitfield_unit.set(16usize, 4u8, {
            let sampler_dimensionality: u32 =
                unsafe { ::std::mem::transmute(sampler_dimensionality) };
            sampler_dimensionality as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let sampler_shadow: u32 = unsafe { ::std::mem::transmute(sampler_shadow) };
            sampler_shadow as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let sampler_array: u32 = unsafe { ::std::mem::transmute(sampler_array) };
            sampler_array as u64
        });
        __bindgen_bitfield_unit.set(22usize, 2u8, {
            let interface_packing: u32 = unsafe { ::std::mem::transmute(interface_packing) };
            interface_packing as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let interface_row_major: u32 = unsafe { ::std::mem::transmute(interface_row_major) };
            interface_row_major as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn packed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_packed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_builtin_name(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_builtin_name(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        packed: ::std::os::raw::c_uint,
        has_builtin_name: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let packed: u32 = unsafe { ::std::mem::transmute(packed) };
            packed as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_builtin_name: u32 = unsafe { ::std::mem::transmute(has_builtin_name) };
            has_builtin_name as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct glsl_struct_field {
    pub type_: *const glsl_type,
    pub name: *const ::std::os::raw::c_char,
    #[doc = " For interface blocks, gl_varying_slot corresponding to the input/output\n if this is a built-in input/output (i.e. a member of the built-in\n gl_PerVertex interface block); -1 otherwise.\n\n Ignored for structs."]
    pub location: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may explicitly assign the component used\n by a varying. Ignored for structs."]
    pub component: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may have an explicit byte offset\n specified; -1 otherwise. Also used for xfb_offset layout qualifier.\n\n Unless used for xfb_offset this field is ignored for structs."]
    pub offset: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may define a transform feedback buffer;\n -1 otherwise."]
    pub xfb_buffer: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may define a transform feedback stride;\n -1 otherwise."]
    pub xfb_stride: ::std::os::raw::c_int,
    #[doc = " Layout format, applicable to image variables only."]
    pub image_format: pipe_format,
    pub anon_1: glsl_struct_field__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union glsl_struct_field__bindgen_ty_1 {
    pub anon_1: glsl_struct_field__bindgen_ty_1__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct glsl_struct_field__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout_glsl_struct_field__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<glsl_struct_field__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(glsl_struct_field__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<glsl_struct_field__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(glsl_struct_field__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl glsl_struct_field__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn interpolation(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_interpolation(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn centroid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_centroid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn matrix_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_matrix_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn patch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn memory_read_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_read_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn memory_write_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_write_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn memory_coherent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_coherent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn memory_volatile(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_volatile(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn memory_restrict(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_restrict(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_xfb_buffer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_buffer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn implicit_sized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_sized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        interpolation: ::std::os::raw::c_uint,
        centroid: ::std::os::raw::c_uint,
        sample: ::std::os::raw::c_uint,
        matrix_layout: ::std::os::raw::c_uint,
        patch: ::std::os::raw::c_uint,
        precision: ::std::os::raw::c_uint,
        memory_read_only: ::std::os::raw::c_uint,
        memory_write_only: ::std::os::raw::c_uint,
        memory_coherent: ::std::os::raw::c_uint,
        memory_volatile: ::std::os::raw::c_uint,
        memory_restrict: ::std::os::raw::c_uint,
        explicit_xfb_buffer: ::std::os::raw::c_uint,
        implicit_sized_array: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let interpolation: u32 = unsafe { ::std::mem::transmute(interpolation) };
            interpolation as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let centroid: u32 = unsafe { ::std::mem::transmute(centroid) };
            centroid as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let sample: u32 = unsafe { ::std::mem::transmute(sample) };
            sample as u64
        });
        __bindgen_bitfield_unit.set(5usize, 2u8, {
            let matrix_layout: u32 = unsafe { ::std::mem::transmute(matrix_layout) };
            matrix_layout as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let patch: u32 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let precision: u32 = unsafe { ::std::mem::transmute(precision) };
            precision as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let memory_read_only: u32 = unsafe { ::std::mem::transmute(memory_read_only) };
            memory_read_only as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let memory_write_only: u32 = unsafe { ::std::mem::transmute(memory_write_only) };
            memory_write_only as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let memory_coherent: u32 = unsafe { ::std::mem::transmute(memory_coherent) };
            memory_coherent as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let memory_volatile: u32 = unsafe { ::std::mem::transmute(memory_volatile) };
            memory_volatile as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let memory_restrict: u32 = unsafe { ::std::mem::transmute(memory_restrict) };
            memory_restrict as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let explicit_xfb_buffer: u32 = unsafe { ::std::mem::transmute(explicit_xfb_buffer) };
            explicit_xfb_buffer as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let implicit_sized_array: u32 = unsafe { ::std::mem::transmute(implicit_sized_array) };
            implicit_sized_array as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_glsl_struct_field__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<glsl_struct_field__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<glsl_struct_field__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(glsl_struct_field__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<glsl_struct_field__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(glsl_struct_field__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for glsl_struct_field__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_glsl_struct_field() {
    const UNINIT: ::std::mem::MaybeUninit<glsl_struct_field> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<glsl_struct_field>(),
        48usize,
        concat!("Size of: ", stringify!(glsl_struct_field))
    );
    assert_eq!(
        ::std::mem::align_of::<glsl_struct_field>(),
        8usize,
        concat!("Alignment of ", stringify!(glsl_struct_field))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).location) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).component) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(component)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xfb_buffer) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(xfb_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xfb_stride) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(xfb_stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_format) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(glsl_struct_field),
            "::",
            stringify!(image_format)
        )
    );
}
impl Default for glsl_struct_field {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn glsl_type_is_vector(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_is_scalar(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_is_vector_or_scalar(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_is_matrix(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_is_array_or_matrix(t: *const glsl_type) -> bool;
}
extern "C" {
    #[doc = " Query whether a 64-bit type takes two slots."]
    pub fn glsl_type_is_dual_slot(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_is_leaf(type_: *const glsl_type) -> bool;
}
extern "C" {
    #[doc = " Gets the \"bare\" type without any decorations or layout information."]
    pub fn glsl_get_bare_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Get the basic scalar type which this type aggregates.\n\n If the type is a numeric or boolean scalar, vector, or matrix, or an\n array of any of those, this function gets the scalar type of the\n individual components.  For structs and arrays of structs, this function\n returns the struct type.  For samplers and arrays of samplers, this\n function returns the sampler type."]
    pub fn glsl_get_scalar_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " For numeric and boolean derived types returns the basic scalar type\n\n If the type is a numeric or boolean scalar, vector, or matrix type,\n this function gets the scalar type of the individual components.  For\n all other types, including arrays of numeric or boolean types, the\n error type is returned."]
    pub fn glsl_get_base_glsl_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_get_length(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_type_wrap_in_arrays(
        t: *const glsl_type,
        arrays: *const glsl_type,
    ) -> *const glsl_type;
}
extern "C" {
    #[doc = " Return the total number of elements in an array including the elements\n in arrays of arrays."]
    pub fn glsl_get_aoa_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_get_array_element(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Get the type stripped of any arrays\n\n \\return\n Pointer to the type of elements of the first non-array type for array\n types, or pointer to itself for non-array types."]
    pub fn glsl_without_array(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_without_array_or_matrix(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_get_cmat_element(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_get_cmat_description(t: *const glsl_type) -> *const glsl_cmat_description;
}
extern "C" {
    #[doc = " Return the amount of atomic counter storage required for a type."]
    pub fn glsl_atomic_size(type_: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Type A contains type B if A is B or A is a composite type (struct,\n interface, array) that has an element that contains B."]
    pub fn glsl_type_contains_32bit(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_contains_64bit(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_type_contains_image(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_atomic(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_double(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_integer(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_opaque(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_sampler(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_array(t: *const glsl_type) -> bool;
}
extern "C" {
    pub fn glsl_contains_subroutine(t: *const glsl_type) -> bool;
}
extern "C" {
    #[doc = " Return the number of coordinate components needed for this\n sampler or image type.\n\n This is based purely on the sampler's dimensionality.  For example, this\n returns 1 for sampler1D, and 3 for sampler2DArray.\n\n Note that this is often different than actual coordinate type used in\n a texturing built-in function, since those pack additional values (such\n as the shadow comparator or projector) into the coordinate type."]
    pub fn glsl_get_sampler_coordinate_components(t: *const glsl_type) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Compares whether this type matches another type without taking into\n account the precision in structures.\n\n This is applied recursively so that structures containing structure\n members can also ignore the precision."]
    pub fn glsl_type_compare_no_precision(a: *const glsl_type, b: *const glsl_type) -> bool;
}
extern "C" {
    #[doc = " Compare a record type against another record type.\n\n This is useful for matching record types declared on the same shader\n stage as well as across different shader stages.\n The option to not match name is needed for matching record types\n declared across different shader stages.\n The option to not match locations is to deal with places where the\n same struct is defined in a block which has a location set on it."]
    pub fn glsl_record_compare(
        a: *const glsl_type,
        b: *const glsl_type,
        match_name: bool,
        match_locations: bool,
        match_precision: bool,
    ) -> bool;
}
extern "C" {
    pub fn glsl_get_struct_field(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_get_struct_field_data(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const glsl_struct_field;
}
extern "C" {
    #[doc = " Calculate offset between the base location of the struct in\n uniform storage and a struct member.\n For the initial call, length is the index of the member to find the\n offset for."]
    pub fn glsl_get_struct_location_offset(
        t: *const glsl_type,
        length: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Get the location of a field within a record type"]
    pub fn glsl_get_field_index(
        t: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the type of a structure field\n\n \\return\n Pointer to the type of the named field.  If the type is not a structure\n or the named field does not exist, \\c &glsl_type_builtin_error is returned."]
    pub fn glsl_get_field_type(
        t: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_f16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_dvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_ivec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_uvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_bvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_i64vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_u64vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_i16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_u16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_i8vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_u8vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_simple_explicit_type(
        base_type: ::std::os::raw::c_uint,
        rows: ::std::os::raw::c_uint,
        columns: ::std::os::raw::c_uint,
        explicit_stride: ::std::os::raw::c_uint,
        row_major: bool,
        explicit_alignment: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_sampler_type(
        dim: glsl_sampler_dim,
        shadow: bool,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_bare_sampler_type() -> *const glsl_type;
}
extern "C" {
    pub fn glsl_bare_shadow_sampler_type() -> *const glsl_type;
}
extern "C" {
    pub fn glsl_texture_type(
        dim: glsl_sampler_dim,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_image_type(
        dim: glsl_sampler_dim,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_array_type(
        element: *const glsl_type,
        array_size: ::std::os::raw::c_uint,
        explicit_stride: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_cmat_type(desc: *const glsl_cmat_description) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_struct_type_with_explicit_alignment(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        name: *const ::std::os::raw::c_char,
        packed: bool,
        explicit_alignment: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_interface_type(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        packing: glsl_interface_packing,
        row_major: bool,
        block_name: *const ::std::os::raw::c_char,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_subroutine_type(subroutine_name: *const ::std::os::raw::c_char)
        -> *const glsl_type;
}
extern "C" {
    #[doc = " Query the full type of a matrix row\n\n \\return\n If the type is not a matrix, \\c glsl_type::error_type is returned.\n Otherwise a type matching the rows of the matrix is returned."]
    pub fn glsl_get_row_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Query the full type of a matrix column\n\n \\return\n If the type is not a matrix, \\c glsl_type::error_type is returned.\n Otherwise a type matching the columns of the matrix is returned."]
    pub fn glsl_get_column_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Returns an explicitly laid out type given a type and size/align func\n\n The size/align func is only called for scalar and vector types and the\n returned type is otherwise laid out in the natural way as follows:\n\n  - Arrays and matrices have a stride of align(elem_size, elem_align).\n\n  - Structure types have their elements in-order and as tightly packed as\n    possible following the alignment required by the size/align func.\n\n  - All composite types (structures, matrices, and arrays) have an\n    alignment equal to the highest alignment of any member of the composite.\n\n The types returned by this function are likely not suitable for most UBO\n or SSBO layout because they do not add the extra array and substructure\n alignment that is required by std140 and std430."]
    pub fn glsl_get_explicit_type_for_size_align(
        type_: *const glsl_type,
        type_info: glsl_type_size_align_func,
        size: *mut ::std::os::raw::c_uint,
        alignment: *mut ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_type_replace_vec3_with_vec4(type_: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Gets the float16 version of this type."]
    pub fn glsl_float16_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Gets the int16 version of this type."]
    pub fn glsl_int16_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Gets the uint16 version of this type."]
    pub fn glsl_uint16_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_type_to_16bit(old_type: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_replace_vector_type(
        t: *const glsl_type,
        components: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_channel_type(t: *const glsl_type) -> *const glsl_type;
}
extern "C" {
    #[doc = " Get the type resulting from a multiplication of \\p type_a * \\p type_b"]
    pub fn glsl_get_mul_type(
        type_a: *const glsl_type,
        type_b: *const glsl_type,
    ) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_type_get_sampler_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_type_get_texture_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_type_get_image_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Calculate the number of vec4 slots required to hold this type.\n\n This is the underlying recursive type_size function for\n count_attribute_slots() (vertex inputs and varyings) but also for\n gallium's !PIPE_CAP_PACKED_UNIFORMS case."]
    pub fn glsl_count_vec4_slots(
        t: *const glsl_type,
        is_gl_vertex_input: bool,
        is_bindless: bool,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Calculate the number of vec4 slots required to hold this type.\n\n This is the underlying recursive type_size function for\n gallium's PIPE_CAP_PACKED_UNIFORMS case."]
    pub fn glsl_count_dword_slots(t: *const glsl_type, is_bindless: bool)
        -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Calculate the number of components slots required to hold this type\n\n This is used to determine how many uniform or varying locations a type\n might occupy."]
    pub fn glsl_get_component_slots(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_get_component_slots_aligned(
        t: *const glsl_type,
        offset: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Used to count the number of varyings contained in the type ignoring\n innermost array elements."]
    pub fn glsl_varying_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Calculate the number of unique values from glGetUniformLocation for the\n elements of the type.\n\n This is used to allocate slots in the UniformRemapTable, the amount of\n locations may not match with actual used storage space by the driver."]
    pub fn glsl_type_uniform_locations(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Size in bytes of this type in OpenCL memory"]
    pub fn glsl_get_cl_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Alignment in bytes of the start of this type in OpenCL memory."]
    pub fn glsl_get_cl_alignment(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn glsl_get_cl_type_size_align(
        t: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    #[doc = " Get the type interface packing used internally. For shared and packing\n layouts this is implementation defined."]
    pub fn glsl_get_internal_ifc_packing(
        t: *const glsl_type,
        std430_supported: bool,
    ) -> glsl_interface_packing;
}
extern "C" {
    #[doc = " Alignment in bytes of the start of this type in a std140 uniform\n block."]
    pub fn glsl_get_std140_base_alignment(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Size in bytes of this type in a std140 uniform block.\n\n Note that this is not GL_UNIFORM_SIZE (which is the number of\n elements in the array)"]
    pub fn glsl_get_std140_size(t: *const glsl_type, row_major: bool) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Calculate array stride in bytes of this type in a std430 shader storage\n block."]
    pub fn glsl_get_std430_array_stride(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Alignment in bytes of the start of this type in a std430 shader\n storage block."]
    pub fn glsl_get_std430_base_alignment(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Size in bytes of this type in a std430 shader storage block.\n\n Note that this is not GL_BUFFER_SIZE"]
    pub fn glsl_get_std430_size(t: *const glsl_type, row_major: bool) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Size in bytes of this type based on its explicit data.\n\n When using SPIR-V shaders (ARB_gl_spirv), memory layouts are expressed\n through explicit offset, stride and matrix layout, so the size\n can/should be computed used those values.\n\n Note that the value returned by this method is only correct if such\n values are set, so only with SPIR-V shaders. Should not be used with\n GLSL shaders."]
    pub fn glsl_get_explicit_size(
        t: *const glsl_type,
        align_to_stride: bool,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Gets an explicitly laid out type with the std140 layout."]
    pub fn glsl_get_explicit_std140_type(t: *const glsl_type, row_major: bool) -> *const glsl_type;
}
extern "C" {
    #[doc = " Gets an explicitly laid out type with the std430 layout."]
    pub fn glsl_get_explicit_std430_type(t: *const glsl_type, row_major: bool) -> *const glsl_type;
}
extern "C" {
    pub fn glsl_get_natural_size_align_bytes(
        t: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn glsl_get_vec4_size_align_bytes(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    #[doc = " Allocate a new ralloc context.\n\n While any ralloc'd pointer can be used as a context, sometimes it is useful\n to simply allocate a context with no associated memory.\n\n It is equivalent to:\n \\code\n ((type *) ralloc_size(ctx, 0)\n \\endcode"]
    pub fn ralloc_context(ctx: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate memory chained off of the given context.\n\n This is the core allocation routine which is used by all others.  It\n simply allocates storage for \\p size bytes and returns the pointer,\n similar to \\c malloc."]
    pub fn ralloc_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate zero-initialized memory chained off of the given context.\n\n This is similar to \\c calloc with a size of 1."]
    pub fn rzalloc_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate memory for an array chained off the given context.\n\n Similar to \\c calloc, but does not initialize the memory to zero.\n\n More than a convenience function, this also checks for integer overflow when\n multiplying \\p size and \\p count.  This is necessary for security."]
    pub fn ralloc_array_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
        count: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocate a zero-initialized array chained off the given context.\n\n Similar to \\c calloc.\n\n More than a convenience function, this also checks for integer overflow when\n multiplying \\p size and \\p count.  This is necessary for security."]
    pub fn rzalloc_array_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
        count: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Free a piece of ralloc-managed memory.\n\n This will also free the memory of any children allocated this context."]
    pub fn ralloc_free(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " \"Steal\" memory from one context, changing it to another.\n\n This changes \\p ptr's context to \\p new_ctx.  This is quite useful if\n memory is allocated out of a temporary context."]
    pub fn ralloc_steal(new_ctx: *const ::std::os::raw::c_void, ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Reparent all children from one context to another.\n\n This effectively calls ralloc_steal(new_ctx, child) for all children of \\p old_ctx."]
    pub fn ralloc_adopt(
        new_ctx: *const ::std::os::raw::c_void,
        old_ctx: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " Return the given pointer's ralloc context."]
    pub fn ralloc_parent(ptr: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Set a callback to occur just before an object is freed."]
    pub fn ralloc_set_destructor(
        ptr: *const ::std::os::raw::c_void,
        destructor: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    );
}
extern "C" {
    #[doc = " Duplicate memory, allocating the memory from the given context."]
    pub fn ralloc_memdup(
        ctx: *const ::std::os::raw::c_void,
        mem: *const ::std::os::raw::c_void,
        n: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " \\defgroup array String Functions @{\n**\n* Duplicate a string, allocating the memory from the given context.\n*/"]
    pub fn ralloc_strdup(
        ctx: *const ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Duplicate a string, allocating the memory from the given context.\n\n Like \\c strndup, at most \\p n characters are copied.  If \\p str is longer\n than \\p n characters, \\p n are copied, and a termining \\c '\\0' byte is added."]
    pub fn ralloc_strndup(
        ctx: *const ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
        n: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Concatenate two strings, allocating the necessary space.\n\n This appends \\p str to \\p *dest, similar to \\c strcat, using ralloc_resize\n to expand \\p *dest to the appropriate size.  \\p dest will be updated to the\n new pointer unless allocation fails.\n\n The result will always be null-terminated.\n\n \\return True unless allocation failed."]
    pub fn ralloc_strcat(
        dest: *mut *mut ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    #[doc = " Concatenate two strings, allocating the necessary space.\n\n This appends at most \\p n bytes of \\p str to \\p *dest, using ralloc_resize\n to expand \\p *dest to the appropriate size.  \\p dest will be updated to the\n new pointer unless allocation fails.\n\n The result will always be null-terminated; \\p str does not need to be null\n terminated if it is longer than \\p n.\n\n \\return True unless allocation failed."]
    pub fn ralloc_strncat(
        dest: *mut *mut ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
        n: usize,
    ) -> bool;
}
extern "C" {
    #[doc = " Concatenate two strings, allocating the necessary space.\n\n This appends \\p n bytes of \\p str to \\p *dest, using ralloc_resize\n to expand \\p *dest to the appropriate size.  \\p dest will be updated to the\n new pointer unless allocation fails.\n\n The result will always be null-terminated.\n\n This function differs from ralloc_strcat() and ralloc_strncat() in that it\n does not do any strlen() calls which can become costly on large strings.\n\n \\return True unless allocation failed."]
    pub fn ralloc_str_append(
        dest: *mut *mut ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
        existing_length: usize,
        str_size: usize,
    ) -> bool;
}
extern "C" {
    #[doc = " Print to a string.\n\n This is analogous to \\c sprintf, but allocates enough space (using \\p ctx\n as the context) for the resulting string.\n\n \\return The newly allocated string."]
    pub fn ralloc_asprintf(
        ctx: *const ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Print to a string, given a va_list.\n\n This is analogous to \\c vsprintf, but allocates enough space (using \\p ctx\n as the context) for the resulting string.\n\n \\return The newly allocated string."]
    pub fn ralloc_vasprintf(
        ctx: *const ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
        args: *mut va_list,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Rewrite the tail of an existing string, starting at a given index.\n\n Overwrites the contents of *str starting at \\p start with newly formatted\n text, including a new null-terminator.  Allocates more memory as necessary.\n\n This can be used to append formatted text when the length of the existing\n string is already known, saving a strlen() call.\n\n \\sa ralloc_asprintf_append\n\n \\param str   The string to be updated.\n \\param start The index to start appending new data at.\n \\param fmt   A printf-style formatting string\n\n \\p str will be updated to the new pointer unless allocation fails.\n \\p start will be increased by the length of the newly formatted text.\n\n \\return True unless allocation failed."]
    pub fn ralloc_asprintf_rewrite_tail(
        str_: *mut *mut ::std::os::raw::c_char,
        start: *mut usize,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> bool;
}
extern "C" {
    #[doc = " Rewrite the tail of an existing string, starting at a given index.\n\n Overwrites the contents of *str starting at \\p start with newly formatted\n text, including a new null-terminator.  Allocates more memory as necessary.\n\n This can be used to append formatted text when the length of the existing\n string is already known, saving a strlen() call.\n\n \\sa ralloc_vasprintf_append\n\n \\param str   The string to be updated.\n \\param start The index to start appending new data at.\n \\param fmt   A printf-style formatting string\n \\param args  A va_list containing the data to be formatted\n\n \\p str will be updated to the new pointer unless allocation fails.\n \\p start will be increased by the length of the newly formatted text.\n\n \\return True unless allocation failed."]
    pub fn ralloc_vasprintf_rewrite_tail(
        str_: *mut *mut ::std::os::raw::c_char,
        start: *mut usize,
        fmt: *const ::std::os::raw::c_char,
        args: *mut va_list,
    ) -> bool;
}
extern "C" {
    #[doc = " Append formatted text to the supplied string.\n\n This is equivalent to\n \\code\n ralloc_asprintf_rewrite_tail(str, strlen(*str), fmt, ...)\n \\endcode\n\n \\sa ralloc_asprintf\n \\sa ralloc_asprintf_rewrite_tail\n \\sa ralloc_strcat\n\n \\p str will be updated to the new pointer unless allocation fails.\n\n \\return True unless allocation failed."]
    pub fn ralloc_asprintf_append(
        str_: *mut *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> bool;
}
extern "C" {
    #[doc = " Append formatted text to the supplied string, given a va_list.\n\n This is equivalent to\n \\code\n ralloc_vasprintf_rewrite_tail(str, strlen(*str), fmt, args)\n \\endcode\n\n \\sa ralloc_vasprintf\n \\sa ralloc_vasprintf_rewrite_tail\n \\sa ralloc_strcat\n\n \\p str will be updated to the new pointer unless allocation fails.\n\n \\return True unless allocation failed."]
    pub fn ralloc_vasprintf_append(
        str_: *mut *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        args: *mut va_list,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gc_ctx {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linear_ctx {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Same as ralloc_steal, but steals the entire linear context."]
    pub fn ralloc_steal_linear_context(
        new_ralloc_ctx: *mut ::std::os::raw::c_void,
        ctx: *mut linear_ctx,
    );
}
extern "C" {
    #[doc = " Return the ralloc parent of the linear context."]
    pub fn ralloc_parent_of_linear_context(ctx: *mut linear_ctx) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ralloc_print_info(
        f: *mut FILE,
        p: *const ::std::os::raw::c_void,
        flags: ::std::os::raw::c_uint,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct exec_node {
    pub next: *mut exec_node,
    pub prev: *mut exec_node,
}
#[test]
fn bindgen_test_layout_exec_node() {
    const UNINIT: ::std::mem::MaybeUninit<exec_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<exec_node>(),
        16usize,
        concat!("Size of: ", stringify!(exec_node))
    );
    assert_eq!(
        ::std::mem::align_of::<exec_node>(),
        8usize,
        concat!("Alignment of ", stringify!(exec_node))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(exec_node),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(exec_node),
            "::",
            stringify!(prev)
        )
    );
}
impl Default for exec_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct exec_list {
    pub head_sentinel: exec_node,
    pub tail_sentinel: exec_node,
}
#[test]
fn bindgen_test_layout_exec_list() {
    const UNINIT: ::std::mem::MaybeUninit<exec_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<exec_list>(),
        32usize,
        concat!("Size of: ", stringify!(exec_list))
    );
    assert_eq!(
        ::std::mem::align_of::<exec_list>(),
        8usize,
        concat!("Alignment of ", stringify!(exec_list))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).head_sentinel) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(exec_list),
            "::",
            stringify!(head_sentinel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tail_sentinel) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(exec_list),
            "::",
            stringify!(tail_sentinel)
        )
    );
}
impl Default for exec_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _SHA1_CTX {
    pub state: [u32; 5usize],
    pub count: u64,
    pub buffer: [u8; 64usize],
}
#[test]
fn bindgen_test_layout__SHA1_CTX() {
    const UNINIT: ::std::mem::MaybeUninit<_SHA1_CTX> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_SHA1_CTX>(),
        96usize,
        concat!("Size of: ", stringify!(_SHA1_CTX))
    );
    assert_eq!(
        ::std::mem::align_of::<_SHA1_CTX>(),
        8usize,
        concat!("Alignment of ", stringify!(_SHA1_CTX))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SHA1_CTX),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_SHA1_CTX),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_SHA1_CTX),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for _SHA1_CTX {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SHA1_CTX = _SHA1_CTX;
extern "C" {
    pub fn SHA1Init(arg1: *mut SHA1_CTX);
}
extern "C" {
    pub fn SHA1Update(arg1: *mut SHA1_CTX, arg2: *const u8, arg3: usize);
}
extern "C" {
    pub fn SHA1Final(arg1: *mut [u8; 20usize], arg2: *mut SHA1_CTX);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct spirv_supported_capabilities {
    pub address: bool,
    pub amd_fragment_mask: bool,
    pub amd_gcn_shader: bool,
    pub amd_image_gather_bias_lod: bool,
    pub amd_image_read_write_lod: bool,
    pub amd_shader_ballot: bool,
    pub amd_shader_explicit_vertex_parameter: bool,
    pub amd_trinary_minmax: bool,
    pub atomic_storage: bool,
    pub cooperative_matrix: bool,
    pub demote_to_helper_invocation: bool,
    pub derivative_group: bool,
    pub descriptor_array_dynamic_indexing: bool,
    pub descriptor_array_non_uniform_indexing: bool,
    pub descriptor_indexing: bool,
    pub device_group: bool,
    pub draw_parameters: bool,
    pub float_controls: bool,
    pub float16_atomic_add: bool,
    pub float16_atomic_min_max: bool,
    pub float16: bool,
    pub float32_atomic_add: bool,
    pub float32_atomic_min_max: bool,
    pub float64_atomic_add: bool,
    pub float64_atomic_min_max: bool,
    pub float64: bool,
    pub fragment_barycentric: bool,
    pub fragment_density: bool,
    pub fragment_fully_covered: bool,
    pub fragment_shader_pixel_interlock: bool,
    pub fragment_shader_sample_interlock: bool,
    pub fragment_shading_rate: bool,
    pub generic_pointers: bool,
    pub geometry_streams: bool,
    pub groups: bool,
    pub image_atomic_int64: bool,
    pub image_ms_array: bool,
    pub image_read_without_format: bool,
    pub image_write_without_format: bool,
    pub int16: bool,
    pub int64_atomics: bool,
    pub int64: bool,
    pub int8: bool,
    pub integer_functions2: bool,
    pub kernel_image_read_write: bool,
    pub kernel_image: bool,
    pub kernel: bool,
    pub linkage: bool,
    pub literal_sampler: bool,
    pub mesh_shading_nv: bool,
    pub mesh_shading: bool,
    pub min_lod: bool,
    pub multiview: bool,
    pub per_view_attributes_nv: bool,
    pub physical_storage_buffer_address: bool,
    pub post_depth_coverage: bool,
    pub printf: bool,
    pub quad_control: bool,
    pub ray_cull_mask: bool,
    pub ray_query: bool,
    pub ray_tracing: bool,
    pub ray_traversal_primitive_culling: bool,
    pub ray_tracing_position_fetch: bool,
    pub runtime_descriptor_array: bool,
    pub shader_clock: bool,
    pub shader_enqueue: bool,
    pub shader_sm_builtins_nv: bool,
    pub shader_viewport_index_layer: bool,
    pub shader_viewport_mask_nv: bool,
    pub sparse_residency: bool,
    pub stencil_export: bool,
    pub storage_16bit: bool,
    pub storage_8bit: bool,
    pub storage_image_ms: bool,
    pub subgroup_arithmetic: bool,
    pub subgroup_ballot: bool,
    pub subgroup_basic: bool,
    pub subgroup_dispatch: bool,
    pub subgroup_quad: bool,
    pub subgroup_rotate: bool,
    pub subgroup_shuffle: bool,
    pub subgroup_uniform_control_flow: bool,
    pub subgroup_vote: bool,
    pub tessellation: bool,
    pub transform_feedback: bool,
    pub variable_pointers: bool,
    pub vk_memory_model_device_scope: bool,
    pub vk_memory_model: bool,
    pub workgroup_memory_explicit_layout: bool,
    pub intel_subgroup_shuffle: bool,
    pub intel_subgroup_buffer_block_io: bool,
}
#[test]
fn bindgen_test_layout_spirv_supported_capabilities() {
    const UNINIT: ::std::mem::MaybeUninit<spirv_supported_capabilities> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<spirv_supported_capabilities>(),
        91usize,
        concat!("Size of: ", stringify!(spirv_supported_capabilities))
    );
    assert_eq!(
        ::std::mem::align_of::<spirv_supported_capabilities>(),
        1usize,
        concat!("Alignment of ", stringify!(spirv_supported_capabilities))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_fragment_mask) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_fragment_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_gcn_shader) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_gcn_shader)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_image_gather_bias_lod) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_image_gather_bias_lod)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_image_read_write_lod) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_image_read_write_lod)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_shader_ballot) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_shader_ballot)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).amd_shader_explicit_vertex_parameter) as usize
                - ptr as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_shader_explicit_vertex_parameter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_trinary_minmax) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(amd_trinary_minmax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).atomic_storage) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(atomic_storage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cooperative_matrix) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(cooperative_matrix)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).demote_to_helper_invocation) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(demote_to_helper_invocation)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).derivative_group) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(derivative_group)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).descriptor_array_dynamic_indexing) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(descriptor_array_dynamic_indexing)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).descriptor_array_non_uniform_indexing) as usize
                - ptr as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(descriptor_array_non_uniform_indexing)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).descriptor_indexing) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(descriptor_indexing)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).device_group) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(device_group)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).draw_parameters) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(draw_parameters)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float_controls) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float_controls)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float16_atomic_add) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float16_atomic_add)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float16_atomic_min_max) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float16_atomic_min_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float16) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float32_atomic_add) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float32_atomic_add)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float32_atomic_min_max) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float32_atomic_min_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float64_atomic_add) as usize - ptr as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float64_atomic_add)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float64_atomic_min_max) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float64_atomic_min_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float64) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(float64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fragment_barycentric) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(fragment_barycentric)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fragment_density) as usize - ptr as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(fragment_density)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fragment_fully_covered) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(fragment_fully_covered)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).fragment_shader_pixel_interlock) as usize - ptr as usize
        },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(fragment_shader_pixel_interlock)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).fragment_shader_sample_interlock) as usize - ptr as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(fragment_shader_sample_interlock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fragment_shading_rate) as usize - ptr as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(fragment_shading_rate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).generic_pointers) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(generic_pointers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).geometry_streams) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(geometry_streams)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).groups) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(groups)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_atomic_int64) as usize - ptr as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(image_atomic_int64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_ms_array) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(image_ms_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_read_without_format) as usize - ptr as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(image_read_without_format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_write_without_format) as usize - ptr as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(image_write_without_format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).int16) as usize - ptr as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(int16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).int64_atomics) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(int64_atomics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).int64) as usize - ptr as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(int64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).int8) as usize - ptr as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(int8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).integer_functions2) as usize - ptr as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(integer_functions2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kernel_image_read_write) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(kernel_image_read_write)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kernel_image) as usize - ptr as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(kernel_image)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kernel) as usize - ptr as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(kernel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).linkage) as usize - ptr as usize },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(linkage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).literal_sampler) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(literal_sampler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mesh_shading_nv) as usize - ptr as usize },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(mesh_shading_nv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mesh_shading) as usize - ptr as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(mesh_shading)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_lod) as usize - ptr as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(min_lod)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).multiview) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(multiview)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).per_view_attributes_nv) as usize - ptr as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(per_view_attributes_nv)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).physical_storage_buffer_address) as usize - ptr as usize
        },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(physical_storage_buffer_address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).post_depth_coverage) as usize - ptr as usize },
        55usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(post_depth_coverage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).printf) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(printf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).quad_control) as usize - ptr as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(quad_control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ray_cull_mask) as usize - ptr as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(ray_cull_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ray_query) as usize - ptr as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(ray_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ray_tracing) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(ray_tracing)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).ray_traversal_primitive_culling) as usize - ptr as usize
        },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(ray_traversal_primitive_culling)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ray_tracing_position_fetch) as usize - ptr as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(ray_tracing_position_fetch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).runtime_descriptor_array) as usize - ptr as usize },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(runtime_descriptor_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader_clock) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(shader_clock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader_enqueue) as usize - ptr as usize },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(shader_enqueue)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader_sm_builtins_nv) as usize - ptr as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(shader_sm_builtins_nv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader_viewport_index_layer) as usize - ptr as usize },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(shader_viewport_index_layer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader_viewport_mask_nv) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(shader_viewport_mask_nv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sparse_residency) as usize - ptr as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(sparse_residency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stencil_export) as usize - ptr as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(stencil_export)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).storage_16bit) as usize - ptr as usize },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(storage_16bit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).storage_8bit) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(storage_8bit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).storage_image_ms) as usize - ptr as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(storage_image_ms)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_arithmetic) as usize - ptr as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_arithmetic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_ballot) as usize - ptr as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_ballot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_basic) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_basic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_dispatch) as usize - ptr as usize },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_dispatch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_quad) as usize - ptr as usize },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_quad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_rotate) as usize - ptr as usize },
        79usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_rotate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_shuffle) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_shuffle)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).subgroup_uniform_control_flow) as usize - ptr as usize
        },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_uniform_control_flow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_vote) as usize - ptr as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(subgroup_vote)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tessellation) as usize - ptr as usize },
        83usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(tessellation)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).transform_feedback) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(transform_feedback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).variable_pointers) as usize - ptr as usize },
        85usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(variable_pointers)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).vk_memory_model_device_scope) as usize - ptr as usize
        },
        86usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(vk_memory_model_device_scope)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vk_memory_model) as usize - ptr as usize },
        87usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(vk_memory_model)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).workgroup_memory_explicit_layout) as usize - ptr as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(workgroup_memory_explicit_layout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intel_subgroup_shuffle) as usize - ptr as usize },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(intel_subgroup_shuffle)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).intel_subgroup_buffer_block_io) as usize - ptr as usize
        },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(spirv_supported_capabilities),
            "::",
            stringify!(intel_subgroup_buffer_block_io)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct shader_info {
    pub name: *const ::std::os::raw::c_char,
    pub label: *const ::std::os::raw::c_char,
    pub internal: bool,
    pub source_sha1: [u8; 20usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub num_textures: u8,
    pub num_ubos: u8,
    pub num_abos: u8,
    pub num_ssbos: u8,
    pub num_images: u8,
    pub inputs_read: u64,
    pub dual_slot_inputs: u64,
    pub outputs_written: u64,
    pub outputs_read: u64,
    pub system_values_read: [::std::os::raw::c_uint; 3usize],
    pub per_primitive_inputs: u64,
    pub per_primitive_outputs: u64,
    pub per_view_outputs: u64,
    pub inputs_read_16bit: u16,
    pub outputs_written_16bit: u16,
    pub outputs_read_16bit: u16,
    pub inputs_read_indirectly_16bit: u16,
    pub outputs_accessed_indirectly_16bit: u16,
    pub patch_inputs_read: u32,
    pub patch_outputs_written: u32,
    pub patch_outputs_read: u32,
    pub inputs_read_indirectly: u64,
    pub outputs_accessed_indirectly: u64,
    pub patch_inputs_read_indirectly: u64,
    pub patch_outputs_accessed_indirectly: u64,
    pub textures_used: [::std::os::raw::c_uint; 4usize],
    pub textures_used_by_txf: [::std::os::raw::c_uint; 4usize],
    pub samplers_used: [::std::os::raw::c_uint; 1usize],
    pub images_used: [::std::os::raw::c_uint; 2usize],
    pub image_buffers: [::std::os::raw::c_uint; 2usize],
    pub msaa_images: [::std::os::raw::c_uint; 2usize],
    pub float_controls_execution_mode: u32,
    #[doc = " Size of shared variables accessed by compute/task/mesh shaders."]
    pub shared_size: ::std::os::raw::c_uint,
    #[doc = " Size of task payload variables accessed by task/mesh shaders."]
    pub task_payload_size: ::std::os::raw::c_uint,
    #[doc = " Number of ray tracing queries in the shader (counts all elements of all\n variables)."]
    pub ray_queries: ::std::os::raw::c_uint,
    #[doc = " Local workgroup size used by compute/task/mesh shaders."]
    pub workgroup_size: [u16; 3usize],
    pub subgroup_size: gl_subgroup_size,
    pub num_subgroups: u8,
    #[doc = " Uses subgroup intrinsics which can communicate across a quad."]
    pub uses_wide_subgroup_intrinsics: bool,
    pub xfb_stride: [u8; 4usize],
    pub inlinable_uniform_dw_offsets: [u16; 4usize],
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub bit_sizes_float: u8,
    pub bit_sizes_int: u8,
    pub _bitfield_align_3: [u8; 0],
    pub _bitfield_3: __BindgenBitfieldUnit<[u8; 2usize]>,
    #[doc = " Set if this shader uses legacy (DX9 or ARB assembly) math rules.\n\n From the ARB_fragment_program specification:\n\n    \"The following rules apply to multiplication:\n\n      1. <x> * <y> == <y> * <x>, for all <x> and <y>.\n      2. +/-0.0 * <x> = +/-0.0, at least for all <x> that correspond to\n         *representable numbers (IEEE \"not a number\" and \"infinity\"\n         *encodings may be exceptions).\n      3. +1.0 * <x> = <x>, for all <x>.\"\"\n\n However, in effect this was due to DX9 semantics implying that 0*x=0 even\n for inf/nan if the hardware generated them instead of float_min/max.  So,\n you should not have an exception for inf/nan to rule 2 above.\n\n One implementation of this behavior would be to flush all generated NaNs\n to zero, at which point 0*Inf=Nan=0.  Most DX9/ARB-asm hardware did not\n generate NaNs, and the only way the GPU saw one was to possibly feed it\n in as a uniform."]
    pub use_legacy_math_rules: bool,
    pub anon_1: shader_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union shader_info__bindgen_ty_1 {
    pub vs: shader_info__bindgen_ty_1__bindgen_ty_1,
    pub gs: shader_info__bindgen_ty_1__bindgen_ty_2,
    pub fs: shader_info__bindgen_ty_1__bindgen_ty_3,
    pub cs: shader_info__bindgen_ty_1__bindgen_ty_4,
    pub tess: shader_info__bindgen_ty_1__bindgen_ty_5,
    pub mesh: shader_info__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_1 {
    pub double_inputs: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).double_inputs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(double_inputs)
        )
    );
}
impl shader_info__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn blit_sgprs_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_blit_sgprs_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn tes_agx(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_tes_agx(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn window_space_position(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_window_space_position(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn needs_edge_flag(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_edge_flag(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        blit_sgprs_amd: u8,
        tes_agx: bool,
        window_space_position: bool,
        needs_edge_flag: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let blit_sgprs_amd: u8 = unsafe { ::std::mem::transmute(blit_sgprs_amd) };
            blit_sgprs_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let tes_agx: u8 = unsafe { ::std::mem::transmute(tes_agx) };
            tes_agx as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let window_space_position: u8 = unsafe { ::std::mem::transmute(window_space_position) };
            window_space_position as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_edge_flag: u8 = unsafe { ::std::mem::transmute(needs_edge_flag) };
            needs_edge_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " The output primitive type"]
    pub output_primitive: mesa_prim,
    #[doc = " The input primitive type"]
    pub input_primitive: mesa_prim,
    #[doc = " The maximum number of vertices the geometry shader might write."]
    pub vertices_out: u16,
    #[doc = " 1 .. MAX_GEOMETRY_SHADER_INVOCATIONS"]
    pub invocations: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_2>(),
        6usize,
        concat!(
            "Size of: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_2>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output_primitive) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(output_primitive)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).input_primitive) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(input_primitive)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vertices_out) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(vertices_out)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).invocations) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(invocations)
        )
    );
}
impl Default for shader_info__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn vertices_in(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_vertices_in(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_end_primitive(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_end_primitive(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn active_stream_mask(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_active_stream_mask(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vertices_in: u8,
        uses_end_primitive: bool,
        active_stream_mask: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let vertices_in: u8 = unsafe { ::std::mem::transmute(vertices_in) };
            vertices_in as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let uses_end_primitive: u8 = unsafe { ::std::mem::transmute(uses_end_primitive) };
            uses_end_primitive as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let active_stream_mask: u8 = unsafe { ::std::mem::transmute(active_stream_mask) };
            active_stream_mask as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 5usize]>,
    pub advanced_blend_modes: ::std::os::raw::c_uint,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_3>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).advanced_blend_modes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(advanced_blend_modes)
        )
    );
}
impl Default for shader_info__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn uses_discard(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_discard(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_demote(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_demote(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_fbfetch_output(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_fbfetch_output(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fbfetch_coherent(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fbfetch_coherent(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_is_dual_source(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color_is_dual_source(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn require_full_quads(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_require_full_quads(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn needs_quad_helper_invocations(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_quad_helper_invocations(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_sample_qualifier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_qualifier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_sample_shading(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_shading(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn early_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inner_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_inner_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn post_depth_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_post_depth_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pixel_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pixel_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn untyped_color_outputs(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_untyped_color_outputs(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> gl_frag_depth_layout {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn color0_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color0_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn color0_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color0_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color1_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color1_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn color1_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color1_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uses_discard: bool,
        uses_demote: bool,
        uses_fbfetch_output: bool,
        fbfetch_coherent: bool,
        color_is_dual_source: bool,
        require_full_quads: bool,
        quad_derivatives: bool,
        needs_quad_helper_invocations: bool,
        uses_sample_qualifier: bool,
        uses_sample_shading: bool,
        early_fragment_tests: bool,
        inner_coverage: bool,
        post_depth_coverage: bool,
        pixel_center_integer: bool,
        origin_upper_left: bool,
        pixel_interlock_ordered: bool,
        pixel_interlock_unordered: bool,
        sample_interlock_ordered: bool,
        sample_interlock_unordered: bool,
        untyped_color_outputs: bool,
        depth_layout: gl_frag_depth_layout,
        color0_interp: ::std::os::raw::c_uint,
        color0_sample: bool,
        color0_centroid: bool,
        color1_interp: ::std::os::raw::c_uint,
        color1_sample: bool,
        color1_centroid: bool,
    ) -> __BindgenBitfieldUnit<[u8; 5usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 5usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let uses_discard: u8 = unsafe { ::std::mem::transmute(uses_discard) };
            uses_discard as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let uses_demote: u8 = unsafe { ::std::mem::transmute(uses_demote) };
            uses_demote as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let uses_fbfetch_output: u8 = unsafe { ::std::mem::transmute(uses_fbfetch_output) };
            uses_fbfetch_output as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fbfetch_coherent: u8 = unsafe { ::std::mem::transmute(fbfetch_coherent) };
            fbfetch_coherent as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let color_is_dual_source: u8 = unsafe { ::std::mem::transmute(color_is_dual_source) };
            color_is_dual_source as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let require_full_quads: u8 = unsafe { ::std::mem::transmute(require_full_quads) };
            require_full_quads as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let quad_derivatives: u8 = unsafe { ::std::mem::transmute(quad_derivatives) };
            quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let needs_quad_helper_invocations: u8 =
                unsafe { ::std::mem::transmute(needs_quad_helper_invocations) };
            needs_quad_helper_invocations as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let uses_sample_qualifier: u8 = unsafe { ::std::mem::transmute(uses_sample_qualifier) };
            uses_sample_qualifier as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let uses_sample_shading: u8 = unsafe { ::std::mem::transmute(uses_sample_shading) };
            uses_sample_shading as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let early_fragment_tests: u8 = unsafe { ::std::mem::transmute(early_fragment_tests) };
            early_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let inner_coverage: u8 = unsafe { ::std::mem::transmute(inner_coverage) };
            inner_coverage as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let post_depth_coverage: u8 = unsafe { ::std::mem::transmute(post_depth_coverage) };
            post_depth_coverage as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let pixel_center_integer: u8 = unsafe { ::std::mem::transmute(pixel_center_integer) };
            pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let origin_upper_left: u8 = unsafe { ::std::mem::transmute(origin_upper_left) };
            origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pixel_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_ordered) };
            pixel_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let pixel_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_unordered) };
            pixel_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let sample_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_ordered) };
            sample_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let sample_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_unordered) };
            sample_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let untyped_color_outputs: u8 = unsafe { ::std::mem::transmute(untyped_color_outputs) };
            untyped_color_outputs as u64
        });
        __bindgen_bitfield_unit.set(20usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(23usize, 3u8, {
            let color0_interp: u32 = unsafe { ::std::mem::transmute(color0_interp) };
            color0_interp as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let color0_sample: u8 = unsafe { ::std::mem::transmute(color0_sample) };
            color0_sample as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let color0_centroid: u8 = unsafe { ::std::mem::transmute(color0_centroid) };
            color0_centroid as u64
        });
        __bindgen_bitfield_unit.set(28usize, 3u8, {
            let color1_interp: u32 = unsafe { ::std::mem::transmute(color1_interp) };
            color1_interp as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let color1_sample: u8 = unsafe { ::std::mem::transmute(color1_sample) };
            color1_sample as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let color1_centroid: u8 = unsafe { ::std::mem::transmute(color1_centroid) };
            color1_centroid as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn early_and_late_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_and_late_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn stencil_front_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_front_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn stencil_back_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_back_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        early_and_late_fragment_tests: bool,
        stencil_front_layout: gl_frag_stencil_layout,
        stencil_back_layout: gl_frag_stencil_layout,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let early_and_late_fragment_tests: u8 =
                unsafe { ::std::mem::transmute(early_and_late_fragment_tests) };
            early_and_late_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let stencil_front_layout: u32 = unsafe { ::std::mem::transmute(stencil_front_layout) };
            stencil_front_layout as u64
        });
        __bindgen_bitfield_unit.set(4usize, 3u8, {
            let stencil_back_layout: u32 = unsafe { ::std::mem::transmute(stencil_back_layout) };
            stencil_back_layout as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_4 {
    pub workgroup_size_hint: [u16; 3usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " pointer size is:\n   AddressingModelLogical:    0    (default)\n   AddressingModelPhysical32: 32\n   AddressingModelPhysical64: 64"]
    pub ptr_size: ::std::os::raw::c_uint,
    #[doc = " Index provided by VkPipelineShaderStageNodeCreateInfoAMDX or ShaderIndexAMDX"]
    pub shader_index: u32,
    #[doc = " Maximum size required by any output node payload array"]
    pub node_payloads_size: u32,
    #[doc = " Static workgroup count for overwriting the enqueued workgroup count. (0 if dynamic)"]
    pub workgroup_count: [u32; 3usize],
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1__bindgen_ty_4() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1__bindgen_ty_4> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_4>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_4>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).workgroup_size_hint) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(workgroup_size_hint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(ptr_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader_index) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(shader_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node_payloads_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(node_payloads_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).workgroup_count) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(workgroup_count)
        )
    );
}
impl Default for shader_info__bindgen_ty_1__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_4 {
    #[inline]
    pub fn user_data_components_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_user_data_components_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn derivative_group(&self) -> gl_derivative_group {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_derivative_group(&mut self, val: gl_derivative_group) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn has_variable_shared_mem(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_variable_shared_mem(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_cooperative_matrix(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_cooperative_matrix(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        user_data_components_amd: u8,
        derivative_group: gl_derivative_group,
        has_variable_shared_mem: bool,
        has_cooperative_matrix: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let user_data_components_amd: u8 =
                unsafe { ::std::mem::transmute(user_data_components_amd) };
            user_data_components_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let derivative_group: u32 = unsafe { ::std::mem::transmute(derivative_group) };
            derivative_group as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let has_variable_shared_mem: u8 =
                unsafe { ::std::mem::transmute(has_variable_shared_mem) };
            has_variable_shared_mem as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let has_cooperative_matrix: u8 =
                unsafe { ::std::mem::transmute(has_cooperative_matrix) };
            has_cooperative_matrix as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_5 {
    pub _primitive_mode: tess_primitive_mode,
    #[doc = " The number of vertices in the TCS output patch."]
    pub tcs_vertices_out: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub tcs_cross_invocation_inputs_read: u64,
    pub tcs_cross_invocation_outputs_read: u64,
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1__bindgen_ty_5() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1__bindgen_ty_5> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_5>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_5>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._primitive_mode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(_primitive_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tcs_vertices_out) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(tcs_vertices_out)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).tcs_cross_invocation_inputs_read) as usize - ptr as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(tcs_cross_invocation_inputs_read)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).tcs_cross_invocation_outputs_read) as usize - ptr as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(tcs_cross_invocation_outputs_read)
        )
    );
}
impl Default for shader_info__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_5 {
    #[inline]
    pub fn spacing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_spacing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn ccw(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_ccw(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn point_mode(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_mode(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        spacing: ::std::os::raw::c_uint,
        ccw: bool,
        point_mode: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let spacing: u32 = unsafe { ::std::mem::transmute(spacing) };
            spacing as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let ccw: u8 = unsafe { ::std::mem::transmute(ccw) };
            ccw as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let point_mode: u8 = unsafe { ::std::mem::transmute(point_mode) };
            point_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_6 {
    pub ms_cross_invocation_output_access: u64,
    pub ts_mesh_dispatch_dimensions: [u32; 3usize],
    pub max_vertices_out: u16,
    pub max_primitives_out: u16,
    pub primitive_type: mesa_prim,
    pub nv: bool,
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1__bindgen_ty_6() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1__bindgen_ty_6> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_6>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_6>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).ms_cross_invocation_output_access) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(ms_cross_invocation_output_access)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ts_mesh_dispatch_dimensions) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(ts_mesh_dispatch_dimensions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_vertices_out) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(max_vertices_out)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_primitives_out) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(max_primitives_out)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).primitive_type) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(primitive_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nv) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(nv)
        )
    );
}
impl Default for shader_info__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_shader_info__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(shader_info__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(shader_info__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1),
            "::",
            stringify!(vs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tess) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1),
            "::",
            stringify!(tess)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mesh) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info__bindgen_ty_1),
            "::",
            stringify!(mesh)
        )
    );
}
impl Default for shader_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_shader_info() {
    const UNINIT: ::std::mem::MaybeUninit<shader_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shader_info>(),
        320usize,
        concat!("Size of: ", stringify!(shader_info))
    );
    assert_eq!(
        ::std::mem::align_of::<shader_info>(),
        8usize,
        concat!("Alignment of ", stringify!(shader_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).label) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(label)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).internal) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).source_sha1) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(source_sha1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_textures) as usize - ptr as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(num_textures)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_ubos) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(num_ubos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_abos) as usize - ptr as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(num_abos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_ssbos) as usize - ptr as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(num_ssbos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_images) as usize - ptr as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(num_images)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inputs_read) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(inputs_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dual_slot_inputs) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(dual_slot_inputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).outputs_written) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(outputs_written)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).outputs_read) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(outputs_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).system_values_read) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(system_values_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).per_primitive_inputs) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(per_primitive_inputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).per_primitive_outputs) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(per_primitive_outputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).per_view_outputs) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(per_view_outputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inputs_read_16bit) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(inputs_read_16bit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).outputs_written_16bit) as usize - ptr as usize },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(outputs_written_16bit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).outputs_read_16bit) as usize - ptr as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(outputs_read_16bit)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).inputs_read_indirectly_16bit) as usize - ptr as usize
        },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(inputs_read_indirectly_16bit)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).outputs_accessed_indirectly_16bit) as usize - ptr as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(outputs_accessed_indirectly_16bit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).patch_inputs_read) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(patch_inputs_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).patch_outputs_written) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(patch_outputs_written)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).patch_outputs_read) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(patch_outputs_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inputs_read_indirectly) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(inputs_read_indirectly)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).outputs_accessed_indirectly) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(outputs_accessed_indirectly)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).patch_inputs_read_indirectly) as usize - ptr as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(patch_inputs_read_indirectly)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).patch_outputs_accessed_indirectly) as usize - ptr as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(patch_outputs_accessed_indirectly)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).textures_used) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(textures_used)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).textures_used_by_txf) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(textures_used_by_txf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).samplers_used) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(samplers_used)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).images_used) as usize - ptr as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(images_used)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_buffers) as usize - ptr as usize },
        220usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(image_buffers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msaa_images) as usize - ptr as usize },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(msaa_images)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).float_controls_execution_mode) as usize - ptr as usize
        },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(float_controls_execution_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shared_size) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(shared_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).task_payload_size) as usize - ptr as usize },
        244usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(task_payload_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ray_queries) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(ray_queries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).workgroup_size) as usize - ptr as usize },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(workgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_size) as usize - ptr as usize },
        258usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(subgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_subgroups) as usize - ptr as usize },
        259usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(num_subgroups)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).uses_wide_subgroup_intrinsics) as usize - ptr as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(uses_wide_subgroup_intrinsics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xfb_stride) as usize - ptr as usize },
        261usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(xfb_stride)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).inlinable_uniform_dw_offsets) as usize - ptr as usize
        },
        266usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(inlinable_uniform_dw_offsets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_sizes_float) as usize - ptr as usize },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(bit_sizes_float)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_sizes_int) as usize - ptr as usize },
        277usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(bit_sizes_int)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_legacy_math_rules) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(shader_info),
            "::",
            stringify!(use_legacy_math_rules)
        )
    );
}
impl Default for shader_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info {
    #[inline]
    pub fn stage(&self) -> gl_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_stage(&mut self, val: gl_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn next_stage(&self) -> gl_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_next_stage(&mut self, val: gl_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        stage: gl_shader_stage,
        next_stage: gl_shader_stage,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let stage: u32 = unsafe { ::std::mem::transmute(stage) };
            stage as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let next_stage: u32 = unsafe { ::std::mem::transmute(next_stage) };
            next_stage as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn num_inlinable_uniforms(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_num_inlinable_uniforms(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn clip_distance_array_size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_clip_distance_array_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn cull_distance_array_size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(8usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_cull_distance_array_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(8usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_texture_gather(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_texture_gather(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_resource_info_query(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_resource_info_query(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_fddx_fddy(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_fddx_fddy(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn divergence_analysis_run(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_divergence_analysis_run(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        num_inlinable_uniforms: u8,
        clip_distance_array_size: u8,
        cull_distance_array_size: u8,
        uses_texture_gather: bool,
        uses_resource_info_query: bool,
        uses_fddx_fddy: bool,
        divergence_analysis_run: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let num_inlinable_uniforms: u8 =
                unsafe { ::std::mem::transmute(num_inlinable_uniforms) };
            num_inlinable_uniforms as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let clip_distance_array_size: u8 =
                unsafe { ::std::mem::transmute(clip_distance_array_size) };
            clip_distance_array_size as u64
        });
        __bindgen_bitfield_unit.set(8usize, 4u8, {
            let cull_distance_array_size: u8 =
                unsafe { ::std::mem::transmute(cull_distance_array_size) };
            cull_distance_array_size as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let uses_texture_gather: u8 = unsafe { ::std::mem::transmute(uses_texture_gather) };
            uses_texture_gather as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let uses_resource_info_query: u8 =
                unsafe { ::std::mem::transmute(uses_resource_info_query) };
            uses_resource_info_query as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let uses_fddx_fddy: u8 = unsafe { ::std::mem::transmute(uses_fddx_fddy) };
            uses_fddx_fddy as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let divergence_analysis_run: u8 =
                unsafe { ::std::mem::transmute(divergence_analysis_run) };
            divergence_analysis_run as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn first_ubo_is_default_ubo(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_first_ubo_is_default_ubo(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_shader(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_separate_shader(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_transform_feedback_varyings(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_transform_feedback_varyings(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn flrp_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_flrp_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn io_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_io_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn var_copies_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_var_copies_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn writes_memory(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_writes_memory(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn layer_viewport_relative(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_layer_viewport_relative(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_control_barrier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_control_barrier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_memory_barrier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_memory_barrier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_bindless(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_bindless(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn shared_memory_explicit_layout(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shared_memory_explicit_layout(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn zero_initialize_shared_memory(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_zero_initialize_shared_memory(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn workgroup_size_variable(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_workgroup_size_variable(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uses_printf(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_printf(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn maximally_reconverges(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_maximally_reconverges(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_3(
        first_ubo_is_default_ubo: bool,
        separate_shader: bool,
        has_transform_feedback_varyings: bool,
        flrp_lowered: bool,
        io_lowered: bool,
        var_copies_lowered: bool,
        writes_memory: bool,
        layer_viewport_relative: bool,
        uses_control_barrier: bool,
        uses_memory_barrier: bool,
        uses_bindless: bool,
        shared_memory_explicit_layout: bool,
        zero_initialize_shared_memory: bool,
        workgroup_size_variable: bool,
        uses_printf: bool,
        maximally_reconverges: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let first_ubo_is_default_ubo: u8 =
                unsafe { ::std::mem::transmute(first_ubo_is_default_ubo) };
            first_ubo_is_default_ubo as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let separate_shader: u8 = unsafe { ::std::mem::transmute(separate_shader) };
            separate_shader as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let has_transform_feedback_varyings: u8 =
                unsafe { ::std::mem::transmute(has_transform_feedback_varyings) };
            has_transform_feedback_varyings as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let flrp_lowered: u8 = unsafe { ::std::mem::transmute(flrp_lowered) };
            flrp_lowered as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let io_lowered: u8 = unsafe { ::std::mem::transmute(io_lowered) };
            io_lowered as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let var_copies_lowered: u8 = unsafe { ::std::mem::transmute(var_copies_lowered) };
            var_copies_lowered as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let writes_memory: u8 = unsafe { ::std::mem::transmute(writes_memory) };
            writes_memory as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let layer_viewport_relative: u8 =
                unsafe { ::std::mem::transmute(layer_viewport_relative) };
            layer_viewport_relative as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let uses_control_barrier: u8 = unsafe { ::std::mem::transmute(uses_control_barrier) };
            uses_control_barrier as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let uses_memory_barrier: u8 = unsafe { ::std::mem::transmute(uses_memory_barrier) };
            uses_memory_barrier as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let uses_bindless: u8 = unsafe { ::std::mem::transmute(uses_bindless) };
            uses_bindless as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let shared_memory_explicit_layout: u8 =
                unsafe { ::std::mem::transmute(shared_memory_explicit_layout) };
            shared_memory_explicit_layout as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let zero_initialize_shared_memory: u8 =
                unsafe { ::std::mem::transmute(zero_initialize_shared_memory) };
            zero_initialize_shared_memory as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let workgroup_size_variable: u8 =
                unsafe { ::std::mem::transmute(workgroup_size_variable) };
            workgroup_size_variable as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let uses_printf: u8 = unsafe { ::std::mem::transmute(uses_printf) };
            uses_printf as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let maximally_reconverges: u8 = unsafe { ::std::mem::transmute(maximally_reconverges) };
            maximally_reconverges as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct hash_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_hash_entry() {
    const UNINIT: ::std::mem::MaybeUninit<hash_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<hash_entry>(),
        24usize,
        concat!("Size of: ", stringify!(hash_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<hash_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(hash_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hash) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_entry),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_entry),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_entry),
            "::",
            stringify!(data)
        )
    );
}
impl Default for hash_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct hash_table {
    pub table: *mut hash_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub deleted_key: *const ::std::os::raw::c_void,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
}
#[test]
fn bindgen_test_layout_hash_table() {
    const UNINIT: ::std::mem::MaybeUninit<hash_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<hash_table>(),
        72usize,
        concat!("Size of: ", stringify!(hash_table))
    );
    assert_eq!(
        ::std::mem::align_of::<hash_table>(),
        8usize,
        concat!("Alignment of ", stringify!(hash_table))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_hash_function) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(key_hash_function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_equals_function) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(key_equals_function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deleted_key) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(deleted_key)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rehash) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(rehash)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size_magic) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(size_magic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rehash_magic) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(rehash_magic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_entries) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size_index) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(size_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(entries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deleted_entries) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_table),
            "::",
            stringify!(deleted_entries)
        )
    );
}
impl Default for hash_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct list_head {
    pub prev: *mut list_head,
    pub next: *mut list_head,
}
#[test]
fn bindgen_test_layout_list_head() {
    const UNINIT: ::std::mem::MaybeUninit<list_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<list_head>(),
        16usize,
        concat!("Size of: ", stringify!(list_head))
    );
    assert_eq!(
        ::std::mem::align_of::<list_head>(),
        8usize,
        concat!("Alignment of ", stringify!(list_head))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(list_head),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(list_head),
            "::",
            stringify!(next)
        )
    );
}
impl Default for list_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum mesa_log_level {
    MESA_LOG_ERROR = 0,
    MESA_LOG_WARN = 1,
    MESA_LOG_INFO = 2,
    MESA_LOG_DEBUG = 3,
}
extern "C" {
    pub fn mesa_log_get_file() -> *mut FILE;
}
extern "C" {
    pub fn mesa_log(
        arg1: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn mesa_log_v(
        arg1: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        va: *mut va_list,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct log_stream {
    pub msg: *mut ::std::os::raw::c_char,
    pub tag: *const ::std::os::raw::c_char,
    pub pos: usize,
    pub level: mesa_log_level,
}
#[test]
fn bindgen_test_layout_log_stream() {
    const UNINIT: ::std::mem::MaybeUninit<log_stream> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<log_stream>(),
        32usize,
        concat!("Size of: ", stringify!(log_stream))
    );
    assert_eq!(
        ::std::mem::align_of::<log_stream>(),
        8usize,
        concat!("Alignment of ", stringify!(log_stream))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(log_stream),
            "::",
            stringify!(msg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tag) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(log_stream),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(log_stream),
            "::",
            stringify!(pos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(log_stream),
            "::",
            stringify!(level)
        )
    );
}
impl Default for log_stream {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn mesa_log_stream_destroy(stream: *mut log_stream);
}
extern "C" {
    pub fn mesa_log_stream_printf(
        stream: *mut log_stream,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct set_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_set_entry() {
    const UNINIT: ::std::mem::MaybeUninit<set_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<set_entry>(),
        16usize,
        concat!("Size of: ", stringify!(set_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<set_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(set_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hash) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(set_entry),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(set_entry),
            "::",
            stringify!(key)
        )
    );
}
impl Default for set_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct set {
    pub mem_ctx: *mut ::std::os::raw::c_void,
    pub table: *mut set_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
}
#[test]
fn bindgen_test_layout_set() {
    const UNINIT: ::std::mem::MaybeUninit<set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<set>(),
        72usize,
        concat!("Size of: ", stringify!(set))
    );
    assert_eq!(
        ::std::mem::align_of::<set>(),
        8usize,
        concat!("Alignment of ", stringify!(set))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem_ctx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(mem_ctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_hash_function) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(key_hash_function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_equals_function) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(key_equals_function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(set), "::", stringify!(size))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rehash) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(rehash)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size_magic) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(size_magic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rehash_magic) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(rehash_magic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_entries) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(max_entries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size_index) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(size_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(entries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deleted_entries) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(set),
            "::",
            stringify!(deleted_entries)
        )
    );
}
impl Default for set {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct u_printf_info {
    pub num_args: ::std::os::raw::c_uint,
    pub arg_sizes: *mut ::std::os::raw::c_uint,
    pub string_size: ::std::os::raw::c_uint,
    pub strings: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_u_printf_info() {
    const UNINIT: ::std::mem::MaybeUninit<u_printf_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<u_printf_info>(),
        32usize,
        concat!("Size of: ", stringify!(u_printf_info))
    );
    assert_eq!(
        ::std::mem::align_of::<u_printf_info>(),
        8usize,
        concat!("Alignment of ", stringify!(u_printf_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_args) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(u_printf_info),
            "::",
            stringify!(num_args)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arg_sizes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(u_printf_info),
            "::",
            stringify!(arg_sizes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).string_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(u_printf_info),
            "::",
            stringify!(string_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).strings) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(u_printf_info),
            "::",
            stringify!(strings)
        )
    );
}
impl Default for u_printf_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn u_printf_length(
        fmt: *const ::std::os::raw::c_char,
        untouched_args: *mut va_list,
    ) -> usize;
}
extern "C" {
    pub fn u_printf(
        out: *mut FILE,
        buffer: *const ::std::os::raw::c_char,
        buffer_size: usize,
        arg1: *const u_printf_info,
        info_size: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn u_printf_ptr(
        out: *mut FILE,
        buffer: *const ::std::os::raw::c_char,
        buffer_size: usize,
        info: *mut *const u_printf_info,
        info_size: ::std::os::raw::c_uint,
    );
}
impl nir_op {
    pub const nir_last_opcode: nir_op = nir_op::nir_op_vec8;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_op {
    nir_op_amul = 0,
    nir_op_b16all_fequal16 = 1,
    nir_op_b16all_fequal2 = 2,
    nir_op_b16all_fequal3 = 3,
    nir_op_b16all_fequal4 = 4,
    nir_op_b16all_fequal5 = 5,
    nir_op_b16all_fequal8 = 6,
    nir_op_b16all_iequal16 = 7,
    nir_op_b16all_iequal2 = 8,
    nir_op_b16all_iequal3 = 9,
    nir_op_b16all_iequal4 = 10,
    nir_op_b16all_iequal5 = 11,
    nir_op_b16all_iequal8 = 12,
    nir_op_b16any_fnequal16 = 13,
    nir_op_b16any_fnequal2 = 14,
    nir_op_b16any_fnequal3 = 15,
    nir_op_b16any_fnequal4 = 16,
    nir_op_b16any_fnequal5 = 17,
    nir_op_b16any_fnequal8 = 18,
    nir_op_b16any_inequal16 = 19,
    nir_op_b16any_inequal2 = 20,
    nir_op_b16any_inequal3 = 21,
    nir_op_b16any_inequal4 = 22,
    nir_op_b16any_inequal5 = 23,
    nir_op_b16any_inequal8 = 24,
    nir_op_b16csel = 25,
    nir_op_b2b1 = 26,
    nir_op_b2b16 = 27,
    nir_op_b2b32 = 28,
    nir_op_b2b8 = 29,
    nir_op_b2f16 = 30,
    nir_op_b2f32 = 31,
    nir_op_b2f64 = 32,
    nir_op_b2i1 = 33,
    nir_op_b2i16 = 34,
    nir_op_b2i32 = 35,
    nir_op_b2i64 = 36,
    nir_op_b2i8 = 37,
    nir_op_b32all_fequal16 = 38,
    nir_op_b32all_fequal2 = 39,
    nir_op_b32all_fequal3 = 40,
    nir_op_b32all_fequal4 = 41,
    nir_op_b32all_fequal5 = 42,
    nir_op_b32all_fequal8 = 43,
    nir_op_b32all_iequal16 = 44,
    nir_op_b32all_iequal2 = 45,
    nir_op_b32all_iequal3 = 46,
    nir_op_b32all_iequal4 = 47,
    nir_op_b32all_iequal5 = 48,
    nir_op_b32all_iequal8 = 49,
    nir_op_b32any_fnequal16 = 50,
    nir_op_b32any_fnequal2 = 51,
    nir_op_b32any_fnequal3 = 52,
    nir_op_b32any_fnequal4 = 53,
    nir_op_b32any_fnequal5 = 54,
    nir_op_b32any_fnequal8 = 55,
    nir_op_b32any_inequal16 = 56,
    nir_op_b32any_inequal2 = 57,
    nir_op_b32any_inequal3 = 58,
    nir_op_b32any_inequal4 = 59,
    nir_op_b32any_inequal5 = 60,
    nir_op_b32any_inequal8 = 61,
    nir_op_b32csel = 62,
    nir_op_b32fcsel_mdg = 63,
    nir_op_b8all_fequal16 = 64,
    nir_op_b8all_fequal2 = 65,
    nir_op_b8all_fequal3 = 66,
    nir_op_b8all_fequal4 = 67,
    nir_op_b8all_fequal5 = 68,
    nir_op_b8all_fequal8 = 69,
    nir_op_b8all_iequal16 = 70,
    nir_op_b8all_iequal2 = 71,
    nir_op_b8all_iequal3 = 72,
    nir_op_b8all_iequal4 = 73,
    nir_op_b8all_iequal5 = 74,
    nir_op_b8all_iequal8 = 75,
    nir_op_b8any_fnequal16 = 76,
    nir_op_b8any_fnequal2 = 77,
    nir_op_b8any_fnequal3 = 78,
    nir_op_b8any_fnequal4 = 79,
    nir_op_b8any_fnequal5 = 80,
    nir_op_b8any_fnequal8 = 81,
    nir_op_b8any_inequal16 = 82,
    nir_op_b8any_inequal2 = 83,
    nir_op_b8any_inequal3 = 84,
    nir_op_b8any_inequal4 = 85,
    nir_op_b8any_inequal5 = 86,
    nir_op_b8any_inequal8 = 87,
    nir_op_b8csel = 88,
    nir_op_ball_fequal16 = 89,
    nir_op_ball_fequal2 = 90,
    nir_op_ball_fequal3 = 91,
    nir_op_ball_fequal4 = 92,
    nir_op_ball_fequal5 = 93,
    nir_op_ball_fequal8 = 94,
    nir_op_ball_iequal16 = 95,
    nir_op_ball_iequal2 = 96,
    nir_op_ball_iequal3 = 97,
    nir_op_ball_iequal4 = 98,
    nir_op_ball_iequal5 = 99,
    nir_op_ball_iequal8 = 100,
    nir_op_bany_fnequal16 = 101,
    nir_op_bany_fnequal2 = 102,
    nir_op_bany_fnequal3 = 103,
    nir_op_bany_fnequal4 = 104,
    nir_op_bany_fnequal5 = 105,
    nir_op_bany_fnequal8 = 106,
    nir_op_bany_inequal16 = 107,
    nir_op_bany_inequal2 = 108,
    nir_op_bany_inequal3 = 109,
    nir_op_bany_inequal4 = 110,
    nir_op_bany_inequal5 = 111,
    nir_op_bany_inequal8 = 112,
    nir_op_bcsel = 113,
    nir_op_bfi = 114,
    nir_op_bfm = 115,
    nir_op_bit_count = 116,
    nir_op_bitfield_insert = 117,
    nir_op_bitfield_reverse = 118,
    nir_op_bitfield_select = 119,
    nir_op_bitnz = 120,
    nir_op_bitnz16 = 121,
    nir_op_bitnz32 = 122,
    nir_op_bitnz8 = 123,
    nir_op_bitz = 124,
    nir_op_bitz16 = 125,
    nir_op_bitz32 = 126,
    nir_op_bitz8 = 127,
    nir_op_cube_amd = 128,
    nir_op_extr_agx = 129,
    nir_op_extract_i16 = 130,
    nir_op_extract_i8 = 131,
    nir_op_extract_u16 = 132,
    nir_op_extract_u8 = 133,
    nir_op_f2f16 = 134,
    nir_op_f2f16_rtne = 135,
    nir_op_f2f16_rtz = 136,
    nir_op_f2f32 = 137,
    nir_op_f2f64 = 138,
    nir_op_f2fmp = 139,
    nir_op_f2i1 = 140,
    nir_op_f2i16 = 141,
    nir_op_f2i32 = 142,
    nir_op_f2i64 = 143,
    nir_op_f2i8 = 144,
    nir_op_f2imp = 145,
    nir_op_f2snorm_16_v3d = 146,
    nir_op_f2u1 = 147,
    nir_op_f2u16 = 148,
    nir_op_f2u32 = 149,
    nir_op_f2u64 = 150,
    nir_op_f2u8 = 151,
    nir_op_f2ump = 152,
    nir_op_f2unorm_16_v3d = 153,
    nir_op_fabs = 154,
    nir_op_fadd = 155,
    nir_op_fall_equal16 = 156,
    nir_op_fall_equal2 = 157,
    nir_op_fall_equal3 = 158,
    nir_op_fall_equal4 = 159,
    nir_op_fall_equal5 = 160,
    nir_op_fall_equal8 = 161,
    nir_op_fany_nequal16 = 162,
    nir_op_fany_nequal2 = 163,
    nir_op_fany_nequal3 = 164,
    nir_op_fany_nequal4 = 165,
    nir_op_fany_nequal5 = 166,
    nir_op_fany_nequal8 = 167,
    nir_op_fceil = 168,
    nir_op_fclamp_pos_mali = 169,
    nir_op_fcos = 170,
    nir_op_fcos_amd = 171,
    nir_op_fcos_mdg = 172,
    nir_op_fcsel = 173,
    nir_op_fcsel_ge = 174,
    nir_op_fcsel_gt = 175,
    nir_op_fddx = 176,
    nir_op_fddx_coarse = 177,
    nir_op_fddx_fine = 178,
    nir_op_fddx_must_abs_mali = 179,
    nir_op_fddy = 180,
    nir_op_fddy_coarse = 181,
    nir_op_fddy_fine = 182,
    nir_op_fddy_must_abs_mali = 183,
    nir_op_fdiv = 184,
    nir_op_fdot16 = 185,
    nir_op_fdot16_replicated = 186,
    nir_op_fdot2 = 187,
    nir_op_fdot2_replicated = 188,
    nir_op_fdot3 = 189,
    nir_op_fdot3_replicated = 190,
    nir_op_fdot4 = 191,
    nir_op_fdot4_replicated = 192,
    nir_op_fdot5 = 193,
    nir_op_fdot5_replicated = 194,
    nir_op_fdot8 = 195,
    nir_op_fdot8_replicated = 196,
    nir_op_fdph = 197,
    nir_op_fdph_replicated = 198,
    nir_op_feq = 199,
    nir_op_feq16 = 200,
    nir_op_feq32 = 201,
    nir_op_feq8 = 202,
    nir_op_fexp2 = 203,
    nir_op_ffloor = 204,
    nir_op_ffma = 205,
    nir_op_ffmaz = 206,
    nir_op_ffract = 207,
    nir_op_fge = 208,
    nir_op_fge16 = 209,
    nir_op_fge32 = 210,
    nir_op_fge8 = 211,
    nir_op_find_lsb = 212,
    nir_op_fisfinite = 213,
    nir_op_fisfinite32 = 214,
    nir_op_fisnormal = 215,
    nir_op_flog2 = 216,
    nir_op_flrp = 217,
    nir_op_flt = 218,
    nir_op_flt16 = 219,
    nir_op_flt32 = 220,
    nir_op_flt8 = 221,
    nir_op_fmax = 222,
    nir_op_fmin = 223,
    nir_op_fmod = 224,
    nir_op_fmul = 225,
    nir_op_fmulz = 226,
    nir_op_fneg = 227,
    nir_op_fneu = 228,
    nir_op_fneu16 = 229,
    nir_op_fneu32 = 230,
    nir_op_fneu8 = 231,
    nir_op_fpow = 232,
    nir_op_fquantize2f16 = 233,
    nir_op_frcp = 234,
    nir_op_frem = 235,
    nir_op_frexp_exp = 236,
    nir_op_frexp_sig = 237,
    nir_op_fround_even = 238,
    nir_op_frsq = 239,
    nir_op_fsat = 240,
    nir_op_fsat_signed_mali = 241,
    nir_op_fsign = 242,
    nir_op_fsin = 243,
    nir_op_fsin_agx = 244,
    nir_op_fsin_amd = 245,
    nir_op_fsin_mdg = 246,
    nir_op_fsqrt = 247,
    nir_op_fsub = 248,
    nir_op_fsum2 = 249,
    nir_op_fsum3 = 250,
    nir_op_fsum4 = 251,
    nir_op_ftrunc = 252,
    nir_op_i2f16 = 253,
    nir_op_i2f32 = 254,
    nir_op_i2f64 = 255,
    nir_op_i2fmp = 256,
    nir_op_i2i1 = 257,
    nir_op_i2i16 = 258,
    nir_op_i2i32 = 259,
    nir_op_i2i64 = 260,
    nir_op_i2i8 = 261,
    nir_op_i2imp = 262,
    nir_op_i32csel_ge = 263,
    nir_op_i32csel_gt = 264,
    nir_op_iabs = 265,
    nir_op_iadd = 266,
    nir_op_iadd3 = 267,
    nir_op_iadd_sat = 268,
    nir_op_iand = 269,
    nir_op_ibfe = 270,
    nir_op_ibitfield_extract = 271,
    nir_op_idiv = 272,
    nir_op_ieq = 273,
    nir_op_ieq16 = 274,
    nir_op_ieq32 = 275,
    nir_op_ieq8 = 276,
    nir_op_ifind_msb = 277,
    nir_op_ifind_msb_rev = 278,
    nir_op_ige = 279,
    nir_op_ige16 = 280,
    nir_op_ige32 = 281,
    nir_op_ige8 = 282,
    nir_op_ihadd = 283,
    nir_op_ilt = 284,
    nir_op_ilt16 = 285,
    nir_op_ilt32 = 286,
    nir_op_ilt8 = 287,
    nir_op_imad = 288,
    nir_op_imad24_ir3 = 289,
    nir_op_imadsh_mix16 = 290,
    nir_op_imadshl_agx = 291,
    nir_op_imax = 292,
    nir_op_imin = 293,
    nir_op_imod = 294,
    nir_op_imsubshl_agx = 295,
    nir_op_imul = 296,
    nir_op_imul24 = 297,
    nir_op_imul24_relaxed = 298,
    nir_op_imul_2x32_64 = 299,
    nir_op_imul_32x16 = 300,
    nir_op_imul_high = 301,
    nir_op_ine = 302,
    nir_op_ine16 = 303,
    nir_op_ine32 = 304,
    nir_op_ine8 = 305,
    nir_op_ineg = 306,
    nir_op_inot = 307,
    nir_op_insert_u16 = 308,
    nir_op_insert_u8 = 309,
    nir_op_interleave_agx = 310,
    nir_op_ior = 311,
    nir_op_irem = 312,
    nir_op_irhadd = 313,
    nir_op_ishl = 314,
    nir_op_ishr = 315,
    nir_op_isign = 316,
    nir_op_isub = 317,
    nir_op_isub_sat = 318,
    nir_op_ixor = 319,
    nir_op_ldexp = 320,
    nir_op_mov = 321,
    nir_op_mqsad_4x8 = 322,
    nir_op_msad_4x8 = 323,
    nir_op_pack_2x16_to_snorm_2x8_v3d = 324,
    nir_op_pack_2x16_to_unorm_10_2_v3d = 325,
    nir_op_pack_2x16_to_unorm_2x10_v3d = 326,
    nir_op_pack_2x16_to_unorm_2x8_v3d = 327,
    nir_op_pack_2x32_to_2x16_v3d = 328,
    nir_op_pack_32_2x16 = 329,
    nir_op_pack_32_2x16_split = 330,
    nir_op_pack_32_4x8 = 331,
    nir_op_pack_32_4x8_split = 332,
    nir_op_pack_32_to_r11g11b10_v3d = 333,
    nir_op_pack_4x16_to_4x8_v3d = 334,
    nir_op_pack_64_2x32 = 335,
    nir_op_pack_64_2x32_split = 336,
    nir_op_pack_64_4x16 = 337,
    nir_op_pack_double_2x32_dxil = 338,
    nir_op_pack_half_2x16 = 339,
    nir_op_pack_half_2x16_rtz_split = 340,
    nir_op_pack_half_2x16_split = 341,
    nir_op_pack_sint_2x16 = 342,
    nir_op_pack_snorm_2x16 = 343,
    nir_op_pack_snorm_4x8 = 344,
    nir_op_pack_uint_2x16 = 345,
    nir_op_pack_uint_32_to_r10g10b10a2_v3d = 346,
    nir_op_pack_unorm_2x16 = 347,
    nir_op_pack_unorm_4x8 = 348,
    nir_op_pack_uvec2_to_uint = 349,
    nir_op_pack_uvec4_to_uint = 350,
    nir_op_sdot_2x16_iadd = 351,
    nir_op_sdot_2x16_iadd_sat = 352,
    nir_op_sdot_4x8_iadd = 353,
    nir_op_sdot_4x8_iadd_sat = 354,
    nir_op_seq = 355,
    nir_op_sge = 356,
    nir_op_shfr = 357,
    nir_op_slt = 358,
    nir_op_sne = 359,
    nir_op_sudot_4x8_iadd = 360,
    nir_op_sudot_4x8_iadd_sat = 361,
    nir_op_u2f16 = 362,
    nir_op_u2f32 = 363,
    nir_op_u2f64 = 364,
    nir_op_u2fmp = 365,
    nir_op_u2u1 = 366,
    nir_op_u2u16 = 367,
    nir_op_u2u32 = 368,
    nir_op_u2u64 = 369,
    nir_op_u2u8 = 370,
    nir_op_uabs_isub = 371,
    nir_op_uabs_usub = 372,
    nir_op_uadd_carry = 373,
    nir_op_uadd_sat = 374,
    nir_op_ubfe = 375,
    nir_op_ubitfield_extract = 376,
    nir_op_uclz = 377,
    nir_op_udiv = 378,
    nir_op_udot_2x16_uadd = 379,
    nir_op_udot_2x16_uadd_sat = 380,
    nir_op_udot_4x8_uadd = 381,
    nir_op_udot_4x8_uadd_sat = 382,
    nir_op_ufind_msb = 383,
    nir_op_ufind_msb_rev = 384,
    nir_op_uge = 385,
    nir_op_uge16 = 386,
    nir_op_uge32 = 387,
    nir_op_uge8 = 388,
    nir_op_uhadd = 389,
    nir_op_ult = 390,
    nir_op_ult16 = 391,
    nir_op_ult32 = 392,
    nir_op_ult8 = 393,
    nir_op_umad24 = 394,
    nir_op_umad24_relaxed = 395,
    nir_op_umax = 396,
    nir_op_umax_4x8_vc4 = 397,
    nir_op_umin = 398,
    nir_op_umin_4x8_vc4 = 399,
    nir_op_umod = 400,
    nir_op_umul24 = 401,
    nir_op_umul24_relaxed = 402,
    nir_op_umul_2x32_64 = 403,
    nir_op_umul_32x16 = 404,
    nir_op_umul_high = 405,
    nir_op_umul_low = 406,
    nir_op_umul_unorm_4x8_vc4 = 407,
    nir_op_unpack_32_2x16 = 408,
    nir_op_unpack_32_2x16_split_x = 409,
    nir_op_unpack_32_2x16_split_y = 410,
    nir_op_unpack_32_4x8 = 411,
    nir_op_unpack_64_2x32 = 412,
    nir_op_unpack_64_2x32_split_x = 413,
    nir_op_unpack_64_2x32_split_y = 414,
    nir_op_unpack_64_4x16 = 415,
    nir_op_unpack_double_2x32_dxil = 416,
    nir_op_unpack_half_2x16 = 417,
    nir_op_unpack_half_2x16_flush_to_zero = 418,
    nir_op_unpack_half_2x16_split_x = 419,
    nir_op_unpack_half_2x16_split_x_flush_to_zero = 420,
    nir_op_unpack_half_2x16_split_y = 421,
    nir_op_unpack_half_2x16_split_y_flush_to_zero = 422,
    nir_op_unpack_snorm_2x16 = 423,
    nir_op_unpack_snorm_4x8 = 424,
    nir_op_unpack_unorm_2x16 = 425,
    nir_op_unpack_unorm_4x8 = 426,
    nir_op_urhadd = 427,
    nir_op_urol = 428,
    nir_op_uror = 429,
    nir_op_usadd_4x8_vc4 = 430,
    nir_op_ushr = 431,
    nir_op_ussub_4x8_vc4 = 432,
    nir_op_usub_borrow = 433,
    nir_op_usub_sat = 434,
    nir_op_vec16 = 435,
    nir_op_vec2 = 436,
    nir_op_vec3 = 437,
    nir_op_vec4 = 438,
    nir_op_vec5 = 439,
    nir_op_vec8 = 440,
    nir_num_opcodes = 441,
}
extern "C" {
    pub static mut nir_debug: u32;
}
pub type nir_component_mask_t = u16;
extern "C" {
    pub fn nir_process_debug_variable();
}
extern "C" {
    pub fn nir_component_mask_can_reinterpret(
        mask: nir_component_mask_t,
        old_bit_size: ::std::os::raw::c_uint,
        new_bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_component_mask_reinterpret(
        mask: nir_component_mask_t,
        old_bit_size: ::std::os::raw::c_uint,
        new_bit_size: ::std::os::raw::c_uint,
    ) -> nir_component_mask_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_builder {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_xfb_info {
    _unused: [u8; 0],
}
#[doc = " Description of built-in state associated with a uniform\n\n :c:member:`nir_variable.state_slots`"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_state_slot {
    pub tokens: [gl_state_index16; 4usize],
}
#[test]
fn bindgen_test_layout_nir_state_slot() {
    const UNINIT: ::std::mem::MaybeUninit<nir_state_slot> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_state_slot>(),
        8usize,
        concat!("Size of: ", stringify!(nir_state_slot))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_state_slot>(),
        2usize,
        concat!("Alignment of ", stringify!(nir_state_slot))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tokens) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_state_slot),
            "::",
            stringify!(tokens)
        )
    );
}
impl nir_variable_mode {
    pub const nir_var_system_value: nir_variable_mode = nir_variable_mode(1);
}
impl nir_variable_mode {
    pub const nir_var_uniform: nir_variable_mode = nir_variable_mode(2);
}
impl nir_variable_mode {
    pub const nir_var_shader_in: nir_variable_mode = nir_variable_mode(4);
}
impl nir_variable_mode {
    pub const nir_var_shader_out: nir_variable_mode = nir_variable_mode(8);
}
impl nir_variable_mode {
    pub const nir_var_image: nir_variable_mode = nir_variable_mode(16);
}
impl nir_variable_mode {
    #[doc = " Incoming call or ray payload data for ray-tracing shaders"]
    pub const nir_var_shader_call_data: nir_variable_mode = nir_variable_mode(32);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_ray_hit_attrib: nir_variable_mode = nir_variable_mode(64);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_ubo: nir_variable_mode = nir_variable_mode(128);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_push_const: nir_variable_mode = nir_variable_mode(256);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_ssbo: nir_variable_mode = nir_variable_mode(512);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_constant: nir_variable_mode = nir_variable_mode(1024);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_task_payload: nir_variable_mode = nir_variable_mode(2048);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_node_payload: nir_variable_mode = nir_variable_mode(4096);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_node_payload_in: nir_variable_mode = nir_variable_mode(8192);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_shader_temp: nir_variable_mode = nir_variable_mode(16384);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_function_temp: nir_variable_mode = nir_variable_mode(32768);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_shared: nir_variable_mode = nir_variable_mode(65536);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_global: nir_variable_mode = nir_variable_mode(131072);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_generic: nir_variable_mode = nir_variable_mode(245760);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_read_only_modes: nir_variable_mode = nir_variable_mode(1159);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_vec_indexable_modes: nir_variable_mode = nir_variable_mode(248713);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_num_variable_modes: nir_variable_mode = nir_variable_mode(18);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_all: nir_variable_mode = nir_variable_mode(262143);
}
impl ::std::ops::BitOr<nir_variable_mode> for nir_variable_mode {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        nir_variable_mode(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for nir_variable_mode {
    #[inline]
    fn bitor_assign(&mut self, rhs: nir_variable_mode) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<nir_variable_mode> for nir_variable_mode {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        nir_variable_mode(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for nir_variable_mode {
    #[inline]
    fn bitand_assign(&mut self, rhs: nir_variable_mode) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_mode(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[doc = " Rounding modes."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_rounding_mode {
    nir_rounding_mode_undef = 0,
    nir_rounding_mode_rtne = 1,
    nir_rounding_mode_ru = 2,
    nir_rounding_mode_rd = 3,
    nir_rounding_mode_rtz = 4,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_const_value {
    pub b: bool,
    pub f32_: ::std::os::raw::c_float,
    pub f64_: ::std::os::raw::c_double,
    pub i8_: i8,
    pub u8_: u8,
    pub i16_: i16,
    pub u16_: u16,
    pub i32_: i32,
    pub u32_: u32,
    pub i64_: i64,
    pub u64_: u64,
}
#[test]
fn bindgen_test_layout_nir_const_value() {
    const UNINIT: ::std::mem::MaybeUninit<nir_const_value> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_const_value>(),
        8usize,
        concat!("Size of: ", stringify!(nir_const_value))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_const_value>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_const_value))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).f32_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(f32_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).f64_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(f64_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i8_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(i8_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u8_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(u8_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i16_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(i16_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u16_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(u16_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i32_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(i32_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u32_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(u32_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i64_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(i64_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_const_value),
            "::",
            stringify!(u64_)
        )
    );
}
impl Default for nir_const_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_const_value_for_float(
        b: ::std::os::raw::c_double,
        bit_size: ::std::os::raw::c_uint,
    ) -> nir_const_value;
}
extern "C" {
    pub fn nir_const_value_as_float(
        value: nir_const_value,
        bit_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_double;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_constant {
    #[doc = " Value of the constant.\n\n The field used to back the values supplied by the constant is determined\n by the type associated with the ``nir_variable``.  Constants may be\n scalars, vectors, or matrices."]
    pub values: [nir_const_value; 16usize],
    pub is_null_constant: bool,
    pub num_elements: ::std::os::raw::c_uint,
    pub elements: *mut *mut nir_constant,
}
#[test]
fn bindgen_test_layout_nir_constant() {
    const UNINIT: ::std::mem::MaybeUninit<nir_constant> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_constant>(),
        144usize,
        concat!("Size of: ", stringify!(nir_constant))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_constant>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_constant))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).values) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_constant),
            "::",
            stringify!(values)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_null_constant) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_constant),
            "::",
            stringify!(is_null_constant)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_elements) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_constant),
            "::",
            stringify!(num_elements)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).elements) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_constant),
            "::",
            stringify!(elements)
        )
    );
}
impl Default for nir_constant {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Either a uniform, global variable, shader input, or shader output. Based on\n ir_variable - it should be easy to translate between the two."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_variable {
    pub node: exec_node,
    #[doc = " Declared type of the variable"]
    pub type_: *const glsl_type,
    #[doc = " Declared name of the variable"]
    pub name: *mut ::std::os::raw::c_char,
    pub data: nir_variable_nir_variable_data,
    #[doc = " Identifier for this variable generated by nir_index_vars() that is unique\n among other variables in the same exec_list."]
    pub index: ::std::os::raw::c_uint,
    pub num_members: u16,
    #[doc = " Built-in state that backs this uniform\n\n Once set at variable creation, ``state_slots`` must remain invariant.\n This is because, ideally, this array would be shared by all clones of\n this variable in the IR tree.  In other words, we'd really like for it\n to be a fly-weight.\n\n If the variable is not a uniform, ``num_state_slots`` will be zero and\n ``state_slots`` will be ``NULL``.\n\n Number of state slots used."]
    pub num_state_slots: u16,
    #[doc = " State descriptors."]
    pub state_slots: *mut nir_state_slot,
    #[doc = " Constant expression assigned in the initializer of the variable\n\n This field should only be used temporarily by creators of NIR shaders\n and then nir_lower_variable_initializers can be used to get rid of them.\n Most of the rest of NIR ignores this field or asserts that it's NULL."]
    pub constant_initializer: *mut nir_constant,
    #[doc = " Global variable assigned in the initializer of the variable\n This field should only be used temporarily by creators of NIR shaders\n and then nir_lower_variable_initializers can be used to get rid of them.\n Most of the rest of NIR ignores this field or asserts that it's NULL."]
    pub pointer_initializer: *mut nir_variable,
    #[doc = " For variables that are in an interface block or are an instance of an\n interface block, this is the ``GLSL_TYPE_INTERFACE`` type for that block.\n\n ``ir_variable.location``"]
    pub interface_type: *const glsl_type,
    #[doc = " Description of per-member data for per-member struct variables\n\n This is used for variables which are actually an amalgamation of\n multiple entities such as a struct of built-in values or a struct of\n inputs each with their own layout specifier.  This is only allowed on\n variables with a struct or array of array of struct type."]
    pub members: *mut nir_variable_nir_variable_data,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_variable_nir_variable_data {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 6usize]>,
    #[doc = " Highest element accessed with a constant array index\n\n Not used for non-array variables. -1 is never accessed."]
    pub max_array_access: ::std::os::raw::c_int,
    pub _bitfield_align_2: [u16; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 6usize]>,
    #[doc = " output index for dual source blending."]
    pub index: ::std::os::raw::c_uint,
    #[doc = " Initial binding point for a sampler or UBO.\n\n For array types, this represents the binding point for the first element."]
    pub binding: ::std::os::raw::c_uint,
    #[doc = " Storage location of the base of this variable\n\n The precise meaning of this field depends on the nature of the variable.\n\n   - Vertex shader input: one of the values from ``gl_vert_attrib``.\n   - Vertex shader output: one of the values from ``gl_varying_slot``.\n   - Geometry shader input: one of the values from ``gl_varying_slot``.\n   - Geometry shader output: one of the values from ``gl_varying_slot``.\n   - Fragment shader input: one of the values from ``gl_varying_slot``.\n   - Fragment shader output: one of the values from ``gl_frag_result``.\n   - Task shader output: one of the values from ``gl_varying_slot``.\n   - Mesh shader input: one of the values from ``gl_varying_slot``.\n   - Mesh shader output: one of the values from ``gl_varying_slot``.\n   - Uniforms: Per-stage uniform slot number for default uniform block.\n   - Uniforms: Index within the uniform block definition for UBO members.\n   - Non-UBO Uniforms: uniform slot number.\n   - Other: This field is not currently used.\n\n If the variable is a uniform, shader input, or shader output, and the\n slot has not been assigned, the value will be -1."]
    pub location: ::std::os::raw::c_int,
    #[doc = " Required alignment of this variable"]
    pub alignment: ::std::os::raw::c_uint,
    #[doc = " The actual location of the variable in the IR. Only valid for inputs,\n outputs, uniforms (including samplers and images), and for UBO and SSBO\n variables in GLSL."]
    pub driver_location: ::std::os::raw::c_uint,
    #[doc = " Location an atomic counter or transform feedback is stored at."]
    pub offset: ::std::os::raw::c_uint,
    pub anon_1: nir_variable_nir_variable_data__bindgen_ty_1,
    #[doc = " Name of the node this payload will be enqueued to."]
    pub node_name: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_variable_nir_variable_data__bindgen_ty_1 {
    pub image: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1,
    pub sampler: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2,
    pub xfb: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Image internal format if specified explicitly, otherwise PIPE_FORMAT_NONE."]
    pub format: pipe_format,
}
#[test]
fn bindgen_test_layout_nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(format)
        )
    );
}
impl Default for nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2)
        )
    );
}
impl nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn is_inline_sampler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_inline_sampler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn addressing_mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_addressing_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn normalized_coordinates(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_normalized_coordinates(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn filter_mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_filter_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_inline_sampler: ::std::os::raw::c_uint,
        addressing_mode: ::std::os::raw::c_uint,
        normalized_coordinates: ::std::os::raw::c_uint,
        filter_mode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_inline_sampler: u32 = unsafe { ::std::mem::transmute(is_inline_sampler) };
            is_inline_sampler as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let addressing_mode: u32 = unsafe { ::std::mem::transmute(addressing_mode) };
            addressing_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let normalized_coordinates: u32 =
                unsafe { ::std::mem::transmute(normalized_coordinates) };
            normalized_coordinates as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let filter_mode: u32 = unsafe { ::std::mem::transmute(filter_mode) };
            filter_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Transform feedback stride."]
    pub stride: u16,
}
#[test]
fn bindgen_test_layout_nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stride) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(stride)
        )
    );
}
impl nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn buffer(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_buffer(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(buffer: u16) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let buffer: u16 = unsafe { ::std::mem::transmute(buffer) };
            buffer as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_nir_variable_nir_variable_data__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<nir_variable_nir_variable_data__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_variable_nir_variable_data__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_variable_nir_variable_data__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1),
            "::",
            stringify!(sampler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xfb) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data__bindgen_ty_1),
            "::",
            stringify!(xfb)
        )
    );
}
impl Default for nir_variable_nir_variable_data__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_nir_variable_nir_variable_data() {
    const UNINIT: ::std::mem::MaybeUninit<nir_variable_nir_variable_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_variable_nir_variable_data>(),
        56usize,
        concat!("Size of: ", stringify!(nir_variable_nir_variable_data))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_variable_nir_variable_data>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_variable_nir_variable_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_array_access) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(max_array_access)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).binding) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(binding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).location) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alignment) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(alignment)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).driver_location) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(driver_location)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node_name) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable_nir_variable_data),
            "::",
            stringify!(node_name)
        )
    );
}
impl Default for nir_variable_nir_variable_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_variable_nir_variable_data {
    #[inline]
    pub fn mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 18u8) as u32) }
    }
    #[inline]
    pub fn set_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 18u8, val as u64)
        }
    }
    #[inline]
    pub fn read_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn centroid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_centroid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn patch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ray_query(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ray_query(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn assigned(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_assigned(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cannot_coalesce(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cannot_coalesce(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn always_active_io(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_always_active_io(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn interpolation(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_interpolation(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn location_frac(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(35usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_location_frac(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(35usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn compact(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(37usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_compact(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(37usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fb_fetch_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(38usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(38usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bindless(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(39usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bindless(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(39usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_binding(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_binding(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_location(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(41usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_location(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(41usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn implicit_sized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(42usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_sized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(42usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mode: ::std::os::raw::c_uint,
        read_only: ::std::os::raw::c_uint,
        centroid: ::std::os::raw::c_uint,
        sample: ::std::os::raw::c_uint,
        patch: ::std::os::raw::c_uint,
        invariant: ::std::os::raw::c_uint,
        explicit_invariant: ::std::os::raw::c_uint,
        ray_query: ::std::os::raw::c_uint,
        precision: ::std::os::raw::c_uint,
        assigned: ::std::os::raw::c_uint,
        cannot_coalesce: ::std::os::raw::c_uint,
        always_active_io: ::std::os::raw::c_uint,
        interpolation: ::std::os::raw::c_uint,
        location_frac: ::std::os::raw::c_uint,
        compact: ::std::os::raw::c_uint,
        fb_fetch_output: ::std::os::raw::c_uint,
        bindless: ::std::os::raw::c_uint,
        explicit_binding: ::std::os::raw::c_uint,
        explicit_location: ::std::os::raw::c_uint,
        implicit_sized_array: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 6usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 6usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 18u8, {
            let mode: u32 = unsafe { ::std::mem::transmute(mode) };
            mode as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let read_only: u32 = unsafe { ::std::mem::transmute(read_only) };
            read_only as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let centroid: u32 = unsafe { ::std::mem::transmute(centroid) };
            centroid as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let sample: u32 = unsafe { ::std::mem::transmute(sample) };
            sample as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let patch: u32 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let invariant: u32 = unsafe { ::std::mem::transmute(invariant) };
            invariant as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let explicit_invariant: u32 = unsafe { ::std::mem::transmute(explicit_invariant) };
            explicit_invariant as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let ray_query: u32 = unsafe { ::std::mem::transmute(ray_query) };
            ray_query as u64
        });
        __bindgen_bitfield_unit.set(25usize, 2u8, {
            let precision: u32 = unsafe { ::std::mem::transmute(precision) };
            precision as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let assigned: u32 = unsafe { ::std::mem::transmute(assigned) };
            assigned as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let cannot_coalesce: u32 = unsafe { ::std::mem::transmute(cannot_coalesce) };
            cannot_coalesce as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let always_active_io: u32 = unsafe { ::std::mem::transmute(always_active_io) };
            always_active_io as u64
        });
        __bindgen_bitfield_unit.set(32usize, 3u8, {
            let interpolation: u32 = unsafe { ::std::mem::transmute(interpolation) };
            interpolation as u64
        });
        __bindgen_bitfield_unit.set(35usize, 2u8, {
            let location_frac: u32 = unsafe { ::std::mem::transmute(location_frac) };
            location_frac as u64
        });
        __bindgen_bitfield_unit.set(37usize, 1u8, {
            let compact: u32 = unsafe { ::std::mem::transmute(compact) };
            compact as u64
        });
        __bindgen_bitfield_unit.set(38usize, 1u8, {
            let fb_fetch_output: u32 = unsafe { ::std::mem::transmute(fb_fetch_output) };
            fb_fetch_output as u64
        });
        __bindgen_bitfield_unit.set(39usize, 1u8, {
            let bindless: u32 = unsafe { ::std::mem::transmute(bindless) };
            bindless as u64
        });
        __bindgen_bitfield_unit.set(40usize, 1u8, {
            let explicit_binding: u32 = unsafe { ::std::mem::transmute(explicit_binding) };
            explicit_binding as u64
        });
        __bindgen_bitfield_unit.set(41usize, 1u8, {
            let explicit_location: u32 = unsafe { ::std::mem::transmute(explicit_location) };
            explicit_location as u64
        });
        __bindgen_bitfield_unit.set(42usize, 1u8, {
            let implicit_sized_array: u32 = unsafe { ::std::mem::transmute(implicit_sized_array) };
            implicit_sized_array as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn has_initializer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_initializer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_implicit_initializer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_implicit_initializer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_xfb(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_xfb(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_xfb_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_xfb_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_xfb_buffer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_buffer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_xfb_stride(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_stride(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_offset(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_offset(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn matrix_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(7usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_matrix_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(7usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn from_named_ifc_block(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_from_named_ifc_block(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn from_ssbo_unsized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_from_ssbo_unsized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn must_be_shader_input(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_must_be_shader_input(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn how_declared(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(13usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_how_declared(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(13usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn per_view(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_view(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn per_primitive(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_primitive(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn per_vertex(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_vertex(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(18usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(18usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn stream(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(21usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_stream(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(21usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn access(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(32usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_access(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(32usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn descriptor_set(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(41usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_descriptor_set(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(41usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        has_initializer: ::std::os::raw::c_uint,
        is_implicit_initializer: ::std::os::raw::c_uint,
        is_xfb: ::std::os::raw::c_uint,
        is_xfb_only: ::std::os::raw::c_uint,
        explicit_xfb_buffer: ::std::os::raw::c_uint,
        explicit_xfb_stride: ::std::os::raw::c_uint,
        explicit_offset: ::std::os::raw::c_uint,
        matrix_layout: ::std::os::raw::c_uint,
        from_named_ifc_block: ::std::os::raw::c_uint,
        from_ssbo_unsized_array: ::std::os::raw::c_uint,
        must_be_shader_input: ::std::os::raw::c_uint,
        used: ::std::os::raw::c_uint,
        how_declared: ::std::os::raw::c_uint,
        per_view: ::std::os::raw::c_uint,
        per_primitive: ::std::os::raw::c_uint,
        per_vertex: ::std::os::raw::c_uint,
        depth_layout: ::std::os::raw::c_uint,
        stream: ::std::os::raw::c_uint,
        access: ::std::os::raw::c_uint,
        descriptor_set: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 6usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 6usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_initializer: u32 = unsafe { ::std::mem::transmute(has_initializer) };
            has_initializer as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_implicit_initializer: u32 =
                unsafe { ::std::mem::transmute(is_implicit_initializer) };
            is_implicit_initializer as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_xfb: u32 = unsafe { ::std::mem::transmute(is_xfb) };
            is_xfb as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_xfb_only: u32 = unsafe { ::std::mem::transmute(is_xfb_only) };
            is_xfb_only as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let explicit_xfb_buffer: u32 = unsafe { ::std::mem::transmute(explicit_xfb_buffer) };
            explicit_xfb_buffer as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let explicit_xfb_stride: u32 = unsafe { ::std::mem::transmute(explicit_xfb_stride) };
            explicit_xfb_stride as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let explicit_offset: u32 = unsafe { ::std::mem::transmute(explicit_offset) };
            explicit_offset as u64
        });
        __bindgen_bitfield_unit.set(7usize, 2u8, {
            let matrix_layout: u32 = unsafe { ::std::mem::transmute(matrix_layout) };
            matrix_layout as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let from_named_ifc_block: u32 = unsafe { ::std::mem::transmute(from_named_ifc_block) };
            from_named_ifc_block as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let from_ssbo_unsized_array: u32 =
                unsafe { ::std::mem::transmute(from_ssbo_unsized_array) };
            from_ssbo_unsized_array as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let must_be_shader_input: u32 = unsafe { ::std::mem::transmute(must_be_shader_input) };
            must_be_shader_input as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let used: u32 = unsafe { ::std::mem::transmute(used) };
            used as u64
        });
        __bindgen_bitfield_unit.set(13usize, 2u8, {
            let how_declared: u32 = unsafe { ::std::mem::transmute(how_declared) };
            how_declared as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let per_view: u32 = unsafe { ::std::mem::transmute(per_view) };
            per_view as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let per_primitive: u32 = unsafe { ::std::mem::transmute(per_primitive) };
            per_primitive as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let per_vertex: u32 = unsafe { ::std::mem::transmute(per_vertex) };
            per_vertex as u64
        });
        __bindgen_bitfield_unit.set(18usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(21usize, 9u8, {
            let stream: u32 = unsafe { ::std::mem::transmute(stream) };
            stream as u64
        });
        __bindgen_bitfield_unit.set(32usize, 9u8, {
            let access: u32 = unsafe { ::std::mem::transmute(access) };
            access as u64
        });
        __bindgen_bitfield_unit.set(41usize, 5u8, {
            let descriptor_set: u32 = unsafe { ::std::mem::transmute(descriptor_set) };
            descriptor_set as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_nir_variable() {
    const UNINIT: ::std::mem::MaybeUninit<nir_variable> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_variable>(),
        136usize,
        concat!("Size of: ", stringify!(nir_variable))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_variable>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_variable))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_members) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(num_members)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_state_slots) as usize - ptr as usize },
        94usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(num_state_slots)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state_slots) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(state_slots)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).constant_initializer) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(constant_initializer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pointer_initializer) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(pointer_initializer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interface_type) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(interface_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).members) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_variable),
            "::",
            stringify!(members)
        )
    );
}
impl Default for nir_variable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_instr_type {
    nir_instr_type_alu = 0,
    nir_instr_type_deref = 1,
    nir_instr_type_call = 2,
    nir_instr_type_tex = 3,
    nir_instr_type_intrinsic = 4,
    nir_instr_type_load_const = 5,
    nir_instr_type_jump = 6,
    nir_instr_type_undef = 7,
    nir_instr_type_phi = 8,
    nir_instr_type_parallel_copy = 9,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_instr {
    pub node: exec_node,
    pub block: *mut nir_block,
    pub type_: nir_instr_type,
    pub pass_flags: u8,
    #[doc = " generic instruction index."]
    pub index: u32,
}
#[test]
fn bindgen_test_layout_nir_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_instr>(),
        32usize,
        concat!("Size of: ", stringify!(nir_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_instr),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_instr),
            "::",
            stringify!(block)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_instr),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pass_flags) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_instr),
            "::",
            stringify!(pass_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_instr),
            "::",
            stringify!(index)
        )
    );
}
impl Default for nir_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_def {
    #[doc = " Instruction which produces this SSA value."]
    pub parent_instr: *mut nir_instr,
    #[doc = " set of nir_instrs where this register is used (read from)"]
    pub uses: list_head,
    #[doc = " generic SSA definition index."]
    pub index: ::std::os::raw::c_uint,
    pub num_components: u8,
    pub bit_size: u8,
    #[doc = " True if this SSA value may have different values in different SIMD\n invocations of the shader.  This is set by nir_divergence_analysis."]
    pub divergent: bool,
}
#[test]
fn bindgen_test_layout_nir_def() {
    const UNINIT: ::std::mem::MaybeUninit<nir_def> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_def>(),
        32usize,
        concat!("Size of: ", stringify!(nir_def))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_def>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_def))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_def),
            "::",
            stringify!(parent_instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uses) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_def),
            "::",
            stringify!(uses)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_def),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_components) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_def),
            "::",
            stringify!(num_components)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_size) as usize - ptr as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_def),
            "::",
            stringify!(bit_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).divergent) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_def),
            "::",
            stringify!(divergent)
        )
    );
}
impl Default for nir_def {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_src {
    pub _parent: usize,
    pub use_link: list_head,
    pub ssa: *mut nir_def,
}
#[test]
fn bindgen_test_layout_nir_src() {
    const UNINIT: ::std::mem::MaybeUninit<nir_src> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_src>(),
        32usize,
        concat!("Size of: ", stringify!(nir_src))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_src>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._parent) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_src),
            "::",
            stringify!(_parent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_link) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_src),
            "::",
            stringify!(use_link)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssa) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_src),
            "::",
            stringify!(ssa)
        )
    );
}
impl Default for nir_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_alu_src {
    #[doc = " Base source"]
    pub src: nir_src,
    #[doc = " For each input component, says which component of the register it is\n chosen from.\n\n Note that which elements of the swizzle are used and which are ignored\n are based on the write mask for most opcodes - for example, a statement\n like \"foo.xzw = bar.zyx\" would have a writemask of 1101b and a swizzle\n of {2, 1, x, 0} where x means \"don't care.\""]
    pub swizzle: [u8; 16usize],
}
#[test]
fn bindgen_test_layout_nir_alu_src() {
    const UNINIT: ::std::mem::MaybeUninit<nir_alu_src> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_alu_src>(),
        48usize,
        concat!("Size of: ", stringify!(nir_alu_src))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_alu_src>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_alu_src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_alu_src),
            "::",
            stringify!(src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).swizzle) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_alu_src),
            "::",
            stringify!(swizzle)
        )
    );
}
impl Default for nir_alu_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u8)]
#[doc = " NIR sized and unsized types\n\n The values in this enum are carefully chosen so that the sized type is\n just the unsized type OR the number of bits."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_alu_type {
    nir_type_invalid = 0,
    nir_type_int = 2,
    nir_type_uint = 4,
    nir_type_bool = 6,
    nir_type_float = 128,
    nir_type_bool1 = 7,
    nir_type_bool8 = 14,
    nir_type_bool16 = 22,
    nir_type_bool32 = 38,
    nir_type_int1 = 3,
    nir_type_int8 = 10,
    nir_type_int16 = 18,
    nir_type_int32 = 34,
    nir_type_int64 = 66,
    nir_type_uint1 = 5,
    nir_type_uint8 = 12,
    nir_type_uint16 = 20,
    nir_type_uint32 = 36,
    nir_type_uint64 = 68,
    nir_type_float16 = 144,
    nir_type_float32 = 160,
    nir_type_float64 = 192,
}
extern "C" {
    pub fn nir_get_nir_type_for_glsl_base_type(base_type: glsl_base_type) -> nir_alu_type;
}
extern "C" {
    pub fn nir_get_glsl_base_type_for_nir_type(base_type: nir_alu_type) -> glsl_base_type;
}
extern "C" {
    pub fn nir_type_conversion_op(
        src: nir_alu_type,
        dst: nir_alu_type,
        rnd: nir_rounding_mode,
    ) -> nir_op;
}
extern "C" {
    #[doc = " Returns nir_op_vec<num_components> or nir_op_mov if num_components == 1\n\n This is subtly different from nir_op_is_vec() which returns false for\n nir_op_mov.  Returning nir_op_mov from nir_op_vec() when num_components == 1\n makes sense under the assumption that the num_components of the resulting\n nir_def will same as what is passed in here because a single-component mov\n is effectively a vec1.  However, if alu->def.num_components > 1, nir_op_mov\n has different semantics from nir_op_vec* so so code which detects \"is this\n a vec?\" typically needs to handle nir_op_mov separate from nir_op_vecN.\n\n In the unlikely case where you can handle nir_op_vecN and nir_op_mov\n together, use nir_op_is_vec_or_mov()."]
    pub fn nir_op_vec(num_components: ::std::os::raw::c_uint) -> nir_op;
}
extern "C" {
    #[doc = " Returns true if this op is one of nir_op_vec*\n\n Returns false for nir_op_mov.  See nir_op_vec() for more details."]
    pub fn nir_op_is_vec(op: nir_op) -> bool;
}
#[repr(C)]
#[derive(Debug)]
pub struct nir_alu_instr {
    #[doc = " Base instruction"]
    pub instr: nir_instr,
    #[doc = " Opcode"]
    pub op: nir_op,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Destination"]
    pub def: nir_def,
    #[doc = " Sources\n\n The size of the array is given by :c:member:`nir_op_info.num_inputs`."]
    pub src: __IncompleteArrayField<nir_alu_src>,
}
#[test]
fn bindgen_test_layout_nir_alu_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_alu_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_alu_instr>(),
        72usize,
        concat!("Size of: ", stringify!(nir_alu_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_alu_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_alu_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_alu_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).op) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_alu_instr),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_alu_instr),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_alu_instr),
            "::",
            stringify!(src)
        )
    );
}
impl Default for nir_alu_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_alu_instr {
    #[inline]
    pub fn exact(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_exact(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_signed_wrap(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_signed_wrap(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_unsigned_wrap(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_unsigned_wrap(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        exact: bool,
        no_signed_wrap: bool,
        no_unsigned_wrap: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let exact: u8 = unsafe { ::std::mem::transmute(exact) };
            exact as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let no_signed_wrap: u8 = unsafe { ::std::mem::transmute(no_signed_wrap) };
            no_signed_wrap as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let no_unsigned_wrap: u8 = unsafe { ::std::mem::transmute(no_unsigned_wrap) };
            no_unsigned_wrap as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_alu_src_copy(dest: *mut nir_alu_src, src: *const nir_alu_src);
}
extern "C" {
    pub fn nir_alu_instr_src_read_mask(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_component_mask_t;
}
extern "C" {
    #[doc = " Get the number of channels used for a source"]
    pub fn nir_ssa_alu_instr_src_components(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_alu_instr_is_comparison(instr: *const nir_alu_instr) -> bool;
}
extern "C" {
    pub fn nir_const_value_negative_equal(
        c1: nir_const_value,
        c2: nir_const_value,
        full_type: nir_alu_type,
    ) -> bool;
}
extern "C" {
    pub fn nir_alu_srcs_equal(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_alu_srcs_negative_equal(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_alu_src_is_trivial_ssa(
        alu: *const nir_alu_instr,
        srcn: ::std::os::raw::c_uint,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_deref_type {
    nir_deref_type_var = 0,
    nir_deref_type_array = 1,
    nir_deref_type_array_wildcard = 2,
    nir_deref_type_ptr_as_array = 3,
    nir_deref_type_struct = 4,
    nir_deref_type_cast = 5,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_deref_instr {
    pub instr: nir_instr,
    #[doc = " The type of this deref instruction"]
    pub deref_type: nir_deref_type,
    #[doc = " Bitmask what modes the underlying variable might be\n\n For OpenCL-style generic pointers, we may not know exactly what mode it\n is at any given point in time in the compile process.  This bitfield\n contains the set of modes which it MAY be.\n\n Generally, this field should not be accessed directly.  Use one of the\n nir_deref_mode_ helpers instead."]
    pub modes: nir_variable_mode,
    #[doc = " The dereferenced type of the resulting pointer value"]
    pub type_: *const glsl_type,
    pub anon_1: nir_deref_instr__bindgen_ty_1,
    pub anon_2: nir_deref_instr__bindgen_ty_2,
    #[doc = " Destination to store the resulting \"pointer\""]
    pub def: nir_def,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_deref_instr__bindgen_ty_1 {
    #[doc = " Variable being dereferenced if deref_type is a deref_var"]
    pub var: *mut nir_variable,
    #[doc = " Parent deref if deref_type is not deref_var"]
    pub parent: nir_src,
}
#[test]
fn bindgen_test_layout_nir_deref_instr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<nir_deref_instr__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_deref_instr__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(nir_deref_instr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_deref_instr__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_deref_instr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).var) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_1),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_1),
            "::",
            stringify!(parent)
        )
    );
}
impl Default for nir_deref_instr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Additional deref parameters"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_deref_instr__bindgen_ty_2 {
    pub arr: nir_deref_instr__bindgen_ty_2__bindgen_ty_1,
    pub strct: nir_deref_instr__bindgen_ty_2__bindgen_ty_2,
    pub cast: nir_deref_instr__bindgen_ty_2__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_1 {
    pub index: nir_src,
    pub in_bounds: bool,
}
#[test]
fn bindgen_test_layout_nir_deref_instr__bindgen_ty_2__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<nir_deref_instr__bindgen_ty_2__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_1>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).in_bounds) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(in_bounds)
        )
    );
}
impl Default for nir_deref_instr__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_2 {
    pub index: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_deref_instr__bindgen_ty_2__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<nir_deref_instr__bindgen_ty_2__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_2),
            "::",
            stringify!(index)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_3 {
    pub ptr_stride: ::std::os::raw::c_uint,
    pub align_mul: ::std::os::raw::c_uint,
    pub align_offset: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_deref_instr__bindgen_ty_2__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<nir_deref_instr__bindgen_ty_2__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_3>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr_stride) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3),
            "::",
            stringify!(ptr_stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).align_mul) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3),
            "::",
            stringify!(align_mul)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).align_offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3),
            "::",
            stringify!(align_offset)
        )
    );
}
#[test]
fn bindgen_test_layout_nir_deref_instr__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<nir_deref_instr__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_deref_instr__bindgen_ty_2>(),
        40usize,
        concat!("Size of: ", stringify!(nir_deref_instr__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_deref_instr__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_deref_instr__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2),
            "::",
            stringify!(arr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).strct) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2),
            "::",
            stringify!(strct)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cast) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr__bindgen_ty_2),
            "::",
            stringify!(cast)
        )
    );
}
impl Default for nir_deref_instr__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_nir_deref_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_deref_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_deref_instr>(),
        152usize,
        concat!("Size of: ", stringify!(nir_deref_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_deref_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_deref_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deref_type) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr),
            "::",
            stringify!(deref_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).modes) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr),
            "::",
            stringify!(modes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_deref_instr),
            "::",
            stringify!(def)
        )
    );
}
impl Default for nir_deref_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[doc = " Returns true if the cast is trivial, i.e. the source and destination type is\n the same."]
    pub fn nir_deref_cast_is_trivial(cast: *mut nir_deref_instr) -> bool;
}
extern "C" {
    pub fn nir_deref_instr_has_indirect(instr: *mut nir_deref_instr) -> bool;
}
extern "C" {
    pub fn nir_deref_instr_is_known_out_of_bounds(instr: *mut nir_deref_instr) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_deref_instr_has_complex_use_options {
    nir_deref_instr_has_complex_use_allow_memcpy_src = 1,
    nir_deref_instr_has_complex_use_allow_memcpy_dst = 2,
    nir_deref_instr_has_complex_use_allow_atomics = 4,
}
extern "C" {
    pub fn nir_deref_instr_has_complex_use(
        instr: *mut nir_deref_instr,
        opts: nir_deref_instr_has_complex_use_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_deref_instr_remove_if_unused(instr: *mut nir_deref_instr) -> bool;
}
extern "C" {
    pub fn nir_deref_instr_array_stride(instr: *mut nir_deref_instr) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug)]
pub struct nir_call_instr {
    pub instr: nir_instr,
    pub callee: *mut nir_function,
    pub num_params: ::std::os::raw::c_uint,
    pub params: __IncompleteArrayField<nir_src>,
}
#[test]
fn bindgen_test_layout_nir_call_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_call_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_call_instr>(),
        48usize,
        concat!("Size of: ", stringify!(nir_call_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_call_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_call_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_call_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callee) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_call_instr),
            "::",
            stringify!(callee)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_params) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_call_instr),
            "::",
            stringify!(num_params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_call_instr),
            "::",
            stringify!(params)
        )
    );
}
impl Default for nir_call_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_intrinsic_op {
    pub const nir_last_intrinsic: nir_intrinsic_op =
        nir_intrinsic_op::nir_intrinsic_xfb_counter_sub_gfx11_amd;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_intrinsic_op {
    nir_intrinsic_accept_ray_intersection = 0,
    nir_intrinsic_addr_mode_is = 1,
    nir_intrinsic_al2p_nv = 2,
    nir_intrinsic_ald_nv = 3,
    nir_intrinsic_as_uniform = 4,
    nir_intrinsic_ast_nv = 5,
    nir_intrinsic_atomic_add_gen_prim_count_amd = 6,
    nir_intrinsic_atomic_add_gs_emit_prim_count_amd = 7,
    nir_intrinsic_atomic_add_shader_invocation_count_amd = 8,
    nir_intrinsic_atomic_add_xfb_prim_count_amd = 9,
    nir_intrinsic_atomic_counter_add = 10,
    nir_intrinsic_atomic_counter_add_deref = 11,
    nir_intrinsic_atomic_counter_and = 12,
    nir_intrinsic_atomic_counter_and_deref = 13,
    nir_intrinsic_atomic_counter_comp_swap = 14,
    nir_intrinsic_atomic_counter_comp_swap_deref = 15,
    nir_intrinsic_atomic_counter_exchange = 16,
    nir_intrinsic_atomic_counter_exchange_deref = 17,
    nir_intrinsic_atomic_counter_inc = 18,
    nir_intrinsic_atomic_counter_inc_deref = 19,
    nir_intrinsic_atomic_counter_max = 20,
    nir_intrinsic_atomic_counter_max_deref = 21,
    nir_intrinsic_atomic_counter_min = 22,
    nir_intrinsic_atomic_counter_min_deref = 23,
    nir_intrinsic_atomic_counter_or = 24,
    nir_intrinsic_atomic_counter_or_deref = 25,
    nir_intrinsic_atomic_counter_post_dec = 26,
    nir_intrinsic_atomic_counter_post_dec_deref = 27,
    nir_intrinsic_atomic_counter_pre_dec = 28,
    nir_intrinsic_atomic_counter_pre_dec_deref = 29,
    nir_intrinsic_atomic_counter_read = 30,
    nir_intrinsic_atomic_counter_read_deref = 31,
    nir_intrinsic_atomic_counter_xor = 32,
    nir_intrinsic_atomic_counter_xor_deref = 33,
    nir_intrinsic_ballot = 34,
    nir_intrinsic_ballot_bit_count_exclusive = 35,
    nir_intrinsic_ballot_bit_count_inclusive = 36,
    nir_intrinsic_ballot_bit_count_reduce = 37,
    nir_intrinsic_ballot_bitfield_extract = 38,
    nir_intrinsic_ballot_find_lsb = 39,
    nir_intrinsic_ballot_find_msb = 40,
    nir_intrinsic_ballot_relaxed = 41,
    nir_intrinsic_bar_break_nv = 42,
    nir_intrinsic_bar_set_nv = 43,
    nir_intrinsic_bar_sync_nv = 44,
    nir_intrinsic_barrier = 45,
    nir_intrinsic_begin_invocation_interlock = 46,
    nir_intrinsic_bindless_image_atomic = 47,
    nir_intrinsic_bindless_image_atomic_swap = 48,
    nir_intrinsic_bindless_image_descriptor_amd = 49,
    nir_intrinsic_bindless_image_format = 50,
    nir_intrinsic_bindless_image_fragment_mask_load_amd = 51,
    nir_intrinsic_bindless_image_load = 52,
    nir_intrinsic_bindless_image_load_raw_intel = 53,
    nir_intrinsic_bindless_image_order = 54,
    nir_intrinsic_bindless_image_samples = 55,
    nir_intrinsic_bindless_image_samples_identical = 56,
    nir_intrinsic_bindless_image_size = 57,
    nir_intrinsic_bindless_image_sparse_load = 58,
    nir_intrinsic_bindless_image_store = 59,
    nir_intrinsic_bindless_image_store_raw_intel = 60,
    nir_intrinsic_bindless_image_texel_address = 61,
    nir_intrinsic_bindless_resource_ir3 = 62,
    nir_intrinsic_block_image_store_agx = 63,
    nir_intrinsic_brcst_active_ir3 = 64,
    nir_intrinsic_btd_retire_intel = 65,
    nir_intrinsic_btd_spawn_intel = 66,
    nir_intrinsic_btd_stack_push_intel = 67,
    nir_intrinsic_bvh64_intersect_ray_amd = 68,
    nir_intrinsic_cmat_binary_op = 69,
    nir_intrinsic_cmat_bitcast = 70,
    nir_intrinsic_cmat_construct = 71,
    nir_intrinsic_cmat_copy = 72,
    nir_intrinsic_cmat_extract = 73,
    nir_intrinsic_cmat_insert = 74,
    nir_intrinsic_cmat_length = 75,
    nir_intrinsic_cmat_load = 76,
    nir_intrinsic_cmat_muladd = 77,
    nir_intrinsic_cmat_muladd_amd = 78,
    nir_intrinsic_cmat_scalar_op = 79,
    nir_intrinsic_cmat_store = 80,
    nir_intrinsic_cmat_unary_op = 81,
    nir_intrinsic_convert_alu_types = 82,
    nir_intrinsic_copy_deref = 83,
    nir_intrinsic_copy_fs_outputs_nv = 84,
    nir_intrinsic_copy_global_to_uniform_ir3 = 85,
    nir_intrinsic_copy_push_const_to_uniform_ir3 = 86,
    nir_intrinsic_copy_ubo_to_uniform_ir3 = 87,
    nir_intrinsic_decl_reg = 88,
    nir_intrinsic_demote = 89,
    nir_intrinsic_demote_if = 90,
    nir_intrinsic_deref_atomic = 91,
    nir_intrinsic_deref_atomic_swap = 92,
    nir_intrinsic_deref_buffer_array_length = 93,
    nir_intrinsic_deref_mode_is = 94,
    nir_intrinsic_discard = 95,
    nir_intrinsic_discard_agx = 96,
    nir_intrinsic_discard_if = 97,
    nir_intrinsic_doorbell_agx = 98,
    nir_intrinsic_dpas_intel = 99,
    nir_intrinsic_elect = 100,
    nir_intrinsic_emit_vertex = 101,
    nir_intrinsic_emit_vertex_nv = 102,
    nir_intrinsic_emit_vertex_with_counter = 103,
    nir_intrinsic_end_invocation_interlock = 104,
    nir_intrinsic_end_primitive = 105,
    nir_intrinsic_end_primitive_nv = 106,
    nir_intrinsic_end_primitive_with_counter = 107,
    nir_intrinsic_enqueue_node_payloads = 108,
    nir_intrinsic_exclusive_scan = 109,
    nir_intrinsic_exclusive_scan_clusters_ir3 = 110,
    nir_intrinsic_execute_callable = 111,
    nir_intrinsic_execute_closest_hit_amd = 112,
    nir_intrinsic_execute_miss_amd = 113,
    nir_intrinsic_export_agx = 114,
    nir_intrinsic_export_amd = 115,
    nir_intrinsic_export_dual_src_blend_amd = 116,
    nir_intrinsic_export_row_amd = 117,
    nir_intrinsic_fence_helper_exit_agx = 118,
    nir_intrinsic_fence_mem_to_tex_agx = 119,
    nir_intrinsic_fence_pbe_to_tex_agx = 120,
    nir_intrinsic_fence_pbe_to_tex_pixel_agx = 121,
    nir_intrinsic_final_primitive_nv = 122,
    nir_intrinsic_finalize_incoming_node_payload = 123,
    nir_intrinsic_first_invocation = 124,
    nir_intrinsic_fs_out_nv = 125,
    nir_intrinsic_gds_atomic_add_amd = 126,
    nir_intrinsic_get_ssbo_size = 127,
    nir_intrinsic_get_ubo_size = 128,
    nir_intrinsic_global_atomic = 129,
    nir_intrinsic_global_atomic_2x32 = 130,
    nir_intrinsic_global_atomic_agx = 131,
    nir_intrinsic_global_atomic_amd = 132,
    nir_intrinsic_global_atomic_ir3 = 133,
    nir_intrinsic_global_atomic_swap = 134,
    nir_intrinsic_global_atomic_swap_2x32 = 135,
    nir_intrinsic_global_atomic_swap_agx = 136,
    nir_intrinsic_global_atomic_swap_amd = 137,
    nir_intrinsic_global_atomic_swap_ir3 = 138,
    nir_intrinsic_ignore_ray_intersection = 139,
    nir_intrinsic_image_atomic = 140,
    nir_intrinsic_image_atomic_swap = 141,
    nir_intrinsic_image_deref_atomic = 142,
    nir_intrinsic_image_deref_atomic_swap = 143,
    nir_intrinsic_image_deref_descriptor_amd = 144,
    nir_intrinsic_image_deref_format = 145,
    nir_intrinsic_image_deref_fragment_mask_load_amd = 146,
    nir_intrinsic_image_deref_load = 147,
    nir_intrinsic_image_deref_load_param_intel = 148,
    nir_intrinsic_image_deref_load_raw_intel = 149,
    nir_intrinsic_image_deref_order = 150,
    nir_intrinsic_image_deref_samples = 151,
    nir_intrinsic_image_deref_samples_identical = 152,
    nir_intrinsic_image_deref_size = 153,
    nir_intrinsic_image_deref_sparse_load = 154,
    nir_intrinsic_image_deref_store = 155,
    nir_intrinsic_image_deref_store_raw_intel = 156,
    nir_intrinsic_image_deref_texel_address = 157,
    nir_intrinsic_image_descriptor_amd = 158,
    nir_intrinsic_image_format = 159,
    nir_intrinsic_image_fragment_mask_load_amd = 160,
    nir_intrinsic_image_load = 161,
    nir_intrinsic_image_load_raw_intel = 162,
    nir_intrinsic_image_order = 163,
    nir_intrinsic_image_samples = 164,
    nir_intrinsic_image_samples_identical = 165,
    nir_intrinsic_image_size = 166,
    nir_intrinsic_image_sparse_load = 167,
    nir_intrinsic_image_store = 168,
    nir_intrinsic_image_store_raw_intel = 169,
    nir_intrinsic_image_texel_address = 170,
    nir_intrinsic_inclusive_scan = 171,
    nir_intrinsic_inclusive_scan_clusters_ir3 = 172,
    nir_intrinsic_initialize_node_payloads = 173,
    nir_intrinsic_interp_deref_at_centroid = 174,
    nir_intrinsic_interp_deref_at_offset = 175,
    nir_intrinsic_interp_deref_at_sample = 176,
    nir_intrinsic_interp_deref_at_vertex = 177,
    nir_intrinsic_inverse_ballot = 178,
    nir_intrinsic_ipa_nv = 179,
    nir_intrinsic_is_helper_invocation = 180,
    nir_intrinsic_is_sparse_resident_zink = 181,
    nir_intrinsic_is_sparse_texels_resident = 182,
    nir_intrinsic_is_subgroup_invocation_lt_amd = 183,
    nir_intrinsic_isberd_nv = 184,
    nir_intrinsic_lane_permute_16_amd = 185,
    nir_intrinsic_last_invocation = 186,
    nir_intrinsic_launch_mesh_workgroups = 187,
    nir_intrinsic_launch_mesh_workgroups_with_payload_deref = 188,
    nir_intrinsic_ldtram_nv = 189,
    nir_intrinsic_load_aa_line_width = 190,
    nir_intrinsic_load_accel_struct_amd = 191,
    nir_intrinsic_load_active_samples_agx = 192,
    nir_intrinsic_load_active_subgroup_invocation_agx = 193,
    nir_intrinsic_load_agx = 194,
    nir_intrinsic_load_alpha_reference_amd = 195,
    nir_intrinsic_load_api_sample_mask_agx = 196,
    nir_intrinsic_load_attrib_clamp_agx = 197,
    nir_intrinsic_load_back_face_agx = 198,
    nir_intrinsic_load_barycentric_at_offset = 199,
    nir_intrinsic_load_barycentric_at_offset_nv = 200,
    nir_intrinsic_load_barycentric_at_sample = 201,
    nir_intrinsic_load_barycentric_centroid = 202,
    nir_intrinsic_load_barycentric_coord_at_offset = 203,
    nir_intrinsic_load_barycentric_coord_at_sample = 204,
    nir_intrinsic_load_barycentric_coord_centroid = 205,
    nir_intrinsic_load_barycentric_coord_pixel = 206,
    nir_intrinsic_load_barycentric_coord_sample = 207,
    nir_intrinsic_load_barycentric_model = 208,
    nir_intrinsic_load_barycentric_optimize_amd = 209,
    nir_intrinsic_load_barycentric_pixel = 210,
    nir_intrinsic_load_barycentric_sample = 211,
    nir_intrinsic_load_base_global_invocation_id = 212,
    nir_intrinsic_load_base_instance = 213,
    nir_intrinsic_load_base_vertex = 214,
    nir_intrinsic_load_base_workgroup_id = 215,
    nir_intrinsic_load_blend_const_color_a_float = 216,
    nir_intrinsic_load_blend_const_color_aaaa8888_unorm = 217,
    nir_intrinsic_load_blend_const_color_b_float = 218,
    nir_intrinsic_load_blend_const_color_g_float = 219,
    nir_intrinsic_load_blend_const_color_r_float = 220,
    nir_intrinsic_load_blend_const_color_rgba = 221,
    nir_intrinsic_load_blend_const_color_rgba8888_unorm = 222,
    nir_intrinsic_load_btd_global_arg_addr_intel = 223,
    nir_intrinsic_load_btd_local_arg_addr_intel = 224,
    nir_intrinsic_load_btd_resume_sbt_addr_intel = 225,
    nir_intrinsic_load_btd_shader_type_intel = 226,
    nir_intrinsic_load_btd_stack_id_intel = 227,
    nir_intrinsic_load_buffer_amd = 228,
    nir_intrinsic_load_callable_sbt_addr_intel = 229,
    nir_intrinsic_load_callable_sbt_stride_intel = 230,
    nir_intrinsic_load_clamp_vertex_color_amd = 231,
    nir_intrinsic_load_clip_half_line_width_amd = 232,
    nir_intrinsic_load_clip_z_coeff_agx = 233,
    nir_intrinsic_load_coalesced_input_count = 234,
    nir_intrinsic_load_coefficients_agx = 235,
    nir_intrinsic_load_color0 = 236,
    nir_intrinsic_load_color1 = 237,
    nir_intrinsic_load_constant = 238,
    nir_intrinsic_load_constant_agx = 239,
    nir_intrinsic_load_constant_base_ptr = 240,
    nir_intrinsic_load_converted_output_pan = 241,
    nir_intrinsic_load_core_id_agx = 242,
    nir_intrinsic_load_cull_any_enabled_amd = 243,
    nir_intrinsic_load_cull_back_face_enabled_amd = 244,
    nir_intrinsic_load_cull_ccw_amd = 245,
    nir_intrinsic_load_cull_front_face_enabled_amd = 246,
    nir_intrinsic_load_cull_mask = 247,
    nir_intrinsic_load_cull_mask_and_flags_amd = 248,
    nir_intrinsic_load_cull_small_prim_precision_amd = 249,
    nir_intrinsic_load_cull_small_primitives_enabled_amd = 250,
    nir_intrinsic_load_debug_log_desc_amd = 251,
    nir_intrinsic_load_deref = 252,
    nir_intrinsic_load_deref_block_intel = 253,
    nir_intrinsic_load_desc_set_address_intel = 254,
    nir_intrinsic_load_desc_set_dynamic_index_intel = 255,
    nir_intrinsic_load_draw_id = 256,
    nir_intrinsic_load_esgs_vertex_stride_amd = 257,
    nir_intrinsic_load_exported_agx = 258,
    nir_intrinsic_load_fb_layers_v3d = 259,
    nir_intrinsic_load_fep_w_v3d = 260,
    nir_intrinsic_load_first_vertex = 261,
    nir_intrinsic_load_fixed_point_size_agx = 262,
    nir_intrinsic_load_flat_mask = 263,
    nir_intrinsic_load_force_vrs_rates_amd = 264,
    nir_intrinsic_load_frag_coord = 265,
    nir_intrinsic_load_frag_coord_unscaled_ir3 = 266,
    nir_intrinsic_load_frag_coord_zw = 267,
    nir_intrinsic_load_frag_invocation_count = 268,
    nir_intrinsic_load_frag_offset_ir3 = 269,
    nir_intrinsic_load_frag_shading_rate = 270,
    nir_intrinsic_load_frag_size = 271,
    nir_intrinsic_load_frag_size_ir3 = 272,
    nir_intrinsic_load_from_texture_handle_agx = 273,
    nir_intrinsic_load_front_face = 274,
    nir_intrinsic_load_fs_input_interp_deltas = 275,
    nir_intrinsic_load_fully_covered = 276,
    nir_intrinsic_load_geometry_param_buffer_agx = 277,
    nir_intrinsic_load_global = 278,
    nir_intrinsic_load_global_2x32 = 279,
    nir_intrinsic_load_global_amd = 280,
    nir_intrinsic_load_global_base_ptr = 281,
    nir_intrinsic_load_global_block_intel = 282,
    nir_intrinsic_load_global_const_block_intel = 283,
    nir_intrinsic_load_global_constant = 284,
    nir_intrinsic_load_global_constant_bounded = 285,
    nir_intrinsic_load_global_constant_offset = 286,
    nir_intrinsic_load_global_constant_uniform_block_intel = 287,
    nir_intrinsic_load_global_invocation_id = 288,
    nir_intrinsic_load_global_invocation_id_zero_base = 289,
    nir_intrinsic_load_global_invocation_index = 290,
    nir_intrinsic_load_global_ir3 = 291,
    nir_intrinsic_load_gs_header_ir3 = 292,
    nir_intrinsic_load_gs_vertex_offset_amd = 293,
    nir_intrinsic_load_gs_wave_id_amd = 294,
    nir_intrinsic_load_helper_arg_hi_agx = 295,
    nir_intrinsic_load_helper_arg_lo_agx = 296,
    nir_intrinsic_load_helper_invocation = 297,
    nir_intrinsic_load_helper_op_id_agx = 298,
    nir_intrinsic_load_hit_attrib_amd = 299,
    nir_intrinsic_load_hs_out_patch_data_offset_amd = 300,
    nir_intrinsic_load_hs_patch_stride_ir3 = 301,
    nir_intrinsic_load_initial_edgeflags_amd = 302,
    nir_intrinsic_load_input = 303,
    nir_intrinsic_load_input_assembly_buffer_agx = 304,
    nir_intrinsic_load_input_topology_agx = 305,
    nir_intrinsic_load_input_vertex = 306,
    nir_intrinsic_load_instance_id = 307,
    nir_intrinsic_load_interpolated_input = 308,
    nir_intrinsic_load_intersection_opaque_amd = 309,
    nir_intrinsic_load_invocation_id = 310,
    nir_intrinsic_load_is_indexed_draw = 311,
    nir_intrinsic_load_kernel_input = 312,
    nir_intrinsic_load_layer_id = 313,
    nir_intrinsic_load_lds_ngg_gs_out_vertex_base_amd = 314,
    nir_intrinsic_load_lds_ngg_scratch_base_amd = 315,
    nir_intrinsic_load_leaf_opaque_intel = 316,
    nir_intrinsic_load_leaf_procedural_intel = 317,
    nir_intrinsic_load_line_coord = 318,
    nir_intrinsic_load_line_width = 319,
    nir_intrinsic_load_local_invocation_id = 320,
    nir_intrinsic_load_local_invocation_index = 321,
    nir_intrinsic_load_local_pixel_agx = 322,
    nir_intrinsic_load_local_shared_r600 = 323,
    nir_intrinsic_load_lshs_vertex_stride_amd = 324,
    nir_intrinsic_load_merged_wave_info_amd = 325,
    nir_intrinsic_load_mesh_inline_data_intel = 326,
    nir_intrinsic_load_mesh_view_count = 327,
    nir_intrinsic_load_mesh_view_indices = 328,
    nir_intrinsic_load_multisampled_pan = 329,
    nir_intrinsic_load_num_subgroups = 330,
    nir_intrinsic_load_num_vertices = 331,
    nir_intrinsic_load_num_vertices_per_primitive_amd = 332,
    nir_intrinsic_load_num_workgroups = 333,
    nir_intrinsic_load_ordered_id_amd = 334,
    nir_intrinsic_load_output = 335,
    nir_intrinsic_load_packed_passthrough_primitive_amd = 336,
    nir_intrinsic_load_param = 337,
    nir_intrinsic_load_patch_vertices_in = 338,
    nir_intrinsic_load_per_primitive_output = 339,
    nir_intrinsic_load_per_vertex_input = 340,
    nir_intrinsic_load_per_vertex_output = 341,
    nir_intrinsic_load_persp_center_rhw_ir3 = 342,
    nir_intrinsic_load_pipeline_stat_query_enabled_amd = 343,
    nir_intrinsic_load_pixel_coord = 344,
    nir_intrinsic_load_point_coord = 345,
    nir_intrinsic_load_point_coord_maybe_flipped = 346,
    nir_intrinsic_load_poly_line_smooth_enabled = 347,
    nir_intrinsic_load_polygon_stipple_agx = 348,
    nir_intrinsic_load_preamble = 349,
    nir_intrinsic_load_prim_gen_query_enabled_amd = 350,
    nir_intrinsic_load_prim_xfb_query_enabled_amd = 351,
    nir_intrinsic_load_primitive_id = 352,
    nir_intrinsic_load_primitive_location_ir3 = 353,
    nir_intrinsic_load_printf_buffer_address = 354,
    nir_intrinsic_load_provoking_last = 355,
    nir_intrinsic_load_provoking_vtx_amd = 356,
    nir_intrinsic_load_provoking_vtx_in_prim_amd = 357,
    nir_intrinsic_load_push_constant = 358,
    nir_intrinsic_load_push_constant_zink = 359,
    nir_intrinsic_load_rasterization_primitive_amd = 360,
    nir_intrinsic_load_rasterization_samples_amd = 361,
    nir_intrinsic_load_raw_output_pan = 362,
    nir_intrinsic_load_ray_base_mem_addr_intel = 363,
    nir_intrinsic_load_ray_flags = 364,
    nir_intrinsic_load_ray_geometry_index = 365,
    nir_intrinsic_load_ray_hit_kind = 366,
    nir_intrinsic_load_ray_hit_sbt_addr_intel = 367,
    nir_intrinsic_load_ray_hit_sbt_stride_intel = 368,
    nir_intrinsic_load_ray_hw_stack_size_intel = 369,
    nir_intrinsic_load_ray_instance_custom_index = 370,
    nir_intrinsic_load_ray_launch_id = 371,
    nir_intrinsic_load_ray_launch_size = 372,
    nir_intrinsic_load_ray_miss_sbt_addr_intel = 373,
    nir_intrinsic_load_ray_miss_sbt_stride_intel = 374,
    nir_intrinsic_load_ray_num_dss_rt_stacks_intel = 375,
    nir_intrinsic_load_ray_object_direction = 376,
    nir_intrinsic_load_ray_object_origin = 377,
    nir_intrinsic_load_ray_object_to_world = 378,
    nir_intrinsic_load_ray_query_global_intel = 379,
    nir_intrinsic_load_ray_sw_stack_size_intel = 380,
    nir_intrinsic_load_ray_t_max = 381,
    nir_intrinsic_load_ray_t_min = 382,
    nir_intrinsic_load_ray_tracing_stack_base_lvp = 383,
    nir_intrinsic_load_ray_triangle_vertex_positions = 384,
    nir_intrinsic_load_ray_world_direction = 385,
    nir_intrinsic_load_ray_world_origin = 386,
    nir_intrinsic_load_ray_world_to_object = 387,
    nir_intrinsic_load_reg = 388,
    nir_intrinsic_load_reg_indirect = 389,
    nir_intrinsic_load_rel_patch_id_ir3 = 390,
    nir_intrinsic_load_reloc_const_intel = 391,
    nir_intrinsic_load_resume_shader_address_amd = 392,
    nir_intrinsic_load_ring_attr_amd = 393,
    nir_intrinsic_load_ring_attr_offset_amd = 394,
    nir_intrinsic_load_ring_es2gs_offset_amd = 395,
    nir_intrinsic_load_ring_esgs_amd = 396,
    nir_intrinsic_load_ring_gs2vs_offset_amd = 397,
    nir_intrinsic_load_ring_gsvs_amd = 398,
    nir_intrinsic_load_ring_mesh_scratch_amd = 399,
    nir_intrinsic_load_ring_mesh_scratch_offset_amd = 400,
    nir_intrinsic_load_ring_task_draw_amd = 401,
    nir_intrinsic_load_ring_task_payload_amd = 402,
    nir_intrinsic_load_ring_tess_factors_amd = 403,
    nir_intrinsic_load_ring_tess_factors_offset_amd = 404,
    nir_intrinsic_load_ring_tess_offchip_amd = 405,
    nir_intrinsic_load_ring_tess_offchip_offset_amd = 406,
    nir_intrinsic_load_rt_arg_scratch_offset_amd = 407,
    nir_intrinsic_load_rt_conversion_pan = 408,
    nir_intrinsic_load_rt_dynamic_callable_stack_base_amd = 409,
    nir_intrinsic_load_sample_id = 410,
    nir_intrinsic_load_sample_id_no_per_sample = 411,
    nir_intrinsic_load_sample_mask = 412,
    nir_intrinsic_load_sample_mask_in = 413,
    nir_intrinsic_load_sample_pos = 414,
    nir_intrinsic_load_sample_pos_from_id = 415,
    nir_intrinsic_load_sample_pos_or_center = 416,
    nir_intrinsic_load_sample_positions_agx = 417,
    nir_intrinsic_load_sample_positions_amd = 418,
    nir_intrinsic_load_sample_positions_pan = 419,
    nir_intrinsic_load_sampler_handle_agx = 420,
    nir_intrinsic_load_sampler_lod_parameters_pan = 421,
    nir_intrinsic_load_samples_log2_agx = 422,
    nir_intrinsic_load_sbt_base_amd = 423,
    nir_intrinsic_load_sbt_offset_amd = 424,
    nir_intrinsic_load_sbt_stride_amd = 425,
    nir_intrinsic_load_scalar_arg_amd = 426,
    nir_intrinsic_load_scratch = 427,
    nir_intrinsic_load_scratch_base_ptr = 428,
    nir_intrinsic_load_shader_call_data_offset_lvp = 429,
    nir_intrinsic_load_shader_index = 430,
    nir_intrinsic_load_shader_part_tests_zs_agx = 431,
    nir_intrinsic_load_shader_record_ptr = 432,
    nir_intrinsic_load_shared = 433,
    nir_intrinsic_load_shared2_amd = 434,
    nir_intrinsic_load_shared_base_ptr = 435,
    nir_intrinsic_load_shared_block_intel = 436,
    nir_intrinsic_load_shared_ir3 = 437,
    nir_intrinsic_load_shared_uniform_block_intel = 438,
    nir_intrinsic_load_simd_width_intel = 439,
    nir_intrinsic_load_sm_count_nv = 440,
    nir_intrinsic_load_sm_id_nv = 441,
    nir_intrinsic_load_smem_amd = 442,
    nir_intrinsic_load_ssbo = 443,
    nir_intrinsic_load_ssbo_address = 444,
    nir_intrinsic_load_ssbo_block_intel = 445,
    nir_intrinsic_load_ssbo_ir3 = 446,
    nir_intrinsic_load_ssbo_uniform_block_intel = 447,
    nir_intrinsic_load_stack = 448,
    nir_intrinsic_load_stat_query_address_agx = 449,
    nir_intrinsic_load_streamout_buffer_amd = 450,
    nir_intrinsic_load_streamout_config_amd = 451,
    nir_intrinsic_load_streamout_offset_amd = 452,
    nir_intrinsic_load_streamout_write_index_amd = 453,
    nir_intrinsic_load_subgroup_eq_mask = 454,
    nir_intrinsic_load_subgroup_ge_mask = 455,
    nir_intrinsic_load_subgroup_gt_mask = 456,
    nir_intrinsic_load_subgroup_id = 457,
    nir_intrinsic_load_subgroup_id_shift_ir3 = 458,
    nir_intrinsic_load_subgroup_invocation = 459,
    nir_intrinsic_load_subgroup_le_mask = 460,
    nir_intrinsic_load_subgroup_lt_mask = 461,
    nir_intrinsic_load_subgroup_size = 462,
    nir_intrinsic_load_sysval_agx = 463,
    nir_intrinsic_load_sysval_nv = 464,
    nir_intrinsic_load_task_payload = 465,
    nir_intrinsic_load_task_ring_entry_amd = 466,
    nir_intrinsic_load_tcs_header_ir3 = 467,
    nir_intrinsic_load_tcs_in_param_base_r600 = 468,
    nir_intrinsic_load_tcs_num_patches_amd = 469,
    nir_intrinsic_load_tcs_out_param_base_r600 = 470,
    nir_intrinsic_load_tcs_primitive_mode_amd = 471,
    nir_intrinsic_load_tcs_rel_patch_id_r600 = 472,
    nir_intrinsic_load_tcs_tess_factor_base_r600 = 473,
    nir_intrinsic_load_tcs_tess_levels_to_tes_amd = 474,
    nir_intrinsic_load_tess_coord = 475,
    nir_intrinsic_load_tess_coord_xy = 476,
    nir_intrinsic_load_tess_factor_base_ir3 = 477,
    nir_intrinsic_load_tess_level_inner = 478,
    nir_intrinsic_load_tess_level_inner_default = 479,
    nir_intrinsic_load_tess_level_outer = 480,
    nir_intrinsic_load_tess_level_outer_default = 481,
    nir_intrinsic_load_tess_param_base_ir3 = 482,
    nir_intrinsic_load_tess_param_buffer_agx = 483,
    nir_intrinsic_load_tess_rel_patch_id_amd = 484,
    nir_intrinsic_load_tex_sprite_mask_agx = 485,
    nir_intrinsic_load_texture_handle_agx = 486,
    nir_intrinsic_load_texture_scale = 487,
    nir_intrinsic_load_texture_size_etna = 488,
    nir_intrinsic_load_tlb_color_v3d = 489,
    nir_intrinsic_load_topology_id_intel = 490,
    nir_intrinsic_load_typed_buffer_amd = 491,
    nir_intrinsic_load_ubo = 492,
    nir_intrinsic_load_ubo_uniform_block_intel = 493,
    nir_intrinsic_load_ubo_vec4 = 494,
    nir_intrinsic_load_uniform = 495,
    nir_intrinsic_load_user_clip_plane = 496,
    nir_intrinsic_load_user_data_amd = 497,
    nir_intrinsic_load_uvs_index_agx = 498,
    nir_intrinsic_load_vbo_base_agx = 499,
    nir_intrinsic_load_vector_arg_amd = 500,
    nir_intrinsic_load_vertex_id = 501,
    nir_intrinsic_load_vertex_id_zero_base = 502,
    nir_intrinsic_load_view_index = 503,
    nir_intrinsic_load_viewport_offset = 504,
    nir_intrinsic_load_viewport_scale = 505,
    nir_intrinsic_load_viewport_x_offset = 506,
    nir_intrinsic_load_viewport_x_scale = 507,
    nir_intrinsic_load_viewport_xy_scale_and_offset = 508,
    nir_intrinsic_load_viewport_y_offset = 509,
    nir_intrinsic_load_viewport_y_scale = 510,
    nir_intrinsic_load_viewport_z_offset = 511,
    nir_intrinsic_load_viewport_z_scale = 512,
    nir_intrinsic_load_vs_output_buffer_agx = 513,
    nir_intrinsic_load_vs_output_buffer_ptr_agx = 514,
    nir_intrinsic_load_vs_outputs_agx = 515,
    nir_intrinsic_load_vs_primitive_stride_ir3 = 516,
    nir_intrinsic_load_vs_vertex_stride_ir3 = 517,
    nir_intrinsic_load_vulkan_descriptor = 518,
    nir_intrinsic_load_warp_id_nv = 519,
    nir_intrinsic_load_warps_per_sm_nv = 520,
    nir_intrinsic_load_work_dim = 521,
    nir_intrinsic_load_workgroup_id = 522,
    nir_intrinsic_load_workgroup_id_zero_base = 523,
    nir_intrinsic_load_workgroup_index = 524,
    nir_intrinsic_load_workgroup_num_input_primitives_amd = 525,
    nir_intrinsic_load_workgroup_num_input_vertices_amd = 526,
    nir_intrinsic_load_workgroup_size = 527,
    nir_intrinsic_load_xfb_address = 528,
    nir_intrinsic_load_xfb_index_buffer = 529,
    nir_intrinsic_load_xfb_size = 530,
    nir_intrinsic_masked_swizzle_amd = 531,
    nir_intrinsic_mbcnt_amd = 532,
    nir_intrinsic_memcpy_deref = 533,
    nir_intrinsic_nop = 534,
    nir_intrinsic_optimization_barrier_sgpr_amd = 535,
    nir_intrinsic_optimization_barrier_vgpr_amd = 536,
    nir_intrinsic_ordered_xfb_counter_add_gfx11_amd = 537,
    nir_intrinsic_overwrite_tes_arguments_amd = 538,
    nir_intrinsic_overwrite_vs_arguments_amd = 539,
    nir_intrinsic_preamble_end_ir3 = 540,
    nir_intrinsic_preamble_start_ir3 = 541,
    nir_intrinsic_printf = 542,
    nir_intrinsic_quad_broadcast = 543,
    nir_intrinsic_quad_swap_diagonal = 544,
    nir_intrinsic_quad_swap_horizontal = 545,
    nir_intrinsic_quad_swap_vertical = 546,
    nir_intrinsic_quad_swizzle_amd = 547,
    nir_intrinsic_quad_vote_all = 548,
    nir_intrinsic_quad_vote_any = 549,
    nir_intrinsic_read_first_invocation = 550,
    nir_intrinsic_read_invocation = 551,
    nir_intrinsic_read_invocation_cond_ir3 = 552,
    nir_intrinsic_reduce = 553,
    nir_intrinsic_reduce_clusters_ir3 = 554,
    nir_intrinsic_report_ray_intersection = 555,
    nir_intrinsic_resource_intel = 556,
    nir_intrinsic_rotate = 557,
    nir_intrinsic_rq_confirm_intersection = 558,
    nir_intrinsic_rq_generate_intersection = 559,
    nir_intrinsic_rq_initialize = 560,
    nir_intrinsic_rq_load = 561,
    nir_intrinsic_rq_proceed = 562,
    nir_intrinsic_rq_terminate = 563,
    nir_intrinsic_rt_execute_callable = 564,
    nir_intrinsic_rt_resume = 565,
    nir_intrinsic_rt_return_amd = 566,
    nir_intrinsic_rt_trace_ray = 567,
    nir_intrinsic_sample_mask_agx = 568,
    nir_intrinsic_sendmsg_amd = 569,
    nir_intrinsic_set_vertex_and_primitive_count = 570,
    nir_intrinsic_shader_clock = 571,
    nir_intrinsic_shared_atomic = 572,
    nir_intrinsic_shared_atomic_swap = 573,
    nir_intrinsic_shuffle = 574,
    nir_intrinsic_shuffle_down = 575,
    nir_intrinsic_shuffle_up = 576,
    nir_intrinsic_shuffle_xor = 577,
    nir_intrinsic_sparse_residency_code_and = 578,
    nir_intrinsic_ssa_bar_nv = 579,
    nir_intrinsic_ssbo_atomic = 580,
    nir_intrinsic_ssbo_atomic_ir3 = 581,
    nir_intrinsic_ssbo_atomic_swap = 582,
    nir_intrinsic_ssbo_atomic_swap_ir3 = 583,
    nir_intrinsic_stack_map_agx = 584,
    nir_intrinsic_stack_unmap_agx = 585,
    nir_intrinsic_store_agx = 586,
    nir_intrinsic_store_buffer_amd = 587,
    nir_intrinsic_store_combined_output_pan = 588,
    nir_intrinsic_store_deref = 589,
    nir_intrinsic_store_deref_block_intel = 590,
    nir_intrinsic_store_global = 591,
    nir_intrinsic_store_global_2x32 = 592,
    nir_intrinsic_store_global_amd = 593,
    nir_intrinsic_store_global_block_intel = 594,
    nir_intrinsic_store_global_ir3 = 595,
    nir_intrinsic_store_hit_attrib_amd = 596,
    nir_intrinsic_store_local_pixel_agx = 597,
    nir_intrinsic_store_local_shared_r600 = 598,
    nir_intrinsic_store_output = 599,
    nir_intrinsic_store_per_primitive_output = 600,
    nir_intrinsic_store_per_vertex_output = 601,
    nir_intrinsic_store_preamble = 602,
    nir_intrinsic_store_raw_output_pan = 603,
    nir_intrinsic_store_reg = 604,
    nir_intrinsic_store_reg_indirect = 605,
    nir_intrinsic_store_scalar_arg_amd = 606,
    nir_intrinsic_store_scratch = 607,
    nir_intrinsic_store_shared = 608,
    nir_intrinsic_store_shared2_amd = 609,
    nir_intrinsic_store_shared_block_intel = 610,
    nir_intrinsic_store_shared_ir3 = 611,
    nir_intrinsic_store_ssbo = 612,
    nir_intrinsic_store_ssbo_block_intel = 613,
    nir_intrinsic_store_ssbo_ir3 = 614,
    nir_intrinsic_store_stack = 615,
    nir_intrinsic_store_task_payload = 616,
    nir_intrinsic_store_tf_r600 = 617,
    nir_intrinsic_store_tlb_sample_color_v3d = 618,
    nir_intrinsic_store_uniform_ir3 = 619,
    nir_intrinsic_store_uvs_agx = 620,
    nir_intrinsic_store_vector_arg_amd = 621,
    nir_intrinsic_store_zs_agx = 622,
    nir_intrinsic_strict_wqm_coord_amd = 623,
    nir_intrinsic_task_payload_atomic = 624,
    nir_intrinsic_task_payload_atomic_swap = 625,
    nir_intrinsic_terminate = 626,
    nir_intrinsic_terminate_if = 627,
    nir_intrinsic_terminate_ray = 628,
    nir_intrinsic_trace_ray = 629,
    nir_intrinsic_trace_ray_intel = 630,
    nir_intrinsic_unit_test_amd = 631,
    nir_intrinsic_unit_test_divergent_amd = 632,
    nir_intrinsic_unit_test_uniform_amd = 633,
    nir_intrinsic_vote_all = 634,
    nir_intrinsic_vote_any = 635,
    nir_intrinsic_vote_feq = 636,
    nir_intrinsic_vote_ieq = 637,
    nir_intrinsic_vulkan_resource_index = 638,
    nir_intrinsic_vulkan_resource_reindex = 639,
    nir_intrinsic_write_invocation_amd = 640,
    nir_intrinsic_xfb_counter_sub_gfx11_amd = 641,
    nir_num_intrinsics = 642,
}
#[doc = " Represents an intrinsic\n\n An intrinsic is an instruction type for handling things that are\n more-or-less regular operations but don't just consume and produce SSA\n values like ALU operations do.  Intrinsics are not for things that have\n special semantic meaning such as phi nodes and parallel copies.\n Examples of intrinsics include variable load/store operations, system\n value loads, and the like.  Even though texturing more-or-less falls\n under this category, texturing is its own instruction type because\n trying to represent texturing with intrinsics would lead to a\n combinatorial explosion of intrinsic opcodes.\n\n By having a single instruction type for handling a lot of different\n cases, optimization passes can look for intrinsics and, for the most\n part, completely ignore them.  Each intrinsic type also has a few\n possible flags that govern whether or not they can be reordered or\n eliminated.  That way passes like dead code elimination can still work\n on intrisics without understanding the meaning of each.\n\n Each intrinsic has some number of constant indices, some number of\n variables, and some number of sources.  What these sources, variables,\n and indices mean depends on the intrinsic and is documented with the\n intrinsic declaration in nir_intrinsics.h.  Intrinsics and texture\n instructions are the only types of instruction that can operate on\n variables."]
#[repr(C)]
#[derive(Debug)]
pub struct nir_intrinsic_instr {
    pub instr: nir_instr,
    pub intrinsic: nir_intrinsic_op,
    pub def: nir_def,
    #[doc = " number of components if this is a vectorized intrinsic\n\n Similarly to ALU operations, some intrinsics are vectorized.\n An intrinsic is vectorized if nir_intrinsic_infos.dest_components == 0.\n For vectorized intrinsics, the num_components field specifies the\n number of destination components and the number of source components\n for all sources with nir_intrinsic_infos.src_components[i] == 0."]
    pub num_components: u8,
    pub const_index: [::std::os::raw::c_int; 8usize],
    pub name: *const ::std::os::raw::c_char,
    pub src: __IncompleteArrayField<nir_src>,
}
#[test]
fn bindgen_test_layout_nir_intrinsic_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_intrinsic_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_intrinsic_instr>(),
        120usize,
        concat!("Size of: ", stringify!(nir_intrinsic_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_intrinsic_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_intrinsic_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intrinsic) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(intrinsic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_components) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(num_components)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).const_index) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(const_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_intrinsic_instr),
            "::",
            stringify!(src)
        )
    );
}
impl Default for nir_intrinsic_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_instr_xfb_write_mask(instr: *mut nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_intrinsic_src_components(
        intr: *const nir_intrinsic_instr,
        srcn: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_intrinsic_dest_components(intr: *mut nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_intrinsic_instr_src_type(
        intrin: *const nir_intrinsic_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_alu_type;
}
extern "C" {
    pub fn nir_intrinsic_instr_dest_type(intrin: *const nir_intrinsic_instr) -> nir_alu_type;
}
extern "C" {
    #[doc = " Helper to copy const_index[] from src to dst, without assuming they\n match in order."]
    pub fn nir_intrinsic_copy_const_indices(
        dst: *mut nir_intrinsic_instr,
        src: *mut nir_intrinsic_instr,
    );
}
extern "C" {
    pub fn nir_image_intrinsic_coord_components(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_rewrite_image_intrinsic(
        instr: *mut nir_intrinsic_instr,
        handle: *mut nir_def,
        bindless: bool,
    );
}
extern "C" {
    pub fn nir_intrinsic_writes_external_memory(instr: *const nir_intrinsic_instr) -> bool;
}
#[repr(u32)]
#[doc = " Texture instruction source type"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_tex_src_type {
    #[doc = " Texture coordinate\n\n Must have :c:member:`nir_tex_instr.coord_components` components."]
    nir_tex_src_coord = 0,
    #[doc = " Projector\n\n The texture coordinate (except for the array component, if any) is\n divided by this value before LOD computation and sampling.\n\n Must be a float scalar."]
    nir_tex_src_projector = 1,
    #[doc = " Shadow comparator\n\n For shadow sampling, the fetched texel values are compared against the\n shadow comparator using the compare op specified by the sampler object\n and converted to 1.0 if the comparison succeeds and 0.0 if it fails.\n Interpolation happens after this conversion so the actual result may be\n anywhere in the range [0.0, 1.0].\n\n Only valid if :c:member:`nir_tex_instr.is_shadow` and must be a float\n scalar."]
    nir_tex_src_comparator = 2,
    #[doc = " Coordinate offset\n\n An integer value that is added to the texel address before sampling.\n This is only allowed with operations that take an explicit LOD as it is\n applied in integer texel space after LOD selection and not normalized\n coordinate space."]
    nir_tex_src_offset = 3,
    #[doc = " LOD bias\n\n This value is added to the computed LOD before mip-mapping."]
    nir_tex_src_bias = 4,
    #[doc = " Explicit LOD"]
    nir_tex_src_lod = 5,
    #[doc = " Min LOD\n\n The computed LOD is clamped to be at least as large as min_lod before\n mip-mapping."]
    nir_tex_src_min_lod = 6,
    #[doc = " MSAA sample index"]
    nir_tex_src_ms_index = 7,
    #[doc = " Intel-specific MSAA compression data"]
    nir_tex_src_ms_mcs_intel = 8,
    #[doc = " Explicit horizontal (X-major) coordinate derivative"]
    nir_tex_src_ddx = 9,
    #[doc = " Explicit vertical (Y-major) coordinate derivative"]
    nir_tex_src_ddy = 10,
    #[doc = " Texture variable dereference"]
    nir_tex_src_texture_deref = 11,
    #[doc = " Sampler variable dereference"]
    nir_tex_src_sampler_deref = 12,
    #[doc = " Texture index offset\n\n This is added to :c:member:`nir_tex_instr.texture_index`.  Unless\n :c:member:`nir_tex_instr.texture_non_uniform` is set, this is guaranteed\n to be dynamically uniform."]
    nir_tex_src_texture_offset = 13,
    #[doc = " Dynamically uniform sampler index offset\n\n This is added to :c:member:`nir_tex_instr.sampler_index`.  Unless\n :c:member:`nir_tex_instr.sampler_non_uniform` is set, this is guaranteed to be\n dynamically uniform.  This should not be present until GLSL ES 3.20, GLSL\n 4.00, or ARB_gpu_shader5, because in ES 3.10 and GL 3.30 samplers said\n \"When aggregated into arrays within a shader, samplers can only be indexed\n with a constant integral expression.\""]
    nir_tex_src_sampler_offset = 14,
    #[doc = " Bindless texture handle\n\n This is, unfortunately, a bit overloaded at the moment.  There are\n generally two types of bindless handles:\n\n  1. For GL_ARB_bindless bindless handles. These are part of the\n     GL/Gallium-level API and are always a 64-bit integer.\n\n  2. HW-specific handles.  GL_ARB_bindless handles may be lowered to\n     these.  Also, these are used by many Vulkan drivers to implement\n     descriptor sets, especially for UPDATE_AFTER_BIND descriptors.\n     The details of hardware handles (bit size, format, etc.) is\n     HW-specific.\n\n Because of this overloading and the resulting ambiguity, we currently\n don't validate anything for these."]
    nir_tex_src_texture_handle = 15,
    #[doc = " Bindless sampler handle\n\n See nir_tex_src_texture_handle,"]
    nir_tex_src_sampler_handle = 16,
    #[doc = " Plane index for multi-plane YCbCr textures"]
    nir_tex_src_plane = 17,
    #[doc = " Backend-specific vec4 tex src argument.\n\n Can be used to have NIR optimization (copy propagation, lower_vec_to_regs)\n apply to the packing of the tex srcs.  This lowering must only happen\n after nir_lower_tex().\n\n The nir_tex_instr_src_type() of this argument is float, so no lowering\n will happen if nir_lower_int_to_float is used."]
    nir_tex_src_backend1 = 18,
    #[doc = " Second backend-specific vec4 tex src argument, see nir_tex_src_backend1."]
    nir_tex_src_backend2 = 19,
    #[doc = " Second backend-specific vec4 tex src argument, see nir_tex_src_backend1."]
    nir_num_tex_src_types = 20,
}
#[doc = " A texture instruction source"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tex_src {
    #[doc = " Base source"]
    pub src: nir_src,
    #[doc = " Type of this source"]
    pub src_type: nir_tex_src_type,
}
#[test]
fn bindgen_test_layout_nir_tex_src() {
    const UNINIT: ::std::mem::MaybeUninit<nir_tex_src> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_tex_src>(),
        40usize,
        concat!("Size of: ", stringify!(nir_tex_src))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_tex_src>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_tex_src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_src),
            "::",
            stringify!(src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src_type) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_src),
            "::",
            stringify!(src_type)
        )
    );
}
impl Default for nir_tex_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[doc = " Texture instruction opcode"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_texop {
    #[doc = " Regular texture look-up"]
    nir_texop_tex = 0,
    #[doc = " Texture look-up with LOD bias"]
    nir_texop_txb = 1,
    #[doc = " Texture look-up with explicit LOD"]
    nir_texop_txl = 2,
    #[doc = " Texture look-up with partial derivatives"]
    nir_texop_txd = 3,
    #[doc = " Texel fetch with explicit LOD"]
    nir_texop_txf = 4,
    #[doc = " Multisample texture fetch"]
    nir_texop_txf_ms = 5,
    #[doc = " Multisample texture fetch from framebuffer"]
    nir_texop_txf_ms_fb = 6,
    #[doc = " Multisample compression value fetch"]
    nir_texop_txf_ms_mcs_intel = 7,
    #[doc = " Texture size"]
    nir_texop_txs = 8,
    #[doc = " Texture lod query"]
    nir_texop_lod = 9,
    #[doc = " Texture gather"]
    nir_texop_tg4 = 10,
    #[doc = " Texture levels query"]
    nir_texop_query_levels = 11,
    #[doc = " Texture samples query"]
    nir_texop_texture_samples = 12,
    #[doc = " Query whether all samples are definitely identical."]
    nir_texop_samples_identical = 13,
    #[doc = " Regular texture look-up, eligible for pre-dispatch"]
    nir_texop_tex_prefetch = 14,
    #[doc = " Multisample fragment color texture fetch"]
    nir_texop_fragment_fetch_amd = 15,
    #[doc = " Multisample fragment mask texture fetch"]
    nir_texop_fragment_mask_fetch_amd = 16,
    #[doc = " Returns a buffer or image descriptor."]
    nir_texop_descriptor_amd = 17,
    #[doc = " Returns a sampler descriptor."]
    nir_texop_sampler_descriptor_amd = 18,
    #[doc = " Returns the sampler's LOD bias"]
    nir_texop_lod_bias_agx = 19,
    #[doc = " Maps to TXQ.DIMENSION"]
    nir_texop_hdr_dim_nv = 20,
    #[doc = " Maps to TXQ.TEXTURE_TYPE"]
    nir_texop_tex_type_nv = 21,
}
#[doc = " Represents a texture instruction"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tex_instr {
    #[doc = " Base instruction"]
    pub instr: nir_instr,
    #[doc = " Dimensionality of the texture operation\n\n This will typically match the dimensionality of the texture deref type\n if a nir_tex_src_texture_deref is present.  However, it may not if\n texture lowering has occurred."]
    pub sampler_dim: glsl_sampler_dim,
    #[doc = " ALU type of the destination\n\n This is the canonical sampled type for this texture operation and may\n not exactly match the sampled type of the deref type when a\n nir_tex_src_texture_deref is present.  For OpenCL, the sampled type of\n the texture deref will be GLSL_TYPE_VOID and this is allowed to be\n anything.  With SPIR-V, the signedness of integer types is allowed to\n differ.  For all APIs, the bit size may differ if the driver has done\n any sort of mediump or similar lowering since texture types always have\n 32-bit sampled types."]
    pub dest_type: nir_alu_type,
    #[doc = " Texture opcode"]
    pub op: nir_texop,
    #[doc = " Destination"]
    pub def: nir_def,
    #[doc = " Array of sources\n\n This array has :c:member:`nir_tex_instr.num_srcs` elements"]
    pub src: *mut nir_tex_src,
    #[doc = " Number of sources"]
    pub num_srcs: ::std::os::raw::c_uint,
    #[doc = " Number of components in the coordinate, if any"]
    pub coord_components: ::std::os::raw::c_uint,
    #[doc = " True if the texture instruction acts on an array texture"]
    pub is_array: bool,
    #[doc = " True if the texture instruction performs a shadow comparison\n\n If this is true, the texture instruction must have a\n nir_tex_src_comparator."]
    pub is_shadow: bool,
    #[doc = " If is_shadow is true, whether this is the old-style shadow that outputs\n 4 components or the new-style shadow that outputs 1 component."]
    pub is_new_style_shadow: bool,
    #[doc = " True if this texture instruction should return a sparse residency code.\n The code is in the last component of the result."]
    pub is_sparse: bool,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Gather offsets"]
    pub tg4_offsets: [[i8; 2usize]; 4usize],
    #[doc = " True if the texture index or handle is not dynamically uniform"]
    pub texture_non_uniform: bool,
    #[doc = " True if the sampler index or handle is not dynamically uniform.\n\n This may be set when VK_EXT_descriptor_indexing is supported and the\n appropriate capability is enabled.\n\n This should always be false in GLSL (GLSL ES 3.20 says \"When aggregated\n into arrays within a shader, opaque types can only be indexed with a\n dynamically uniform integral expression\", and GLSL 4.60 says \"When\n aggregated into arrays within a shader, [texture, sampler, and\n samplerShadow] types can only be indexed with a dynamically uniform\n expression, or texture lookup will result in undefined values.\")."]
    pub sampler_non_uniform: bool,
    #[doc = " The texture index\n\n If this texture instruction has a nir_tex_src_texture_offset source,\n then the texture index is given by texture_index + texture_offset."]
    pub texture_index: ::std::os::raw::c_uint,
    #[doc = " The sampler index\n\n The following operations do not require a sampler and, as such, this\n field should be ignored:\n\n    - nir_texop_txf\n    - nir_texop_txf_ms\n    - nir_texop_txs\n    - nir_texop_query_levels\n    - nir_texop_texture_samples\n    - nir_texop_samples_identical\n\n If this texture instruction has a nir_tex_src_sampler_offset source,\n then the sampler index is given by sampler_index + sampler_offset."]
    pub sampler_index: ::std::os::raw::c_uint,
    pub backend_flags: u32,
}
#[test]
fn bindgen_test_layout_nir_tex_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_tex_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_tex_instr>(),
        128usize,
        concat!("Size of: ", stringify!(nir_tex_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_tex_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_tex_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler_dim) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(sampler_dim)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dest_type) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(dest_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).op) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_srcs) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(num_srcs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).coord_components) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(coord_components)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_array) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(is_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_shadow) as usize - ptr as usize },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(is_shadow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_new_style_shadow) as usize - ptr as usize },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(is_new_style_shadow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_sparse) as usize - ptr as usize },
        99usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(is_sparse)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tg4_offsets) as usize - ptr as usize },
        101usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(tg4_offsets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texture_non_uniform) as usize - ptr as usize },
        109usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(texture_non_uniform)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler_non_uniform) as usize - ptr as usize },
        110usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(sampler_non_uniform)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texture_index) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(texture_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler_index) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(sampler_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).backend_flags) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_instr),
            "::",
            stringify!(backend_flags)
        )
    );
}
impl Default for nir_tex_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_tex_instr {
    #[inline]
    pub fn component(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_component(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn array_is_lowered_cube(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_array_is_lowered_cube(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_gather_implicit_lod(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_gather_implicit_lod(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        component: ::std::os::raw::c_uint,
        array_is_lowered_cube: ::std::os::raw::c_uint,
        is_gather_implicit_lod: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let component: u32 = unsafe { ::std::mem::transmute(component) };
            component as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let array_is_lowered_cube: u32 =
                unsafe { ::std::mem::transmute(array_is_lowered_cube) };
            array_is_lowered_cube as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_gather_implicit_lod: u32 =
                unsafe { ::std::mem::transmute(is_gather_implicit_lod) };
            is_gather_implicit_lod as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    #[doc = " Returns true if the texture operation requires a sampler as a general rule\n\n Note that the specific hw/driver backend could require to a sampler\n object/configuration packet in any case, for some other reason.\n\n See also :c:member:`nir_tex_instr.sampler_index`."]
    pub fn nir_tex_instr_need_sampler(instr: *const nir_tex_instr) -> bool;
}
extern "C" {
    #[doc = " Returns the number of components returned by this nir_tex_instr\n\n Useful for code building texture instructions when you don't want to think\n about how many components a particular texture op returns.  This does not\n include the sparse residency code."]
    pub fn nir_tex_instr_result_size(instr: *const nir_tex_instr) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Returns true if this texture operation queries something about the texture\n rather than actually sampling it."]
    pub fn nir_tex_instr_is_query(instr: *const nir_tex_instr) -> bool;
}
extern "C" {
    #[doc = " Returns true if this texture instruction does implicit derivatives\n\n This is important as there are extra control-flow rules around derivatives\n and texture instructions which perform them implicitly."]
    pub fn nir_tex_instr_has_implicit_derivative(instr: *const nir_tex_instr) -> bool;
}
extern "C" {
    #[doc = " Returns the ALU type of the given texture instruction source"]
    pub fn nir_tex_instr_src_type(
        instr: *const nir_tex_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_alu_type;
}
extern "C" {
    #[doc = " Returns the number of components required by the given texture instruction\n source"]
    pub fn nir_tex_instr_src_size(
        instr: *const nir_tex_instr,
        src: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " Adds a source to a texture instruction"]
    pub fn nir_tex_instr_add_src(
        tex: *mut nir_tex_instr,
        src_type: nir_tex_src_type,
        src: *mut nir_def,
    );
}
extern "C" {
    #[doc = " Removes a source from a texture instruction"]
    pub fn nir_tex_instr_remove_src(tex: *mut nir_tex_instr, src_idx: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn nir_tex_instr_has_explicit_tg4_offsets(tex: *mut nir_tex_instr) -> bool;
}
#[repr(C)]
pub struct nir_load_const_instr {
    pub instr: nir_instr,
    pub def: nir_def,
    pub value: __IncompleteArrayField<nir_const_value>,
}
#[test]
fn bindgen_test_layout_nir_load_const_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_load_const_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_load_const_instr>(),
        64usize,
        concat!("Size of: ", stringify!(nir_load_const_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_load_const_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_load_const_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_const_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_const_instr),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_const_instr),
            "::",
            stringify!(value)
        )
    );
}
impl Default for nir_load_const_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_jump_type {
    #[doc = " Return from a function\n\n This instruction is a classic function return.  It jumps to\n nir_function_impl::end_block.  No return value is provided in this\n instruction.  Instead, the function is expected to write any return\n data to a deref passed in from the caller."]
    nir_jump_return = 0,
    #[doc = " Immediately exit the current shader\n\n This instruction is roughly the equivalent of C's \"exit()\" in that it\n immediately terminates the current shader invocation.  From a CFG\n perspective, it looks like a jump to nir_function_impl::end_block but\n it actually jumps to the end block of the shader entrypoint.  A halt\n instruction in the shader entrypoint itself is semantically identical\n to a return.\n\n For shaders with built-in I/O, any outputs written prior to a halt\n instruction remain written and any outputs not written prior to the\n halt have undefined values.  It does NOT cause an implicit discard of\n written results.  If one wants discard results in a fragment shader,\n for instance, a discard or demote intrinsic is required."]
    nir_jump_halt = 1,
    #[doc = " Break out of the inner-most loop\n\n This has the same semantics as C's \"break\" statement."]
    nir_jump_break = 2,
    #[doc = " Jump back to the top of the inner-most loop\n\n This has the same semantics as C's \"continue\" statement assuming that a\n NIR loop is implemented as \"while (1) { body }\"."]
    nir_jump_continue = 3,
    #[doc = " Jumps for unstructured CFG.\n\n As within an unstructured CFG we can't rely on block ordering we need to\n place explicit jumps at the end of every block."]
    nir_jump_goto = 4,
    #[doc = " Jumps for unstructured CFG.\n\n As within an unstructured CFG we can't rely on block ordering we need to\n place explicit jumps at the end of every block."]
    nir_jump_goto_if = 5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_jump_instr {
    pub instr: nir_instr,
    pub type_: nir_jump_type,
    pub condition: nir_src,
    pub target: *mut nir_block,
    pub else_target: *mut nir_block,
}
#[test]
fn bindgen_test_layout_nir_jump_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_jump_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_jump_instr>(),
        88usize,
        concat!("Size of: ", stringify!(nir_jump_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_jump_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_jump_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_jump_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_jump_instr),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).condition) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_jump_instr),
            "::",
            stringify!(condition)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).target) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_jump_instr),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).else_target) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_jump_instr),
            "::",
            stringify!(else_target)
        )
    );
}
impl Default for nir_jump_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_undef_instr {
    pub instr: nir_instr,
    pub def: nir_def,
}
#[test]
fn bindgen_test_layout_nir_undef_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_undef_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_undef_instr>(),
        64usize,
        concat!("Size of: ", stringify!(nir_undef_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_undef_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_undef_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_undef_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_undef_instr),
            "::",
            stringify!(def)
        )
    );
}
impl Default for nir_undef_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_phi_src {
    pub node: exec_node,
    pub pred: *mut nir_block,
    pub src: nir_src,
}
#[test]
fn bindgen_test_layout_nir_phi_src() {
    const UNINIT: ::std::mem::MaybeUninit<nir_phi_src> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_phi_src>(),
        56usize,
        concat!("Size of: ", stringify!(nir_phi_src))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_phi_src>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_phi_src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_phi_src),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pred) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_phi_src),
            "::",
            stringify!(pred)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_phi_src),
            "::",
            stringify!(src)
        )
    );
}
impl Default for nir_phi_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_phi_instr {
    pub instr: nir_instr,
    #[doc = " list of nir_phi_src"]
    pub srcs: exec_list,
    pub def: nir_def,
}
#[test]
fn bindgen_test_layout_nir_phi_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_phi_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_phi_instr>(),
        96usize,
        concat!("Size of: ", stringify!(nir_phi_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_phi_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_phi_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_phi_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).srcs) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_phi_instr),
            "::",
            stringify!(srcs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_phi_instr),
            "::",
            stringify!(def)
        )
    );
}
impl Default for nir_phi_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_parallel_copy_instr {
    pub instr: nir_instr,
    pub entries: exec_list,
}
#[test]
fn bindgen_test_layout_nir_parallel_copy_instr() {
    const UNINIT: ::std::mem::MaybeUninit<nir_parallel_copy_instr> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_parallel_copy_instr>(),
        64usize,
        concat!("Size of: ", stringify!(nir_parallel_copy_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_parallel_copy_instr>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_parallel_copy_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_parallel_copy_instr),
            "::",
            stringify!(instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_parallel_copy_instr),
            "::",
            stringify!(entries)
        )
    );
}
impl Default for nir_parallel_copy_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_scalar {
    pub def: *mut nir_def,
    pub comp: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_scalar() {
    const UNINIT: ::std::mem::MaybeUninit<nir_scalar> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_scalar>(),
        16usize,
        concat!("Size of: ", stringify!(nir_scalar))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_scalar>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_scalar))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_scalar),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).comp) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_scalar),
            "::",
            stringify!(comp)
        )
    );
}
impl Default for nir_scalar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_scalar_chase_movs(s: nir_scalar) -> nir_scalar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_binding {
    pub success: bool,
    pub var: *mut nir_variable,
    pub desc_set: ::std::os::raw::c_uint,
    pub binding: ::std::os::raw::c_uint,
    pub num_indices: ::std::os::raw::c_uint,
    pub indices: [nir_src; 4usize],
    pub read_first_invocation: bool,
}
#[test]
fn bindgen_test_layout_nir_binding() {
    const UNINIT: ::std::mem::MaybeUninit<nir_binding> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_binding>(),
        168usize,
        concat!("Size of: ", stringify!(nir_binding))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_binding>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_binding))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).success) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(success)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).var) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).desc_set) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(desc_set)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).binding) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(binding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_indices) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(num_indices)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).indices) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(indices)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_first_invocation) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_binding),
            "::",
            stringify!(read_first_invocation)
        )
    );
}
impl Default for nir_binding {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_chase_binding(rsrc: nir_src) -> nir_binding;
}
extern "C" {
    pub fn nir_get_binding_variable(
        shader: *mut nir_shader,
        binding: nir_binding,
    ) -> *mut nir_variable;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_cf_node_type {
    nir_cf_node_block = 0,
    nir_cf_node_if = 1,
    nir_cf_node_loop = 2,
    nir_cf_node_function = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_cf_node {
    pub node: exec_node,
    pub type_: nir_cf_node_type,
    pub parent: *mut nir_cf_node,
}
#[test]
fn bindgen_test_layout_nir_cf_node() {
    const UNINIT: ::std::mem::MaybeUninit<nir_cf_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_cf_node>(),
        32usize,
        concat!("Size of: ", stringify!(nir_cf_node))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_cf_node>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_cf_node))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_cf_node),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_cf_node),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_cf_node),
            "::",
            stringify!(parent)
        )
    );
}
impl Default for nir_cf_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_block {
    pub cf_node: nir_cf_node,
    #[doc = " list of nir_instr"]
    pub instr_list: exec_list,
    #[doc = " generic block index; generated by nir_index_blocks"]
    pub index: ::std::os::raw::c_uint,
    pub divergent: bool,
    pub successors: [*mut nir_block; 2usize],
    pub predecessors: *mut set,
    pub imm_dom: *mut nir_block,
    pub num_dom_children: ::std::os::raw::c_uint,
    pub dom_children: *mut *mut nir_block,
    pub dom_frontier: *mut set,
    pub dom_pre_index: u32,
    pub dom_post_index: u32,
    #[doc = " Value just before the first nir_instr->index in the block, but after\n end_ip that of any predecessor block."]
    pub start_ip: u32,
    #[doc = " Value just after the last nir_instr->index in the block, but before the\n start_ip of any successor block."]
    pub end_ip: u32,
    pub live_in: *mut ::std::os::raw::c_uint,
    pub live_out: *mut ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_block() {
    const UNINIT: ::std::mem::MaybeUninit<nir_block> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_block>(),
        160usize,
        concat!("Size of: ", stringify!(nir_block))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_block>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_block))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cf_node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(cf_node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr_list) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(instr_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).divergent) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(divergent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).successors) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(successors)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).predecessors) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(predecessors)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imm_dom) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(imm_dom)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_dom_children) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(num_dom_children)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dom_children) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(dom_children)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dom_frontier) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(dom_frontier)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dom_pre_index) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(dom_pre_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dom_post_index) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(dom_post_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_ip) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(start_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_ip) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(end_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).live_in) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(live_in)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).live_out) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_block),
            "::",
            stringify!(live_out)
        )
    );
}
impl Default for nir_block {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_selection_control {
    nir_selection_control_none = 0,
    #[doc = " Defined by SPIR-V spec 3.22 \"Selection Control\".\n The application prefers to remove control flow."]
    nir_selection_control_flatten = 1,
    #[doc = " Defined by SPIR-V spec 3.22 \"Selection Control\".\n The application prefers to keep control flow."]
    nir_selection_control_dont_flatten = 2,
    #[doc = " May be applied by the compiler stack when it knows\n that a branch is divergent, and:\n - either both the if and else are always taken\n - the if or else is empty and the other is always taken"]
    nir_selection_control_divergent_always_taken = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_if {
    pub cf_node: nir_cf_node,
    pub condition: nir_src,
    pub control: nir_selection_control,
    #[doc = " list of nir_cf_node"]
    pub then_list: exec_list,
    #[doc = " list of nir_cf_node"]
    pub else_list: exec_list,
}
#[test]
fn bindgen_test_layout_nir_if() {
    const UNINIT: ::std::mem::MaybeUninit<nir_if> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_if>(),
        136usize,
        concat!("Size of: ", stringify!(nir_if))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_if>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_if))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cf_node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_if),
            "::",
            stringify!(cf_node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).condition) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_if),
            "::",
            stringify!(condition)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).control) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_if),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).then_list) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_if),
            "::",
            stringify!(then_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).else_list) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_if),
            "::",
            stringify!(else_list)
        )
    );
}
impl Default for nir_if {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop_terminator {
    pub nif: *mut nir_if,
    #[doc = " Instruction that generates nif::condition."]
    pub conditional_instr: *mut nir_instr,
    #[doc = " Block within ::nif that has the break instruction."]
    pub break_block: *mut nir_block,
    #[doc = " Last block for the then- or else-path that does not contain the break."]
    pub continue_from_block: *mut nir_block,
    #[doc = " True when ::break_block is in the else-path of ::nif."]
    pub continue_from_then: bool,
    pub induction_rhs: bool,
    pub exact_trip_count_unknown: bool,
    pub loop_terminator_link: list_head,
}
#[test]
fn bindgen_test_layout_nir_loop_terminator() {
    const UNINIT: ::std::mem::MaybeUninit<nir_loop_terminator> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_loop_terminator>(),
        56usize,
        concat!("Size of: ", stringify!(nir_loop_terminator))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_loop_terminator>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_loop_terminator))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nif) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(nif)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).conditional_instr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(conditional_instr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).break_block) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(break_block)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).continue_from_block) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(continue_from_block)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).continue_from_then) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(continue_from_then)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).induction_rhs) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(induction_rhs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exact_trip_count_unknown) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(exact_trip_count_unknown)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).loop_terminator_link) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_terminator),
            "::",
            stringify!(loop_terminator_link)
        )
    );
}
impl Default for nir_loop_terminator {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop_induction_variable {
    pub def: *mut nir_def,
    pub init_src: *mut nir_src,
    pub update_src: *mut nir_alu_src,
}
#[test]
fn bindgen_test_layout_nir_loop_induction_variable() {
    const UNINIT: ::std::mem::MaybeUninit<nir_loop_induction_variable> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_loop_induction_variable>(),
        24usize,
        concat!("Size of: ", stringify!(nir_loop_induction_variable))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_loop_induction_variable>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_loop_induction_variable))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_induction_variable),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init_src) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_induction_variable),
            "::",
            stringify!(init_src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).update_src) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_induction_variable),
            "::",
            stringify!(update_src)
        )
    );
}
impl Default for nir_loop_induction_variable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop_info {
    pub instr_cost: ::std::os::raw::c_uint,
    pub has_soft_fp64: bool,
    pub guessed_trip_count: ::std::os::raw::c_uint,
    pub max_trip_count: ::std::os::raw::c_uint,
    pub exact_trip_count_known: bool,
    pub force_unroll: bool,
    pub complex_loop: bool,
    pub limiting_terminator: *mut nir_loop_terminator,
    pub loop_terminator_list: list_head,
    pub induction_vars: *mut nir_loop_induction_variable,
    pub num_induction_vars: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_loop_info() {
    const UNINIT: ::std::mem::MaybeUninit<nir_loop_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_loop_info>(),
        64usize,
        concat!("Size of: ", stringify!(nir_loop_info))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_loop_info>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_loop_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr_cost) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(instr_cost)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_soft_fp64) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(has_soft_fp64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).guessed_trip_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(guessed_trip_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_trip_count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(max_trip_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exact_trip_count_known) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(exact_trip_count_known)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).force_unroll) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(force_unroll)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).complex_loop) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(complex_loop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limiting_terminator) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(limiting_terminator)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).loop_terminator_list) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(loop_terminator_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).induction_vars) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(induction_vars)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_induction_vars) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop_info),
            "::",
            stringify!(num_induction_vars)
        )
    );
}
impl Default for nir_loop_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_loop_control {
    nir_loop_control_none = 0,
    nir_loop_control_unroll = 1,
    nir_loop_control_dont_unroll = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop {
    pub cf_node: nir_cf_node,
    #[doc = " list of nir_cf_node"]
    pub body: exec_list,
    #[doc = " (optional) list of nir_cf_node"]
    pub continue_list: exec_list,
    pub info: *mut nir_loop_info,
    pub control: nir_loop_control,
    pub partially_unrolled: bool,
    pub divergent: bool,
}
#[test]
fn bindgen_test_layout_nir_loop() {
    const UNINIT: ::std::mem::MaybeUninit<nir_loop> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_loop>(),
        112usize,
        concat!("Size of: ", stringify!(nir_loop))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_loop>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_loop))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cf_node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(cf_node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).body) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(body)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).continue_list) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(continue_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).control) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).partially_unrolled) as usize - ptr as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(partially_unrolled)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).divergent) as usize - ptr as usize },
        109usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_loop),
            "::",
            stringify!(divergent)
        )
    );
}
impl Default for nir_loop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(i32)]
#[doc = " Various bits of metadata that can may be created or required by\n optimization and analysis passes"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_metadata {
    nir_metadata_none = 0,
    #[doc = " Indicates that nir_block::index values are valid.\n\n The start block has index 0 and they increase through a natural walk of\n the CFG.  nir_function_impl::num_blocks is the number of blocks and\n every block index is in the range [0, nir_function_impl::num_blocks].\n\n A pass can preserve this metadata type if it doesn't touch the CFG."]
    nir_metadata_block_index = 1,
    #[doc = " Indicates that block dominance information is valid\n\n This includes:\n\n   - nir_block::num_dom_children\n   - nir_block::dom_children\n   - nir_block::dom_frontier\n   - nir_block::dom_pre_index\n   - nir_block::dom_post_index\n\n A pass can preserve this metadata type if it doesn't touch the CFG."]
    nir_metadata_dominance = 2,
    #[doc = " Indicates that SSA def data-flow liveness information is valid\n\n This includes:\n\n   - nir_block::live_in\n   - nir_block::live_out\n\n A pass can preserve this metadata type if it never adds or removes any\n SSA defs or uses of SSA defs (most passes shouldn't preserve this\n metadata type)."]
    nir_metadata_live_defs = 4,
    #[doc = " A dummy metadata value to track when a pass forgot to call\n nir_metadata_preserve.\n\n A pass should always clear this value even if it doesn't make any\n progress to indicate that it thought about preserving metadata."]
    nir_metadata_not_properly_reset = 8,
    #[doc = " Indicates that loop analysis information is valid.\n\n This includes everything pointed to by nir_loop::info.\n\n A pass can preserve this metadata type if it is guaranteed to not affect\n any loop metadata.  However, since loop metadata includes things like\n loop counts which depend on arithmetic in the loop, this is very hard to\n determine.  Most passes shouldn't preserve this metadata type."]
    nir_metadata_loop_analysis = 16,
    #[doc = " Indicates that nir_instr::index values are valid.\n\n The start instruction has index 0 and they increase through a natural\n walk of instructions in blocks in the CFG.  The indices my have holes\n after passes such as DCE.\n\n A pass can preserve this metadata type if it never adds or moves any\n instructions (most passes shouldn't preserve this metadata type), but\n can preserve it if it only removes instructions."]
    nir_metadata_instr_index = 32,
    #[doc = " All metadata\n\n This includes all nir_metadata flags except not_properly_reset.  Passes\n which do not change the shader in any way should call\n\n    nir_metadata_preserve(impl, nir_metadata_all);"]
    nir_metadata_all = -9,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_function_impl {
    pub cf_node: nir_cf_node,
    #[doc = " pointer to the function of which this is an implementation"]
    pub function: *mut nir_function,
    #[doc = " For entrypoints, a pointer to a nir_function_impl which runs before\n it, once per draw or dispatch, communicating via store_preamble and\n load_preamble intrinsics. If NULL then there is no preamble."]
    pub preamble: *mut nir_function,
    #[doc = " list of nir_cf_node"]
    pub body: exec_list,
    pub end_block: *mut nir_block,
    #[doc = " list for all local variables in the function"]
    pub locals: exec_list,
    #[doc = " next available SSA value index"]
    pub ssa_alloc: ::std::os::raw::c_uint,
    pub num_blocks: ::std::os::raw::c_uint,
    #[doc = " True if this nir_function_impl uses structured control-flow\n\n Structured nir_function_impls have different validation rules."]
    pub structured: bool,
    pub valid_metadata: nir_metadata,
}
#[test]
fn bindgen_test_layout_nir_function_impl() {
    const UNINIT: ::std::mem::MaybeUninit<nir_function_impl> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_function_impl>(),
        136usize,
        concat!("Size of: ", stringify!(nir_function_impl))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_function_impl>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_function_impl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cf_node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(cf_node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).function) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preamble) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(preamble)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).body) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(body)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_block) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(end_block)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).locals) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(locals)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssa_alloc) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(ssa_alloc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_blocks) as usize - ptr as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(num_blocks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).structured) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(structured)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).valid_metadata) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function_impl),
            "::",
            stringify!(valid_metadata)
        )
    );
}
impl Default for nir_function_impl {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_parameter {
    pub num_components: u8,
    pub bit_size: u8,
    pub is_return: bool,
    pub type_: *const glsl_type,
}
#[test]
fn bindgen_test_layout_nir_parameter() {
    const UNINIT: ::std::mem::MaybeUninit<nir_parameter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_parameter>(),
        16usize,
        concat!("Size of: ", stringify!(nir_parameter))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_parameter>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_parameter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_components) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_parameter),
            "::",
            stringify!(num_components)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_size) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_parameter),
            "::",
            stringify!(bit_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_return) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_parameter),
            "::",
            stringify!(is_return)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_parameter),
            "::",
            stringify!(type_)
        )
    );
}
impl Default for nir_parameter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_function {
    pub node: exec_node,
    pub name: *const ::std::os::raw::c_char,
    pub shader: *mut nir_shader,
    pub num_params: ::std::os::raw::c_uint,
    pub params: *mut nir_parameter,
    #[doc = " The implementation of this function.\n\n If the function is only declared and not implemented, this is NULL.\n\n Unless setting to NULL or NIR_SERIALIZE_FUNC_HAS_IMPL, set with\n nir_function_set_impl to maintain IR invariants."]
    pub impl_: *mut nir_function_impl,
    pub is_entrypoint: bool,
    pub is_exported: bool,
    pub is_preamble: bool,
    pub should_inline: bool,
    pub dont_inline: bool,
    #[doc = " Is this function a subroutine type declaration\n e.g. subroutine void type1(float arg1);"]
    pub is_subroutine: bool,
    #[doc = " Is this function associated to a subroutine type\n e.g. subroutine (type1, type2) function_name { function_body };\n would have num_subroutine_types 2,\n and pointers to the type1 and type2 types."]
    pub num_subroutine_types: ::std::os::raw::c_int,
    pub subroutine_types: *mut *const glsl_type,
    pub subroutine_index: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_nir_function() {
    const UNINIT: ::std::mem::MaybeUninit<nir_function> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_function>(),
        88usize,
        concat!("Size of: ", stringify!(nir_function))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_function>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_function))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shader) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(shader)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_params) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(num_params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).impl_) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(impl_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_entrypoint) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(is_entrypoint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_exported) as usize - ptr as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(is_exported)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_preamble) as usize - ptr as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(is_preamble)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).should_inline) as usize - ptr as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(should_inline)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dont_inline) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(dont_inline)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_subroutine) as usize - ptr as usize },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(is_subroutine)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_subroutine_types) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(num_subroutine_types)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subroutine_types) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(subroutine_types)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subroutine_index) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_function),
            "::",
            stringify!(subroutine_index)
        )
    );
}
impl Default for nir_function {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_lower_int64_options {
    pub const nir_lower_imul64: nir_lower_int64_options = nir_lower_int64_options(1);
}
impl nir_lower_int64_options {
    pub const nir_lower_isign64: nir_lower_int64_options = nir_lower_int64_options(2);
}
impl nir_lower_int64_options {
    #[doc = " Lower all int64 modulus and division opcodes"]
    pub const nir_lower_divmod64: nir_lower_int64_options = nir_lower_int64_options(4);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_imul_high64: nir_lower_int64_options = nir_lower_int64_options(8);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_bcsel64: nir_lower_int64_options = nir_lower_int64_options(16);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_icmp64: nir_lower_int64_options = nir_lower_int64_options(32);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iadd64: nir_lower_int64_options = nir_lower_int64_options(64);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iabs64: nir_lower_int64_options = nir_lower_int64_options(128);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_ineg64: nir_lower_int64_options = nir_lower_int64_options(256);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_logic64: nir_lower_int64_options = nir_lower_int64_options(512);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_minmax64: nir_lower_int64_options = nir_lower_int64_options(1024);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_shift64: nir_lower_int64_options = nir_lower_int64_options(2048);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_imul_2x32_64: nir_lower_int64_options = nir_lower_int64_options(4096);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_extract64: nir_lower_int64_options = nir_lower_int64_options(8192);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_ufind_msb64: nir_lower_int64_options = nir_lower_int64_options(16384);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_bit_count64: nir_lower_int64_options = nir_lower_int64_options(32768);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_subgroup_shuffle64: nir_lower_int64_options =
        nir_lower_int64_options(65536);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_scan_reduce_bitwise64: nir_lower_int64_options =
        nir_lower_int64_options(131072);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_scan_reduce_iadd64: nir_lower_int64_options =
        nir_lower_int64_options(262144);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_vote_ieq64: nir_lower_int64_options = nir_lower_int64_options(524288);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_usub_sat64: nir_lower_int64_options = nir_lower_int64_options(1048576);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iadd_sat64: nir_lower_int64_options = nir_lower_int64_options(2097152);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_find_lsb64: nir_lower_int64_options = nir_lower_int64_options(4194304);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_conv64: nir_lower_int64_options = nir_lower_int64_options(8388608);
}
impl ::std::ops::BitOr<nir_lower_int64_options> for nir_lower_int64_options {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        nir_lower_int64_options(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for nir_lower_int64_options {
    #[inline]
    fn bitor_assign(&mut self, rhs: nir_lower_int64_options) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<nir_lower_int64_options> for nir_lower_int64_options {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        nir_lower_int64_options(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for nir_lower_int64_options {
    #[inline]
    fn bitand_assign(&mut self, rhs: nir_lower_int64_options) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_int64_options(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_doubles_options {
    nir_lower_drcp = 1,
    nir_lower_dsqrt = 2,
    nir_lower_drsq = 4,
    nir_lower_dtrunc = 8,
    nir_lower_dfloor = 16,
    nir_lower_dceil = 32,
    nir_lower_dfract = 64,
    nir_lower_dround_even = 128,
    nir_lower_dmod = 256,
    nir_lower_dsub = 512,
    nir_lower_ddiv = 1024,
    nir_lower_dsign = 2048,
    nir_lower_dminmax = 4096,
    nir_lower_dsat = 8192,
    nir_lower_fp64_full_software = 16384,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_divergence_options {
    nir_divergence_single_prim_per_subgroup = 1,
    nir_divergence_single_patch_per_tcs_subgroup = 2,
    nir_divergence_single_patch_per_tes_subgroup = 4,
    nir_divergence_view_index_uniform = 8,
    nir_divergence_single_frag_shading_rate_per_subgroup = 16,
    nir_divergence_multiple_workgroup_per_compute_subgroup = 32,
    nir_divergence_shader_record_ptr_uniform = 64,
    nir_divergence_uniform_load_tears = 128,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_io_options {
    #[doc = " Whether a fragment shader can interpolate the same input multiple times\n with different modes (smooth, noperspective) and locations (pixel,\n centroid, sample, at_offset, at_sample), excluding the flat mode.\n\n This matches AMD GPU flexibility and limitations and is a superset of\n the GL4 requirement that each input can be interpolated at its specified\n location, and then also as centroid, at_offset, and at_sample."]
    nir_io_has_flexible_input_interpolation_except_flat = 1,
    #[doc = " nir_opt_varyings compacts (relocates) components of varyings by\n rewriting their locations completely, effectively moving components of\n varyings between slots. This option forces nir_opt_varyings to make\n VARYING_SLOT_POS unused by moving its contents to VARn if the consumer\n is not FS. If this option is not set and POS is unused, it moves\n components of VARn to POS until it's fully used."]
    nir_io_dont_use_pos_for_non_fs_varyings = 2,
    #[doc = " nir_opt_varyings compacts (relocates) components of varyings by\n rewriting their locations completely, effectively moving components of\n varyings between slots. This option forces nir_opt_varyings to make\n VARYING_SLOT_POS unused by moving its contents to VARn if the consumer\n is not FS. If this option is not set and POS is unused, it moves\n components of VARn to POS until it's fully used."]
    nir_io_16bit_input_output_support = 4,
    #[doc = " Lower load_deref/store_deref to load_input/store_output/etc. intrinsics.\n This is only affects GLSL compilation."]
    nir_io_glsl_lower_derefs = 65536,
    #[doc = " Run nir_opt_varyings in the GLSL linker. If false, optimize varyings\n the old way and lower IO later.\n\n nir_io_lower_to_intrinsics must be set for this to take effect.\n\n TODO: remove this and default to enabled once we are sure that this\n codepath is solid."]
    nir_io_glsl_opt_varyings = 131072,
}
#[doc = " An instruction filtering callback\n\n Returns true if the instruction should be processed and false otherwise."]
pub type nir_instr_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const nir_instr, arg2: *const ::std::os::raw::c_void) -> bool,
>;
#[doc = " A vectorization width callback\n\n Returns the maximum vectorization width per instruction.\n 0, if the instruction must not be modified.\n\n The vectorization width must be a power of 2."]
pub type nir_vectorize_cb = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const nir_instr, arg2: *const ::std::os::raw::c_void) -> u8,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_shader_compiler_options {
    pub lower_fdiv: bool,
    pub lower_ffma16: bool,
    pub lower_ffma32: bool,
    pub lower_ffma64: bool,
    pub fuse_ffma16: bool,
    pub fuse_ffma32: bool,
    pub fuse_ffma64: bool,
    pub lower_flrp16: bool,
    pub lower_flrp32: bool,
    #[doc = " Lowers flrp when it does not support doubles"]
    pub lower_flrp64: bool,
    pub lower_fpow: bool,
    pub lower_fsat: bool,
    pub lower_fsqrt: bool,
    pub lower_sincos: bool,
    pub lower_fmod: bool,
    #[doc = " Lowers ibitfield_extract/ubitfield_extract."]
    pub lower_bitfield_extract: bool,
    #[doc = " Lowers bitfield_insert."]
    pub lower_bitfield_insert: bool,
    #[doc = " Lowers bitfield_reverse to shifts."]
    pub lower_bitfield_reverse: bool,
    #[doc = " Lowers bit_count to shifts."]
    pub lower_bit_count: bool,
    #[doc = " Lowers ifind_msb."]
    pub lower_ifind_msb: bool,
    #[doc = " Lowers ufind_msb."]
    pub lower_ufind_msb: bool,
    #[doc = " Lowers find_lsb to ufind_msb and logic ops"]
    pub lower_find_lsb: bool,
    pub lower_uadd_carry: bool,
    pub lower_usub_borrow: bool,
    #[doc = " Lowers imul_high/umul_high to 16-bit multiplies and carry operations."]
    pub lower_mul_high: bool,
    #[doc = " lowers fneg to fmul(x, -1.0). Driver must call nir_opt_algebraic_late()"]
    pub lower_fneg: bool,
    #[doc = " lowers ineg to isub. Driver must call nir_opt_algebraic_late()."]
    pub lower_ineg: bool,
    #[doc = " lowers fisnormal to alu ops."]
    pub lower_fisnormal: bool,
    pub lower_scmp: bool,
    pub lower_vector_cmp: bool,
    #[doc = " enable rules to avoid bit ops"]
    pub lower_bitops: bool,
    #[doc = " enables rules to lower isign to imin+imax"]
    pub lower_isign: bool,
    #[doc = " enables rules to lower fsign to fsub and flt"]
    pub lower_fsign: bool,
    #[doc = " enables rules to lower iabs to ineg+imax"]
    pub lower_iabs: bool,
    #[doc = " enable rules that avoid generating umax from signed integer ops"]
    pub lower_umax: bool,
    #[doc = " enable rules that avoid generating umin from signed integer ops"]
    pub lower_umin: bool,
    pub lower_fdph: bool,
    #[doc = " lower fdot to fmul and fsum/fadd."]
    pub lower_fdot: bool,
    pub fdot_replicates: bool,
    #[doc = " lowers ffloor to fsub+ffract:"]
    pub lower_ffloor: bool,
    #[doc = " lowers ffract to fsub+ffloor:"]
    pub lower_ffract: bool,
    #[doc = " lowers fceil to fneg+ffloor+fneg:"]
    pub lower_fceil: bool,
    pub lower_ftrunc: bool,
    #[doc = " Lowers fround_even to ffract+feq+csel.\n\n Not correct in that it doesn't correctly handle the \"_even\" part of the\n rounding, but good enough for DX9 array indexing handling on DX9-class\n hardware."]
    pub lower_fround_even: bool,
    pub lower_ldexp: bool,
    pub lower_pack_half_2x16: bool,
    pub lower_pack_unorm_2x16: bool,
    pub lower_pack_snorm_2x16: bool,
    pub lower_pack_unorm_4x8: bool,
    pub lower_pack_snorm_4x8: bool,
    pub lower_pack_64_2x32: bool,
    pub lower_pack_64_4x16: bool,
    pub lower_pack_32_2x16: bool,
    pub lower_pack_64_2x32_split: bool,
    pub lower_pack_32_2x16_split: bool,
    pub lower_unpack_half_2x16: bool,
    pub lower_unpack_unorm_2x16: bool,
    pub lower_unpack_snorm_2x16: bool,
    pub lower_unpack_unorm_4x8: bool,
    pub lower_unpack_snorm_4x8: bool,
    pub lower_unpack_64_2x32_split: bool,
    pub lower_unpack_32_2x16_split: bool,
    pub lower_pack_split: bool,
    pub lower_extract_byte: bool,
    pub lower_extract_word: bool,
    pub lower_insert_byte: bool,
    pub lower_insert_word: bool,
    pub lower_all_io_to_temps: bool,
    pub lower_all_io_to_elements: bool,
    pub vertex_id_zero_based: bool,
    #[doc = " If enabled, gl_BaseVertex will be lowered as:\n is_indexed_draw (~0/0) & firstvertex"]
    pub lower_base_vertex: bool,
    #[doc = " If enabled, gl_HelperInvocation will be lowered as:\n\n   !((1 << sample_id) & sample_mask_in))\n\n This depends on some possibly hw implementation details, which may\n not be true for all hw.  In particular that the FS is only executed\n for covered samples or for helper invocations.  So, do not blindly\n enable this option.\n\n Note: See also issue #22 in ARB_shader_image_load_store"]
    pub lower_helper_invocation: bool,
    #[doc = " Convert gl_SampleMaskIn to gl_HelperInvocation as follows:\n\n   gl_SampleMaskIn == 0 ---> gl_HelperInvocation\n   gl_SampleMaskIn != 0 ---> !gl_HelperInvocation"]
    pub optimize_sample_mask_in: bool,
    #[doc = " Optimize boolean reductions of quad broadcasts. This should only be enabled if\n nir_intrinsic_reduce supports INCLUDE_HELPERS."]
    pub optimize_quad_vote_to_reduce: bool,
    pub lower_cs_local_index_to_id: bool,
    pub lower_cs_local_id_to_index: bool,
    pub has_cs_global_id: bool,
    pub lower_device_index_to_zero: bool,
    pub lower_wpos_pntc: bool,
    #[doc = " Set if nir_op_[iu]hadd and nir_op_[iu]rhadd instructions should be\n lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions.\n\n :c:member:`lower_hadd64`"]
    pub lower_hadd: bool,
    #[doc = " Set if only 64-bit nir_op_[iu]hadd and nir_op_[iu]rhadd instructions\n should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to only 64-bit\n versions of these instructions.\n\n :c:member:`lower_hadd`"]
    pub lower_hadd64: bool,
    #[doc = " Set if nir_op_uadd_sat should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_uadd_sat: bool,
    #[doc = " Set if nir_op_usub_sat should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_usub_sat: bool,
    #[doc = " Set if nir_op_iadd_sat and nir_op_isub_sat should be lowered to simple\n arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_iadd_sat: bool,
    #[doc = " Set if imul_32x16 and umul_32x16 should be lowered to simple\n arithmetic."]
    pub lower_mul_32x16: bool,
    #[doc = " Should IO be re-vectorized?  Some scalar ISAs still operate on vec4's\n for IO purposes and would prefer loads/stores be vectorized."]
    pub vectorize_io: bool,
    pub vectorize_tess_levels: bool,
    pub lower_to_scalar: bool,
    pub lower_to_scalar_filter: nir_instr_filter_cb,
    #[doc = " Disables potentially harmful algebraic transformations for architectures\n with SIMD-within-a-register semantics.\n\n Note, to actually vectorize 16bit instructions, use nir_opt_vectorize()\n with a suitable callback function."]
    pub vectorize_vec2_16bit: bool,
    #[doc = " Should the linker unify inputs_read/outputs_written between adjacent\n shader stages which are linked into a single program?"]
    pub unify_interfaces: bool,
    #[doc = " Should nir_lower_io() create load_interpolated_input intrinsics?\n\n If not, it generates regular load_input intrinsics and interpolation\n information must be inferred from the list of input nir_variables."]
    pub use_interpolated_input_intrinsics: bool,
    #[doc = " Whether nir_lower_io() will lower interpolateAt functions to\n load_interpolated_input intrinsics.\n\n Unlike use_interpolated_input_intrinsics this will only lower these\n functions and leave input load intrinsics untouched."]
    pub lower_interpolate_at: bool,
    pub lower_mul_2x32_64: bool,
    pub has_rotate8: bool,
    pub has_rotate16: bool,
    pub has_rotate32: bool,
    #[doc = " Backend supports shfr"]
    pub has_shfr32: bool,
    #[doc = " Backend supports ternary addition"]
    pub has_iadd3: bool,
    #[doc = " Backend supports imul24, and would like to use it (when possible)\n for address/offset calculation.  If true, driver should call\n nir_lower_amul().  (If not set, amul will automatically be lowered\n to imul.)"]
    pub has_imul24: bool,
    #[doc = " Backend supports umul24, if not set  umul24 will automatically be lowered\n to imul with masked inputs"]
    pub has_umul24: bool,
    #[doc = " Backend supports 32-bit imad"]
    pub has_imad32: bool,
    #[doc = " Backend supports umad24, if not set  umad24 will automatically be lowered\n to imul with masked inputs and iadd"]
    pub has_umad24: bool,
    pub has_fused_comp_and_csel: bool,
    #[doc = " Backend supports fsub, if not set fsub will automatically be lowered to\n fadd(x, fneg(y)). If true, driver should call nir_opt_algebraic_late()."]
    pub has_fsub: bool,
    #[doc = " Backend supports isub, if not set isub will automatically be lowered to\n iadd(x, ineg(y)). If true, driver should call nir_opt_algebraic_late()."]
    pub has_isub: bool,
    #[doc = " Backend supports pack_32_4x8 or pack_32_4x8_split."]
    pub has_pack_32_4x8: bool,
    #[doc = " Backend supports nir_load_texture_scale and prefers it over txs for nir\n lowerings."]
    pub has_texture_scaling: bool,
    #[doc = " Backend supports sdot_4x8_iadd."]
    pub has_sdot_4x8: bool,
    #[doc = " Backend supports udot_4x8_uadd."]
    pub has_udot_4x8: bool,
    #[doc = " Backend supports sudot_4x8_iadd."]
    pub has_sudot_4x8: bool,
    #[doc = " Backend supports sdot_4x8_iadd_sat."]
    pub has_sdot_4x8_sat: bool,
    #[doc = " Backend supports udot_4x8_uadd_sat."]
    pub has_udot_4x8_sat: bool,
    #[doc = " Backend supports sudot_4x8_iadd_sat."]
    pub has_sudot_4x8_sat: bool,
    #[doc = " Backend supports sdot_2x16 and udot_2x16 opcodes."]
    pub has_dot_2x16: bool,
    #[doc = " Backend supports fmulz (and ffmaz if lower_ffma32=false)"]
    pub has_fmulz: bool,
    #[doc = " Backend supports fmulz (and ffmaz if lower_ffma32=false) but only if\n FLOAT_CONTROLS_DENORM_PRESERVE_FP32 is not set"]
    pub has_fmulz_no_denorms: bool,
    #[doc = " Backend supports 32bit ufind_msb_rev and ifind_msb_rev."]
    pub has_find_msb_rev: bool,
    #[doc = " Backend supports pack_half_2x16_rtz_split."]
    pub has_pack_half_2x16_rtz: bool,
    #[doc = " Backend supports bitz/bitnz."]
    pub has_bit_test: bool,
    #[doc = " Backend supports ubfe/ibfe."]
    pub has_bfe: bool,
    #[doc = " Backend supports bfm."]
    pub has_bfm: bool,
    #[doc = " Backend supports bfi."]
    pub has_bfi: bool,
    #[doc = " Backend supports bitfield_select."]
    pub has_bitfield_select: bool,
    #[doc = " Backend supports uclz."]
    pub has_uclz: bool,
    #[doc = " Backend support msad_u4x8."]
    pub has_msad: bool,
    #[doc = " Is this the Intel vec4 backend?\n\n Used to inhibit algebraic optimizations that are known to be harmful on\n the Intel vec4 backend.  This is generally applicable to any\n optimization that might cause more immediate values to be used in\n 3-source (e.g., ffma and flrp) instructions."]
    pub intel_vec4: bool,
    #[doc = " For most Intel GPUs, all ternary operations such as FMA and BFE cannot\n have immediates, so two to three instructions may eventually be needed."]
    pub avoid_ternary_with_two_constants: bool,
    #[doc = " Whether 8-bit ALU is supported."]
    pub support_8bit_alu: bool,
    #[doc = " Whether 16-bit ALU is supported."]
    pub support_16bit_alu: bool,
    pub max_unroll_iterations: ::std::os::raw::c_uint,
    pub max_unroll_iterations_aggressive: ::std::os::raw::c_uint,
    pub max_unroll_iterations_fp64: ::std::os::raw::c_uint,
    pub lower_uniforms_to_ubo: bool,
    pub linker_ignore_precision: bool,
    pub force_indirect_unrolling_sampler: bool,
    pub no_integers: bool,
    #[doc = " Specifies which type of indirectly accessed variables should force\n loop unrolling."]
    pub force_indirect_unrolling: nir_variable_mode,
    pub driver_functions: bool,
    pub lower_int64_options: nir_lower_int64_options,
    pub lower_doubles_options: nir_lower_doubles_options,
    pub divergence_analysis_options: nir_divergence_options,
    #[doc = " The masks of shader stages that support indirect indexing with\n load_input and store_output intrinsics. It's used by\n nir_lower_io_passes."]
    pub support_indirect_inputs: u8,
    pub support_indirect_outputs: u8,
    #[doc = " Remove varying loaded from uniform, let fragment shader load the\n uniform directly. GPU passing varying by memory can benifit from it\n for sure; but GPU passing varying by on chip resource may not.\n Because it saves on chip resource but may increase memory pressure when\n fragment task is far more than vertex one, so better left it disabled."]
    pub lower_varying_from_uniform: bool,
    #[doc = " store the variable offset into the instrinsic range_base instead\n  of adding it to the image index."]
    pub lower_image_offset_to_range_base: bool,
    #[doc = " store the variable offset into the instrinsic range_base instead\n  of adding it to the atomic source"]
    pub lower_atomic_offset_to_range_base: bool,
    #[doc = " Don't convert medium-precision casts (e.g. f2fmp) into concrete\n  type casts (e.g. f2f16)."]
    pub preserve_mediump: bool,
    #[doc = " lowers fquantize2f16 to alu ops."]
    pub lower_fquantize2f16: bool,
    #[doc = " Lower f2f16 to f2f16_rtz when execution mode is not rtne."]
    pub force_f2f16_rtz: bool,
    #[doc = " Lower VARYING_SLOT_LAYER in FS to SYSTEM_VALUE_LAYER_ID."]
    pub lower_layer_fs_input_to_sysval: bool,
    #[doc = " clip/cull distance and tess level arrays use compact semantics"]
    pub compact_arrays: bool,
    #[doc = " Options determining lowering and behavior of inputs and outputs."]
    pub io_options: nir_io_options,
    #[doc = " Driver callback where drivers can define how to lower mediump.\n  Used by nir_lower_io_passes."]
    pub lower_mediump_io: ::std::option::Option<unsafe extern "C" fn(nir: *mut nir_shader)>,
    #[doc = " Return the maximum cost of an expression that's written to a shader\n output that can be moved into the next shader to remove that output.\n\n Currently only uniform expressions are moved. A uniform expression is\n any ALU expression sourcing only constants, uniforms, and UBO loads.\n\n Set to NULL or return 0 if you only want to propagate constants from\n outputs to inputs.\n\n Drivers can set the maximum cost based on the types of consecutive\n shaders or shader SHA1s.\n\n Drivers should also set \"varying_estimate_instr_cost\"."]
    pub varying_expression_max_cost: ::std::option::Option<
        unsafe extern "C" fn(
            consumer: *mut nir_shader,
            producer: *mut nir_shader,
        ) -> ::std::os::raw::c_uint,
    >,
    #[doc = " Return the cost of an instruction that could be moved into the next\n shader. If the cost of all instructions in an expression is <=\n varying_expression_max_cost(), the instruction is moved."]
    pub varying_estimate_instr_cost: ::std::option::Option<
        unsafe extern "C" fn(instr: *mut nir_instr) -> ::std::os::raw::c_uint,
    >,
}
#[test]
fn bindgen_test_layout_nir_shader_compiler_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_shader_compiler_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_shader_compiler_options>(),
        216usize,
        concat!("Size of: ", stringify!(nir_shader_compiler_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_shader_compiler_options>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_shader_compiler_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fdiv) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fdiv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ffma16) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ffma16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ffma32) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ffma32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ffma64) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ffma64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fuse_ffma16) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(fuse_ffma16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fuse_ffma32) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(fuse_ffma32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fuse_ffma64) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(fuse_ffma64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_flrp16) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_flrp16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_flrp32) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_flrp32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_flrp64) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_flrp64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fpow) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fpow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fsat) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fsat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fsqrt) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fsqrt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_sincos) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_sincos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fmod) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fmod)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_bitfield_extract) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_bitfield_extract)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_bitfield_insert) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_bitfield_insert)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_bitfield_reverse) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_bitfield_reverse)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_bit_count) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_bit_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ifind_msb) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ifind_msb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ufind_msb) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ufind_msb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_find_lsb) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_find_lsb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_uadd_carry) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_uadd_carry)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_usub_borrow) as usize - ptr as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_usub_borrow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_mul_high) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_mul_high)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fneg) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fneg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ineg) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ineg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fisnormal) as usize - ptr as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fisnormal)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_scmp) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_scmp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_vector_cmp) as usize - ptr as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_vector_cmp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_bitops) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_bitops)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_isign) as usize - ptr as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_isign)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fsign) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fsign)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_iabs) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_iabs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_umax) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_umax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_umin) as usize - ptr as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_umin)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fdph) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fdph)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fdot) as usize - ptr as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fdot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fdot_replicates) as usize - ptr as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(fdot_replicates)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ffloor) as usize - ptr as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ffloor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ffract) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ffract)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fceil) as usize - ptr as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fceil)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ftrunc) as usize - ptr as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ftrunc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fround_even) as usize - ptr as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fround_even)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ldexp) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_ldexp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_half_2x16) as usize - ptr as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_half_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_unorm_2x16) as usize - ptr as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_unorm_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_snorm_2x16) as usize - ptr as usize },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_snorm_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_unorm_4x8) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_unorm_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_snorm_4x8) as usize - ptr as usize },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_snorm_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_64_2x32) as usize - ptr as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_64_2x32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_64_4x16) as usize - ptr as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_64_4x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_32_2x16) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_32_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_64_2x32_split) as usize - ptr as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_64_2x32_split)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_32_2x16_split) as usize - ptr as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_32_2x16_split)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_half_2x16) as usize - ptr as usize },
        55usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_half_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_unorm_2x16) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_unorm_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_snorm_2x16) as usize - ptr as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_snorm_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_unorm_4x8) as usize - ptr as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_unorm_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_snorm_4x8) as usize - ptr as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_snorm_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_64_2x32_split) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_64_2x32_split)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_unpack_32_2x16_split) as usize - ptr as usize },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_unpack_32_2x16_split)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_pack_split) as usize - ptr as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_pack_split)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_extract_byte) as usize - ptr as usize },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_extract_byte)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_extract_word) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_extract_word)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_insert_byte) as usize - ptr as usize },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_insert_byte)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_insert_word) as usize - ptr as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_insert_word)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_all_io_to_temps) as usize - ptr as usize },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_all_io_to_temps)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_all_io_to_elements) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_all_io_to_elements)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vertex_id_zero_based) as usize - ptr as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(vertex_id_zero_based)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_base_vertex) as usize - ptr as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_base_vertex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_helper_invocation) as usize - ptr as usize },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_helper_invocation)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).optimize_sample_mask_in) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(optimize_sample_mask_in)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).optimize_quad_vote_to_reduce) as usize - ptr as usize
        },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(optimize_quad_vote_to_reduce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_cs_local_index_to_id) as usize - ptr as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_cs_local_index_to_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_cs_local_id_to_index) as usize - ptr as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_cs_local_id_to_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_cs_global_id) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_cs_global_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_device_index_to_zero) as usize - ptr as usize },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_device_index_to_zero)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_wpos_pntc) as usize - ptr as usize },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_wpos_pntc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_hadd) as usize - ptr as usize },
        79usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_hadd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_hadd64) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_hadd64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_uadd_sat) as usize - ptr as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_uadd_sat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_usub_sat) as usize - ptr as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_usub_sat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_iadd_sat) as usize - ptr as usize },
        83usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_iadd_sat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_mul_32x16) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_mul_32x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vectorize_io) as usize - ptr as usize },
        85usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(vectorize_io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vectorize_tess_levels) as usize - ptr as usize },
        86usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(vectorize_tess_levels)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_to_scalar) as usize - ptr as usize },
        87usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_to_scalar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_to_scalar_filter) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_to_scalar_filter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vectorize_vec2_16bit) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(vectorize_vec2_16bit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unify_interfaces) as usize - ptr as usize },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(unify_interfaces)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).use_interpolated_input_intrinsics) as usize - ptr as usize
        },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(use_interpolated_input_intrinsics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_interpolate_at) as usize - ptr as usize },
        99usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_interpolate_at)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_mul_2x32_64) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_mul_2x32_64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_rotate8) as usize - ptr as usize },
        101usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_rotate8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_rotate16) as usize - ptr as usize },
        102usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_rotate16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_rotate32) as usize - ptr as usize },
        103usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_rotate32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_shfr32) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_shfr32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_iadd3) as usize - ptr as usize },
        105usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_iadd3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_imul24) as usize - ptr as usize },
        106usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_imul24)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_umul24) as usize - ptr as usize },
        107usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_umul24)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_imad32) as usize - ptr as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_imad32)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_umad24) as usize - ptr as usize },
        109usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_umad24)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_fused_comp_and_csel) as usize - ptr as usize },
        110usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_fused_comp_and_csel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_fsub) as usize - ptr as usize },
        111usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_fsub)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_isub) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_isub)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_pack_32_4x8) as usize - ptr as usize },
        113usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_pack_32_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_texture_scaling) as usize - ptr as usize },
        114usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_texture_scaling)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_sdot_4x8) as usize - ptr as usize },
        115usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_sdot_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_udot_4x8) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_udot_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_sudot_4x8) as usize - ptr as usize },
        117usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_sudot_4x8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_sdot_4x8_sat) as usize - ptr as usize },
        118usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_sdot_4x8_sat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_udot_4x8_sat) as usize - ptr as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_udot_4x8_sat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_sudot_4x8_sat) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_sudot_4x8_sat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_dot_2x16) as usize - ptr as usize },
        121usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_dot_2x16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_fmulz) as usize - ptr as usize },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_fmulz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_fmulz_no_denorms) as usize - ptr as usize },
        123usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_fmulz_no_denorms)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_find_msb_rev) as usize - ptr as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_find_msb_rev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_pack_half_2x16_rtz) as usize - ptr as usize },
        125usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_pack_half_2x16_rtz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_bit_test) as usize - ptr as usize },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_bit_test)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_bfe) as usize - ptr as usize },
        127usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_bfe)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_bfm) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_bfm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_bfi) as usize - ptr as usize },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_bfi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_bitfield_select) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_bitfield_select)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_uclz) as usize - ptr as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_uclz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_msad) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(has_msad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intel_vec4) as usize - ptr as usize },
        133usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(intel_vec4)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).avoid_ternary_with_two_constants) as usize - ptr as usize
        },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(avoid_ternary_with_two_constants)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).support_8bit_alu) as usize - ptr as usize },
        135usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(support_8bit_alu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).support_16bit_alu) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(support_16bit_alu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_unroll_iterations) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(max_unroll_iterations)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).max_unroll_iterations_aggressive) as usize - ptr as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(max_unroll_iterations_aggressive)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_unroll_iterations_fp64) as usize - ptr as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(max_unroll_iterations_fp64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_uniforms_to_ubo) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_uniforms_to_ubo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).linker_ignore_precision) as usize - ptr as usize },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(linker_ignore_precision)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).force_indirect_unrolling_sampler) as usize - ptr as usize
        },
        154usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(force_indirect_unrolling_sampler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).no_integers) as usize - ptr as usize },
        155usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(no_integers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).force_indirect_unrolling) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(force_indirect_unrolling)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).driver_functions) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(driver_functions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_int64_options) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_int64_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_doubles_options) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_doubles_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).divergence_analysis_options) as usize - ptr as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(divergence_analysis_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).support_indirect_inputs) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(support_indirect_inputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).support_indirect_outputs) as usize - ptr as usize },
        177usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(support_indirect_outputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_varying_from_uniform) as usize - ptr as usize },
        178usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_varying_from_uniform)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).lower_image_offset_to_range_base) as usize - ptr as usize
        },
        179usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_image_offset_to_range_base)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).lower_atomic_offset_to_range_base) as usize - ptr as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_atomic_offset_to_range_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preserve_mediump) as usize - ptr as usize },
        181usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(preserve_mediump)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_fquantize2f16) as usize - ptr as usize },
        182usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_fquantize2f16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).force_f2f16_rtz) as usize - ptr as usize },
        183usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(force_f2f16_rtz)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).lower_layer_fs_input_to_sysval) as usize - ptr as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_layer_fs_input_to_sysval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compact_arrays) as usize - ptr as usize },
        185usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(compact_arrays)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io_options) as usize - ptr as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(io_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_mediump_io) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(lower_mediump_io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).varying_expression_max_cost) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(varying_expression_max_cost)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).varying_estimate_instr_cost) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader_compiler_options),
            "::",
            stringify!(varying_estimate_instr_cost)
        )
    );
}
impl Default for nir_shader_compiler_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_shader {
    pub gctx: *mut gc_ctx,
    #[doc = " list of uniforms (nir_variable)"]
    pub variables: exec_list,
    #[doc = " Set of driver-specific options for the shader.\n\n The memory for the options is expected to be kept in a single static\n copy by the driver."]
    pub options: *const nir_shader_compiler_options,
    #[doc = " Various bits of compile-time information about a given shader"]
    pub info: shader_info,
    #[doc = " list of nir_function"]
    pub functions: exec_list,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_inputs: ::std::os::raw::c_uint,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_uniforms: ::std::os::raw::c_uint,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_outputs: ::std::os::raw::c_uint,
    #[doc = " Size in bytes of required implicitly bound global memory"]
    pub global_mem_size: ::std::os::raw::c_uint,
    #[doc = " Size in bytes of required scratch space"]
    pub scratch_size: ::std::os::raw::c_uint,
    #[doc = " Constant data associated with this shader.\n\n Constant data is loaded through load_constant intrinsics (as compared to\n the NIR load_const instructions which have the constant value inlined\n into them).  This is usually generated by nir_opt_large_constants (so\n shaders don't have to load_const into a temporary array when they want\n to indirect on a const array)."]
    pub constant_data: *mut ::std::os::raw::c_void,
    #[doc = " Size of the constant data associated with the shader, in bytes"]
    pub constant_data_size: ::std::os::raw::c_uint,
    pub xfb_info: *mut nir_xfb_info,
    pub printf_info_count: ::std::os::raw::c_uint,
    pub printf_info: *mut u_printf_info,
}
#[test]
fn bindgen_test_layout_nir_shader() {
    const UNINIT: ::std::mem::MaybeUninit<nir_shader> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_shader>(),
        464usize,
        concat!("Size of: ", stringify!(nir_shader))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_shader>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_shader))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gctx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(gctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).variables) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(variables)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).options) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).functions) as usize - ptr as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(functions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_inputs) as usize - ptr as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(num_inputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_uniforms) as usize - ptr as usize },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(num_uniforms)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_outputs) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(num_outputs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).global_mem_size) as usize - ptr as usize },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(global_mem_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scratch_size) as usize - ptr as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(scratch_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).constant_data) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(constant_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).constant_data_size) as usize - ptr as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(constant_data_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xfb_info) as usize - ptr as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(xfb_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).printf_info_count) as usize - ptr as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(printf_info_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).printf_info) as usize - ptr as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_shader),
            "::",
            stringify!(printf_info)
        )
    );
}
impl Default for nir_shader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_remove_non_entrypoints(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_remove_non_exported(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_shader_create(
        mem_ctx: *mut ::std::os::raw::c_void,
        stage: gl_shader_stage,
        options: *const nir_shader_compiler_options,
        si: *mut shader_info,
    ) -> *mut nir_shader;
}
extern "C" {
    #[doc = " Adds a variable to the appropriate list in nir_shader"]
    pub fn nir_shader_add_variable(shader: *mut nir_shader, var: *mut nir_variable);
}
extern "C" {
    #[doc = " creates a variable, sets a few defaults, and adds it to the list"]
    pub fn nir_variable_create(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_variable;
}
extern "C" {
    #[doc = " creates a local variable and adds it to the list"]
    pub fn nir_local_variable_create(
        impl_: *mut nir_function_impl,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_variable;
}
extern "C" {
    #[doc = " Creates a uniform builtin state variable."]
    pub fn nir_state_variable_create(
        shader: *mut nir_shader,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
        tokens: *const [gl_state_index16; 4usize],
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_get_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_int,
        type_: *const glsl_type,
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_create_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_int,
        type_: *const glsl_type,
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_find_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_find_variable_with_driver_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_find_state_variable(
        s: *mut nir_shader,
        tokens: *mut [gl_state_index16; 4usize],
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_find_sampler_variable_with_tex_index(
        shader: *mut nir_shader,
        texture_index: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_sort_variables_with_modes(
        shader: *mut nir_shader,
        compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const nir_variable,
                arg2: *const nir_variable,
            ) -> ::std::os::raw::c_int,
        >,
        modes: nir_variable_mode,
    );
}
extern "C" {
    #[doc = " creates a function and adds it to the shader's list of functions"]
    pub fn nir_function_create(
        shader: *mut nir_shader,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_function;
}
extern "C" {
    pub fn nir_function_impl_create(func: *mut nir_function) -> *mut nir_function_impl;
}
extern "C" {
    #[doc = " creates a function_impl that isn't tied to any particular function"]
    pub fn nir_function_impl_create_bare(shader: *mut nir_shader) -> *mut nir_function_impl;
}
extern "C" {
    pub fn nir_block_create(shader: *mut nir_shader) -> *mut nir_block;
}
extern "C" {
    pub fn nir_if_create(shader: *mut nir_shader) -> *mut nir_if;
}
extern "C" {
    pub fn nir_loop_create(shader: *mut nir_shader) -> *mut nir_loop;
}
extern "C" {
    pub fn nir_cf_node_get_function(node: *mut nir_cf_node) -> *mut nir_function_impl;
}
extern "C" {
    #[doc = " requests that the given pieces of metadata be generated"]
    pub fn nir_metadata_require(impl_: *mut nir_function_impl, required: nir_metadata, ...);
}
extern "C" {
    #[doc = " dirties all but the preserved metadata"]
    pub fn nir_metadata_preserve(impl_: *mut nir_function_impl, preserved: nir_metadata);
}
extern "C" {
    #[doc = " Preserves all metadata for the given shader"]
    pub fn nir_shader_preserve_all_metadata(shader: *mut nir_shader);
}
extern "C" {
    #[doc = " creates an instruction with default swizzle/writemask/etc. with NULL registers"]
    pub fn nir_alu_instr_create(shader: *mut nir_shader, op: nir_op) -> *mut nir_alu_instr;
}
extern "C" {
    pub fn nir_deref_instr_create(
        shader: *mut nir_shader,
        deref_type: nir_deref_type,
    ) -> *mut nir_deref_instr;
}
extern "C" {
    pub fn nir_jump_instr_create(
        shader: *mut nir_shader,
        type_: nir_jump_type,
    ) -> *mut nir_jump_instr;
}
extern "C" {
    pub fn nir_load_const_instr_create(
        shader: *mut nir_shader,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> *mut nir_load_const_instr;
}
extern "C" {
    pub fn nir_intrinsic_instr_create(
        shader: *mut nir_shader,
        op: nir_intrinsic_op,
    ) -> *mut nir_intrinsic_instr;
}
extern "C" {
    pub fn nir_call_instr_create(
        shader: *mut nir_shader,
        callee: *mut nir_function,
    ) -> *mut nir_call_instr;
}
extern "C" {
    #[doc = " Creates a NIR texture instruction"]
    pub fn nir_tex_instr_create(
        shader: *mut nir_shader,
        num_srcs: ::std::os::raw::c_uint,
    ) -> *mut nir_tex_instr;
}
extern "C" {
    pub fn nir_phi_instr_create(shader: *mut nir_shader) -> *mut nir_phi_instr;
}
extern "C" {
    pub fn nir_phi_instr_add_src(
        instr: *mut nir_phi_instr,
        pred: *mut nir_block,
        src: *mut nir_def,
    ) -> *mut nir_phi_src;
}
extern "C" {
    pub fn nir_parallel_copy_instr_create(shader: *mut nir_shader) -> *mut nir_parallel_copy_instr;
}
extern "C" {
    pub fn nir_undef_instr_create(
        shader: *mut nir_shader,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> *mut nir_undef_instr;
}
extern "C" {
    pub fn nir_alu_binop_identity(
        binop: nir_op,
        bit_size: ::std::os::raw::c_uint,
    ) -> nir_const_value;
}
#[repr(u32)]
#[doc = " NIR Cursors and Instruction Insertion API\n @{\n\n A tiny struct representing a point to insert/extract instructions or\n control flow nodes.  Helps reduce the combinatorial explosion of possible\n points to insert/extract.\n\n \\sa nir_control_flow.h"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_cursor_option {
    nir_cursor_before_block = 0,
    nir_cursor_after_block = 1,
    nir_cursor_before_instr = 2,
    nir_cursor_after_instr = 3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_cursor {
    pub option: nir_cursor_option,
    pub anon_1: nir_cursor__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_cursor__bindgen_ty_1 {
    pub block: *mut nir_block,
    pub instr: *mut nir_instr,
}
#[test]
fn bindgen_test_layout_nir_cursor__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<nir_cursor__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_cursor__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(nir_cursor__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_cursor__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_cursor__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_cursor__bindgen_ty_1),
            "::",
            stringify!(block)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_cursor__bindgen_ty_1),
            "::",
            stringify!(instr)
        )
    );
}
impl Default for nir_cursor__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_nir_cursor() {
    const UNINIT: ::std::mem::MaybeUninit<nir_cursor> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_cursor>(),
        16usize,
        concat!("Size of: ", stringify!(nir_cursor))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_cursor))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).option) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_cursor),
            "::",
            stringify!(option)
        )
    );
}
impl Default for nir_cursor {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_cursors_equal(a: nir_cursor, b: nir_cursor) -> bool;
}
extern "C" {
    #[doc = " Insert a NIR instruction at the given cursor.\n\n Note: This does not update the cursor."]
    pub fn nir_instr_insert(cursor: nir_cursor, instr: *mut nir_instr);
}
extern "C" {
    pub fn nir_instr_move(cursor: nir_cursor, instr: *mut nir_instr) -> bool;
}
extern "C" {
    pub fn nir_instr_remove_v(instr: *mut nir_instr);
}
extern "C" {
    pub fn nir_instr_free(instr: *mut nir_instr);
}
extern "C" {
    pub fn nir_instr_free_list(list: *mut exec_list);
}
extern "C" {
    pub fn nir_instr_free_and_dce(instr: *mut nir_instr) -> nir_cursor;
}
extern "C" {
    #[doc = " @}"]
    pub fn nir_instr_def(instr: *mut nir_instr) -> *mut nir_def;
}
pub type nir_foreach_src_cb = ::std::option::Option<
    unsafe extern "C" fn(src: *mut nir_src, state: *mut ::std::os::raw::c_void) -> bool,
>;
extern "C" {
    pub fn nir_foreach_phi_src_leaving_block(
        instr: *mut nir_block,
        cb: nir_foreach_src_cb,
        state: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_src_as_const_value(src: nir_src) -> *mut nir_const_value;
}
extern "C" {
    pub fn nir_src_is_always_uniform(src: nir_src) -> bool;
}
extern "C" {
    pub fn nir_srcs_equal(src1: nir_src, src2: nir_src) -> bool;
}
extern "C" {
    pub fn nir_instrs_equal(instr1: *const nir_instr, instr2: *const nir_instr) -> bool;
}
extern "C" {
    #[doc = " Initialize a nir_src\n\n This is almost never the helper you want to use.  This helper assumes that\n the source is uninitialized garbage and blasts over it without doing any\n tear-down the existing source, including removing it from uses lists.\n Using this helper on a source that currently exists in any uses list will\n result in linked list corruption.  It also assumes that the instruction is\n currently live in the IR and adds the source to the uses list for the given\n nir_def as part of setup.\n\n This is pretty much only useful for adding sources to extant instructions\n or manipulating parallel copy instructions as part of out-of-SSA.\n\n When in doubt, use nir_src_rewrite() instead."]
    pub fn nir_instr_init_src(instr: *mut nir_instr, src: *mut nir_src, def: *mut nir_def);
}
extern "C" {
    #[doc = " Clear a nir_src\n\n This helper clears a nir_src by removing it from any uses lists and\n resetting its contents to NIR_SRC_INIT.  This is typically used as a\n precursor to removing the source from the instruction by adjusting a\n num_srcs parameter somewhere or overwriting it with nir_instr_move_src()."]
    pub fn nir_instr_clear_src(instr: *mut nir_instr, src: *mut nir_src);
}
extern "C" {
    pub fn nir_instr_move_src(dest_instr: *mut nir_instr, dest: *mut nir_src, src: *mut nir_src);
}
extern "C" {
    pub fn nir_def_init(
        instr: *mut nir_instr,
        def: *mut nir_def,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn nir_def_rewrite_uses(def: *mut nir_def, new_ssa: *mut nir_def);
}
extern "C" {
    pub fn nir_def_rewrite_uses_src(def: *mut nir_def, new_src: nir_src);
}
extern "C" {
    pub fn nir_def_rewrite_uses_after(
        def: *mut nir_def,
        new_ssa: *mut nir_def,
        after_me: *mut nir_instr,
    );
}
extern "C" {
    pub fn nir_src_components_read(src: *const nir_src) -> nir_component_mask_t;
}
extern "C" {
    pub fn nir_def_components_read(def: *const nir_def) -> nir_component_mask_t;
}
extern "C" {
    pub fn nir_def_all_uses_are_fsat(def: *const nir_def) -> bool;
}
extern "C" {
    #[doc = " Sorts unstructured blocks\n\n NIR requires that unstructured blocks be sorted in reverse post\n depth-first-search order.  This is the standard ordering used in the\n compiler literature which guarantees dominance.  In particular, reverse\n post-DFS order guarantees that dominators occur in the list before the\n blocks they dominate.\n\n NOTE: This function also implicitly deletes any unreachable blocks."]
    pub fn nir_sort_unstructured_blocks(impl_: *mut nir_function_impl);
}
extern "C" {
    #[doc = " Returns the next block\n\n For structured control-flow, this follows the same order as\n nir_block_cf_tree_next().  For unstructured control-flow the blocks are in\n reverse post-DFS order.  (See nir_sort_unstructured_blocks() above.)"]
    pub fn nir_block_unstructured_next(block: *mut nir_block) -> *mut nir_block;
}
extern "C" {
    pub fn nir_unstructured_start_block(impl_: *mut nir_function_impl) -> *mut nir_block;
}
extern "C" {
    pub fn nir_block_cf_tree_next(block: *mut nir_block) -> *mut nir_block;
}
extern "C" {
    pub fn nir_block_cf_tree_prev(block: *mut nir_block) -> *mut nir_block;
}
extern "C" {
    pub fn nir_cf_node_cf_tree_first(node: *mut nir_cf_node) -> *mut nir_block;
}
extern "C" {
    pub fn nir_cf_node_cf_tree_last(node: *mut nir_cf_node) -> *mut nir_block;
}
extern "C" {
    pub fn nir_cf_node_cf_tree_next(node: *mut nir_cf_node) -> *mut nir_block;
}
extern "C" {
    pub fn nir_cf_node_cf_tree_prev(node: *mut nir_cf_node) -> *mut nir_block;
}
extern "C" {
    pub fn nir_block_get_following_if(block: *mut nir_block) -> *mut nir_if;
}
extern "C" {
    pub fn nir_block_get_following_loop(block: *mut nir_block) -> *mut nir_loop;
}
extern "C" {
    pub fn nir_block_get_predecessors_sorted(
        block: *const nir_block,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut *mut nir_block;
}
extern "C" {
    pub fn nir_index_ssa_defs(impl_: *mut nir_function_impl);
}
extern "C" {
    pub fn nir_index_instrs(impl_: *mut nir_function_impl) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_index_blocks(impl_: *mut nir_function_impl);
}
extern "C" {
    pub fn nir_shader_clear_pass_flags(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_shader_index_vars(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_function_impl_index_vars(impl_: *mut nir_function_impl) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_print_shader(shader: *mut nir_shader, fp: *mut FILE);
}
extern "C" {
    pub fn nir_print_shader_annotated(
        shader: *mut nir_shader,
        fp: *mut FILE,
        errors: *mut hash_table,
    );
}
extern "C" {
    pub fn nir_print_instr(instr: *const nir_instr, fp: *mut FILE);
}
extern "C" {
    pub fn nir_print_deref(deref: *const nir_deref_instr, fp: *mut FILE);
}
extern "C" {
    pub fn nir_log_shader_annotated_tagged(
        level: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        shader: *mut nir_shader,
        annotations: *mut hash_table,
    );
}
extern "C" {
    pub fn nir_shader_as_str(
        nir: *mut nir_shader,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn nir_shader_as_str_annotated(
        nir: *mut nir_shader,
        annotations: *mut hash_table,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn nir_instr_as_str(
        instr: *const nir_instr,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Shallow clone of a single instruction."]
    pub fn nir_instr_clone(s: *mut nir_shader, orig: *const nir_instr) -> *mut nir_instr;
}
extern "C" {
    #[doc = " Clone a single instruction, including a remap table to rewrite sources."]
    pub fn nir_instr_clone_deep(
        s: *mut nir_shader,
        orig: *const nir_instr,
        remap_table: *mut hash_table,
    ) -> *mut nir_instr;
}
extern "C" {
    #[doc = " Shallow clone of a single ALU instruction."]
    pub fn nir_alu_instr_clone(
        s: *mut nir_shader,
        orig: *const nir_alu_instr,
    ) -> *mut nir_alu_instr;
}
extern "C" {
    pub fn nir_shader_clone(
        mem_ctx: *mut ::std::os::raw::c_void,
        s: *const nir_shader,
    ) -> *mut nir_shader;
}
extern "C" {
    pub fn nir_function_clone(ns: *mut nir_shader, fxn: *const nir_function) -> *mut nir_function;
}
extern "C" {
    pub fn nir_function_impl_clone(
        shader: *mut nir_shader,
        fi: *const nir_function_impl,
    ) -> *mut nir_function_impl;
}
extern "C" {
    pub fn nir_constant_clone(c: *const nir_constant, var: *mut nir_variable) -> *mut nir_constant;
}
extern "C" {
    pub fn nir_variable_clone(c: *const nir_variable, shader: *mut nir_shader)
        -> *mut nir_variable;
}
extern "C" {
    pub fn nir_shader_replace(dest: *mut nir_shader, src: *mut nir_shader);
}
extern "C" {
    pub fn nir_shader_serialize_deserialize(s: *mut nir_shader);
}
#[doc = " An instruction filtering callback with writemask\n\n Returns true if the instruction should be processed with the associated\n writemask and false otherwise."]
pub type nir_instr_writemask_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_instr,
        writemask: ::std::os::raw::c_uint,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[doc = " A simple instruction lowering callback\n\n Many instruction lowering passes can be written as a simple function which\n takes an instruction as its input and returns a sequence of instructions\n that implement the consumed instruction.  This function type represents\n such a lowering function.  When called, a function with this prototype\n should either return NULL indicating that no lowering needs to be done or\n emit a sequence of instructions using the provided builder (whose cursor\n will already be placed after the instruction to be lowered) and return the\n resulting nir_def."]
pub type nir_lower_instr_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut nir_builder,
        arg2: *mut nir_instr,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut nir_def,
>;
extern "C" {
    #[doc = " Iterate over all the instructions in a nir_function_impl and lower them\n  using the provided callbacks\n\n This function implements the guts of a standard lowering pass for you.  It\n iterates over all of the instructions in a nir_function_impl and calls the\n filter callback on each one.  If the filter callback returns true, it then\n calls the lowering call back on the instruction.  (Splitting it this way\n allows us to avoid some save/restore work for instructions we know won't be\n lowered.)  If the instruction is dead after the lowering is complete, it\n will be removed.  If new instructions are added, the lowering callback will\n also be called on them in case multiple lowerings are required.\n\n If the callback indicates that the original instruction is replaced (either\n through a new SSA def or NIR_LOWER_INSTR_PROGRESS_REPLACE), then the\n instruction is removed along with any now-dead SSA defs it used.\n\n The metadata for the nir_function_impl will also be updated.  If any blocks\n are added (they cannot be removed), dominance and block indices will be\n invalidated."]
    pub fn nir_function_impl_lower_instructions(
        impl_: *mut nir_function_impl,
        filter: nir_instr_filter_cb,
        lower: nir_lower_instr_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_shader_lower_instructions(
        shader: *mut nir_shader,
        filter: nir_instr_filter_cb,
        lower: nir_lower_instr_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_calc_dominance_impl(impl_: *mut nir_function_impl);
}
extern "C" {
    pub fn nir_calc_dominance(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_dominance_lca(b1: *mut nir_block, b2: *mut nir_block) -> *mut nir_block;
}
extern "C" {
    pub fn nir_block_dominates(parent: *mut nir_block, child: *mut nir_block) -> bool;
}
extern "C" {
    pub fn nir_block_is_unreachable(block: *mut nir_block) -> bool;
}
extern "C" {
    pub fn nir_dump_dom_tree_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
extern "C" {
    pub fn nir_dump_dom_tree(shader: *mut nir_shader, fp: *mut FILE);
}
extern "C" {
    pub fn nir_dump_dom_frontier_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
extern "C" {
    pub fn nir_dump_dom_frontier(shader: *mut nir_shader, fp: *mut FILE);
}
extern "C" {
    pub fn nir_dump_cfg_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
extern "C" {
    pub fn nir_dump_cfg(shader: *mut nir_shader, fp: *mut FILE);
}
extern "C" {
    pub fn nir_gs_count_vertices_and_primitives(
        shader: *const nir_shader,
        out_vtxcnt: *mut ::std::os::raw::c_int,
        out_prmcnt: *mut ::std::os::raw::c_int,
        out_decomposed_prmcnt: *mut ::std::os::raw::c_int,
        num_streams: ::std::os::raw::c_uint,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_load_grouping {
    nir_group_all = 0,
    nir_group_same_resource_only = 1,
}
extern "C" {
    pub fn nir_group_loads(
        shader: *mut nir_shader,
        grouping: nir_load_grouping,
        max_distance: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn nir_shrink_vec_array_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_split_array_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_split_var_copies(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_split_per_member_structs(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_split_struct_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_lower_returns_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_lower_returns(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_inline_function_impl(
        b: *mut nir_builder,
        impl_: *const nir_function_impl,
        params: *mut *mut nir_def,
        shader_var_remap: *mut hash_table,
    );
}
extern "C" {
    pub fn nir_inline_functions(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_cleanup_functions(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_link_shader_functions(
        shader: *mut nir_shader,
        link_shader: *const nir_shader,
    ) -> bool;
}
extern "C" {
    pub fn nir_find_inlinable_uniforms(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_inline_uniforms(
        shader: *mut nir_shader,
        num_uniforms: ::std::os::raw::c_uint,
        uniform_values: *const u32,
        uniform_dw_offsets: *const u16,
    );
}
extern "C" {
    pub fn nir_collect_src_uniforms(
        src: *const nir_src,
        component: ::std::os::raw::c_int,
        uni_offsets: *mut u32,
        num_offsets: *mut u8,
        max_num_bo: ::std::os::raw::c_uint,
        max_offset: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_add_inlinable_uniforms(
        cond: *const nir_src,
        info: *mut nir_loop_info,
        uni_offsets: *mut u32,
        num_offsets: *mut u8,
        max_num_bo: ::std::os::raw::c_uint,
        max_offset: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn nir_propagate_invariant(shader: *mut nir_shader, invariant_prim: bool) -> bool;
}
extern "C" {
    pub fn nir_lower_var_copy_instr(copy: *mut nir_intrinsic_instr, shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_lower_deref_copy_instr(b: *mut nir_builder, copy: *mut nir_intrinsic_instr);
}
extern "C" {
    pub fn nir_lower_var_copies(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_memcpy(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_memcpy(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_fixup_deref_modes(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_fixup_deref_types(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_lower_global_vars_to_local(shader: *mut nir_shader) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_array_deref_of_vec_options {
    nir_lower_direct_array_deref_of_vec_load = 1,
    nir_lower_indirect_array_deref_of_vec_load = 2,
    nir_lower_direct_array_deref_of_vec_store = 4,
    nir_lower_indirect_array_deref_of_vec_store = 8,
}
extern "C" {
    pub fn nir_lower_array_deref_of_vec(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        options: nir_lower_array_deref_of_vec_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_indirect_derefs(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        max_lower_array_len: u32,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_indirect_var_derefs(shader: *mut nir_shader, vars: *const set) -> bool;
}
extern "C" {
    pub fn nir_lower_locals_to_regs(shader: *mut nir_shader, bool_bitsize: u8) -> bool;
}
extern "C" {
    pub fn nir_lower_io_to_temporaries(
        shader: *mut nir_shader,
        entrypoint: *mut nir_function_impl,
        outputs: bool,
        inputs: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_vars_to_scratch(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        size_threshold: ::std::os::raw::c_int,
        size_align: glsl_type_size_align_func,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_halfz(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_shader_gather_info(shader: *mut nir_shader, entrypoint: *mut nir_function_impl);
}
extern "C" {
    pub fn nir_gather_types(
        impl_: *mut nir_function_impl,
        float_types: *mut ::std::os::raw::c_uint,
        int_types: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn nir_assign_var_locations(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        size: *mut ::std::os::raw::c_uint,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn nir_remove_unused_varyings(producer: *mut nir_shader, consumer: *mut nir_shader)
        -> bool;
}
extern "C" {
    pub fn nir_remove_unused_io_vars(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        used_by_other_stage: *mut u64,
        used_by_other_stage_patches: *mut u64,
    ) -> bool;
}
extern "C" {
    pub fn nir_compact_varyings(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
        default_to_smooth_interp: bool,
    );
}
extern "C" {
    pub fn nir_link_xfb_varyings(producer: *mut nir_shader, consumer: *mut nir_shader);
}
extern "C" {
    pub fn nir_link_opt_varyings(producer: *mut nir_shader, consumer: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_link_varying_precision(producer: *mut nir_shader, consumer: *mut nir_shader);
}
extern "C" {
    pub fn nir_clone_uniform_variable(
        nir: *mut nir_shader,
        uniform: *mut nir_variable,
        spirv: bool,
    ) -> *mut nir_variable;
}
extern "C" {
    pub fn nir_clone_deref_instr(
        b: *mut nir_builder,
        var: *mut nir_variable,
        deref: *mut nir_deref_instr,
    ) -> *mut nir_deref_instr;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_opt_varyings_progress {
    nir_progress_producer = 1,
    nir_progress_consumer = 2,
}
extern "C" {
    pub fn nir_opt_varyings(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
        spirv: bool,
        max_uniform_components: ::std::os::raw::c_uint,
        max_ubos_per_stage: ::std::os::raw::c_uint,
    ) -> nir_opt_varyings_progress;
}
extern "C" {
    pub fn nir_slot_is_sysval_output(slot: gl_varying_slot, next_shader: gl_shader_stage) -> bool;
}
extern "C" {
    pub fn nir_slot_is_varying(slot: gl_varying_slot) -> bool;
}
extern "C" {
    pub fn nir_slot_is_sysval_output_and_varying(
        slot: gl_varying_slot,
        next_shader: gl_shader_stage,
    ) -> bool;
}
extern "C" {
    pub fn nir_remove_varying(intr: *mut nir_intrinsic_instr, next_shader: gl_shader_stage)
        -> bool;
}
extern "C" {
    pub fn nir_remove_sysval_output(intr: *mut nir_intrinsic_instr) -> bool;
}
extern "C" {
    pub fn nir_lower_amul(
        shader: *mut nir_shader,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_ubo_vec4(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_sort_variables_by_location(shader: *mut nir_shader, mode: nir_variable_mode);
}
extern "C" {
    pub fn nir_assign_io_var_locations(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        size: *mut ::std::os::raw::c_uint,
        stage: gl_shader_stage,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_linked_io_var_info {
    pub num_linked_io_vars: u8,
    pub num_linked_patch_io_vars: u8,
}
#[test]
fn bindgen_test_layout_nir_linked_io_var_info() {
    const UNINIT: ::std::mem::MaybeUninit<nir_linked_io_var_info> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_linked_io_var_info>(),
        2usize,
        concat!("Size of: ", stringify!(nir_linked_io_var_info))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_linked_io_var_info>(),
        1usize,
        concat!("Alignment of ", stringify!(nir_linked_io_var_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_linked_io_vars) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_linked_io_var_info),
            "::",
            stringify!(num_linked_io_vars)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_linked_patch_io_vars) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_linked_io_var_info),
            "::",
            stringify!(num_linked_patch_io_vars)
        )
    );
}
extern "C" {
    pub fn nir_assign_linked_io_var_locations(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
    ) -> nir_linked_io_var_info;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_io_options {
    nir_lower_io_lower_64bit_to_32 = 1,
    nir_lower_io_lower_64bit_float_to_32 = 2,
    nir_lower_io_lower_64bit_to_32_new = 4,
}
extern "C" {
    pub fn nir_lower_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
        arg1: nir_lower_io_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_io_add_const_offset_to_base(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_lower_color_inputs(nir: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_io_passes(nir: *mut nir_shader, renumber_vs_inputs: bool);
}
extern "C" {
    pub fn nir_io_add_intrinsic_xfb_info(nir: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_vars_to_explicit_types(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        type_info: glsl_type_size_align_func,
    ) -> bool;
}
extern "C" {
    pub fn nir_gather_explicit_io_initializers(
        shader: *mut nir_shader,
        dst: *mut ::std::os::raw::c_void,
        dst_size: usize,
        mode: nir_variable_mode,
    );
}
extern "C" {
    pub fn nir_lower_vec3_to_vec4(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_address_format {
    #[doc = " An address format which is a simple 32-bit global GPU address."]
    nir_address_format_32bit_global = 0,
    #[doc = " An address format which is a simple 64-bit global GPU address."]
    nir_address_format_64bit_global = 1,
    #[doc = " An address format which is a 64-bit global GPU address encoded as a\n 2x32-bit vector."]
    nir_address_format_2x32bit_global = 2,
    #[doc = " An address format which is a 64-bit global base address and a 32-bit\n offset.\n\n This is identical to 64bit_bounded_global except that bounds checking\n is not applied when lowering to global access.  Even though the size is\n never used for an actual bounds check, it needs to be valid so we can\n lower deref_buffer_array_length properly."]
    nir_address_format_64bit_global_32bit_offset = 3,
    #[doc = " An address format which is a bounds-checked 64-bit global GPU address.\n\n The address is comprised as a 32-bit vec4 where .xy are a uint64_t base\n address stored with the low bits in .x and high bits in .y, .z is a\n size, and .w is an offset.  When the final I/O operation is lowered, .w\n is checked against .z and the operation is predicated on the result."]
    nir_address_format_64bit_bounded_global = 4,
    #[doc = " An address format which is comprised of a vec2 where the first\n component is a buffer index and the second is an offset."]
    nir_address_format_32bit_index_offset = 5,
    #[doc = " An address format which is a 64-bit value, where the high 32 bits\n are a buffer index, and the low 32 bits are an offset."]
    nir_address_format_32bit_index_offset_pack64 = 6,
    #[doc = " An address format which is comprised of a vec3 where the first two\n components specify the buffer and the third is an offset."]
    nir_address_format_vec2_index_32bit_offset = 7,
    #[doc = " An address format which represents generic pointers with a 62-bit\n pointer and a 2-bit enum in the top two bits.  The top two bits have\n the following meanings:\n\n  - 0x0: Global memory\n  - 0x1: Shared memory\n  - 0x2: Scratch memory\n  - 0x3: Global memory\n\n The redundancy between 0x0 and 0x3 is because of Intel sign-extension of\n addresses.  Valid global memory addresses may naturally have either 0 or\n ~0 as their high bits.\n\n Shared and scratch pointers are represented as 32-bit offsets with the\n top 32 bits only being used for the enum.  This allows us to avoid\n 64-bit address calculations in a bunch of cases."]
    nir_address_format_62bit_generic = 8,
    #[doc = " An address format which is a simple 32-bit offset."]
    nir_address_format_32bit_offset = 9,
    #[doc = " An address format which is a simple 32-bit offset cast to 64-bit."]
    nir_address_format_32bit_offset_as_64bit = 10,
    #[doc = " An address format representing a purely logical addressing model.  In\n this model, all deref chains must be complete from the dereference\n operation to the variable.  Cast derefs are not allowed.  These\n addresses will be 32-bit scalars but the format is immaterial because\n you can always chase the chain."]
    nir_address_format_logical = 11,
}
extern "C" {
    pub fn nir_address_format_bit_size(addr_format: nir_address_format) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_address_format_num_components(
        addr_format: nir_address_format,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_address_format_null_value(addr_format: nir_address_format)
        -> *const nir_const_value;
}
extern "C" {
    pub fn nir_build_addr_iadd(
        b: *mut nir_builder,
        addr: *mut nir_def,
        addr_format: nir_address_format,
        modes: nir_variable_mode,
        offset: *mut nir_def,
    ) -> *mut nir_def;
}
extern "C" {
    pub fn nir_build_addr_iadd_imm(
        b: *mut nir_builder,
        addr: *mut nir_def,
        addr_format: nir_address_format,
        modes: nir_variable_mode,
        offset: i64,
    ) -> *mut nir_def;
}
extern "C" {
    pub fn nir_build_addr_ieq(
        b: *mut nir_builder,
        addr0: *mut nir_def,
        addr1: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
extern "C" {
    pub fn nir_build_addr_isub(
        b: *mut nir_builder,
        addr0: *mut nir_def,
        addr1: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
extern "C" {
    pub fn nir_explicit_io_address_from_deref(
        b: *mut nir_builder,
        deref: *mut nir_deref_instr,
        base_addr: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
extern "C" {
    pub fn nir_get_explicit_deref_align(
        deref: *mut nir_deref_instr,
        default_to_type_align: bool,
        align_mul: *mut u32,
        align_offset: *mut u32,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_explicit_io_instr(
        b: *mut nir_builder,
        io_instr: *mut nir_intrinsic_instr,
        addr: *mut nir_def,
        addr_format: nir_address_format,
    );
}
extern "C" {
    pub fn nir_lower_explicit_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        arg1: nir_address_format,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_mem_access_size_align {
    pub num_components: u8,
    pub bit_size: u8,
    pub align: u16,
}
#[test]
fn bindgen_test_layout_nir_mem_access_size_align() {
    const UNINIT: ::std::mem::MaybeUninit<nir_mem_access_size_align> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_mem_access_size_align>(),
        4usize,
        concat!("Size of: ", stringify!(nir_mem_access_size_align))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_mem_access_size_align>(),
        2usize,
        concat!("Alignment of ", stringify!(nir_mem_access_size_align))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_components) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_mem_access_size_align),
            "::",
            stringify!(num_components)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_size) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_mem_access_size_align),
            "::",
            stringify!(bit_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).align) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_mem_access_size_align),
            "::",
            stringify!(align)
        )
    );
}
pub type nir_lower_mem_access_bit_sizes_cb = ::std::option::Option<
    unsafe extern "C" fn(
        intrin: nir_intrinsic_op,
        bytes: u8,
        bit_size: u8,
        align_mul: u32,
        align_offset: u32,
        offset_is_const: bool,
        cb_data: *const ::std::os::raw::c_void,
    ) -> nir_mem_access_size_align,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_mem_access_bit_sizes_options {
    pub callback: nir_lower_mem_access_bit_sizes_cb,
    pub modes: nir_variable_mode,
    pub may_lower_unaligned_stores_to_atomics: bool,
    pub cb_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_nir_lower_mem_access_bit_sizes_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_mem_access_bit_sizes_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_mem_access_bit_sizes_options>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(nir_lower_mem_access_bit_sizes_options)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_mem_access_bit_sizes_options>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(nir_lower_mem_access_bit_sizes_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_mem_access_bit_sizes_options),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).modes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_mem_access_bit_sizes_options),
            "::",
            stringify!(modes)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).may_lower_unaligned_stores_to_atomics) as usize
                - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_mem_access_bit_sizes_options),
            "::",
            stringify!(may_lower_unaligned_stores_to_atomics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cb_data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_mem_access_bit_sizes_options),
            "::",
            stringify!(cb_data)
        )
    );
}
impl Default for nir_lower_mem_access_bit_sizes_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_lower_mem_access_bit_sizes(
        shader: *mut nir_shader,
        options: *const nir_lower_mem_access_bit_sizes_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_robust_access_options {
    pub lower_ubo: bool,
    pub lower_ssbo: bool,
    pub lower_image: bool,
    pub lower_buffer_image: bool,
    pub lower_image_atomic: bool,
    pub lower_shared: bool,
}
#[test]
fn bindgen_test_layout_nir_lower_robust_access_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_robust_access_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_robust_access_options>(),
        6usize,
        concat!("Size of: ", stringify!(nir_lower_robust_access_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_robust_access_options>(),
        1usize,
        concat!("Alignment of ", stringify!(nir_lower_robust_access_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ubo) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_robust_access_options),
            "::",
            stringify!(lower_ubo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ssbo) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_robust_access_options),
            "::",
            stringify!(lower_ssbo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_image) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_robust_access_options),
            "::",
            stringify!(lower_image)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_buffer_image) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_robust_access_options),
            "::",
            stringify!(lower_buffer_image)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_image_atomic) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_robust_access_options),
            "::",
            stringify!(lower_image_atomic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_shared) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_robust_access_options),
            "::",
            stringify!(lower_shared)
        )
    );
}
extern "C" {
    pub fn nir_lower_robust_access(
        s: *mut nir_shader,
        opts: *const nir_lower_robust_access_options,
    ) -> bool;
}
pub type nir_should_vectorize_mem_func = ::std::option::Option<
    unsafe extern "C" fn(
        align_mul: ::std::os::raw::c_uint,
        align_offset: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
        num_components: ::std::os::raw::c_uint,
        low: *mut nir_intrinsic_instr,
        high: *mut nir_intrinsic_instr,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_load_store_vectorize_options {
    pub callback: nir_should_vectorize_mem_func,
    pub modes: nir_variable_mode,
    pub robust_modes: nir_variable_mode,
    pub cb_data: *mut ::std::os::raw::c_void,
    pub has_shared2_amd: bool,
}
#[test]
fn bindgen_test_layout_nir_load_store_vectorize_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_load_store_vectorize_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_load_store_vectorize_options>(),
        32usize,
        concat!("Size of: ", stringify!(nir_load_store_vectorize_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_load_store_vectorize_options>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(nir_load_store_vectorize_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_store_vectorize_options),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).modes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_store_vectorize_options),
            "::",
            stringify!(modes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).robust_modes) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_store_vectorize_options),
            "::",
            stringify!(robust_modes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cb_data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_store_vectorize_options),
            "::",
            stringify!(cb_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_shared2_amd) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_load_store_vectorize_options),
            "::",
            stringify!(has_shared2_amd)
        )
    );
}
impl Default for nir_load_store_vectorize_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_opt_load_store_vectorize(
        shader: *mut nir_shader,
        options: *const nir_load_store_vectorize_options,
    ) -> bool;
}
pub type nir_lower_shader_calls_should_remat_func = ::std::option::Option<
    unsafe extern "C" fn(instr: *mut nir_instr, data: *mut ::std::os::raw::c_void) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_shader_calls_options {
    pub address_format: nir_address_format,
    pub stack_alignment: ::std::os::raw::c_uint,
    pub localized_loads: bool,
    pub vectorizer_callback: nir_should_vectorize_mem_func,
    pub vectorizer_data: *mut ::std::os::raw::c_void,
    pub should_remat_callback: nir_lower_shader_calls_should_remat_func,
    pub should_remat_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_nir_lower_shader_calls_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_shader_calls_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_shader_calls_options>(),
        48usize,
        concat!("Size of: ", stringify!(nir_lower_shader_calls_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_shader_calls_options>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_lower_shader_calls_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address_format) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(address_format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stack_alignment) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(stack_alignment)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).localized_loads) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(localized_loads)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vectorizer_callback) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(vectorizer_callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vectorizer_data) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(vectorizer_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).should_remat_callback) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(should_remat_callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).should_remat_data) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_shader_calls_options),
            "::",
            stringify!(should_remat_data)
        )
    );
}
impl Default for nir_lower_shader_calls_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_lower_shader_calls(
        shader: *mut nir_shader,
        options: *const nir_lower_shader_calls_options,
        resume_shaders_out: *mut *mut *mut nir_shader,
        num_resume_shaders_out: *mut u32,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_get_io_offset_src_number(instr: *const nir_intrinsic_instr)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nir_get_io_arrayed_index_src_number(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nir_get_io_offset_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
extern "C" {
    pub fn nir_get_io_arrayed_index_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
extern "C" {
    pub fn nir_get_shader_call_payload_src(call: *mut nir_intrinsic_instr) -> *mut nir_src;
}
extern "C" {
    pub fn nir_is_arrayed_io(var: *const nir_variable, stage: gl_shader_stage) -> bool;
}
extern "C" {
    pub fn nir_lower_reg_intrinsics_to_ssa_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_lower_reg_intrinsics_to_ssa(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_vars_to_ssa(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_remove_dead_derefs(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_remove_dead_derefs_impl(impl_: *mut nir_function_impl) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_remove_dead_variables_options {
    pub can_remove_var: ::std::option::Option<
        unsafe extern "C" fn(var: *mut nir_variable, data: *mut ::std::os::raw::c_void) -> bool,
    >,
    pub can_remove_var_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_nir_remove_dead_variables_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_remove_dead_variables_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_remove_dead_variables_options>(),
        16usize,
        concat!("Size of: ", stringify!(nir_remove_dead_variables_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_remove_dead_variables_options>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(nir_remove_dead_variables_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).can_remove_var) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_remove_dead_variables_options),
            "::",
            stringify!(can_remove_var)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).can_remove_var_data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_remove_dead_variables_options),
            "::",
            stringify!(can_remove_var_data)
        )
    );
}
impl Default for nir_remove_dead_variables_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_remove_dead_variables(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        options: *const nir_remove_dead_variables_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_variable_initializers(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
    ) -> bool;
}
extern "C" {
    pub fn nir_zero_initialize_shared_memory(
        shader: *mut nir_shader,
        shared_size: ::std::os::raw::c_uint,
        chunk_size: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_clear_shared_memory(
        shader: *mut nir_shader,
        shared_size: ::std::os::raw::c_uint,
        chunk_size: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_move_vec_src_uses_to_dest(shader: *mut nir_shader, skip_const_srcs: bool) -> bool;
}
extern "C" {
    pub fn nir_lower_vec_to_regs(
        shader: *mut nir_shader,
        cb: nir_instr_writemask_filter_cb,
        _data: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_alpha_test(
        shader: *mut nir_shader,
        func: compare_func,
        alpha_to_one: bool,
        alpha_ref_state_tokens: *const gl_state_index16,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_alu(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_flrp(
        shader: *mut nir_shader,
        lowering_mask: ::std::os::raw::c_uint,
        always_precise: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_scale_fdiv(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_alu_to_scalar(
        shader: *mut nir_shader,
        cb: nir_instr_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_alu_width(
        shader: *mut nir_shader,
        cb: nir_vectorize_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_alu_vec8_16_srcs(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_bool_to_bitsize(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_bool_to_float(shader: *mut nir_shader, has_fcsel_ne: bool) -> bool;
}
extern "C" {
    pub fn nir_lower_bool_to_int32(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_simplify_convert_alu_types(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_const_arrays_to_uniforms(
        shader: *mut nir_shader,
        max_uniform_components: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_convert_alu_types(
        shader: *mut nir_shader,
        should_lower: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut nir_intrinsic_instr) -> bool,
        >,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_constant_convert_alu_types(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_alu_conversion_to_intrinsic(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_int_to_float(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_load_const_to_scalar(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_read_invocation_to_scalar(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_phis_to_scalar(shader: *mut nir_shader, lower_all: bool) -> bool;
}
extern "C" {
    pub fn nir_lower_io_arrays_to_elements(producer: *mut nir_shader, consumer: *mut nir_shader);
}
extern "C" {
    pub fn nir_lower_io_arrays_to_elements_no_indirects(
        shader: *mut nir_shader,
        outputs_only: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_io_to_scalar(
        shader: *mut nir_shader,
        mask: nir_variable_mode,
        filter: nir_instr_filter_cb,
        filter_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_io_to_scalar_early(shader: *mut nir_shader, mask: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_lower_io_to_vector(shader: *mut nir_shader, mask: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_vectorize_tess_levels(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_create_passthrough_tcs_impl(
        options: *const nir_shader_compiler_options,
        locations: *mut ::std::os::raw::c_uint,
        num_locations: ::std::os::raw::c_uint,
        patch_vertices: u8,
    ) -> *mut nir_shader;
}
extern "C" {
    pub fn nir_create_passthrough_tcs(
        options: *const nir_shader_compiler_options,
        vs: *const nir_shader,
        patch_vertices: u8,
    ) -> *mut nir_shader;
}
extern "C" {
    pub fn nir_create_passthrough_gs(
        options: *const nir_shader_compiler_options,
        prev_stage: *const nir_shader,
        primitive_type: mesa_prim,
        output_primitive_type: mesa_prim,
        emulate_edgeflags: bool,
        force_line_strip_out: bool,
    ) -> *mut nir_shader;
}
extern "C" {
    pub fn nir_lower_fragcolor(shader: *mut nir_shader, max_cbufs: ::std::os::raw::c_uint) -> bool;
}
extern "C" {
    pub fn nir_lower_fragcoord_wtrans(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_frag_coord_to_pixel_coord(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_viewport_transform(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_uniforms_to_ubo(
        shader: *mut nir_shader,
        dword_packed: bool,
        load_vec4: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_is_helper_invocation(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_single_sampled(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_subgroups_options {
    pub subgroup_size: u8,
    pub ballot_bit_size: u8,
    pub ballot_components: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
}
#[test]
fn bindgen_test_layout_nir_lower_subgroups_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_subgroups_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_subgroups_options>(),
        6usize,
        concat!("Size of: ", stringify!(nir_lower_subgroups_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_subgroups_options>(),
        1usize,
        concat!("Alignment of ", stringify!(nir_lower_subgroups_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_subgroups_options),
            "::",
            stringify!(subgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ballot_bit_size) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_subgroups_options),
            "::",
            stringify!(ballot_bit_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ballot_components) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_subgroups_options),
            "::",
            stringify!(ballot_components)
        )
    );
}
impl nir_lower_subgroups_options {
    #[inline]
    pub fn lower_to_scalar(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_to_scalar(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_vote_trivial(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_trivial(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_vote_eq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_eq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_vote_bool_eq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_bool_eq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_first_invocation_to_ballot(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_first_invocation_to_ballot(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_read_first_invocation(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_read_first_invocation(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_subgroup_masks(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_subgroup_masks(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_relative_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_relative_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_shuffle_to_32bit(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle_to_32bit(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_shuffle_to_swizzle_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle_to_swizzle_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_quad(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_quad_broadcast_dynamic(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_broadcast_dynamic(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_quad_broadcast_dynamic_to_const(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_broadcast_dynamic_to_const(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_elect(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_elect(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_read_invocation_to_cond(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_read_invocation_to_cond(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_rotate_to_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_rotate_to_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_ballot_bit_count_to_mbcnt_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_ballot_bit_count_to_mbcnt_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_inverse_ballot(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_inverse_ballot(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_boolean_reduce(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_boolean_reduce(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_boolean_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_boolean_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lower_to_scalar: bool,
        lower_vote_trivial: bool,
        lower_vote_eq: bool,
        lower_vote_bool_eq: bool,
        lower_first_invocation_to_ballot: bool,
        lower_read_first_invocation: bool,
        lower_subgroup_masks: bool,
        lower_relative_shuffle: bool,
        lower_shuffle_to_32bit: bool,
        lower_shuffle_to_swizzle_amd: bool,
        lower_shuffle: bool,
        lower_quad: bool,
        lower_quad_broadcast_dynamic: bool,
        lower_quad_broadcast_dynamic_to_const: bool,
        lower_elect: bool,
        lower_read_invocation_to_cond: bool,
        lower_rotate_to_shuffle: bool,
        lower_ballot_bit_count_to_mbcnt_amd: bool,
        lower_inverse_ballot: bool,
        lower_boolean_reduce: bool,
        lower_boolean_shuffle: bool,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let lower_to_scalar: u8 = unsafe { ::std::mem::transmute(lower_to_scalar) };
            lower_to_scalar as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let lower_vote_trivial: u8 = unsafe { ::std::mem::transmute(lower_vote_trivial) };
            lower_vote_trivial as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let lower_vote_eq: u8 = unsafe { ::std::mem::transmute(lower_vote_eq) };
            lower_vote_eq as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let lower_vote_bool_eq: u8 = unsafe { ::std::mem::transmute(lower_vote_bool_eq) };
            lower_vote_bool_eq as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let lower_first_invocation_to_ballot: u8 =
                unsafe { ::std::mem::transmute(lower_first_invocation_to_ballot) };
            lower_first_invocation_to_ballot as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let lower_read_first_invocation: u8 =
                unsafe { ::std::mem::transmute(lower_read_first_invocation) };
            lower_read_first_invocation as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let lower_subgroup_masks: u8 = unsafe { ::std::mem::transmute(lower_subgroup_masks) };
            lower_subgroup_masks as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let lower_relative_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_relative_shuffle) };
            lower_relative_shuffle as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let lower_shuffle_to_32bit: u8 =
                unsafe { ::std::mem::transmute(lower_shuffle_to_32bit) };
            lower_shuffle_to_32bit as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let lower_shuffle_to_swizzle_amd: u8 =
                unsafe { ::std::mem::transmute(lower_shuffle_to_swizzle_amd) };
            lower_shuffle_to_swizzle_amd as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let lower_shuffle: u8 = unsafe { ::std::mem::transmute(lower_shuffle) };
            lower_shuffle as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let lower_quad: u8 = unsafe { ::std::mem::transmute(lower_quad) };
            lower_quad as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let lower_quad_broadcast_dynamic: u8 =
                unsafe { ::std::mem::transmute(lower_quad_broadcast_dynamic) };
            lower_quad_broadcast_dynamic as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let lower_quad_broadcast_dynamic_to_const: u8 =
                unsafe { ::std::mem::transmute(lower_quad_broadcast_dynamic_to_const) };
            lower_quad_broadcast_dynamic_to_const as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let lower_elect: u8 = unsafe { ::std::mem::transmute(lower_elect) };
            lower_elect as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let lower_read_invocation_to_cond: u8 =
                unsafe { ::std::mem::transmute(lower_read_invocation_to_cond) };
            lower_read_invocation_to_cond as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let lower_rotate_to_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_rotate_to_shuffle) };
            lower_rotate_to_shuffle as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let lower_ballot_bit_count_to_mbcnt_amd: u8 =
                unsafe { ::std::mem::transmute(lower_ballot_bit_count_to_mbcnt_amd) };
            lower_ballot_bit_count_to_mbcnt_amd as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let lower_inverse_ballot: u8 = unsafe { ::std::mem::transmute(lower_inverse_ballot) };
            lower_inverse_ballot as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let lower_boolean_reduce: u8 = unsafe { ::std::mem::transmute(lower_boolean_reduce) };
            lower_boolean_reduce as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let lower_boolean_shuffle: u8 = unsafe { ::std::mem::transmute(lower_boolean_shuffle) };
            lower_boolean_shuffle as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_subgroups(
        shader: *mut nir_shader,
        options: *const nir_lower_subgroups_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_system_values(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_build_lowered_load_helper_invocation(b: *mut nir_builder) -> *mut nir_def;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_compute_system_values_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub num_workgroups: [u32; 3usize],
}
#[test]
fn bindgen_test_layout_nir_lower_compute_system_values_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_compute_system_values_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_compute_system_values_options>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(nir_lower_compute_system_values_options)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_compute_system_values_options>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(nir_lower_compute_system_values_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_workgroups) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_compute_system_values_options),
            "::",
            stringify!(num_workgroups)
        )
    );
}
impl nir_lower_compute_system_values_options {
    #[inline]
    pub fn has_base_global_invocation_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_base_global_invocation_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_base_workgroup_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_base_workgroup_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn shuffle_local_ids_for_quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shuffle_local_ids_for_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_local_invocation_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_local_invocation_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_cs_local_id_to_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_cs_local_id_to_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lower_workgroup_id_to_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_workgroup_id_to_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn shortcut_1d_workgroup_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shortcut_1d_workgroup_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        has_base_global_invocation_id: bool,
        has_base_workgroup_id: bool,
        shuffle_local_ids_for_quad_derivatives: bool,
        lower_local_invocation_index: bool,
        lower_cs_local_id_to_index: bool,
        lower_workgroup_id_to_index: bool,
        shortcut_1d_workgroup_id: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_base_global_invocation_id: u8 =
                unsafe { ::std::mem::transmute(has_base_global_invocation_id) };
            has_base_global_invocation_id as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_base_workgroup_id: u8 = unsafe { ::std::mem::transmute(has_base_workgroup_id) };
            has_base_workgroup_id as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let shuffle_local_ids_for_quad_derivatives: u8 =
                unsafe { ::std::mem::transmute(shuffle_local_ids_for_quad_derivatives) };
            shuffle_local_ids_for_quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let lower_local_invocation_index: u8 =
                unsafe { ::std::mem::transmute(lower_local_invocation_index) };
            lower_local_invocation_index as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let lower_cs_local_id_to_index: u8 =
                unsafe { ::std::mem::transmute(lower_cs_local_id_to_index) };
            lower_cs_local_id_to_index as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let lower_workgroup_id_to_index: u8 =
                unsafe { ::std::mem::transmute(lower_workgroup_id_to_index) };
            lower_workgroup_id_to_index as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let shortcut_1d_workgroup_id: u8 =
                unsafe { ::std::mem::transmute(shortcut_1d_workgroup_id) };
            shortcut_1d_workgroup_id as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_compute_system_values(
        shader: *mut nir_shader,
        options: *const nir_lower_compute_system_values_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_sysvals_to_varyings_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[test]
fn bindgen_test_layout_nir_lower_sysvals_to_varyings_options() {
    assert_eq!(
        ::std::mem::size_of::<nir_lower_sysvals_to_varyings_options>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(nir_lower_sysvals_to_varyings_options)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_sysvals_to_varyings_options>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(nir_lower_sysvals_to_varyings_options)
        )
    );
}
impl nir_lower_sysvals_to_varyings_options {
    #[inline]
    pub fn frag_coord(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_frag_coord(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn front_face(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_front_face(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn point_coord(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_coord(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        frag_coord: bool,
        front_face: bool,
        point_coord: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let frag_coord: u8 = unsafe { ::std::mem::transmute(frag_coord) };
            frag_coord as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let front_face: u8 = unsafe { ::std::mem::transmute(front_face) };
            front_face as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let point_coord: u8 = unsafe { ::std::mem::transmute(point_coord) };
            point_coord as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_sysvals_to_varyings(
        shader: *mut nir_shader,
        options: *const nir_lower_sysvals_to_varyings_options,
    ) -> bool;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_tex_packing {
    #[doc = " No packing"]
    nir_lower_tex_packing_none = 0,
    #[doc = " The sampler returns up to 2 32-bit words of half floats or 16-bit signed\n or unsigned ints based on the sampler type"]
    nir_lower_tex_packing_16 = 1,
    #[doc = " The sampler returns 1 32-bit word of 4x8 unorm"]
    nir_lower_tex_packing_8 = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct nir_lower_tex_options {
    #[doc = " bitmask of (1 << GLSL_SAMPLER_DIM_x) to control for which\n sampler types a texture projector is lowered."]
    pub lower_txp: ::std::os::raw::c_uint,
    #[doc = " If true, lower texture projector for any array sampler dims"]
    pub lower_txp_array: bool,
    #[doc = " If true, lower away nir_tex_src_offset for all texelfetch instructions."]
    pub lower_txf_offset: bool,
    #[doc = " If true, lower away nir_tex_src_offset for all rect textures."]
    pub lower_rect_offset: bool,
    #[doc = " If not NULL, this filter will return true for tex instructions that\n should lower away nir_tex_src_offset."]
    pub lower_offset_filter: nir_instr_filter_cb,
    #[doc = " If true, lower rect textures to 2D, using txs to fetch the\n texture dimensions and dividing the texture coords by the\n texture dims to normalize."]
    pub lower_rect: bool,
    #[doc = " If true, lower 1D textures to 2D. This requires the GL/VK driver to map 1D\n textures to 2D textures with height=1.\n\n lower_1d_shadow does this lowering for shadow textures only."]
    pub lower_1d: bool,
    pub lower_1d_shadow: bool,
    #[doc = " If true, convert yuv to rgb."]
    pub lower_y_uv_external: ::std::os::raw::c_uint,
    pub lower_y_vu_external: ::std::os::raw::c_uint,
    pub lower_y_u_v_external: ::std::os::raw::c_uint,
    pub lower_yx_xuxv_external: ::std::os::raw::c_uint,
    pub lower_yx_xvxu_external: ::std::os::raw::c_uint,
    pub lower_xy_uxvx_external: ::std::os::raw::c_uint,
    pub lower_xy_vxux_external: ::std::os::raw::c_uint,
    pub lower_ayuv_external: ::std::os::raw::c_uint,
    pub lower_xyuv_external: ::std::os::raw::c_uint,
    pub lower_yuv_external: ::std::os::raw::c_uint,
    pub lower_yu_yv_external: ::std::os::raw::c_uint,
    pub lower_yv_yu_external: ::std::os::raw::c_uint,
    pub lower_y41x_external: ::std::os::raw::c_uint,
    pub bt709_external: ::std::os::raw::c_uint,
    pub bt2020_external: ::std::os::raw::c_uint,
    pub yuv_full_range_external: ::std::os::raw::c_uint,
    #[doc = " To emulate certain texture wrap modes, this can be used\n to saturate the specified tex coord to [0.0, 1.0].  The\n bits are according to sampler #, ie. if, for example:\n\n   (conf->saturate_s & (1 << n))\n\n is true, then the s coord for sampler n is saturated.\n\n Note that clamping must happen *after* projector lowering\n so any projected texture sample instruction with a clamped\n coordinate gets automatically lowered, regardless of the\n 'lower_txp' setting."]
    pub saturate_s: ::std::os::raw::c_uint,
    pub saturate_t: ::std::os::raw::c_uint,
    pub saturate_r: ::std::os::raw::c_uint,
    pub swizzle_result: ::std::os::raw::c_uint,
    pub swizzles: [[u8; 4usize]; 32usize],
    pub scale_factors: [::std::os::raw::c_float; 32usize],
    #[doc = " Bitmap of textures that need srgb to linear conversion.  If\n (lower_srgb & (1 << texture_index)) then the rgb (xyz) components\n of the texture are lowered to linear."]
    pub lower_srgb: ::std::os::raw::c_uint,
    #[doc = " If true, lower nir_texop_txd on cube maps with nir_texop_txl."]
    pub lower_txd_cube_map: bool,
    #[doc = " If true, lower nir_texop_txd on 3D surfaces with nir_texop_txl."]
    pub lower_txd_3d: bool,
    #[doc = " If true, lower nir_texop_txd any array surfaces with nir_texop_txl."]
    pub lower_txd_array: bool,
    #[doc = " If true, lower nir_texop_txd on shadow samplers (except cube maps)\n with nir_texop_txl. Notice that cube map shadow samplers are lowered\n with lower_txd_cube_map."]
    pub lower_txd_shadow: bool,
    #[doc = " If true, lower nir_texop_txd on all samplers to a nir_texop_txl.\n Implies lower_txd_cube_map and lower_txd_shadow."]
    pub lower_txd: bool,
    #[doc = " If true, lower nir_texop_txd  when it uses min_lod."]
    pub lower_txd_clamp: bool,
    #[doc = " If true, lower nir_texop_txb that try to use shadow compare and min_lod\n at the same time to a nir_texop_lod, some math, and nir_texop_tex."]
    pub lower_txb_shadow_clamp: bool,
    #[doc = " If true, lower nir_texop_txd on shadow samplers when it uses min_lod\n with nir_texop_txl.  This includes cube maps."]
    pub lower_txd_shadow_clamp: bool,
    #[doc = " If true, lower nir_texop_txd on when it uses both offset and min_lod\n with nir_texop_txl.  This includes cube maps."]
    pub lower_txd_offset_clamp: bool,
    #[doc = " If true, lower nir_texop_txd with min_lod to a nir_texop_txl if the\n sampler is bindless."]
    pub lower_txd_clamp_bindless_sampler: bool,
    #[doc = " If true, lower nir_texop_txd with min_lod to a nir_texop_txl if the\n sampler index is not statically determinable to be less than 16."]
    pub lower_txd_clamp_if_sampler_index_not_lt_16: bool,
    #[doc = " If true, lower nir_texop_txs with a non-0-lod into nir_texop_txs with\n 0-lod followed by a nir_ishr."]
    pub lower_txs_lod: bool,
    #[doc = " If true, lower nir_texop_txs for cube arrays to a nir_texop_txs with a\n 2D array type followed by a nir_idiv by 6."]
    pub lower_txs_cube_array: bool,
    #[doc = " If true, apply a .bagr swizzle on tg4 results to handle Broadcom's\n mixed-up tg4 locations."]
    pub lower_tg4_broadcom_swizzle: bool,
    #[doc = " If true, lowers tg4 with 4 constant offsets to 4 tg4 calls"]
    pub lower_tg4_offsets: bool,
    #[doc = " Lower txf_ms to fragment_mask_fetch and fragment_fetch and samples_identical to\n fragment_mask_fetch."]
    pub lower_to_fragment_fetch_amd: bool,
    #[doc = " To lower packed sampler return formats. This will be called for all\n tex instructions."]
    pub lower_tex_packing_cb: ::std::option::Option<
        unsafe extern "C" fn(
            tex: *const nir_tex_instr,
            data: *const ::std::os::raw::c_void,
        ) -> nir_lower_tex_packing,
    >,
    pub lower_tex_packing_data: *const ::std::os::raw::c_void,
    #[doc = " If true, lower nir_texop_lod to return -FLT_MAX if the sum of the\n absolute values of derivatives is 0 for all coordinates."]
    pub lower_lod_zero_width: bool,
    pub lower_invalid_implicit_lod: bool,
    pub lower_index_to_offset: bool,
    #[doc = " Payload data to be sent to callback / filter functions."]
    pub callback_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_nir_lower_tex_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_tex_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_tex_options>(),
        408usize,
        concat!("Size of: ", stringify!(nir_lower_tex_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_tex_options>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_lower_tex_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txp) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txp_array) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txp_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txf_offset) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txf_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_rect_offset) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_rect_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_offset_filter) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_offset_filter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_rect) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_rect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_1d) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_1d)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_1d_shadow) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_1d_shadow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_y_uv_external) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_y_uv_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_y_vu_external) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_y_vu_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_y_u_v_external) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_y_u_v_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_yx_xuxv_external) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_yx_xuxv_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_yx_xvxu_external) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_yx_xvxu_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_xy_uxvx_external) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_xy_uxvx_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_xy_vxux_external) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_xy_vxux_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_ayuv_external) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_ayuv_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_xyuv_external) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_xyuv_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_yuv_external) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_yuv_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_yu_yv_external) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_yu_yv_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_yv_yu_external) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_yv_yu_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_y41x_external) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_y41x_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bt709_external) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(bt709_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bt2020_external) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(bt2020_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).yuv_full_range_external) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(yuv_full_range_external)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).saturate_s) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(saturate_s)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).saturate_t) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(saturate_t)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).saturate_r) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(saturate_r)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).swizzle_result) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(swizzle_result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).swizzles) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(swizzles)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scale_factors) as usize - ptr as usize },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(scale_factors)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_srgb) as usize - ptr as usize },
        356usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_srgb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_cube_map) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_cube_map)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_3d) as usize - ptr as usize },
        361usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_3d)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_array) as usize - ptr as usize },
        362usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_shadow) as usize - ptr as usize },
        363usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_shadow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd) as usize - ptr as usize },
        364usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_clamp) as usize - ptr as usize },
        365usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_clamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txb_shadow_clamp) as usize - ptr as usize },
        366usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txb_shadow_clamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_shadow_clamp) as usize - ptr as usize },
        367usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_shadow_clamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txd_offset_clamp) as usize - ptr as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_offset_clamp)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).lower_txd_clamp_bindless_sampler) as usize - ptr as usize
        },
        369usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_clamp_bindless_sampler)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).lower_txd_clamp_if_sampler_index_not_lt_16) as usize
                - ptr as usize
        },
        370usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txd_clamp_if_sampler_index_not_lt_16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txs_lod) as usize - ptr as usize },
        371usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txs_lod)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_txs_cube_array) as usize - ptr as usize },
        372usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_txs_cube_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_tg4_broadcom_swizzle) as usize - ptr as usize },
        373usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_tg4_broadcom_swizzle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_tg4_offsets) as usize - ptr as usize },
        374usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_tg4_offsets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_to_fragment_fetch_amd) as usize - ptr as usize },
        375usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_to_fragment_fetch_amd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_tex_packing_cb) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_tex_packing_cb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_tex_packing_data) as usize - ptr as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_tex_packing_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_lod_zero_width) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_lod_zero_width)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_invalid_implicit_lod) as usize - ptr as usize },
        393usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_invalid_implicit_lod)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_index_to_offset) as usize - ptr as usize },
        394usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(lower_index_to_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback_data) as usize - ptr as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_tex_options),
            "::",
            stringify!(callback_data)
        )
    );
}
impl Default for nir_lower_tex_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[doc = " Lowers complex texture instructions to simpler ones"]
    pub fn nir_lower_tex(shader: *mut nir_shader, options: *const nir_lower_tex_options) -> bool;
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_tex_shadow_swizzle {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_nir_lower_tex_shadow_swizzle() {
    assert_eq!(
        ::std::mem::size_of::<nir_lower_tex_shadow_swizzle>(),
        4usize,
        concat!("Size of: ", stringify!(nir_lower_tex_shadow_swizzle))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_tex_shadow_swizzle>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_lower_tex_shadow_swizzle))
    );
}
impl nir_lower_tex_shadow_swizzle {
    #[inline]
    pub fn swizzle_r(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_r(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn swizzle_g(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_g(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn swizzle_b(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_b(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn swizzle_a(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_a(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        swizzle_r: ::std::os::raw::c_uint,
        swizzle_g: ::std::os::raw::c_uint,
        swizzle_b: ::std::os::raw::c_uint,
        swizzle_a: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let swizzle_r: u32 = unsafe { ::std::mem::transmute(swizzle_r) };
            swizzle_r as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let swizzle_g: u32 = unsafe { ::std::mem::transmute(swizzle_g) };
            swizzle_g as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let swizzle_b: u32 = unsafe { ::std::mem::transmute(swizzle_b) };
            swizzle_b as u64
        });
        __bindgen_bitfield_unit.set(9usize, 3u8, {
            let swizzle_a: u32 = unsafe { ::std::mem::transmute(swizzle_a) };
            swizzle_a as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_tex_shadow(
        s: *mut nir_shader,
        n_states: ::std::os::raw::c_uint,
        compare_func: *mut compare_func,
        tex_swizzles: *mut nir_lower_tex_shadow_swizzle,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_image_options {
    #[doc = " If true, lower cube size operations."]
    pub lower_cube_size: bool,
    #[doc = " Lower multi sample image load and samples_identical to use fragment_mask_load."]
    pub lower_to_fragment_mask_load_amd: bool,
    #[doc = " Lower image_samples to a constant in case the driver doesn't support multisampled\n images."]
    pub lower_image_samples_to_one: bool,
}
#[test]
fn bindgen_test_layout_nir_lower_image_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_image_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_image_options>(),
        3usize,
        concat!("Size of: ", stringify!(nir_lower_image_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_image_options>(),
        1usize,
        concat!("Alignment of ", stringify!(nir_lower_image_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_cube_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_image_options),
            "::",
            stringify!(lower_cube_size)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).lower_to_fragment_mask_load_amd) as usize - ptr as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_image_options),
            "::",
            stringify!(lower_to_fragment_mask_load_amd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lower_image_samples_to_one) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_image_options),
            "::",
            stringify!(lower_image_samples_to_one)
        )
    );
}
extern "C" {
    pub fn nir_lower_image(nir: *mut nir_shader, options: *const nir_lower_image_options) -> bool;
}
extern "C" {
    pub fn nir_lower_image_atomics_to_global(s: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_readonly_images_to_tex(shader: *mut nir_shader, per_variable: bool) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_non_uniform_access_type {
    nir_lower_non_uniform_ubo_access = 1,
    nir_lower_non_uniform_ssbo_access = 2,
    nir_lower_non_uniform_texture_access = 4,
    nir_lower_non_uniform_image_access = 8,
    nir_lower_non_uniform_get_ssbo_size = 16,
}
pub type nir_lower_non_uniform_access_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_src,
        arg2: *mut ::std::os::raw::c_void,
    ) -> nir_component_mask_t,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_non_uniform_access_options {
    pub types: nir_lower_non_uniform_access_type,
    pub callback: nir_lower_non_uniform_access_callback,
    pub callback_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_nir_lower_non_uniform_access_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_non_uniform_access_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_non_uniform_access_options>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(nir_lower_non_uniform_access_options)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_non_uniform_access_options>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(nir_lower_non_uniform_access_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).types) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_non_uniform_access_options),
            "::",
            stringify!(types)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_non_uniform_access_options),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback_data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_non_uniform_access_options),
            "::",
            stringify!(callback_data)
        )
    );
}
impl Default for nir_lower_non_uniform_access_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_has_non_uniform_access(
        shader: *mut nir_shader,
        types: nir_lower_non_uniform_access_type,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_non_uniform_access(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_non_uniform_access(
        shader: *mut nir_shader,
        options: *const nir_lower_non_uniform_access_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_idiv_options {
    pub allow_fp16: bool,
}
#[test]
fn bindgen_test_layout_nir_lower_idiv_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_idiv_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_idiv_options>(),
        1usize,
        concat!("Size of: ", stringify!(nir_lower_idiv_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_idiv_options>(),
        1usize,
        concat!("Alignment of ", stringify!(nir_lower_idiv_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).allow_fp16) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_idiv_options),
            "::",
            stringify!(allow_fp16)
        )
    );
}
extern "C" {
    pub fn nir_lower_idiv(shader: *mut nir_shader, options: *const nir_lower_idiv_options) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_input_attachment_options {
    pub use_fragcoord_sysval: bool,
    pub use_layer_id_sysval: bool,
    pub use_view_id_for_layer: bool,
    pub unscaled_input_attachment_ir3: u32,
}
#[test]
fn bindgen_test_layout_nir_input_attachment_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_input_attachment_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_input_attachment_options>(),
        8usize,
        concat!("Size of: ", stringify!(nir_input_attachment_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_input_attachment_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_input_attachment_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_fragcoord_sysval) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_input_attachment_options),
            "::",
            stringify!(use_fragcoord_sysval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_layer_id_sysval) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_input_attachment_options),
            "::",
            stringify!(use_layer_id_sysval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_view_id_for_layer) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_input_attachment_options),
            "::",
            stringify!(use_view_id_for_layer)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).unscaled_input_attachment_ir3) as usize - ptr as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_input_attachment_options),
            "::",
            stringify!(unscaled_input_attachment_ir3)
        )
    );
}
extern "C" {
    pub fn nir_lower_input_attachments(
        shader: *mut nir_shader,
        options: *const nir_input_attachment_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_vs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_vars: bool,
        use_clipdist_array: bool,
        clipplane_state_tokens: *const [[gl_state_index16; 4usize]; 0usize],
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_gs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_clipdist_array: bool,
        clipplane_state_tokens: *const [[gl_state_index16; 4usize]; 0usize],
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_fs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_clipdist_array: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_cull_distance_to_vec4s(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_cull_distance_arrays(nir: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_clip_disable(
        shader: *mut nir_shader,
        clip_plane_enable: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_point_size_mov(
        shader: *mut nir_shader,
        pointsize_state_tokens: *const gl_state_index16,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_frexp(nir: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_two_sided_color(shader: *mut nir_shader, face_sysval: bool) -> bool;
}
extern "C" {
    pub fn nir_lower_clamp_color_outputs(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_flatshade(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_passthrough_edgeflags(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_patch_vertices(
        nir: *mut nir_shader,
        static_count: ::std::os::raw::c_uint,
        uniform_state_tokens: *const gl_state_index16,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_wpos_ytransform_options {
    pub state_tokens: [gl_state_index16; 4usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout_nir_lower_wpos_ytransform_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_wpos_ytransform_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_wpos_ytransform_options>(),
        10usize,
        concat!("Size of: ", stringify!(nir_lower_wpos_ytransform_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_wpos_ytransform_options>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(nir_lower_wpos_ytransform_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state_tokens) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_wpos_ytransform_options),
            "::",
            stringify!(state_tokens)
        )
    );
}
impl nir_lower_wpos_ytransform_options {
    #[inline]
    pub fn fs_coord_origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fs_coord_origin_lower_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_origin_lower_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fs_coord_pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fs_coord_pixel_center_half_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_pixel_center_half_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fs_coord_origin_upper_left: bool,
        fs_coord_origin_lower_left: bool,
        fs_coord_pixel_center_integer: bool,
        fs_coord_pixel_center_half_integer: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fs_coord_origin_upper_left: u8 =
                unsafe { ::std::mem::transmute(fs_coord_origin_upper_left) };
            fs_coord_origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fs_coord_origin_lower_left: u8 =
                unsafe { ::std::mem::transmute(fs_coord_origin_lower_left) };
            fs_coord_origin_lower_left as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fs_coord_pixel_center_integer: u8 =
                unsafe { ::std::mem::transmute(fs_coord_pixel_center_integer) };
            fs_coord_pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fs_coord_pixel_center_half_integer: u8 =
                unsafe { ::std::mem::transmute(fs_coord_pixel_center_half_integer) };
            fs_coord_pixel_center_half_integer as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_wpos_ytransform(
        shader: *mut nir_shader,
        options: *const nir_lower_wpos_ytransform_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_wpos_center(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_pntc_ytransform(
        shader: *mut nir_shader,
        clipplane_state_tokens: *const [[gl_state_index16; 4usize]; 0usize],
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_wrmasks(
        shader: *mut nir_shader,
        cb: nir_instr_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_fb_read(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_drawpixels_options {
    pub texcoord_state_tokens: [gl_state_index16; 4usize],
    pub scale_state_tokens: [gl_state_index16; 4usize],
    pub bias_state_tokens: [gl_state_index16; 4usize],
    pub drawpix_sampler: ::std::os::raw::c_uint,
    pub pixelmap_sampler: ::std::os::raw::c_uint,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_nir_lower_drawpixels_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_drawpixels_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_drawpixels_options>(),
        36usize,
        concat!("Size of: ", stringify!(nir_lower_drawpixels_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_drawpixels_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_lower_drawpixels_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texcoord_state_tokens) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_drawpixels_options),
            "::",
            stringify!(texcoord_state_tokens)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scale_state_tokens) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_drawpixels_options),
            "::",
            stringify!(scale_state_tokens)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bias_state_tokens) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_drawpixels_options),
            "::",
            stringify!(bias_state_tokens)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).drawpix_sampler) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_drawpixels_options),
            "::",
            stringify!(drawpix_sampler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pixelmap_sampler) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_drawpixels_options),
            "::",
            stringify!(pixelmap_sampler)
        )
    );
}
impl nir_lower_drawpixels_options {
    #[inline]
    pub fn pixel_maps(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_maps(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scale_and_bias(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_scale_and_bias(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pixel_maps: bool,
        scale_and_bias: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let pixel_maps: u8 = unsafe { ::std::mem::transmute(pixel_maps) };
            pixel_maps as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let scale_and_bias: u8 = unsafe { ::std::mem::transmute(scale_and_bias) };
            scale_and_bias as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_drawpixels(
        shader: *mut nir_shader,
        options: *const nir_lower_drawpixels_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_bitmap_options {
    pub sampler: ::std::os::raw::c_uint,
    pub swizzle_xxxx: bool,
}
#[test]
fn bindgen_test_layout_nir_lower_bitmap_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_bitmap_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_bitmap_options>(),
        8usize,
        concat!("Size of: ", stringify!(nir_lower_bitmap_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_bitmap_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_lower_bitmap_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_bitmap_options),
            "::",
            stringify!(sampler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).swizzle_xxxx) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_bitmap_options),
            "::",
            stringify!(swizzle_xxxx)
        )
    );
}
extern "C" {
    pub fn nir_lower_bitmap(
        shader: *mut nir_shader,
        options: *const nir_lower_bitmap_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_atomics_to_ssbo(
        shader: *mut nir_shader,
        offset_align_state: ::std::os::raw::c_uint,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_gs_intrinsics_flags {
    nir_lower_gs_intrinsics_per_stream = 1,
    nir_lower_gs_intrinsics_count_primitives = 2,
    nir_lower_gs_intrinsics_count_vertices_per_primitive = 4,
    nir_lower_gs_intrinsics_overwrite_incomplete = 8,
    nir_lower_gs_intrinsics_always_end_primitive = 16,
    nir_lower_gs_intrinsics_count_decomposed_primitives = 32,
}
extern "C" {
    pub fn nir_lower_gs_intrinsics(
        shader: *mut nir_shader,
        options: nir_lower_gs_intrinsics_flags,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_tess_coord_z(shader: *mut nir_shader, triangles: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_task_shader_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub payload_offset_in_bytes: u32,
}
#[test]
fn bindgen_test_layout_nir_lower_task_shader_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_task_shader_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_task_shader_options>(),
        8usize,
        concat!("Size of: ", stringify!(nir_lower_task_shader_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_task_shader_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_lower_task_shader_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).payload_offset_in_bytes) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_task_shader_options),
            "::",
            stringify!(payload_offset_in_bytes)
        )
    );
}
impl nir_lower_task_shader_options {
    #[inline]
    pub fn payload_to_shared_for_atomics(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_payload_to_shared_for_atomics(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn payload_to_shared_for_small_types(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_payload_to_shared_for_small_types(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        payload_to_shared_for_atomics: bool,
        payload_to_shared_for_small_types: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let payload_to_shared_for_atomics: u8 =
                unsafe { ::std::mem::transmute(payload_to_shared_for_atomics) };
            payload_to_shared_for_atomics as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let payload_to_shared_for_small_types: u8 =
                unsafe { ::std::mem::transmute(payload_to_shared_for_small_types) };
            payload_to_shared_for_small_types as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn nir_lower_task_shader(
        shader: *mut nir_shader,
        options: nir_lower_task_shader_options,
    ) -> bool;
}
pub type nir_lower_bit_size_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_instr,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
extern "C" {
    pub fn nir_lower_bit_size(
        shader: *mut nir_shader,
        callback: nir_lower_bit_size_callback,
        callback_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_64bit_phis(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_split_64bit_vec3_and_vec4(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_int64_op_to_options_mask(opcode: nir_op) -> nir_lower_int64_options;
}
extern "C" {
    pub fn nir_lower_int64(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_int64_float_conversions(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_doubles_op_to_options_mask(opcode: nir_op) -> nir_lower_doubles_options;
}
extern "C" {
    pub fn nir_lower_doubles(
        shader: *mut nir_shader,
        softfp64: *const nir_shader,
        options: nir_lower_doubles_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_pack(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_recompute_io_bases(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_lower_mediump_vars(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_lower_mediump_io(
        nir: *mut nir_shader,
        modes: nir_variable_mode,
        varying_mask: u64,
        use_16bit_slots: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_force_mediump_io(
        nir: *mut nir_shader,
        modes: nir_variable_mode,
        types: nir_alu_type,
    ) -> bool;
}
extern "C" {
    pub fn nir_unpack_16bit_varying_slots(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_tex_srcs_options {
    pub sampler_dims: ::std::os::raw::c_uint,
    pub src_types: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_opt_tex_srcs_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_opt_tex_srcs_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_opt_tex_srcs_options>(),
        8usize,
        concat!("Size of: ", stringify!(nir_opt_tex_srcs_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_opt_tex_srcs_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_opt_tex_srcs_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler_dims) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_tex_srcs_options),
            "::",
            stringify!(sampler_dims)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src_types) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_tex_srcs_options),
            "::",
            stringify!(src_types)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_16bit_tex_image_options {
    pub rounding_mode: nir_rounding_mode,
    pub opt_tex_dest_types: nir_alu_type,
    pub opt_image_dest_types: nir_alu_type,
    pub opt_image_store_data: bool,
    pub opt_image_srcs: bool,
    pub opt_srcs_options_count: ::std::os::raw::c_uint,
    pub opt_srcs_options: *mut nir_opt_tex_srcs_options,
}
#[test]
fn bindgen_test_layout_nir_opt_16bit_tex_image_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_opt_16bit_tex_image_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_opt_16bit_tex_image_options>(),
        24usize,
        concat!("Size of: ", stringify!(nir_opt_16bit_tex_image_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_opt_16bit_tex_image_options>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_opt_16bit_tex_image_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rounding_mode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(rounding_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opt_tex_dest_types) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(opt_tex_dest_types)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opt_image_dest_types) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(opt_image_dest_types)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opt_image_store_data) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(opt_image_store_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opt_image_srcs) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(opt_image_srcs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opt_srcs_options_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(opt_srcs_options_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opt_srcs_options) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_16bit_tex_image_options),
            "::",
            stringify!(opt_srcs_options)
        )
    );
}
impl Default for nir_opt_16bit_tex_image_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_opt_16bit_tex_image(
        nir: *mut nir_shader,
        options: *mut nir_opt_16bit_tex_image_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tex_src_type_constraint {
    pub legalize_type: bool,
    pub bit_size: u8,
    pub match_src: nir_tex_src_type,
}
#[test]
fn bindgen_test_layout_nir_tex_src_type_constraint() {
    const UNINIT: ::std::mem::MaybeUninit<nir_tex_src_type_constraint> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_tex_src_type_constraint>(),
        8usize,
        concat!("Size of: ", stringify!(nir_tex_src_type_constraint))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_tex_src_type_constraint>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_tex_src_type_constraint))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).legalize_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_src_type_constraint),
            "::",
            stringify!(legalize_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_size) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_src_type_constraint),
            "::",
            stringify!(bit_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).match_src) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_tex_src_type_constraint),
            "::",
            stringify!(match_src)
        )
    );
}
impl Default for nir_tex_src_type_constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type nir_tex_src_type_constraints = [nir_tex_src_type_constraint; 20usize];
extern "C" {
    pub fn nir_legalize_16bit_sampler_srcs(
        nir: *mut nir_shader,
        constraints: *mut nir_tex_src_type_constraints,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_point_size(
        shader: *mut nir_shader,
        min: ::std::os::raw::c_float,
        max: ::std::os::raw::c_float,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_texcoord_replace(
        s: *mut nir_shader,
        coord_replace: ::std::os::raw::c_uint,
        point_coord_is_sysval: bool,
        yinvert: bool,
    );
}
extern "C" {
    pub fn nir_lower_texcoord_replace_late(
        s: *mut nir_shader,
        coord_replace: ::std::os::raw::c_uint,
        point_coord_is_sysval: bool,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_interpolation_options {
    nir_lower_interpolation_at_sample = 2,
    nir_lower_interpolation_at_offset = 4,
    nir_lower_interpolation_centroid = 8,
    nir_lower_interpolation_pixel = 16,
    nir_lower_interpolation_sample = 32,
}
extern "C" {
    pub fn nir_lower_interpolation(
        shader: *mut nir_shader,
        options: nir_lower_interpolation_options,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_discard_if_options {
    nir_lower_discard_if_to_cf = 1,
    nir_lower_demote_if_to_cf = 2,
    nir_lower_terminate_if_to_cf = 4,
}
extern "C" {
    pub fn nir_lower_discard_if(
        shader: *mut nir_shader,
        options: nir_lower_discard_if_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_discard_or_demote(
        shader: *mut nir_shader,
        force_correct_quad_ops_after_discard: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_lower_terminate_to_demote(nir: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_memory_model(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_goto_ifs(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_continue_constructs(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_shader_uses_view_index(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_can_lower_multiview(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_multiview(shader: *mut nir_shader, view_mask: u32) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_fp16_cast_options {
    nir_lower_fp16_rtz = 1,
    nir_lower_fp16_rtne = 2,
    nir_lower_fp16_ru = 4,
    nir_lower_fp16_rd = 8,
    nir_lower_fp16_all = 15,
    nir_lower_fp16_split_fp64 = 16,
}
extern "C" {
    pub fn nir_lower_fp16_casts(
        shader: *mut nir_shader,
        options: nir_lower_fp16_cast_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_normalize_cubemap_coords(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_shader_supports_implicit_lod(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_live_defs_impl(impl_: *mut nir_function_impl);
}
extern "C" {
    pub fn nir_get_live_defs(
        cursor: nir_cursor,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *const ::std::os::raw::c_uint;
}
extern "C" {
    pub fn nir_loop_analyze_impl(
        impl_: *mut nir_function_impl,
        indirect_mask: nir_variable_mode,
        force_unroll_sampler_indirect: bool,
    );
}
extern "C" {
    pub fn nir_defs_interfere(a: *mut nir_def, b: *mut nir_def) -> bool;
}
extern "C" {
    pub fn nir_repair_ssa_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_repair_ssa(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_convert_loop_to_lcssa(loop_: *mut nir_loop);
}
extern "C" {
    pub fn nir_convert_to_lcssa(
        shader: *mut nir_shader,
        skip_invariants: bool,
        skip_bool_invariants: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_divergence_analysis(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_vertex_divergence_analysis(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_update_instr_divergence(shader: *mut nir_shader, instr: *mut nir_instr) -> bool;
}
extern "C" {
    pub fn nir_has_divergent_loop(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_rewrite_uses_to_load_reg(b: *mut nir_builder, old: *mut nir_def, reg: *mut nir_def);
}
extern "C" {
    pub fn nir_convert_from_ssa(shader: *mut nir_shader, phi_webs_only: bool) -> bool;
}
extern "C" {
    pub fn nir_lower_phis_to_regs_block(block: *mut nir_block) -> bool;
}
extern "C" {
    pub fn nir_lower_ssa_defs_to_regs_block(block: *mut nir_block) -> bool;
}
extern "C" {
    pub fn nir_rematerialize_deref_in_use_blocks(instr: *mut nir_deref_instr) -> bool;
}
extern "C" {
    pub fn nir_rematerialize_derefs_in_use_blocks_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_lower_samplers(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_cl_images(
        shader: *mut nir_shader,
        lower_image_derefs: bool,
        lower_sampler_derefs: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_dedup_inline_samplers(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_ssbo(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_helper_writes(shader: *mut nir_shader, lower_plain_stores: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_printf_options {
    pub max_buffer_size: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_nir_lower_printf_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_lower_printf_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_lower_printf_options>(),
        4usize,
        concat!("Size of: ", stringify!(nir_lower_printf_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_lower_printf_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_lower_printf_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_buffer_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_lower_printf_options),
            "::",
            stringify!(max_buffer_size)
        )
    );
}
extern "C" {
    pub fn nir_lower_printf(nir: *mut nir_shader, options: *const nir_lower_printf_options)
        -> bool;
}
extern "C" {
    pub fn nir_opt_comparison_pre_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_opt_comparison_pre(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_access_options {
    pub is_vulkan: bool,
}
#[test]
fn bindgen_test_layout_nir_opt_access_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_opt_access_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_opt_access_options>(),
        1usize,
        concat!("Size of: ", stringify!(nir_opt_access_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_opt_access_options>(),
        1usize,
        concat!("Alignment of ", stringify!(nir_opt_access_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_vulkan) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_access_options),
            "::",
            stringify!(is_vulkan)
        )
    );
}
extern "C" {
    pub fn nir_opt_access(shader: *mut nir_shader, options: *const nir_opt_access_options) -> bool;
}
extern "C" {
    pub fn nir_opt_algebraic(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_algebraic_before_ffma(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_algebraic_late(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_algebraic_distribute_src_mods(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_constant_folding(shader: *mut nir_shader) -> bool;
}
pub type nir_combine_barrier_cb = ::std::option::Option<
    unsafe extern "C" fn(
        a: *mut nir_intrinsic_instr,
        b: *mut nir_intrinsic_instr,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
extern "C" {
    pub fn nir_opt_combine_barriers(
        shader: *mut nir_shader,
        combine_cb: nir_combine_barrier_cb,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_barrier_modes(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_combine_stores(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
extern "C" {
    pub fn nir_copy_prop_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_copy_prop(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_copy_prop_vars(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_cse(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_dce(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_dead_cf(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_dead_write_vars(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_deref_impl(impl_: *mut nir_function_impl) -> bool;
}
extern "C" {
    pub fn nir_opt_deref(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_find_array_copies(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_fragdepth(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_gcm(shader: *mut nir_shader, value_number: bool) -> bool;
}
extern "C" {
    pub fn nir_opt_idiv_const(
        shader: *mut nir_shader,
        min_bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_mqsad(shader: *mut nir_shader) -> bool;
}
impl nir_opt_if_options {
    pub const nir_opt_if_optimize_phi_true_false: nir_opt_if_options = nir_opt_if_options(1);
}
impl nir_opt_if_options {
    pub const nir_opt_if_avoid_64bit_phis: nir_opt_if_options = nir_opt_if_options(2);
}
impl ::std::ops::BitOr<nir_opt_if_options> for nir_opt_if_options {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        nir_opt_if_options(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for nir_opt_if_options {
    #[inline]
    fn bitor_assign(&mut self, rhs: nir_opt_if_options) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<nir_opt_if_options> for nir_opt_if_options {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        nir_opt_if_options(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for nir_opt_if_options {
    #[inline]
    fn bitand_assign(&mut self, rhs: nir_opt_if_options) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_if_options(pub ::std::os::raw::c_uint);
extern "C" {
    pub fn nir_opt_if(shader: *mut nir_shader, options: nir_opt_if_options) -> bool;
}
extern "C" {
    pub fn nir_opt_intrinsics(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_large_constants(
        shader: *mut nir_shader,
        size_align: glsl_type_size_align_func,
        threshold: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_loop(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_loop_unroll(shader: *mut nir_shader) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_move_options {
    nir_move_const_undef = 1,
    nir_move_load_ubo = 2,
    nir_move_load_input = 4,
    nir_move_comparisons = 8,
    nir_move_copies = 16,
    nir_move_load_ssbo = 32,
    nir_move_load_uniform = 64,
    nir_move_alu = 128,
}
extern "C" {
    pub fn nir_can_move_instr(instr: *mut nir_instr, options: nir_move_options) -> bool;
}
extern "C" {
    pub fn nir_opt_sink(shader: *mut nir_shader, options: nir_move_options) -> bool;
}
extern "C" {
    pub fn nir_opt_move(shader: *mut nir_shader, options: nir_move_options) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_offsets_options {
    #[doc = " nir_load_uniform max base offset"]
    pub uniform_max: u32,
    #[doc = " nir_load_ubo_vec4 max base offset"]
    pub ubo_vec4_max: u32,
    #[doc = " nir_var_mem_shared max base offset"]
    pub shared_max: u32,
    #[doc = " nir_load/store_buffer_amd max base offset"]
    pub buffer_max: u32,
}
#[test]
fn bindgen_test_layout_nir_opt_offsets_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_opt_offsets_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_opt_offsets_options>(),
        16usize,
        concat!("Size of: ", stringify!(nir_opt_offsets_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_opt_offsets_options>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_opt_offsets_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uniform_max) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_offsets_options),
            "::",
            stringify!(uniform_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ubo_vec4_max) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_offsets_options),
            "::",
            stringify!(ubo_vec4_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shared_max) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_offsets_options),
            "::",
            stringify!(shared_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_max) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_offsets_options),
            "::",
            stringify!(buffer_max)
        )
    );
}
extern "C" {
    pub fn nir_opt_offsets(
        shader: *mut nir_shader,
        options: *const nir_opt_offsets_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_peephole_select(
        shader: *mut nir_shader,
        limit: ::std::os::raw::c_uint,
        indirect_load_ok: bool,
        expensive_alu_ok: bool,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_reassociate_bfi(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_rematerialize_compares(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_remove_phis(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_remove_phis_block(block: *mut nir_block) -> bool;
}
extern "C" {
    pub fn nir_opt_phi_precision(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_shrink_stores(shader: *mut nir_shader, shrink_image_store: bool) -> bool;
}
extern "C" {
    pub fn nir_opt_shrink_vectors(shader: *mut nir_shader, shrink_start: bool) -> bool;
}
extern "C" {
    pub fn nir_opt_undef(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_undef_to_zero(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_uniform_atomics(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_uniform_subgroup(
        shader: *mut nir_shader,
        arg1: *const nir_lower_subgroups_options,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_vectorize(
        shader: *mut nir_shader,
        filter: nir_vectorize_cb,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn nir_opt_conditional_discard(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_move_discards_to_top(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_ray_queries(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_ray_query_ranges(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_opt_reuse_constants(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_sweep(shader: *mut nir_shader);
}
extern "C" {
    pub fn nir_remap_dual_slot_attributes(shader: *mut nir_shader, dual_slot_inputs: *mut u64);
}
extern "C" {
    pub fn nir_get_single_slot_attribs_mask(attribs: u64, dual_slot: u64) -> u64;
}
extern "C" {
    pub fn nir_intrinsic_from_system_value(val: gl_system_value) -> nir_intrinsic_op;
}
extern "C" {
    pub fn nir_system_value_from_intrinsic(intrin: nir_intrinsic_op) -> gl_system_value;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_unsigned_upper_bound_config {
    pub min_subgroup_size: ::std::os::raw::c_uint,
    pub max_subgroup_size: ::std::os::raw::c_uint,
    pub max_workgroup_invocations: ::std::os::raw::c_uint,
    pub max_workgroup_count: [::std::os::raw::c_uint; 3usize],
    pub max_workgroup_size: [::std::os::raw::c_uint; 3usize],
    pub vertex_attrib_max: [u32; 32usize],
}
#[test]
fn bindgen_test_layout_nir_unsigned_upper_bound_config() {
    const UNINIT: ::std::mem::MaybeUninit<nir_unsigned_upper_bound_config> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_unsigned_upper_bound_config>(),
        164usize,
        concat!("Size of: ", stringify!(nir_unsigned_upper_bound_config))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_unsigned_upper_bound_config>(),
        4usize,
        concat!("Alignment of ", stringify!(nir_unsigned_upper_bound_config))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_subgroup_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_unsigned_upper_bound_config),
            "::",
            stringify!(min_subgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_subgroup_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_unsigned_upper_bound_config),
            "::",
            stringify!(max_subgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_workgroup_invocations) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_unsigned_upper_bound_config),
            "::",
            stringify!(max_workgroup_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_workgroup_count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_unsigned_upper_bound_config),
            "::",
            stringify!(max_workgroup_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_workgroup_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_unsigned_upper_bound_config),
            "::",
            stringify!(max_workgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vertex_attrib_max) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_unsigned_upper_bound_config),
            "::",
            stringify!(vertex_attrib_max)
        )
    );
}
extern "C" {
    pub fn nir_unsigned_upper_bound(
        shader: *mut nir_shader,
        range_ht: *mut hash_table,
        scalar: nir_scalar,
        config: *const nir_unsigned_upper_bound_config,
    ) -> u32;
}
extern "C" {
    pub fn nir_addition_might_overflow(
        shader: *mut nir_shader,
        range_ht: *mut hash_table,
        ssa: nir_scalar,
        const_val: ::std::os::raw::c_uint,
        config: *const nir_unsigned_upper_bound_config,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_preamble_options {
    pub drawid_uniform: bool,
    pub subgroup_size_uniform: bool,
    pub load_workgroup_size_allowed: bool,
    pub def_size: ::std::option::Option<
        unsafe extern "C" fn(
            def: *mut nir_def,
            size: *mut ::std::os::raw::c_uint,
            align: *mut ::std::os::raw::c_uint,
        ),
    >,
    pub preamble_storage_size: ::std::os::raw::c_uint,
    pub instr_cost_cb: ::std::option::Option<
        unsafe extern "C" fn(
            instr: *mut nir_instr,
            data: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_float,
    >,
    pub rewrite_cost_cb: ::std::option::Option<
        unsafe extern "C" fn(
            def: *mut nir_def,
            data: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_float,
    >,
    pub avoid_instr_cb: nir_instr_filter_cb,
    pub cb_data: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_nir_opt_preamble_options() {
    const UNINIT: ::std::mem::MaybeUninit<nir_opt_preamble_options> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nir_opt_preamble_options>(),
        56usize,
        concat!("Size of: ", stringify!(nir_opt_preamble_options))
    );
    assert_eq!(
        ::std::mem::align_of::<nir_opt_preamble_options>(),
        8usize,
        concat!("Alignment of ", stringify!(nir_opt_preamble_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).drawid_uniform) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(drawid_uniform)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subgroup_size_uniform) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(subgroup_size_uniform)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).load_workgroup_size_allowed) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(load_workgroup_size_allowed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(def_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preamble_storage_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(preamble_storage_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr_cost_cb) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(instr_cost_cb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rewrite_cost_cb) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(rewrite_cost_cb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).avoid_instr_cb) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(avoid_instr_cb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cb_data) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(nir_opt_preamble_options),
            "::",
            stringify!(cb_data)
        )
    );
}
impl Default for nir_opt_preamble_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn nir_opt_preamble(
        shader: *mut nir_shader,
        options: *const nir_opt_preamble_options,
        size: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_shader_get_preamble(shader: *mut nir_shader) -> *mut nir_function_impl;
}
extern "C" {
    pub fn nir_lower_point_smooth(shader: *mut nir_shader) -> bool;
}
extern "C" {
    pub fn nir_lower_poly_line_smooth(
        shader: *mut nir_shader,
        num_smooth_aa_sample: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_mod_analysis(
        val: nir_scalar,
        val_type: nir_alu_type,
        div: ::std::os::raw::c_uint,
        mod_: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_remove_tex_shadow(
        shader: *mut nir_shader,
        textures_bitmask: ::std::os::raw::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn nir_trivialize_registers(s: *mut nir_shader);
}
extern "C" {
    pub fn nir_static_workgroup_size(s: *const nir_shader) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_use_dominance_state {
    _unused: [u8; 0],
}
extern "C" {
    pub fn nir_calc_use_dominance_impl(
        impl_: *mut nir_function_impl,
        post_dominance: bool,
    ) -> *mut nir_use_dominance_state;
}
extern "C" {
    pub fn nir_get_immediate_use_dominator(
        state: *mut nir_use_dominance_state,
        instr: *mut nir_instr,
    ) -> *mut nir_instr;
}
extern "C" {
    pub fn nir_use_dominance_lca(
        state: *mut nir_use_dominance_state,
        i1: *mut nir_instr,
        i2: *mut nir_instr,
    ) -> *mut nir_instr;
}
extern "C" {
    pub fn nir_instr_dominates_use(
        state: *mut nir_use_dominance_state,
        parent: *mut nir_instr,
        child: *mut nir_instr,
    ) -> bool;
}
extern "C" {
    pub fn nir_print_use_dominators(
        state: *mut nir_use_dominance_state,
        instructions: *mut *mut nir_instr,
        num_instructions: ::std::os::raw::c_uint,
    );
}
pub type cache_key = [u8; 20usize];
pub type disk_cache_put_cb = ::std::option::Option<
    unsafe extern "C" fn(
        key: *const ::std::os::raw::c_void,
        keySize: ::std::os::raw::c_long,
        value: *const ::std::os::raw::c_void,
        valueSize: ::std::os::raw::c_long,
    ),
>;
pub type disk_cache_get_cb = ::std::option::Option<
    unsafe extern "C" fn(
        key: *const ::std::os::raw::c_void,
        keySize: ::std::os::raw::c_long,
        value: *mut ::std::os::raw::c_void,
        valueSize: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_long,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct cache_item_metadata {
    #[doc = " The cache item type. This could be used to identify a GLSL cache item,\n a certain type of IR (tgsi, nir, etc), or signal that it is the final\n binary form of the shader."]
    pub type_: u32,
    #[doc = " GLSL cache item metadata"]
    pub keys: *mut cache_key,
    pub num_keys: u32,
}
#[test]
fn bindgen_test_layout_cache_item_metadata() {
    const UNINIT: ::std::mem::MaybeUninit<cache_item_metadata> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cache_item_metadata>(),
        24usize,
        concat!("Size of: ", stringify!(cache_item_metadata))
    );
    assert_eq!(
        ::std::mem::align_of::<cache_item_metadata>(),
        8usize,
        concat!("Alignment of ", stringify!(cache_item_metadata))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cache_item_metadata),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keys) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cache_item_metadata),
            "::",
            stringify!(keys)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_keys) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cache_item_metadata),
            "::",
            stringify!(num_keys)
        )
    );
}
impl Default for cache_item_metadata {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct disk_cache {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Create a new cache object.\n\n This function creates the handle necessary for all subsequent cache_*\n functions.\n\n This cache provides two distinct operations:\n\n   o Storage and retrieval of arbitrary objects by cryptographic\n     name (or \"key\").  This is provided via disk_cache_put() and\n     disk_cache_get().\n\n   o The ability to store a key alone and check later whether the\n     key was previously stored. This is provided via disk_cache_put_key()\n     and disk_cache_has_key().\n\n The put_key()/has_key() operations are conceptually identical to\n put()/get() with no data, but are provided separately to allow for\n a more efficient implementation.\n\n In all cases, the keys are sequences of 20 bytes. It is anticipated\n that callers will compute appropriate SHA-1 signatures for keys,\n (though nothing in this implementation directly relies on how the\n names are computed). See mesa-sha1.h and _mesa_sha1_compute for\n assistance in computing SHA-1 signatures."]
    pub fn disk_cache_create(
        gpu_name: *const ::std::os::raw::c_char,
        timestamp: *const ::std::os::raw::c_char,
        driver_flags: u64,
    ) -> *mut disk_cache;
}
extern "C" {
    #[doc = " Destroy a cache object, (freeing all associated resources)."]
    pub fn disk_cache_destroy(cache: *mut disk_cache);
}
extern "C" {
    pub fn disk_cache_wait_for_idle(cache: *mut disk_cache);
}
extern "C" {
    #[doc = " Remove the item in the cache under the name \\key."]
    pub fn disk_cache_remove(cache: *mut disk_cache, key: *mut cache_key);
}
extern "C" {
    #[doc = " Store an item in the cache under the name \\key.\n\n The item can be retrieved later with disk_cache_get(), (unless the item has\n been evicted in the interim).\n\n Any call to disk_cache_put() may cause an existing, random item to be\n evicted from the cache."]
    pub fn disk_cache_put(
        cache: *mut disk_cache,
        key: *mut cache_key,
        data: *const ::std::os::raw::c_void,
        size: usize,
        cache_item_metadata: *mut cache_item_metadata,
    );
}
extern "C" {
    #[doc = " Store an item in the cache under the name \\key without copying the data param.\n\n The item can be retrieved later with disk_cache_get(), (unless the item has\n been evicted in the interim).\n\n Any call to disk_cache_put() may cause an existing, random item to be\n evicted from the cache.\n\n @p data will be freed"]
    pub fn disk_cache_put_nocopy(
        cache: *mut disk_cache,
        key: *mut cache_key,
        data: *mut ::std::os::raw::c_void,
        size: usize,
        cache_item_metadata: *mut cache_item_metadata,
    );
}
extern "C" {
    #[doc = " Retrieve an item previously stored in the cache with the name <key>.\n\n The item must have been previously stored with a call to disk_cache_put().\n\n If \\size is non-NULL, then, on successful return, it will be set to the\n size of the object.\n\n \\return A pointer to the stored object if found. NULL if the object\n is not found, or if any error occurs, (memory allocation failure,\n filesystem error, etc.). The returned data is malloc'ed so the\n caller should call free() it when finished."]
    pub fn disk_cache_get(
        cache: *mut disk_cache,
        key: *mut cache_key,
        size: *mut usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Store the name \\key within the cache, (without any associated data).\n\n Later this key can be checked with disk_cache_has_key(), (unless the key\n has been evicted in the interim).\n\n Any call to disk_cache_put_key() may cause an existing, random key to be\n evicted from the cache."]
    pub fn disk_cache_put_key(cache: *mut disk_cache, key: *mut cache_key);
}
extern "C" {
    #[doc = " Test whether the name \\key was previously recorded in the cache.\n\n Return value: True if disk_cache_put_key() was previously called with\n \\key, (and the key was not evicted in the interim).\n\n Note: disk_cache_has_key() will only return true for keys passed to\n disk_cache_put_key(). Specifically, a call to disk_cache_put() will not cause\n disk_cache_has_key() to return true for the same key."]
    pub fn disk_cache_has_key(cache: *mut disk_cache, key: *mut cache_key) -> bool;
}
extern "C" {
    #[doc = " Compute the name \\key from \\data of given \\size."]
    pub fn disk_cache_compute_key(
        cache: *mut disk_cache,
        data: *const ::std::os::raw::c_void,
        size: usize,
        key: *mut cache_key,
    );
}
extern "C" {
    pub fn disk_cache_set_callbacks(
        cache: *mut disk_cache,
        put: disk_cache_put_cb,
        get: disk_cache_get_cb,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_video_profile {
    PIPE_VIDEO_PROFILE_UNKNOWN = 0,
    PIPE_VIDEO_PROFILE_MPEG1 = 1,
    PIPE_VIDEO_PROFILE_MPEG2_SIMPLE = 2,
    PIPE_VIDEO_PROFILE_MPEG2_MAIN = 3,
    PIPE_VIDEO_PROFILE_MPEG4_SIMPLE = 4,
    PIPE_VIDEO_PROFILE_MPEG4_ADVANCED_SIMPLE = 5,
    PIPE_VIDEO_PROFILE_VC1_SIMPLE = 6,
    PIPE_VIDEO_PROFILE_VC1_MAIN = 7,
    PIPE_VIDEO_PROFILE_VC1_ADVANCED = 8,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_BASELINE = 9,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_CONSTRAINED_BASELINE = 10,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_MAIN = 11,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_EXTENDED = 12,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_HIGH = 13,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_HIGH10 = 14,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_HIGH422 = 15,
    PIPE_VIDEO_PROFILE_MPEG4_AVC_HIGH444 = 16,
    PIPE_VIDEO_PROFILE_HEVC_MAIN = 17,
    PIPE_VIDEO_PROFILE_HEVC_MAIN_10 = 18,
    PIPE_VIDEO_PROFILE_HEVC_MAIN_STILL = 19,
    PIPE_VIDEO_PROFILE_HEVC_MAIN_12 = 20,
    PIPE_VIDEO_PROFILE_HEVC_MAIN_444 = 21,
    PIPE_VIDEO_PROFILE_JPEG_BASELINE = 22,
    PIPE_VIDEO_PROFILE_VP9_PROFILE0 = 23,
    PIPE_VIDEO_PROFILE_VP9_PROFILE2 = 24,
    PIPE_VIDEO_PROFILE_AV1_MAIN = 25,
    PIPE_VIDEO_PROFILE_MAX = 26,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_video_cap {
    PIPE_VIDEO_CAP_SUPPORTED = 0,
    PIPE_VIDEO_CAP_NPOT_TEXTURES = 1,
    PIPE_VIDEO_CAP_MAX_WIDTH = 2,
    PIPE_VIDEO_CAP_MAX_HEIGHT = 3,
    PIPE_VIDEO_CAP_PREFERED_FORMAT = 4,
    PIPE_VIDEO_CAP_PREFERS_INTERLACED = 5,
    PIPE_VIDEO_CAP_SUPPORTS_PROGRESSIVE = 6,
    PIPE_VIDEO_CAP_SUPPORTS_INTERLACED = 7,
    PIPE_VIDEO_CAP_MAX_LEVEL = 8,
    PIPE_VIDEO_CAP_STACKED_FRAMES = 9,
    PIPE_VIDEO_CAP_MAX_MACROBLOCKS = 10,
    PIPE_VIDEO_CAP_MAX_TEMPORAL_LAYERS = 11,
    PIPE_VIDEO_CAP_EFC_SUPPORTED = 12,
    PIPE_VIDEO_CAP_ENC_MAX_SLICES_PER_FRAME = 13,
    PIPE_VIDEO_CAP_ENC_SLICES_STRUCTURE = 14,
    PIPE_VIDEO_CAP_ENC_MAX_REFERENCES_PER_FRAME = 15,
    PIPE_VIDEO_CAP_VPP_ORIENTATION_MODES = 16,
    PIPE_VIDEO_CAP_VPP_BLEND_MODES = 17,
    PIPE_VIDEO_CAP_VPP_MAX_INPUT_WIDTH = 18,
    PIPE_VIDEO_CAP_VPP_MAX_INPUT_HEIGHT = 19,
    PIPE_VIDEO_CAP_VPP_MIN_INPUT_WIDTH = 20,
    PIPE_VIDEO_CAP_VPP_MIN_INPUT_HEIGHT = 21,
    PIPE_VIDEO_CAP_VPP_MAX_OUTPUT_WIDTH = 22,
    PIPE_VIDEO_CAP_VPP_MAX_OUTPUT_HEIGHT = 23,
    PIPE_VIDEO_CAP_VPP_MIN_OUTPUT_WIDTH = 24,
    PIPE_VIDEO_CAP_VPP_MIN_OUTPUT_HEIGHT = 25,
    PIPE_VIDEO_CAP_ENC_QUALITY_LEVEL = 26,
    PIPE_VIDEO_CAP_SUPPORTS_CONTIGUOUS_PLANES_MAP = 27,
    PIPE_VIDEO_CAP_ENC_SUPPORTS_MAX_FRAME_SIZE = 28,
    PIPE_VIDEO_CAP_ENC_HEVC_BLOCK_SIZES = 29,
    PIPE_VIDEO_CAP_ENC_HEVC_FEATURE_FLAGS = 30,
    PIPE_VIDEO_CAP_ENC_HEVC_PREDICTION_DIRECTION = 31,
    PIPE_VIDEO_CAP_REQUIRES_FLUSH_ON_END_FRAME = 32,
    PIPE_VIDEO_CAP_ENC_SUPPORTS_ASYNC_OPERATION = 33,
    PIPE_VIDEO_CAP_MIN_WIDTH = 34,
    PIPE_VIDEO_CAP_MIN_HEIGHT = 35,
    PIPE_VIDEO_CAP_ENC_RATE_CONTROL_QVBR = 36,
    PIPE_VIDEO_CAP_ENC_AV1_FEATURE = 37,
    PIPE_VIDEO_CAP_ENC_AV1_FEATURE_EXT1 = 38,
    PIPE_VIDEO_CAP_ENC_AV1_FEATURE_EXT2 = 39,
    PIPE_VIDEO_CAP_ENC_SUPPORTS_TILE = 40,
    PIPE_VIDEO_CAP_ENC_MAX_TILE_ROWS = 41,
    PIPE_VIDEO_CAP_ENC_MAX_TILE_COLS = 42,
    PIPE_VIDEO_CAP_ENC_INTRA_REFRESH = 43,
    PIPE_VIDEO_CAP_ENC_SUPPORTS_FEEDBACK_METADATA = 44,
    PIPE_VIDEO_CAP_ENC_H264_DISABLE_DBK_FILTER_MODES_SUPPORTED = 45,
    PIPE_VIDEO_CAP_ENC_INTRA_REFRESH_MAX_DURATION = 46,
    PIPE_VIDEO_CAP_ENC_H264_SUPPORTS_CABAC_ENCODE = 47,
    PIPE_VIDEO_CAP_ROI_CROP_DEC = 48,
    PIPE_VIDEO_CAP_ENC_ROI = 49,
    PIPE_VIDEO_CAP_ENC_SURFACE_ALIGNMENT = 50,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_video_entrypoint {
    PIPE_VIDEO_ENTRYPOINT_UNKNOWN = 0,
    PIPE_VIDEO_ENTRYPOINT_BITSTREAM = 1,
    PIPE_VIDEO_ENTRYPOINT_IDCT = 2,
    PIPE_VIDEO_ENTRYPOINT_MC = 3,
    PIPE_VIDEO_ENTRYPOINT_ENCODE = 4,
    PIPE_VIDEO_ENTRYPOINT_PROCESSING = 5,
}
pub const PIPE_POLYGON_MODE_FILL: _bindgen_ty_31 = _bindgen_ty_31::PIPE_POLYGON_MODE_FILL;
pub const PIPE_POLYGON_MODE_LINE: _bindgen_ty_31 = _bindgen_ty_31::PIPE_POLYGON_MODE_LINE;
pub const PIPE_POLYGON_MODE_POINT: _bindgen_ty_31 = _bindgen_ty_31::PIPE_POLYGON_MODE_POINT;
pub const PIPE_POLYGON_MODE_FILL_RECTANGLE: _bindgen_ty_31 =
    _bindgen_ty_31::PIPE_POLYGON_MODE_FILL_RECTANGLE;
#[repr(u32)]
#[doc = " Polygon fill mode"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum _bindgen_ty_31 {
    PIPE_POLYGON_MODE_FILL = 0,
    PIPE_POLYGON_MODE_LINE = 1,
    PIPE_POLYGON_MODE_POINT = 2,
    PIPE_POLYGON_MODE_FILL_RECTANGLE = 3,
}
#[repr(u32)]
#[doc = " Texture types.\n See the documentation for info on PIPE_TEXTURE_RECT vs PIPE_TEXTURE_2D"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_texture_target {
    PIPE_BUFFER = 0,
    PIPE_TEXTURE_1D = 1,
    PIPE_TEXTURE_2D = 2,
    PIPE_TEXTURE_3D = 3,
    PIPE_TEXTURE_CUBE = 4,
    PIPE_TEXTURE_RECT = 5,
    PIPE_TEXTURE_1D_ARRAY = 6,
    PIPE_TEXTURE_2D_ARRAY = 7,
    PIPE_TEXTURE_CUBE_ARRAY = 8,
    PIPE_MAX_TEXTURE_TYPES = 9,
}
pub mod pipe_tex_wrap {
    pub type Type = ::std::os::raw::c_uint;
    pub const PIPE_TEX_WRAP_REPEAT: Type = 0;
    pub const PIPE_TEX_WRAP_CLAMP: Type = 1;
    pub const PIPE_TEX_WRAP_CLAMP_TO_EDGE: Type = 2;
    pub const PIPE_TEX_WRAP_CLAMP_TO_BORDER: Type = 3;
    pub const PIPE_TEX_WRAP_MIRROR_REPEAT: Type = 4;
    pub const PIPE_TEX_WRAP_MIRROR_CLAMP: Type = 5;
    pub const PIPE_TEX_WRAP_MIRROR_CLAMP_TO_EDGE: Type = 6;
    pub const PIPE_TEX_WRAP_MIRROR_CLAMP_TO_BORDER: Type = 7;
}
pub mod pipe_tex_filter {
    #[doc = " Within a mipmap, ie min/mag filter"]
    pub type Type = ::std::os::raw::c_uint;
    pub const PIPE_TEX_FILTER_NEAREST: Type = 0;
    pub const PIPE_TEX_FILTER_LINEAR: Type = 1;
}
impl pipe_map_flags {
    pub const PIPE_MAP_NONE: pipe_map_flags = pipe_map_flags(0);
}
impl pipe_map_flags {
    #[doc = " Resource contents read back (or accessed directly) at transfer\n create time."]
    pub const PIPE_MAP_READ: pipe_map_flags = pipe_map_flags(1);
}
impl pipe_map_flags {
    #[doc = " Resource contents will be written back at buffer/texture_unmap\n time (or modified as a result of being accessed directly)."]
    pub const PIPE_MAP_WRITE: pipe_map_flags = pipe_map_flags(2);
}
impl pipe_map_flags {
    #[doc = " Read/modify/write"]
    pub const PIPE_MAP_READ_WRITE: pipe_map_flags = pipe_map_flags(3);
}
impl pipe_map_flags {
    #[doc = " The transfer should map the texture storage directly. The driver may\n return NULL if that isn't possible, and the gallium frontend needs to cope\n with that and use an alternative path without this flag.\n\n E.g. the gallium frontend could have a simpler path which maps textures and\n does read/modify/write cycles on them directly, and a more complicated\n path which uses minimal read and write transfers.\n\n This flag supresses implicit \"DISCARD\" for buffer_subdata."]
    pub const PIPE_MAP_DIRECTLY: pipe_map_flags = pipe_map_flags(4);
}
impl pipe_map_flags {
    #[doc = " Discards the memory within the mapped region.\n\n It should not be used with PIPE_MAP_READ.\n\n See also:\n - OpenGL's ARB_map_buffer_range extension, MAP_INVALIDATE_RANGE_BIT flag."]
    pub const PIPE_MAP_DISCARD_RANGE: pipe_map_flags = pipe_map_flags(8);
}
impl pipe_map_flags {
    #[doc = " Fail if the resource cannot be mapped immediately.\n\n See also:\n - Direct3D's D3DLOCK_DONOTWAIT flag.\n - Mesa's MESA_MAP_NOWAIT_BIT flag.\n - WDDM's D3DDDICB_LOCKFLAGS.DonotWait flag."]
    pub const PIPE_MAP_DONTBLOCK: pipe_map_flags = pipe_map_flags(16);
}
impl pipe_map_flags {
    #[doc = " Do not attempt to synchronize pending operations on the resource when mapping.\n\n It should not be used with PIPE_MAP_READ.\n\n See also:\n - OpenGL's ARB_map_buffer_range extension, MAP_UNSYNCHRONIZED_BIT flag.\n - Direct3D's D3DLOCK_NOOVERWRITE flag.\n - WDDM's D3DDDICB_LOCKFLAGS.IgnoreSync flag."]
    pub const PIPE_MAP_UNSYNCHRONIZED: pipe_map_flags = pipe_map_flags(32);
}
impl pipe_map_flags {
    #[doc = " Written ranges will be notified later with\n pipe_context::transfer_flush_region.\n\n It should not be used with PIPE_MAP_READ.\n\n See also:\n - pipe_context::transfer_flush_region\n - OpenGL's ARB_map_buffer_range extension, MAP_FLUSH_EXPLICIT_BIT flag."]
    pub const PIPE_MAP_FLUSH_EXPLICIT: pipe_map_flags = pipe_map_flags(64);
}
impl pipe_map_flags {
    #[doc = " Discards all memory backing the resource.\n\n It should not be used with PIPE_MAP_READ.\n\n This is equivalent to:\n - OpenGL's ARB_map_buffer_range extension, MAP_INVALIDATE_BUFFER_BIT\n - BufferData(NULL) on a GL buffer\n - Direct3D's D3DLOCK_DISCARD flag.\n - WDDM's D3DDDICB_LOCKFLAGS.Discard flag.\n - D3D10 DDI's D3D10_DDI_MAP_WRITE_DISCARD flag\n - D3D10's D3D10_MAP_WRITE_DISCARD flag."]
    pub const PIPE_MAP_DISCARD_WHOLE_RESOURCE: pipe_map_flags = pipe_map_flags(128);
}
impl pipe_map_flags {
    #[doc = " Allows the resource to be used for rendering while mapped.\n\n PIPE_RESOURCE_FLAG_MAP_PERSISTENT must be set when creating\n the resource.\n\n If COHERENT is not set, memory_barrier(PIPE_BARRIER_MAPPED_BUFFER)\n must be called to ensure the device can see what the CPU has written."]
    pub const PIPE_MAP_PERSISTENT: pipe_map_flags = pipe_map_flags(256);
}
impl pipe_map_flags {
    #[doc = " If PERSISTENT is set, this ensures any writes done by the device are\n immediately visible to the CPU and vice versa.\n\n PIPE_RESOURCE_FLAG_MAP_COHERENT must be set when creating\n the resource."]
    pub const PIPE_MAP_COHERENT: pipe_map_flags = pipe_map_flags(512);
}
impl pipe_map_flags {
    #[doc = " Map a resource in a thread-safe manner, because the calling thread can\n be any thread. It can only be used if both WRITE and UNSYNCHRONIZED are\n set."]
    pub const PIPE_MAP_THREAD_SAFE: pipe_map_flags = pipe_map_flags(1024);
}
impl pipe_map_flags {
    #[doc = " Map only the depth aspect of a resource"]
    pub const PIPE_MAP_DEPTH_ONLY: pipe_map_flags = pipe_map_flags(2048);
}
impl pipe_map_flags {
    #[doc = " Map only the stencil aspect of a resource"]
    pub const PIPE_MAP_STENCIL_ONLY: pipe_map_flags = pipe_map_flags(4096);
}
impl pipe_map_flags {
    #[doc = " Mapping will be used only once (never remapped)."]
    pub const PIPE_MAP_ONCE: pipe_map_flags = pipe_map_flags(8192);
}
impl pipe_map_flags {
    #[doc = " This and higher bits are reserved for private use by drivers. Drivers\n should use this as (PIPE_MAP_DRV_PRV << i)."]
    pub const PIPE_MAP_DRV_PRV: pipe_map_flags = pipe_map_flags(16384);
}
impl ::std::ops::BitOr<pipe_map_flags> for pipe_map_flags {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        pipe_map_flags(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for pipe_map_flags {
    #[inline]
    fn bitor_assign(&mut self, rhs: pipe_map_flags) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<pipe_map_flags> for pipe_map_flags {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        pipe_map_flags(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for pipe_map_flags {
    #[inline]
    fn bitand_assign(&mut self, rhs: pipe_map_flags) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[doc = " CPU access map flags"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_map_flags(pub ::std::os::raw::c_uint);
impl pipe_resource_usage {
    pub const PIPE_USAGE_DEFAULT: pipe_resource_usage = pipe_resource_usage(0);
}
impl pipe_resource_usage {
    pub const PIPE_USAGE_IMMUTABLE: pipe_resource_usage = pipe_resource_usage(1);
}
impl pipe_resource_usage {
    pub const PIPE_USAGE_DYNAMIC: pipe_resource_usage = pipe_resource_usage(2);
}
impl pipe_resource_usage {
    pub const PIPE_USAGE_STREAM: pipe_resource_usage = pipe_resource_usage(3);
}
impl pipe_resource_usage {
    pub const PIPE_USAGE_STAGING: pipe_resource_usage = pipe_resource_usage(4);
}
impl ::std::ops::BitOr<pipe_resource_usage> for pipe_resource_usage {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        pipe_resource_usage(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for pipe_resource_usage {
    #[inline]
    fn bitor_assign(&mut self, rhs: pipe_resource_usage) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<pipe_resource_usage> for pipe_resource_usage {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        pipe_resource_usage(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for pipe_resource_usage {
    #[inline]
    fn bitand_assign(&mut self, rhs: pipe_resource_usage) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[doc = " Hint about the expected lifecycle of a resource.\n Sorted according to GPU vs CPU access."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_resource_usage(pub ::std::os::raw::c_uint);
pub mod pipe_query_type {
    #[doc = " Query object types"]
    pub type Type = ::std::os::raw::c_uint;
    pub const PIPE_QUERY_OCCLUSION_COUNTER: Type = 0;
    pub const PIPE_QUERY_OCCLUSION_PREDICATE: Type = 1;
    pub const PIPE_QUERY_OCCLUSION_PREDICATE_CONSERVATIVE: Type = 2;
    pub const PIPE_QUERY_TIMESTAMP: Type = 3;
    pub const PIPE_QUERY_TIMESTAMP_DISJOINT: Type = 4;
    pub const PIPE_QUERY_TIME_ELAPSED: Type = 5;
    pub const PIPE_QUERY_PRIMITIVES_GENERATED: Type = 6;
    pub const PIPE_QUERY_PRIMITIVES_EMITTED: Type = 7;
    pub const PIPE_QUERY_SO_STATISTICS: Type = 8;
    pub const PIPE_QUERY_SO_OVERFLOW_PREDICATE: Type = 9;
    pub const PIPE_QUERY_SO_OVERFLOW_ANY_PREDICATE: Type = 10;
    pub const PIPE_QUERY_GPU_FINISHED: Type = 11;
    pub const PIPE_QUERY_PIPELINE_STATISTICS: Type = 12;
    pub const PIPE_QUERY_PIPELINE_STATISTICS_SINGLE: Type = 13;
    pub const PIPE_QUERY_TYPES: Type = 14;
    pub const PIPE_QUERY_DRIVER_SPECIFIC: Type = 256;
}
#[repr(u32)]
#[doc = " Conditional rendering modes"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_render_cond_flag {
    PIPE_RENDER_COND_WAIT = 0,
    PIPE_RENDER_COND_NO_WAIT = 1,
    PIPE_RENDER_COND_BY_REGION_WAIT = 2,
    PIPE_RENDER_COND_BY_REGION_NO_WAIT = 3,
}
#[repr(u32)]
#[doc = " Viewport swizzles"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_viewport_swizzle {
    PIPE_VIEWPORT_SWIZZLE_POSITIVE_X = 0,
    PIPE_VIEWPORT_SWIZZLE_NEGATIVE_X = 1,
    PIPE_VIEWPORT_SWIZZLE_POSITIVE_Y = 2,
    PIPE_VIEWPORT_SWIZZLE_NEGATIVE_Y = 3,
    PIPE_VIEWPORT_SWIZZLE_POSITIVE_Z = 4,
    PIPE_VIEWPORT_SWIZZLE_NEGATIVE_Z = 5,
    PIPE_VIEWPORT_SWIZZLE_POSITIVE_W = 6,
    PIPE_VIEWPORT_SWIZZLE_NEGATIVE_W = 7,
}
#[repr(u32)]
#[doc = " Device reset status."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_reset_status {
    PIPE_NO_RESET = 0,
    PIPE_GUILTY_CONTEXT_RESET = 1,
    PIPE_INNOCENT_CONTEXT_RESET = 2,
    PIPE_UNKNOWN_CONTEXT_RESET = 3,
}
#[repr(u32)]
#[doc = " Implementation capabilities/limits which are queried through\n pipe_screen::get_param()"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_cap {
    PIPE_CAP_GRAPHICS = 0,
    PIPE_CAP_NPOT_TEXTURES = 1,
    PIPE_CAP_MAX_DUAL_SOURCE_RENDER_TARGETS = 2,
    PIPE_CAP_ANISOTROPIC_FILTER = 3,
    PIPE_CAP_MAX_RENDER_TARGETS = 4,
    PIPE_CAP_OCCLUSION_QUERY = 5,
    PIPE_CAP_QUERY_TIME_ELAPSED = 6,
    PIPE_CAP_TEXTURE_SHADOW_MAP = 7,
    PIPE_CAP_TEXTURE_SWIZZLE = 8,
    PIPE_CAP_MAX_TEXTURE_2D_SIZE = 9,
    PIPE_CAP_MAX_TEXTURE_3D_LEVELS = 10,
    PIPE_CAP_MAX_TEXTURE_CUBE_LEVELS = 11,
    PIPE_CAP_TEXTURE_MIRROR_CLAMP = 12,
    PIPE_CAP_BLEND_EQUATION_SEPARATE = 13,
    PIPE_CAP_MAX_STREAM_OUTPUT_BUFFERS = 14,
    PIPE_CAP_PRIMITIVE_RESTART = 15,
    #[doc = " subset of PRIMITIVE_RESTART where the restart index is always the fixed\n maximum value for the index type"]
    PIPE_CAP_PRIMITIVE_RESTART_FIXED_INDEX = 16,
    #[doc = " blend enables and write masks per rendertarget"]
    PIPE_CAP_INDEP_BLEND_ENABLE = 17,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_INDEP_BLEND_FUNC = 18,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXTURE_ARRAY_LAYERS = 19,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_COORD_ORIGIN_UPPER_LEFT = 20,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_COORD_ORIGIN_LOWER_LEFT = 21,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_COORD_PIXEL_CENTER_HALF_INTEGER = 22,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_COORD_PIXEL_CENTER_INTEGER = 23,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEPTH_CLIP_DISABLE = 24,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEPTH_CLIP_DISABLE_SEPARATE = 25,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEPTH_CLAMP_ENABLE = 26,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_STENCIL_EXPORT = 27,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VS_INSTANCEID = 28,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_ELEMENT_INSTANCE_DIVISOR = 29,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRAGMENT_COLOR_CLAMPED = 30,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MIXED_COLORBUFFER_FORMATS = 31,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SEAMLESS_CUBE_MAP = 32,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SEAMLESS_CUBE_MAP_PER_TEXTURE = 33,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MIN_TEXEL_OFFSET = 34,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXEL_OFFSET = 35,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONDITIONAL_RENDER = 36,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_BARRIER = 37,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_STREAM_OUTPUT_SEPARATE_COMPONENTS = 38,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_STREAM_OUTPUT_INTERLEAVED_COMPONENTS = 39,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_STREAM_OUTPUT_PAUSE_RESUME = 40,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TGSI_CAN_COMPACT_CONSTANTS = 41,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_COLOR_UNCLAMPED = 42,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_COLOR_CLAMPED = 43,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GLSL_FEATURE_LEVEL = 44,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GLSL_FEATURE_LEVEL_COMPATIBILITY = 45,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ESSL_FEATURE_LEVEL = 46,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 47,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_USER_VERTEX_BUFFERS = 48,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_BUFFER_OFFSET_4BYTE_ALIGNED_ONLY = 49,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_BUFFER_STRIDE_4BYTE_ALIGNED_ONLY = 50,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_ELEMENT_SRC_OFFSET_4BYTE_ALIGNED_ONLY = 51,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VERTEX_ATTRIB_ELEMENT_ALIGNED_ONLY = 52,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_COMPUTE = 53,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSTANT_BUFFER_OFFSET_ALIGNMENT = 54,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_START_INSTANCE = 55,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUERY_TIMESTAMP = 56,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TIMER_RESOLUTION = 57,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_MULTISAMPLE = 58,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MIN_MAP_BUFFER_ALIGNMENT = 59,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CUBE_MAP_ARRAY = 60,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_BUFFER_OBJECTS = 61,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 62,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_BUFFER_SAMPLER_VIEW_RGBA_ONLY = 63,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TGSI_TEXCOORD = 64,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_LINEAR_IMAGE_PITCH_ALIGNMENT = 65,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_LINEAR_IMAGE_BASE_ADDRESS_ALIGNMENT = 66,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_TRANSFER_MODES = 67,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUERY_PIPELINE_STATISTICS = 68,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_BORDER_COLOR_QUIRK = 69,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXEL_BUFFER_ELEMENTS_UINT = 70,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_VIEWPORTS = 71,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ENDIANNESS = 72,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MIXED_FRAMEBUFFER_SIZES = 73,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VS_LAYER_VIEWPORT = 74,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_GEOMETRY_OUTPUT_VERTICES = 75,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 76,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXTURE_GATHER_COMPONENTS = 77,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_GATHER_SM5 = 78,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_BUFFER_MAP_PERSISTENT_COHERENT = 79,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FAKE_SW_MSAA = 80,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_QUERY_LOD = 81,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MIN_TEXTURE_GATHER_OFFSET = 82,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXTURE_GATHER_OFFSET = 83,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SAMPLE_SHADING = 84,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_GATHER_OFFSETS = 85,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VS_WINDOW_SPACE_POSITION = 86,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_VERTEX_STREAMS = 87,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DRAW_INDIRECT = 88,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_FINE_DERIVATIVE = 89,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VENDOR_ID = 90,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEVICE_ID = 91,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ACCELERATED = 92,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VIDEO_MEMORY = 93,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_UMA = 94,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONDITIONAL_RENDER_INVERTED = 95,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_VERTEX_ATTRIB_STRIDE = 96,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SAMPLER_VIEW_TARGET = 97,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CLIP_HALFZ = 98,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_POLYGON_OFFSET_CLAMP = 99,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MULTISAMPLE_Z_RESOLVE = 100,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_RESOURCE_FROM_USER_MEMORY = 101,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_RESOURCE_FROM_USER_MEMORY_COMPUTE_ONLY = 102,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEVICE_RESET_STATUS_QUERY = 103,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_SHADER_PATCH_VARYINGS = 104,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_FLOAT_LINEAR = 105,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_HALF_FLOAT_LINEAR = 106,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEPTH_BOUNDS_TEST = 107,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_QUERY_SAMPLES = 108,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FORCE_PERSAMPLE_INTERP = 109,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHAREABLE_SHADERS = 110,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_COPY_BETWEEN_COMPRESSED_AND_PLAIN_FORMATS = 111,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CLEAR_SCISSORED = 112,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DRAW_PARAMETERS = 113,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_PACK_HALF_FLOAT = 114,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MULTI_DRAW_INDIRECT = 115,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MULTI_DRAW_INDIRECT_PARAMS = 116,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MULTI_DRAW_INDIRECT_PARTIAL_STRIDE = 117,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_POSITION_IS_SYSVAL = 118,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_POINT_IS_SYSVAL = 119,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FS_FACE_IS_INTEGER_SYSVAL = 120,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_BUFFER_OFFSET_ALIGNMENT = 121,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_INVALIDATE_BUFFER = 122,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GENERATE_MIPMAP = 123,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_STRING_MARKER = 124,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SURFACE_REINTERPRET_BLOCKS = 125,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUERY_BUFFER_OBJECT = 126,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUERY_MEMORY_INFO = 127,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PCI_GROUP = 128,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PCI_BUS = 129,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PCI_DEVICE = 130,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PCI_FUNCTION = 131,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRAMEBUFFER_NO_ATTACHMENT = 132,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ROBUST_BUFFER_ACCESS_BEHAVIOR = 133,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CULL_DISTANCE = 134,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CULL_DISTANCE_NOCOMBINE = 135,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_GROUP_VOTE = 136,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_WINDOW_RECTANGLES = 137,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_POLYGON_OFFSET_UNITS_UNSCALED = 138,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VIEWPORT_SUBPIXEL_BITS = 139,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_RASTERIZER_SUBPIXEL_BITS = 140,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MIXED_COLOR_DEPTH_BITS = 141,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_ARRAY_COMPONENTS = 142,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_STREAM_OUTPUT_INTERLEAVE_BUFFERS = 143,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_CAN_READ_OUTPUTS = 144,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_NATIVE_FENCE_FD = 145,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GLSL_TESS_LEVELS_AS_INPUTS = 146,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FBFETCH = 147,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_LEGACY_MATH_RULES = 148,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FP16 = 149,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DOUBLES = 150,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_INT64 = 151,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TGSI_TEX_TXF_LZ = 152,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_CLOCK = 153,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_POLYGON_MODE_FILL_RECTANGLE = 154,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SPARSE_BUFFER_PAGE_SIZE = 155,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_BALLOT = 156,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TES_LAYER_VIEWPORT = 157,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CAN_BIND_CONST_BUFFER_AS_VERTEX = 158,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ALLOW_MAPPED_BUFFERS_DURING_EXECUTION = 159,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_POST_DEPTH_COVERAGE = 160,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_BINDLESS_TEXTURE = 161,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_NIR_SAMPLERS_AS_DEREF = 162,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUERY_SO_OVERFLOW = 163,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MEMOBJ = 164,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_LOAD_CONSTBUF = 165,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TILE_RASTER_ORDER = 166,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 167,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRAMEBUFFER_MSAA_CONSTRAINTS = 168,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SIGNED_VERTEX_BUFFER_OFFSET = 169,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONTEXT_PRIORITY_MASK = 170,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FENCE_SIGNAL = 171,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSTBUF0_FLAGS = 172,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PACKED_UNIFORMS = 173,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSERVATIVE_RASTER_POST_SNAP_TRIANGLES = 174,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSERVATIVE_RASTER_POST_SNAP_POINTS_LINES = 175,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSERVATIVE_RASTER_PRE_SNAP_TRIANGLES = 176,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSERVATIVE_RASTER_PRE_SNAP_POINTS_LINES = 177,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_CONSERVATIVE_RASTER_SUBPIXEL_PRECISION_BIAS = 178,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSERVATIVE_RASTER_POST_DEPTH_COVERAGE = 179,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CONSERVATIVE_RASTER_INNER_COVERAGE = 180,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PROGRAMMABLE_SAMPLE_LOCATIONS = 181,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_GS_INVOCATIONS = 182,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_SHADER_BUFFER_SIZE_UINT = 183,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_MIRROR_CLAMP_TO_EDGE = 184,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_COMBINED_SHADER_BUFFERS = 185,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_COMBINED_HW_ATOMIC_COUNTERS = 186,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_COMBINED_HW_ATOMIC_COUNTER_BUFFERS = 187,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXTURE_UPLOAD_MEMORY_BUDGET = 188,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_VERTEX_ELEMENT_SRC_OFFSET = 189,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SURFACE_SAMPLE_COUNT = 190,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_IMAGE_ATOMIC_FLOAT_ADD = 191,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_QUERY_PIPELINE_STATISTICS_SINGLE = 192,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEST_SURFACE_SRGB_CONTROL = 193,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_VARYINGS = 194,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_COMPUTE_GRID_INFO_LAST_BLOCK = 195,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_COMPUTE_SHADER_DERIVATIVES = 196,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_IMAGE_LOAD_FORMATTED = 197,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_IMAGE_STORE_FORMATTED = 198,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_THROTTLE = 199,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DMABUF = 200,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CL_GL_SHARING = 201,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PREFER_COMPUTE_FOR_MULTIMEDIA = 202,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRAGMENT_SHADER_INTERLOCK = 203,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FBFETCH_COHERENT = 204,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ATOMIC_FLOAT_MINMAX = 205,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TGSI_DIV = 206,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRAGMENT_SHADER_TEXTURE_LOD = 207,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRAGMENT_SHADER_DERIVATIVES = 208,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TEXTURE_SHADOW_LOD = 209,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_SAMPLES_IDENTICAL = 210,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_IMAGE_ATOMIC_INC_WRAP = 211,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PREFER_IMM_ARRAYS_AS_CONSTBUF = 212,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GL_SPIRV = 213,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GL_SPIRV_VARIABLE_POINTERS = 214,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_DEMOTE_TO_HELPER_INVOCATION = 215,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TGSI_TG4_COMPONENT_IN_SWIZZLE = 216,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FLATSHADE = 217,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ALPHA_TEST = 218,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_POINT_SIZE_FIXED = 219,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_TWO_SIDED_COLOR = 220,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_CLIP_PLANES = 221,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_VERTEX_BUFFERS = 222,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_OPENCL_INTEGER_FUNCTIONS = 223,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_INTEGER_MULTIPLY_32X16 = 224,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_FRONTEND_NOOP = 225,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_NIR_IMAGES_AS_DEREF = 226,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PACKED_STREAM_OUTPUT = 227,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VIEWPORT_TRANSFORM_LOWERED = 228,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_PSIZ_CLAMPED = 229,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GL_BEGIN_END_BUFFER_SIZE = 230,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VIEWPORT_SWIZZLE = 231,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SYSTEM_SVM = 232,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_VIEWPORT_MASK = 233,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_ALPHA_TO_COVERAGE_DITHER_CONTROL = 234,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAP_UNSYNCHRONIZED_THREAD_SAFE = 235,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_GLSL_ZERO_INIT = 236,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_BLEND_EQUATION_ADVANCED = 237,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_NIR_ATOMICS_AS_DEREF = 238,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_NO_CLIP_ON_COPY_TEX = 239,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_MAX_TEXTURE_MB = 240,
    #[doc = " different blend funcs per rendertarget"]
    PIPE_CAP_SHADER_ATOMIC_INT64 = 241,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_DEVICE_PROTECTED_SURFACE = 242,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_PREFER_REAL_BUFFER_IN_CONSTBUF0 = 243,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_GL_CLAMP = 244,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_TEXRECT = 245,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_SAMPLER_REDUCTION_MINMAX = 246,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_SAMPLER_REDUCTION_MINMAX_ARB = 247,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_ALLOW_DYNAMIC_VAO_FASTPATH = 248,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_EMULATE_NONFIXED_PRIMITIVE_RESTART = 249,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_SUPPORTED_PRIM_MODES = 250,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_SUPPORTED_PRIM_MODES_WITH_RESTART = 251,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_PREFER_BACK_BUFFER_REUSE = 252,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_DRAW_VERTEX_STATE = 253,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_PREFER_POT_ALIGNED_VARYINGS = 254,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_MAX_SPARSE_TEXTURE_SIZE = 255,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_MAX_SPARSE_3D_TEXTURE_SIZE = 256,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 257,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS = 258,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_QUERY_SPARSE_TEXTURE_RESIDENCY = 259,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_CLAMP_SPARSE_TEXTURE_LOD = 260,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_ALLOW_DRAW_OUT_OF_ORDER = 261,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_MAX_CONSTANT_BUFFER_SIZE_UINT = 262,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_HARDWARE_GL_SELECT = 263,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_DITHERING = 264,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_FBFETCH_ZS = 265,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_TIMELINE_SEMAPHORE_IMPORT = 266,
    #[doc = " For EGL_EXT_protected_surface"]
    PIPE_CAP_QUERY_TIMESTAMP_BITS = 267,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_DEVICE_PROTECTED_CONTEXT = 268,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_ALLOW_GLTHREAD_BUFFER_SUBDATA_OPT = 269,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_NULL_TEXTURES = 270,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_ASTC_VOID_EXTENTS_NEED_DENORM_FLUSH = 271,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_VALIDATE_ALL_DIRTY_STATES = 272,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_HAS_CONST_BW = 273,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_PERFORMANCE_MONITOR = 274,
    #[doc = " For EGL_EXT_protected_content"]
    PIPE_CAP_LAST = 275,
}
impl pipe_endian {
    pub const PIPE_ENDIAN_NATIVE: pipe_endian = pipe_endian::PIPE_ENDIAN_LITTLE;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_endian {
    PIPE_ENDIAN_LITTLE = 0,
    PIPE_ENDIAN_BIG = 1,
}
#[repr(u32)]
#[doc = " Implementation limits which are queried through\n pipe_screen::get_paramf()"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_capf {
    PIPE_CAPF_MIN_LINE_WIDTH = 0,
    PIPE_CAPF_MIN_LINE_WIDTH_AA = 1,
    PIPE_CAPF_MAX_LINE_WIDTH = 2,
    PIPE_CAPF_MAX_LINE_WIDTH_AA = 3,
    PIPE_CAPF_LINE_WIDTH_GRANULARITY = 4,
    PIPE_CAPF_MIN_POINT_SIZE = 5,
    PIPE_CAPF_MIN_POINT_SIZE_AA = 6,
    PIPE_CAPF_MAX_POINT_SIZE = 7,
    PIPE_CAPF_MAX_POINT_SIZE_AA = 8,
    PIPE_CAPF_POINT_SIZE_GRANULARITY = 9,
    PIPE_CAPF_MAX_TEXTURE_ANISOTROPY = 10,
    PIPE_CAPF_MAX_TEXTURE_LOD_BIAS = 11,
    PIPE_CAPF_MIN_CONSERVATIVE_RASTER_DILATE = 12,
    PIPE_CAPF_MAX_CONSERVATIVE_RASTER_DILATE = 13,
    PIPE_CAPF_CONSERVATIVE_RASTER_DILATE_GRANULARITY = 14,
}
#[repr(u32)]
#[doc = " Shader caps not specific to any single stage"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_shader_cap {
    PIPE_SHADER_CAP_MAX_INSTRUCTIONS = 0,
    PIPE_SHADER_CAP_MAX_ALU_INSTRUCTIONS = 1,
    PIPE_SHADER_CAP_MAX_TEX_INSTRUCTIONS = 2,
    PIPE_SHADER_CAP_MAX_TEX_INDIRECTIONS = 3,
    PIPE_SHADER_CAP_MAX_CONTROL_FLOW_DEPTH = 4,
    PIPE_SHADER_CAP_MAX_INPUTS = 5,
    PIPE_SHADER_CAP_MAX_OUTPUTS = 6,
    PIPE_SHADER_CAP_MAX_CONST_BUFFER0_SIZE = 7,
    PIPE_SHADER_CAP_MAX_CONST_BUFFERS = 8,
    PIPE_SHADER_CAP_MAX_TEMPS = 9,
    PIPE_SHADER_CAP_CONT_SUPPORTED = 10,
    PIPE_SHADER_CAP_INDIRECT_INPUT_ADDR = 11,
    PIPE_SHADER_CAP_INDIRECT_OUTPUT_ADDR = 12,
    PIPE_SHADER_CAP_INDIRECT_TEMP_ADDR = 13,
    PIPE_SHADER_CAP_INDIRECT_CONST_ADDR = 14,
    PIPE_SHADER_CAP_SUBROUTINES = 15,
    PIPE_SHADER_CAP_INTEGERS = 16,
    PIPE_SHADER_CAP_INT64_ATOMICS = 17,
    PIPE_SHADER_CAP_FP16 = 18,
    PIPE_SHADER_CAP_FP16_DERIVATIVES = 19,
    PIPE_SHADER_CAP_FP16_CONST_BUFFERS = 20,
    PIPE_SHADER_CAP_INT16 = 21,
    PIPE_SHADER_CAP_GLSL_16BIT_CONSTS = 22,
    PIPE_SHADER_CAP_MAX_TEXTURE_SAMPLERS = 23,
    PIPE_SHADER_CAP_TGSI_SQRT_SUPPORTED = 24,
    PIPE_SHADER_CAP_MAX_SAMPLER_VIEWS = 25,
    PIPE_SHADER_CAP_TGSI_ANY_INOUT_DECL_RANGE = 26,
    PIPE_SHADER_CAP_MAX_SHADER_BUFFERS = 27,
    PIPE_SHADER_CAP_SUPPORTED_IRS = 28,
    PIPE_SHADER_CAP_MAX_SHADER_IMAGES = 29,
    PIPE_SHADER_CAP_MAX_HW_ATOMIC_COUNTERS = 30,
    PIPE_SHADER_CAP_MAX_HW_ATOMIC_COUNTER_BUFFERS = 31,
}
#[repr(u32)]
#[doc = " Shader intermediate representation.\n\n Note that if the driver requests something other than TGSI, it must\n always be prepared to receive TGSI in addition to its preferred IR.\n If the driver requests TGSI as its preferred IR, it will *always*\n get TGSI.\n\n Note that PIPE_SHADER_IR_TGSI should be zero for backwards compat with\n gallium frontends that only understand TGSI."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_shader_ir {
    PIPE_SHADER_IR_TGSI = 0,
    PIPE_SHADER_IR_NATIVE = 1,
    PIPE_SHADER_IR_NIR = 2,
    PIPE_SHADER_IR_NIR_SERIALIZED = 3,
}
#[repr(u32)]
#[doc = " Compute-specific implementation capability.  They can be queried\n using pipe_screen::get_compute_param."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_compute_cap {
    PIPE_COMPUTE_CAP_ADDRESS_BITS = 0,
    PIPE_COMPUTE_CAP_IR_TARGET = 1,
    PIPE_COMPUTE_CAP_GRID_DIMENSION = 2,
    PIPE_COMPUTE_CAP_MAX_GRID_SIZE = 3,
    PIPE_COMPUTE_CAP_MAX_BLOCK_SIZE = 4,
    PIPE_COMPUTE_CAP_MAX_THREADS_PER_BLOCK = 5,
    PIPE_COMPUTE_CAP_MAX_GLOBAL_SIZE = 6,
    PIPE_COMPUTE_CAP_MAX_LOCAL_SIZE = 7,
    PIPE_COMPUTE_CAP_MAX_PRIVATE_SIZE = 8,
    PIPE_COMPUTE_CAP_MAX_INPUT_SIZE = 9,
    PIPE_COMPUTE_CAP_MAX_MEM_ALLOC_SIZE = 10,
    PIPE_COMPUTE_CAP_MAX_CLOCK_FREQUENCY = 11,
    PIPE_COMPUTE_CAP_MAX_COMPUTE_UNITS = 12,
    PIPE_COMPUTE_CAP_MAX_SUBGROUPS = 13,
    PIPE_COMPUTE_CAP_IMAGES_SUPPORTED = 14,
    PIPE_COMPUTE_CAP_SUBGROUP_SIZES = 15,
    PIPE_COMPUTE_CAP_MAX_VARIABLE_THREADS_PER_BLOCK = 16,
}
#[repr(u32)]
#[doc = " Resource parameters. They can be queried using\n pipe_screen::get_resource_param."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_resource_param {
    PIPE_RESOURCE_PARAM_NPLANES = 0,
    PIPE_RESOURCE_PARAM_STRIDE = 1,
    PIPE_RESOURCE_PARAM_OFFSET = 2,
    PIPE_RESOURCE_PARAM_MODIFIER = 3,
    PIPE_RESOURCE_PARAM_HANDLE_TYPE_SHARED = 4,
    PIPE_RESOURCE_PARAM_HANDLE_TYPE_KMS = 5,
    PIPE_RESOURCE_PARAM_HANDLE_TYPE_FD = 6,
    PIPE_RESOURCE_PARAM_LAYER_STRIDE = 7,
}
#[repr(u32)]
#[doc = " Types of parameters for pipe_context::set_context_param."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_context_param {
    PIPE_CONTEXT_PARAM_UPDATE_THREAD_SCHEDULING = 0,
}
#[doc = " Query result for PIPE_QUERY_SO_STATISTICS."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_query_data_so_statistics {
    pub num_primitives_written: u64,
    pub primitives_storage_needed: u64,
}
#[test]
fn bindgen_test_layout_pipe_query_data_so_statistics() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_query_data_so_statistics> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_query_data_so_statistics>(),
        16usize,
        concat!("Size of: ", stringify!(pipe_query_data_so_statistics))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_query_data_so_statistics>(),
        8usize,
        concat!("Alignment of ", stringify!(pipe_query_data_so_statistics))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_primitives_written) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_so_statistics),
            "::",
            stringify!(num_primitives_written)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).primitives_storage_needed) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_so_statistics),
            "::",
            stringify!(primitives_storage_needed)
        )
    );
}
#[doc = " Query result for PIPE_QUERY_TIMESTAMP_DISJOINT."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_query_data_timestamp_disjoint {
    pub frequency: u64,
    pub disjoint: bool,
}
#[test]
fn bindgen_test_layout_pipe_query_data_timestamp_disjoint() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_query_data_timestamp_disjoint> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_query_data_timestamp_disjoint>(),
        16usize,
        concat!("Size of: ", stringify!(pipe_query_data_timestamp_disjoint))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_query_data_timestamp_disjoint>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pipe_query_data_timestamp_disjoint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).frequency) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_timestamp_disjoint),
            "::",
            stringify!(frequency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).disjoint) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_timestamp_disjoint),
            "::",
            stringify!(disjoint)
        )
    );
}
#[doc = " Query result for PIPE_QUERY_PIPELINE_STATISTICS."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pipe_query_data_pipeline_statistics {
    pub anon_1: pipe_query_data_pipeline_statistics__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pipe_query_data_pipeline_statistics__bindgen_ty_1 {
    pub anon_1: pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1,
    pub counters: [u64; 13usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1 {
    #[doc = "< Num vertices read by the vertex fetcher."]
    pub ia_vertices: u64,
    #[doc = "< Num primitives read by the vertex fetcher."]
    pub ia_primitives: u64,
    #[doc = "< Num vertex shader invocations."]
    pub vs_invocations: u64,
    #[doc = "< Num geometry shader invocations."]
    pub gs_invocations: u64,
    #[doc = "< Num primitives output by a geometry shader."]
    pub gs_primitives: u64,
    #[doc = "< Num primitives sent to the rasterizer."]
    pub c_invocations: u64,
    #[doc = "< Num primitives that were rendered."]
    pub c_primitives: u64,
    #[doc = "< Num pixel shader invocations."]
    pub ps_invocations: u64,
    #[doc = "< Num hull shader invocations."]
    pub hs_invocations: u64,
    #[doc = "< Num domain shader invocations."]
    pub ds_invocations: u64,
    #[doc = "< Num compute shader invocations."]
    pub cs_invocations: u64,
    #[doc = "< Num task shader invocations."]
    pub ts_invocations: u64,
    #[doc = "< Num mesh shader invocations."]
    pub ms_invocations: u64,
}
#[test]
fn bindgen_test_layout_pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<
        pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1>(),
        104usize,
        concat!(
            "Size of: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ia_vertices) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ia_vertices)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ia_primitives) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ia_primitives)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vs_invocations) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(vs_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gs_invocations) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(gs_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gs_primitives) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(gs_primitives)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c_invocations) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(c_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c_primitives) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(c_primitives)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ps_invocations) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ps_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hs_invocations) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hs_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ds_invocations) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ds_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cs_invocations) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(cs_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ts_invocations) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ts_invocations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ms_invocations) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ms_invocations)
        )
    );
}
#[test]
fn bindgen_test_layout_pipe_query_data_pipeline_statistics__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_query_data_pipeline_statistics__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_query_data_pipeline_statistics__bindgen_ty_1>(),
        104usize,
        concat!(
            "Size of: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_query_data_pipeline_statistics__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counters) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_data_pipeline_statistics__bindgen_ty_1),
            "::",
            stringify!(counters)
        )
    );
}
impl Default for pipe_query_data_pipeline_statistics__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_pipe_query_data_pipeline_statistics() {
    assert_eq!(
        ::std::mem::size_of::<pipe_query_data_pipeline_statistics>(),
        104usize,
        concat!("Size of: ", stringify!(pipe_query_data_pipeline_statistics))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_query_data_pipeline_statistics>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pipe_query_data_pipeline_statistics)
        )
    );
}
impl Default for pipe_query_data_pipeline_statistics {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " For batch queries."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union pipe_numeric_type_union {
    pub u64_: u64,
    pub u32_: u32,
    pub f: ::std::os::raw::c_float,
}
#[test]
fn bindgen_test_layout_pipe_numeric_type_union() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_numeric_type_union> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_numeric_type_union>(),
        8usize,
        concat!("Size of: ", stringify!(pipe_numeric_type_union))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_numeric_type_union>(),
        8usize,
        concat!("Alignment of ", stringify!(pipe_numeric_type_union))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_numeric_type_union),
            "::",
            stringify!(u64_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u32_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_numeric_type_union),
            "::",
            stringify!(u32_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).f) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_numeric_type_union),
            "::",
            stringify!(f)
        )
    );
}
impl Default for pipe_numeric_type_union {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Query result (returned by pipe_context::get_query_result)."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union pipe_query_result {
    pub b: bool,
    pub u64_: u64,
    pub u32_: u32,
    pub f: ::std::os::raw::c_float,
    pub so_statistics: pipe_query_data_so_statistics,
    pub timestamp_disjoint: pipe_query_data_timestamp_disjoint,
    pub pipeline_statistics: pipe_query_data_pipeline_statistics,
    pub batch: [pipe_numeric_type_union; 1usize],
}
#[test]
fn bindgen_test_layout_pipe_query_result() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_query_result> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_query_result>(),
        104usize,
        concat!("Size of: ", stringify!(pipe_query_result))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_query_result>(),
        8usize,
        concat!("Alignment of ", stringify!(pipe_query_result))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(u64_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u32_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(u32_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).f) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(f)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).so_statistics) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(so_statistics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timestamp_disjoint) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(timestamp_disjoint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pipeline_statistics) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(pipeline_statistics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).batch) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_query_result),
            "::",
            stringify!(batch)
        )
    );
}
impl Default for pipe_query_result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_query_value_type {
    PIPE_QUERY_TYPE_I32 = 0,
    PIPE_QUERY_TYPE_U32 = 1,
    PIPE_QUERY_TYPE_I64 = 2,
    PIPE_QUERY_TYPE_U64 = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_query_flags {
    PIPE_QUERY_WAIT = 1,
    PIPE_QUERY_PARTIAL = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_driver_query_type {
    PIPE_DRIVER_QUERY_TYPE_UINT64 = 0,
    PIPE_DRIVER_QUERY_TYPE_UINT = 1,
    PIPE_DRIVER_QUERY_TYPE_FLOAT = 2,
    PIPE_DRIVER_QUERY_TYPE_PERCENTAGE = 3,
    PIPE_DRIVER_QUERY_TYPE_BYTES = 4,
    PIPE_DRIVER_QUERY_TYPE_MICROSECONDS = 5,
    PIPE_DRIVER_QUERY_TYPE_HZ = 6,
    PIPE_DRIVER_QUERY_TYPE_DBM = 7,
    PIPE_DRIVER_QUERY_TYPE_TEMPERATURE = 8,
    PIPE_DRIVER_QUERY_TYPE_VOLTS = 9,
    PIPE_DRIVER_QUERY_TYPE_AMPS = 10,
    PIPE_DRIVER_QUERY_TYPE_WATTS = 11,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_driver_query_result_type {
    PIPE_DRIVER_QUERY_RESULT_TYPE_AVERAGE = 0,
    PIPE_DRIVER_QUERY_RESULT_TYPE_CUMULATIVE = 1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pipe_driver_query_info {
    pub name: *const ::std::os::raw::c_char,
    pub query_type: ::std::os::raw::c_uint,
    pub max_value: pipe_numeric_type_union,
    pub type_: pipe_driver_query_type,
    pub result_type: pipe_driver_query_result_type,
    pub group_id: ::std::os::raw::c_uint,
    pub flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pipe_driver_query_info() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_driver_query_info> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_driver_query_info>(),
        40usize,
        concat!("Size of: ", stringify!(pipe_driver_query_info))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_driver_query_info>(),
        8usize,
        concat!("Alignment of ", stringify!(pipe_driver_query_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).query_type) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(query_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_value) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(max_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).result_type) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(result_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).group_id) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(group_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_info),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for pipe_driver_query_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_driver_query_group_info {
    pub name: *const ::std::os::raw::c_char,
    pub max_active_queries: ::std::os::raw::c_uint,
    pub num_queries: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pipe_driver_query_group_info() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_driver_query_group_info> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_driver_query_group_info>(),
        16usize,
        concat!("Size of: ", stringify!(pipe_driver_query_group_info))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_driver_query_group_info>(),
        8usize,
        concat!("Alignment of ", stringify!(pipe_driver_query_group_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_group_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_active_queries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_group_info),
            "::",
            stringify!(max_active_queries)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_queries) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_driver_query_group_info),
            "::",
            stringify!(num_queries)
        )
    );
}
impl Default for pipe_driver_query_group_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_fd_type {
    PIPE_FD_TYPE_NATIVE_SYNC = 0,
    PIPE_FD_TYPE_SYNCOBJ = 1,
    PIPE_FD_TYPE_TIMELINE_SEMAPHORE = 2,
}
#[doc = " For use with pipe_screen::{resource_from_handle|resource_get_handle}."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct winsys_handle {
    #[doc = " Input for resource_from_handle, valid values are\n WINSYS_HANDLE_TYPE_SHARED or WINSYS_HANDLE_TYPE_FD.\n Input to resource_get_handle,\n to select handle for kms, flink, or prime."]
    pub type_: ::std::os::raw::c_uint,
    #[doc = " Input for resource_get_handle, allows to export the offset\n of a specific layer of an array texture."]
    pub layer: ::std::os::raw::c_uint,
    #[doc = " Input for resource_get_handle, allows to export of a specific plane of a\n texture."]
    pub plane: ::std::os::raw::c_uint,
    pub handle: ::std::os::raw::c_uint,
    #[doc = " Row stride\n Input to texture_from_handle.\n Output for texture_from_handle."]
    pub stride: ::std::os::raw::c_uint,
    #[doc = " Array layer stride\n Input to texture_from_handle.\n Output for texture_from_handle."]
    pub array_stride: ::std::os::raw::c_uint,
    #[doc = " 3D slice stride\n Input to texture_from_handle.\n Output for texture_from_handle."]
    pub image_stride: ::std::os::raw::c_uint,
    #[doc = " Input to texture_from_handle.\n Output for texture_from_handle."]
    pub offset: ::std::os::raw::c_uint,
    #[doc = " Input to resource_from_handle.\n Output from resource_get_handle."]
    pub format: u64,
    #[doc = " Input to resource_from_handle.\n Output from resource_get_handle."]
    pub modifier: u64,
    pub anon_1: winsys_handle__bindgen_ty_1,
    #[doc = " Total size of the object.\n Output for resource_get_handle."]
    pub size: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union winsys_handle__bindgen_ty_1 {
    #[doc = " Input to resource_from_handle.\n Output for resource_get_handle."]
    pub com_obj: *mut ::std::os::raw::c_void,
    #[doc = " String name for an object.\n Input to resource_from_handle."]
    pub name: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_winsys_handle__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<winsys_handle__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<winsys_handle__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(winsys_handle__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<winsys_handle__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(winsys_handle__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).com_obj) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle__bindgen_ty_1),
            "::",
            stringify!(com_obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
}
impl Default for winsys_handle__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_winsys_handle() {
    const UNINIT: ::std::mem::MaybeUninit<winsys_handle> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<winsys_handle>(),
        64usize,
        concat!("Size of: ", stringify!(winsys_handle))
    );
    assert_eq!(
        ::std::mem::align_of::<winsys_handle>(),
        8usize,
        concat!("Alignment of ", stringify!(winsys_handle))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).layer) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(layer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).plane) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(plane)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).handle) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stride) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).array_stride) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(array_stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).image_stride) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(image_stride)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).modifier) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(modifier)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(winsys_handle),
            "::",
            stringify!(size)
        )
    );
}
impl Default for winsys_handle {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pipe_fence_handle {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pipe_query {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pipe_video_buffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pipe_video_codec {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct u_log_context {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct u_upload_mgr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct u_vbuf {
    _unused: [u8; 0],
}
pub type pipe_draw_func = ::std::option::Option<
    unsafe extern "C" fn(
        pipe: *mut pipe_context,
        info: *const pipe_draw_info,
        drawid_offset: ::std::os::raw::c_uint,
        indirect: *const pipe_draw_indirect_info,
        draws: *const pipe_draw_start_count_bias,
        num_draws: ::std::os::raw::c_uint,
    ),
>;
#[doc = " Gallium rendering context.  Basically:\n  - state setting functions\n  - VBO drawing functions\n  - surface functions"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_context {
    pub screen: *mut pipe_screen,
    #[doc = "< context private data (for DRI for example)"]
    pub priv_: *mut ::std::os::raw::c_void,
    #[doc = "< private, for draw module (temporary?)"]
    pub draw: *mut ::std::os::raw::c_void,
    #[doc = "< for cso_context, don't use in drivers"]
    pub vbuf: *mut u_vbuf,
    #[doc = " Stream uploaders created by the driver. All drivers, gallium frontends, and\n modules should use them.\n\n Use u_upload_alloc or u_upload_data as many times as you want.\n Once you are done, use u_upload_unmap."]
    pub stream_uploader: *mut u_upload_mgr,
    pub const_uploader: *mut u_upload_mgr,
    #[doc = " Debug callback set by u_default_set_debug_callback. Frontends should use\n set_debug_callback in case drivers need to flush compiler queues."]
    pub debug: util_debug_callback,
    pub destroy: ::std::option::Option<unsafe extern "C" fn(arg1: *mut pipe_context)>,
    #[doc = " Multi draw.\n\n For indirect multi draws, num_draws is 1 and indirect->draw_count\n is used instead.\n\n Caps:\n - Always supported: Direct multi draws\n - PIPE_CAP_MULTI_DRAW_INDIRECT: Indirect multi draws\n - PIPE_CAP_MULTI_DRAW_INDIRECT_PARAMS: Indirect draw count\n\n Differences against glMultiDraw and glMultiMode:\n - \"info->mode\" and \"draws->index_bias\" are always constant due to the lack\n   of hardware support and CPU performance concerns. Only start and count\n   vary.\n - if \"info->increment_draw_id\" is false, draw_id doesn't change between\n   draws\n\n Direct multi draws are also generated by u_threaded_context, which looks\n ahead in gallium command buffers and merges single draws.\n\n \\param pipe          context\n \\param info          draw info\n \\param drawid_offset offset to add for drawid param of each draw\n \\param indirect      indirect multi draws\n \\param draws         array of (start, count) pairs for direct draws\n \\param num_draws     number of direct draws; 1 for indirect multi draws"]
    pub draw_vbo: pipe_draw_func,
    #[doc = " Multi draw for display lists.\n\n For more information, see pipe_vertex_state and\n pipe_draw_vertex_state_info.\n\n Explanation of partial_vertex_mask:\n\n 1. pipe_vertex_state::input::elements have a monotonic logical index\n    determined by pipe_vertex_state::input::full_velem_mask, specifically,\n    the position of the i-th bit set is the logical index of the i-th\n    vertex element, up to 31.\n\n 2. pipe_vertex_state::input::partial_velem_mask is a subset of\n    full_velem_mask where the bits set determine which vertex elements\n    should be bound contiguously. The vertex elements corresponding to\n    the bits not set in partial_velem_mask should be ignored.\n\n Those two allow creating pipe_vertex_state that has more vertex\n attributes than the vertex shader has inputs. The idea is that\n pipe_vertex_state can be used with any vertex shader that has the same\n number of inputs and same logical indices or less. This may sound like\n an overly complicated way to bind a subset of vertex elements, but it\n actually simplifies everything else:\n\n - In st/mesa, full_velem_mask is exactly the mask of enabled vertex\n   attributes (VERT_ATTRIB_x) in the display list VAO, while\n   partial_velem_mask is exactly the inputs_read mask of the vertex\n   shader (also VERT_ATTRIB_x).\n\n - In the driver, some bit ops and popcnt is needed to assemble vertex\n   elements very quickly."]
    pub draw_vertex_state: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            state: *mut pipe_vertex_state,
            partial_velem_mask: u32,
            info: pipe_draw_vertex_state_info,
            draws: *const pipe_draw_start_count_bias,
            num_draws: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Predicate subsequent rendering on occlusion query result\n \\param query  the query predicate, or NULL if no predicate\n \\param condition whether to skip on FALSE or TRUE query results\n \\param mode  one of PIPE_RENDER_COND_x"]
    pub render_condition: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            query: *mut pipe_query,
            condition: bool,
            mode: pipe_render_cond_flag,
        ),
    >,
    #[doc = " Predicate subsequent rendering on a value in a buffer\n \\param buffer The buffer to query for the value\n \\param offset Offset in the buffer to query 32-bit\n \\param condition whether to skip on FALSE or TRUE query results"]
    pub render_condition_mem: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            buffer: *mut pipe_resource,
            offset: u32,
            condition: bool,
        ),
    >,
    pub create_query: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            query_type: ::std::os::raw::c_uint,
            index: ::std::os::raw::c_uint,
        ) -> *mut pipe_query,
    >,
    #[doc = " Create a query object that queries all given query types simultaneously.\n\n This can only be used for those query types for which\n get_driver_query_info indicates that it must be used. Only one batch\n query object may be active at a time.\n\n There may be additional constraints on which query types can be used\n together, in particular those that are implied by\n get_driver_query_group_info.\n\n \\param num_queries the number of query types\n \\param query_types array of \\p num_queries query types\n \\return a query object, or NULL on error."]
    pub create_batch_query: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            num_queries: ::std::os::raw::c_uint,
            query_types: *mut ::std::os::raw::c_uint,
        ) -> *mut pipe_query,
    >,
    pub destroy_query:
        ::std::option::Option<unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query)>,
    pub begin_query: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query) -> bool,
    >,
    pub end_query: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query) -> bool,
    >,
    #[doc = " Get results of a query.\n \\param wait  if true, this query will block until the result is ready\n \\return TRUE if results are ready, FALSE otherwise"]
    pub get_query_result: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            q: *mut pipe_query,
            wait: bool,
            result: *mut pipe_query_result,
        ) -> bool,
    >,
    #[doc = " Get results of a query, storing into resource. Note that this may not\n be used with batch queries.\n\n \\param wait  if true, this query will block until the result is ready\n \\param result_type  the type of the value being stored:\n \\param index  for queries that return multiple pieces of data, which\n               item of that data to store (e.g. for\n               PIPE_QUERY_PIPELINE_STATISTICS).\n               When the index is -1, instead of the value of the query\n               the driver should instead write a 1 or 0 to the appropriate\n               location with 1 meaning that the query result is available."]
    pub get_query_result_resource: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            q: *mut pipe_query,
            flags: pipe_query_flags,
            result_type: pipe_query_value_type,
            index: ::std::os::raw::c_int,
            resource: *mut pipe_resource,
            offset: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Set whether all current non-driver queries except TIME_ELAPSED are\n active or paused."]
    pub set_active_query_state:
        ::std::option::Option<unsafe extern "C" fn(pipe: *mut pipe_context, enable: bool)>,
    pub init_intel_perf_query_info: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context) -> ::std::os::raw::c_uint,
    >,
    pub get_intel_perf_query_info: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            query_index: ::std::os::raw::c_uint,
            name: *mut *const ::std::os::raw::c_char,
            data_size: *mut u32,
            n_counters: *mut u32,
            n_active: *mut u32,
        ),
    >,
    pub get_intel_perf_query_counter_info: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            query_index: ::std::os::raw::c_uint,
            counter_index: ::std::os::raw::c_uint,
            name: *mut *const ::std::os::raw::c_char,
            desc: *mut *const ::std::os::raw::c_char,
            offset: *mut u32,
            data_size: *mut u32,
            type_enum: *mut u32,
            data_type_enum: *mut u32,
            raw_max: *mut u64,
        ),
    >,
    pub new_intel_perf_query_obj: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            query_index: ::std::os::raw::c_uint,
        ) -> *mut pipe_query,
    >,
    pub begin_intel_perf_query: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query) -> bool,
    >,
    pub end_intel_perf_query:
        ::std::option::Option<unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query)>,
    pub delete_intel_perf_query:
        ::std::option::Option<unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query)>,
    pub wait_intel_perf_query:
        ::std::option::Option<unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query)>,
    pub is_intel_perf_query_ready: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, q: *mut pipe_query) -> bool,
    >,
    pub get_intel_perf_query_data: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            q: *mut pipe_query,
            data_size: usize,
            data: *mut u32,
            bytes_written: *mut u32,
        ) -> bool,
    >,
    #[doc = " Called when a shader program is linked.\n \\param handles  Array of shader handles attached to this program.\n                 The size of the array is \\c PIPE_SHADER_TYPES, and each\n                 position contains the corresponding \\c pipe_shader_state*\n                 or \\c pipe_compute_state*, or \\c NULL.\n                 E.g. You can retrieve the fragment shader handle with\n                      \\c handles[PIPE_SHADER_FRAGMENT]"]
    pub link_shader: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, handles: *mut *mut ::std::os::raw::c_void),
    >,
    pub create_blend_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_blend_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_blend_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_blend_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_sampler_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_sampler_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_sampler_states: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            shader: pipe_shader_type,
            start_slot: ::std::os::raw::c_uint,
            num_samplers: ::std::os::raw::c_uint,
            samplers: *mut *mut ::std::os::raw::c_void,
        ),
    >,
    pub delete_sampler_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_rasterizer_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_rasterizer_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_rasterizer_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_rasterizer_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_depth_stencil_alpha_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_depth_stencil_alpha_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_depth_stencil_alpha_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_depth_stencil_alpha_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_fs_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_fs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_fs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_vs_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_vs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_vs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_gs_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_gs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_gs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_tcs_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_tcs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_tcs_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_tes_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_tes_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_tes_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_vertex_elements_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            num_elements: ::std::os::raw::c_uint,
            arg2: *const pipe_vertex_element,
        ) -> *mut ::std::os::raw::c_void,
    >,
    #[doc = " Bind vertex elements state.\n\n Frontends MUST call set_vertex_buffers after bind_vertex_elements_state\n and before the next draw. This ensures the driver can apply the state\n change before the next draw. Drivers MAY use this constraint to merge\n vertex elements and vertex buffers in set_vertex_buffers instead of\n in draw_vbo."]
    pub bind_vertex_elements_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_vertex_elements_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_ts_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_ts_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_ts_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub create_ms_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *const pipe_shader_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_ms_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_ms_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub set_blend_color: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *const pipe_blend_color),
    >,
    pub set_stencil_ref: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, ref_: pipe_stencil_ref),
    >,
    pub set_sample_mask: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, sample_mask: ::std::os::raw::c_uint),
    >,
    pub set_min_samples: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, min_samples: ::std::os::raw::c_uint),
    >,
    pub set_clip_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *const pipe_clip_state),
    >,
    #[doc = " Set constant buffer\n\n \\param shader           Shader stage\n \\param index            Buffer binding slot index within a shader stage\n \\param take_ownership   The callee takes ownership of the buffer reference.\n                         (the callee shouldn't increment the ref count)\n \\param buf              Constant buffer parameters"]
    pub set_constant_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            shader: pipe_shader_type,
            index: uint,
            take_ownership: bool,
            buf: *const pipe_constant_buffer,
        ),
    >,
    #[doc = " Set inlinable constants for constant buffer 0.\n\n These are constants that the driver would like to inline in the IR\n of the current shader and recompile it. Drivers can determine which\n constants they prefer to inline in finalize_nir and store that\n information in shader_info::*inlinable_uniform*. When the state tracker\n or frontend uploads constants to a constant buffer, it can pass\n inlinable constants separately via this call.\n\n Any set_constant_buffer call invalidates this state, so this function\n must be called after it. Binding a shader also invalidates this state.\n\n There is no PIPE_CAP for this. Drivers shouldn't set the shader_info\n fields if they don't want this or if they don't implement this."]
    pub set_inlinable_constants: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            shader: pipe_shader_type,
            num_values: uint,
            values: *mut u32,
        ),
    >,
    pub set_framebuffer_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *const pipe_framebuffer_state),
    >,
    #[doc = " Set the sample locations used during rasterization. When NULL or sized\n zero, the default locations are used.\n\n Note that get_sample_position() still returns the default locations.\n\n The samples are accessed with\n locations[(pixel_y*grid_w+pixel_x)*ms+i],\n where:\n ms      = the sample count\n grid_w  = the pixel grid width for the sample count\n grid_w  = the pixel grid height for the sample count\n pixel_x = the window x coordinate modulo grid_w\n pixel_y = the window y coordinate modulo grid_w\n i       = the sample index\n This gives a result with the x coordinate as the low 4 bits and the y\n coordinate as the high 4 bits. For each coordinate 0 is the left or top\n edge of the pixel's rectangle and 16 (not 15) is the right or bottom edge.\n\n Out of bounds accesses are return undefined values.\n\n The pixel grid is used to vary sample locations across pixels and its\n size can be queried with get_sample_pixel_grid()."]
    pub set_sample_locations: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, size: usize, locations: *const u8),
    >,
    pub set_polygon_stipple: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *const pipe_poly_stipple),
    >,
    pub set_scissor_states: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            start_slot: ::std::os::raw::c_uint,
            num_scissors: ::std::os::raw::c_uint,
            arg2: *const pipe_scissor_state,
        ),
    >,
    pub set_window_rectangles: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            include: bool,
            num_rectangles: ::std::os::raw::c_uint,
            arg2: *const pipe_scissor_state,
        ),
    >,
    pub set_viewport_states: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            start_slot: ::std::os::raw::c_uint,
            num_viewports: ::std::os::raw::c_uint,
            arg2: *const pipe_viewport_state,
        ),
    >,
    pub set_sampler_views: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            shader: pipe_shader_type,
            start_slot: ::std::os::raw::c_uint,
            num_views: ::std::os::raw::c_uint,
            unbind_num_trailing_slots: ::std::os::raw::c_uint,
            take_ownership: bool,
            views: *mut *mut pipe_sampler_view,
        ),
    >,
    pub set_tess_state: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            default_outer_level: *const [::std::os::raw::c_float; 4usize],
            default_inner_level: *const [::std::os::raw::c_float; 2usize],
        ),
    >,
    #[doc = " Set the number of vertices per input patch for tessellation."]
    pub set_patch_vertices:
        ::std::option::Option<unsafe extern "C" fn(ctx: *mut pipe_context, patch_vertices: u8)>,
    #[doc = " Sets the debug callback. If the pointer is null, then no callback is\n set, otherwise a copy of the data should be made."]
    pub set_debug_callback: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *const util_debug_callback),
    >,
    #[doc = " Bind an array of shader buffers that will be used by a shader.\n Any buffers that were previously bound to the specified range\n will be unbound.\n\n \\param shader     selects shader stage\n \\param start_slot first buffer slot to bind.\n \\param count      number of consecutive buffers to bind.\n \\param buffers    array of pointers to the buffers to bind, it\n                   should contain at least \\a count elements\n                   unless it's NULL, in which case no buffers will\n                   be bound.\n \\param writable_bitmask  If bit i is not set, buffers[i] will only be\n                          used with loads. If unsure, set to ~0."]
    pub set_shader_buffers: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            shader: pipe_shader_type,
            start_slot: ::std::os::raw::c_uint,
            count: ::std::os::raw::c_uint,
            buffers: *const pipe_shader_buffer,
            writable_bitmask: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Bind an array of hw atomic buffers for use by all shaders.\n And buffers that were previously bound to the specified range\n will be unbound.\n\n \\param start_slot first buffer slot to bind.\n \\param count      number of consecutive buffers to bind.\n \\param buffers    array of pointers to the buffers to bind, it\n                   should contain at least \\a count elements\n                   unless it's NULL, in which case no buffers will\n                   be bound."]
    pub set_hw_atomic_buffers: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            start_slot: ::std::os::raw::c_uint,
            count: ::std::os::raw::c_uint,
            buffers: *const pipe_shader_buffer,
        ),
    >,
    #[doc = " Bind an array of images that will be used by a shader.\n Any images that were previously bound to the specified range\n will be unbound.\n\n \\param shader     selects shader stage\n \\param start_slot first image slot to bind.\n \\param count      number of consecutive images to bind.\n \\param unbind_num_trailing_slots  number of images to unbind after\n                                   the bound slot\n \\param buffers    array of the images to bind, it\n                   should contain at least \\a count elements\n                   unless it's NULL, in which case no images will\n                   be bound."]
    pub set_shader_images: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            shader: pipe_shader_type,
            start_slot: ::std::os::raw::c_uint,
            count: ::std::os::raw::c_uint,
            unbind_num_trailing_slots: ::std::os::raw::c_uint,
            images: *const pipe_image_view,
        ),
    >,
    #[doc = " Bind an array of vertex buffers to the specified slots.\n\n Unlike other set functions, the caller should always increment\n the buffer reference counts because the driver should only copy\n the pipe_resource pointers. This is the same behavior as setting\n take_ownership = true in other functions.\n\n count must be equal to the maximum used vertex buffer index + 1\n in vertex elements or 0.\n\n \\param count           number of consecutive vertex buffers to bind.\n \\param buffers         array of the buffers to bind"]
    pub set_vertex_buffers: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            count: ::std::os::raw::c_uint,
            arg2: *const pipe_vertex_buffer,
        ),
    >,
    pub create_stream_output_target: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *mut pipe_resource,
            buffer_offset: ::std::os::raw::c_uint,
            buffer_size: ::std::os::raw::c_uint,
        ) -> *mut pipe_stream_output_target,
    >,
    pub stream_output_target_destroy: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut pipe_stream_output_target),
    >,
    pub set_stream_output_targets: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            num_targets: ::std::os::raw::c_uint,
            targets: *mut *mut pipe_stream_output_target,
            offsets: *const ::std::os::raw::c_uint,
        ),
    >,
    pub stream_output_target_offset:
        ::std::option::Option<unsafe extern "C" fn(target: *mut pipe_stream_output_target) -> u32>,
    pub set_frontend_noop:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut pipe_context, enable: bool)>,
    #[doc = " Copy a block of pixels from one resource to another.\n The resource must be of the same format.\n Resources with nr_samples > 1 are not allowed."]
    pub resource_copy_region: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            dst: *mut pipe_resource,
            dst_level: ::std::os::raw::c_uint,
            dstx: ::std::os::raw::c_uint,
            dsty: ::std::os::raw::c_uint,
            dstz: ::std::os::raw::c_uint,
            src: *mut pipe_resource,
            src_level: ::std::os::raw::c_uint,
            src_box: *const pipe_box,
        ),
    >,
    pub blit: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, info: *const pipe_blit_info),
    >,
    #[doc = " Clear the specified set of currently bound buffers to specified values.\n The entire buffers are cleared (no scissor, no colormask, etc).\n\n \\param buffers  bitfield of PIPE_CLEAR_* values.\n \\param scissor_state  the scissored region to clear\n \\param color  pointer to a union of fiu array for each of r, g, b, a.\n \\param depth  depth clear value in [0,1].\n \\param stencil  stencil clear value"]
    pub clear: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            buffers: ::std::os::raw::c_uint,
            scissor_state: *const pipe_scissor_state,
            color: *const pipe_color_union,
            depth: ::std::os::raw::c_double,
            stencil: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Clear a color rendertarget surface.\n \\param color  pointer to an union of fiu array for each of r, g, b, a."]
    pub clear_render_target: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            dst: *mut pipe_surface,
            color: *const pipe_color_union,
            dstx: ::std::os::raw::c_uint,
            dsty: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
            render_condition_enabled: bool,
        ),
    >,
    #[doc = " Clear a depth-stencil surface.\n \\param clear_flags  bitfield of PIPE_CLEAR_DEPTH/STENCIL values.\n \\param depth  depth clear value in [0,1].\n \\param stencil  stencil clear value"]
    pub clear_depth_stencil: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            dst: *mut pipe_surface,
            clear_flags: ::std::os::raw::c_uint,
            depth: ::std::os::raw::c_double,
            stencil: ::std::os::raw::c_uint,
            dstx: ::std::os::raw::c_uint,
            dsty: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
            render_condition_enabled: bool,
        ),
    >,
    #[doc = " Clear the texture with the specified texel. Not guaranteed to be a\n renderable format. Data provided in the resource's format."]
    pub clear_texture: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            res: *mut pipe_resource,
            level: ::std::os::raw::c_uint,
            box_: *const pipe_box,
            data: *const ::std::os::raw::c_void,
        ),
    >,
    #[doc = " Clear a buffer. Runs a memset over the specified region with the element\n value passed in through clear_value of size clear_value_size."]
    pub clear_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            res: *mut pipe_resource,
            offset: ::std::os::raw::c_uint,
            size: ::std::os::raw::c_uint,
            clear_value: *const ::std::os::raw::c_void,
            clear_value_size: ::std::os::raw::c_int,
        ),
    >,
    #[doc = " If a depth buffer is rendered with different sample location state than\n what is current at the time of reading, the values may differ because\n depth buffer compression can depend the sample locations.\n\n This function is a hint to decompress the current depth buffer to avoid\n such problems."]
    pub evaluate_depth_buffer: ::std::option::Option<unsafe extern "C" fn(pipe: *mut pipe_context)>,
    #[doc = " Flush draw commands.\n\n This guarantees that the new fence (if any) will finish in finite time,\n unless PIPE_FLUSH_DEFERRED is used.\n\n Subsequent operations on other contexts of the same screen are guaranteed\n to execute after the flushed commands, unless PIPE_FLUSH_ASYNC is used.\n\n NOTE: use screen->fence_reference() (or equivalent) to transfer\n new fence ref to **fence, to ensure that previous fence is unref'd\n\n \\param fence  if not NULL, an old fence to unref and transfer a\n    new fence reference to\n \\param flags  bitfield of enum pipe_flush_flags values."]
    pub flush: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            fence: *mut *mut pipe_fence_handle,
            flags: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Create a fence from a fd.\n\n This is used for importing a foreign/external fence fd.\n\n \\param fence  if not NULL, an old fence to unref and transfer a\n    new fence reference to\n \\param fd     fd representing the fence object\n \\param type   indicates which fence types backs fd"]
    pub create_fence_fd: ::std::option::Option<
        unsafe extern "C" fn(
            pipe: *mut pipe_context,
            fence: *mut *mut pipe_fence_handle,
            fd: ::std::os::raw::c_int,
            type_: pipe_fd_type,
        ),
    >,
    #[doc = " Insert commands to have GPU wait for fence to be signaled."]
    pub fence_server_sync: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, fence: *mut pipe_fence_handle),
    >,
    #[doc = " Insert commands to have the GPU signal a fence."]
    pub fence_server_signal: ::std::option::Option<
        unsafe extern "C" fn(pipe: *mut pipe_context, fence: *mut pipe_fence_handle),
    >,
    #[doc = " Create a view on a texture to be used by a shader stage."]
    pub create_sampler_view: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            texture: *mut pipe_resource,
            templat: *const pipe_sampler_view,
        ) -> *mut pipe_sampler_view,
    >,
    #[doc = " Destroy a view on a texture.\n\n \\param ctx the current context\n \\param view the view to be destroyed\n\n \\note The current context may not be the context in which the view was\n       created (view->context). However, the caller must guarantee that\n       the context which created the view is still alive."]
    pub sampler_view_destroy: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, view: *mut pipe_sampler_view),
    >,
    #[doc = " Get a surface which is a \"view\" into a resource, used by\n render target / depth stencil stages."]
    pub create_surface: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            resource: *mut pipe_resource,
            templat: *const pipe_surface,
        ) -> *mut pipe_surface,
    >,
    pub surface_destroy: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, arg1: *mut pipe_surface),
    >,
    #[doc = " Map a resource.\n\n Transfers are (by default) context-private and allow uploads to be\n interleaved with rendering.\n\n out_transfer will contain the transfer object that must be passed\n to all the other transfer functions. It also contains useful\n information (like texture strides for texture_map)."]
    pub buffer_map: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            resource: *mut pipe_resource,
            level: ::std::os::raw::c_uint,
            usage: ::std::os::raw::c_uint,
            arg2: *const pipe_box,
            out_transfer: *mut *mut pipe_transfer,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub transfer_flush_region: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            transfer: *mut pipe_transfer,
            arg2: *const pipe_box,
        ),
    >,
    pub buffer_unmap: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, transfer: *mut pipe_transfer),
    >,
    pub texture_map: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            resource: *mut pipe_resource,
            level: ::std::os::raw::c_uint,
            usage: ::std::os::raw::c_uint,
            arg2: *const pipe_box,
            out_transfer: *mut *mut pipe_transfer,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub texture_unmap: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, transfer: *mut pipe_transfer),
    >,
    pub buffer_subdata: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *mut pipe_resource,
            usage: ::std::os::raw::c_uint,
            offset: ::std::os::raw::c_uint,
            size: ::std::os::raw::c_uint,
            data: *const ::std::os::raw::c_void,
        ),
    >,
    pub texture_subdata: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *mut pipe_resource,
            level: ::std::os::raw::c_uint,
            usage: ::std::os::raw::c_uint,
            arg3: *const pipe_box,
            data: *const ::std::os::raw::c_void,
            stride: ::std::os::raw::c_uint,
            layer_stride: usize,
        ),
    >,
    #[doc = " Flush any pending framebuffer writes and invalidate texture caches."]
    pub texture_barrier: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, flags: ::std::os::raw::c_uint),
    >,
    #[doc = " Flush caches according to flags."]
    pub memory_barrier: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, flags: ::std::os::raw::c_uint),
    >,
    #[doc = " Change the commitment status of a part of the given resource, which must\n have been created with the PIPE_RESOURCE_FLAG_SPARSE bit.\n\n \\param level The texture level whose commitment should be changed.\n \\param box The region of the resource whose commitment should be changed.\n \\param commit Whether memory should be committed or un-committed.\n\n \\return false if out of memory, true on success."]
    pub resource_commit: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *mut pipe_resource,
            level: ::std::os::raw::c_uint,
            box_: *mut pipe_box,
            commit: bool,
        ) -> bool,
    >,
    #[doc = " Creates a video codec for a specific video format/profile"]
    pub create_video_codec: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            templat: *const pipe_video_codec,
        ) -> *mut pipe_video_codec,
    >,
    #[doc = " Creates a video buffer as decoding target"]
    pub create_video_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            templat: *const pipe_video_buffer,
        ) -> *mut pipe_video_buffer,
    >,
    #[doc = " Define the compute program and parameters to be used by\n pipe_context::launch_grid."]
    pub create_compute_state: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            arg1: *const pipe_compute_state,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub bind_compute_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub delete_compute_state: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut pipe_context, arg2: *mut ::std::os::raw::c_void),
    >,
    pub get_compute_state_info: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *mut ::std::os::raw::c_void,
            arg3: *mut pipe_compute_state_object_info,
        ),
    >,
    pub get_compute_state_subgroup_size: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            arg2: *mut ::std::os::raw::c_void,
            block: *const [u32; 3usize],
        ) -> u32,
    >,
    #[doc = " Bind an array of shader resources that will be used by the\n compute program.  Any resources that were previously bound to\n the specified range will be unbound after this call.\n\n \\param start      first resource to bind.\n \\param count      number of consecutive resources to bind.\n \\param resources  array of pointers to the resources to bind, it\n                   should contain at least \\a count elements\n                   unless it's NULL, in which case no new\n                   resources will be bound."]
    pub set_compute_resources: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut pipe_context,
            start: ::std::os::raw::c_uint,
            count: ::std::os::raw::c_uint,
            resources: *mut *mut pipe_surface,
        ),
    >,
    #[doc = " Bind an array of buffers to be mapped into the address space of\n the GLOBAL resource.  Any buffers that were previously bound\n between [first, first + count - 1] are unbound after this call.\n\n \\param first      first buffer to map.\n \\param count      number of consecutive buffers to map.\n \\param resources  array of pointers to the buffers to map, it\n                   should contain at least \\a count elements\n                   unless it's NULL, in which case no new\n                   resources will be bound.\n \\param handles    array of pointers to the memory locations that\n                   will be updated with the address each buffer\n                   will be mapped to.  The base memory address of\n                   each of the buffers will be added to the value\n                   pointed to by its corresponding handle to form\n                   the final address argument.  It should contain\n                   at least \\a count elements, unless \\a\n                   resources is NULL in which case \\a handles\n                   should be NULL as well.\n\n Note that the driver isn't required to make any guarantees about\n the contents of the \\a handles array being valid anytime except\n during the subsequent calls to pipe_context::launch_grid.  This\n means that the only sensible location handles[i] may point to is\n somewhere within the INPUT buffer itself.  This is so to\n accommodate implementations that lack virtual memory but\n nevertheless migrate buffers on the fly, leading to resource\n base addresses that change on each kernel invocation or are\n unknown to the pipe driver."]
    pub set_global_binding: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            first: ::std::os::raw::c_uint,
            count: ::std::os::raw::c_uint,
            resources: *mut *mut pipe_resource,
            handles: *mut *mut u32,
        ),
    >,
    #[doc = " Launch the compute kernel starting from instruction \\a pc of the\n currently bound compute program."]
    pub launch_grid: ::std::option::Option<
        unsafe extern "C" fn(context: *mut pipe_context, info: *const pipe_grid_info),
    >,
    pub draw_mesh_tasks: ::std::option::Option<
        unsafe extern "C" fn(context: *mut pipe_context, info: *const pipe_grid_info),
    >,
    #[doc = " Migrate range of virtual address to device or host memory.\n\n \\param to_device - true if the virtual memory is migrated to the device\n                    false if the virtual memory is migrated to the host\n \\param content_undefined - whether the content of the migrated memory\n                            is undefined after migration"]
    pub svm_migrate: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            num_ptrs: ::std::os::raw::c_uint,
            ptrs: *const *const ::std::os::raw::c_void,
            sizes: *const usize,
            to_device: bool,
            content_undefined: bool,
        ),
    >,
    #[doc = " Get the default sample position for an individual sample point.\n\n \\param sample_count - total number of samples\n \\param sample_index - sample to get the position values for\n \\param out_value - return value of 2 floats for x and y position for\n                    requested sample."]
    pub get_sample_position: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            sample_count: ::std::os::raw::c_uint,
            sample_index: ::std::os::raw::c_uint,
            out_value: *mut ::std::os::raw::c_float,
        ),
    >,
    #[doc = " Query a timestamp in nanoseconds.  This is completely equivalent to\n pipe_screen::get_timestamp() but takes a context handle for drivers\n that require a context."]
    pub get_timestamp: ::std::option::Option<unsafe extern "C" fn(arg1: *mut pipe_context) -> u64>,
    #[doc = " Flush the resource cache, so that the resource can be used\n by an external client. Possible usage:\n - flushing a resource before presenting it on the screen\n - flushing a resource if some other process or device wants to use it\n This shouldn't be used to flush caches if the resource is only managed\n by a single pipe_screen and is not shared with another process.\n (i.e. you shouldn't use it to flush caches explicitly if you want to e.g.\n use the resource for texturing)"]
    pub flush_resource: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, resource: *mut pipe_resource),
    >,
    #[doc = " Invalidate the contents of the resource. This is used to\n\n (1) implement EGL's semantic of undefined depth/stencil\n contents after a swapbuffers.  This allows a tiled renderer (for\n example) to not store the depth buffer.\n\n (2) implement GL's InvalidateBufferData. For backwards compatibility,\n you must only rely on the usability for this purpose when\n PIPE_CAP_INVALIDATE_BUFFER is enabled."]
    pub invalidate_resource: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, resource: *mut pipe_resource),
    >,
    #[doc = " Return information about unexpected device resets."]
    pub get_device_reset_status:
        ::std::option::Option<unsafe extern "C" fn(ctx: *mut pipe_context) -> pipe_reset_status>,
    #[doc = " Sets the reset status callback. If the pointer is null, then no callback\n is set, otherwise a copy of the data should be made."]
    pub set_device_reset_callback: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, cb: *const pipe_device_reset_callback),
    >,
    #[doc = " Dump driver-specific debug information into a stream. This is\n used by debugging tools.\n\n \\param ctx        pipe context\n \\param stream     where the output should be written to\n \\param flags      a mask of PIPE_DUMP_* flags"]
    pub dump_debug_state: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            stream: *mut FILE,
            flags: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Set the log context to which the driver should write internal debug logs\n (internal states, command streams).\n\n The caller must ensure that the log context is destroyed and reset to\n NULL before the pipe context is destroyed, and that log context functions\n are only called from the driver thread.\n\n \\param ctx pipe context\n \\param log logging context"]
    pub set_log_context: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, log: *mut u_log_context),
    >,
    #[doc = " Emit string marker in cmdstream"]
    pub emit_string_marker: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            string: *const ::std::os::raw::c_char,
            len: ::std::os::raw::c_int,
        ),
    >,
    #[doc = " Generate mipmap.\n \\return TRUE if mipmap generation succeeds, FALSE otherwise"]
    pub generate_mipmap: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            resource: *mut pipe_resource,
            format: pipe_format,
            base_level: ::std::os::raw::c_uint,
            last_level: ::std::os::raw::c_uint,
            first_layer: ::std::os::raw::c_uint,
            last_layer: ::std::os::raw::c_uint,
        ) -> bool,
    >,
    #[doc = " Create a 64-bit texture handle.\n\n \\param ctx        pipe context\n \\param view       pipe sampler view object\n \\param state      pipe sampler state template\n \\return           a 64-bit texture handle if success, 0 otherwise"]
    pub create_texture_handle: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            view: *mut pipe_sampler_view,
            state: *const pipe_sampler_state,
        ) -> u64,
    >,
    #[doc = " Delete a texture handle.\n\n \\param ctx        pipe context\n \\param handle     64-bit texture handle"]
    pub delete_texture_handle:
        ::std::option::Option<unsafe extern "C" fn(ctx: *mut pipe_context, handle: u64)>,
    #[doc = " Make a texture handle resident.\n\n \\param ctx        pipe context\n \\param handle     64-bit texture handle\n \\param resident   TRUE for resident, FALSE otherwise"]
    pub make_texture_handle_resident: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, handle: u64, resident: bool),
    >,
    #[doc = " Create a 64-bit image handle.\n\n \\param ctx        pipe context\n \\param image      pipe image view template\n \\return           a 64-bit image handle if success, 0 otherwise"]
    pub create_image_handle: ::std::option::Option<
        unsafe extern "C" fn(ctx: *mut pipe_context, image: *const pipe_image_view) -> u64,
    >,
    #[doc = " Delete an image handle.\n\n \\param ctx        pipe context\n \\param handle     64-bit image handle"]
    pub delete_image_handle:
        ::std::option::Option<unsafe extern "C" fn(ctx: *mut pipe_context, handle: u64)>,
    #[doc = " Make an image handle resident.\n\n \\param ctx        pipe context\n \\param handle     64-bit image handle\n \\param access     GL_READ_ONLY, GL_WRITE_ONLY or GL_READ_WRITE\n \\param resident   TRUE for resident, FALSE otherwise"]
    pub make_image_handle_resident: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            handle: u64,
            access: ::std::os::raw::c_uint,
            resident: bool,
        ),
    >,
    #[doc = " Call the given function from the driver thread.\n\n This is set by threaded contexts for use by debugging wrappers.\n\n \\param asap if true, run the callback immediately if there are no pending\n             commands to be processed by the driver thread"]
    pub callback: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            fn_: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
            data: *mut ::std::os::raw::c_void,
            asap: bool,
        ),
    >,
    #[doc = " Set a context parameter See enum pipe_context_param for more details."]
    pub set_context_param: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut pipe_context,
            param: pipe_context_param,
            value: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Creates a video buffer as decoding target, with modifiers."]
    pub create_video_buffer_with_modifiers: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            templat: *const pipe_video_buffer,
            modifiers: *const u64,
            modifiers_count: ::std::os::raw::c_uint,
        ) -> *mut pipe_video_buffer,
    >,
    #[doc = " Creates a video buffer as decoding target, from external memory"]
    pub video_buffer_from_handle: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            templat: *const pipe_video_buffer,
            handle: *mut winsys_handle,
            usage: ::std::os::raw::c_uint,
        ) -> *mut pipe_video_buffer,
    >,
    #[doc = " Compiles a ML subgraph, to be executed later. The returned pipe_ml_subgraph\n should contain all information needed to execute the subgraph with as\n little effort as strictly needed.\n\n \\param ctx         pipe context\n \\param operations  array containing the definitions of the operations in the graph\n \\param count       number of operations\n \\return            a newly allocated pipe_ml_subgraph"]
    pub ml_subgraph_create: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            operations: *const pipe_ml_operation,
            count: ::std::os::raw::c_uint,
        ) -> *mut pipe_ml_subgraph,
    >,
    #[doc = " Invokes a ML subgraph for a given input tensor.\n\n \\param ctx         pipe context\n \\param subgraph    previously-compiled subgraph\n \\param input       tensor to use as the input"]
    pub ml_subgraph_invoke: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            subgraph: *mut pipe_ml_subgraph,
            input: *mut pipe_tensor,
        ),
    >,
    #[doc = " After a ML subgraph has been invoked, copy the contents of the output\n tensors to the provided buffers.\n\n \\param ctx           pipe context\n \\param subgraph      previously-executed subgraph\n \\param outputs_count number of output tensors to copy out\n \\param output_idxs   array with the indices of output tensors\n \\param outputs       array of buffers to copy the tensor data to"]
    pub ml_subgraph_read_output: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut pipe_context,
            subgraph: *mut pipe_ml_subgraph,
            outputs_count: ::std::os::raw::c_uint,
            output_idxs: *mut [::std::os::raw::c_uint; 0usize],
            outputs: *mut [*mut ::std::os::raw::c_void; 0usize],
        ),
    >,
    #[doc = " Release all resources allocated by the implementation of ml_subgraph_create\n\n \\param ctx           pipe context\n \\param subgraph      subgraph to release"]
    pub ml_subgraph_destroy: ::std::option::Option<
        unsafe extern "C" fn(context: *mut pipe_context, subgraph: *mut pipe_ml_subgraph),
    >,
}
#[test]
fn bindgen_test_layout_pipe_context() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_context> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_context>(),
        1256usize,
        concat!("Size of: ", stringify!(pipe_context))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_context>(),
        8usize,
        concat!("Alignment of ", stringify!(pipe_context))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).screen) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(screen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priv_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(priv_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).draw) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(draw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vbuf) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(vbuf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stream_uploader) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(stream_uploader)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).const_uploader) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(const_uploader)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).debug) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).destroy) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(destroy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).draw_vbo) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(draw_vbo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).draw_vertex_state) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(draw_vertex_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).render_condition) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(render_condition)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).render_condition_mem) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(render_condition_mem)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_query) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_batch_query) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_batch_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).destroy_query) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(destroy_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).begin_query) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(begin_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_query) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(end_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_query_result) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_query_result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_query_result_resource) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_query_result_resource)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_active_query_state) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_active_query_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init_intel_perf_query_info) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(init_intel_perf_query_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_intel_perf_query_info) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_intel_perf_query_info)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).get_intel_perf_query_counter_info) as usize - ptr as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_intel_perf_query_counter_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).new_intel_perf_query_obj) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(new_intel_perf_query_obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).begin_intel_perf_query) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(begin_intel_perf_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_intel_perf_query) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(end_intel_perf_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_intel_perf_query) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_intel_perf_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait_intel_perf_query) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(wait_intel_perf_query)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_intel_perf_query_ready) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(is_intel_perf_query_ready)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_intel_perf_query_data) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_intel_perf_query_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).link_shader) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(link_shader)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_blend_state) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_blend_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_blend_state) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_blend_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_blend_state) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_blend_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_sampler_state) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_sampler_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_sampler_states) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_sampler_states)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_sampler_state) as usize - ptr as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_sampler_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_rasterizer_state) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_rasterizer_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_rasterizer_state) as usize - ptr as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_rasterizer_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_rasterizer_state) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_rasterizer_state)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).create_depth_stencil_alpha_state) as usize - ptr as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_depth_stencil_alpha_state)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).bind_depth_stencil_alpha_state) as usize - ptr as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_depth_stencil_alpha_state)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).delete_depth_stencil_alpha_state) as usize - ptr as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_depth_stencil_alpha_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_fs_state) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_fs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_fs_state) as usize - ptr as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_fs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_fs_state) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_fs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_vs_state) as usize - ptr as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_vs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_vs_state) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_vs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_vs_state) as usize - ptr as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_vs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_gs_state) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_gs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_gs_state) as usize - ptr as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_gs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_gs_state) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_gs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_tcs_state) as usize - ptr as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_tcs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_tcs_state) as usize - ptr as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_tcs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_tcs_state) as usize - ptr as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_tcs_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_tes_state) as usize - ptr as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_tes_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_tes_state) as usize - ptr as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_tes_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_tes_state) as usize - ptr as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_tes_state)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).create_vertex_elements_state) as usize - ptr as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_vertex_elements_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_vertex_elements_state) as usize - ptr as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_vertex_elements_state)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).delete_vertex_elements_state) as usize - ptr as usize
        },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_vertex_elements_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_ts_state) as usize - ptr as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_ts_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_ts_state) as usize - ptr as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_ts_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_ts_state) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_ts_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_ms_state) as usize - ptr as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_ms_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_ms_state) as usize - ptr as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_ms_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_ms_state) as usize - ptr as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_ms_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_blend_color) as usize - ptr as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_blend_color)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_stencil_ref) as usize - ptr as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_stencil_ref)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_sample_mask) as usize - ptr as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_sample_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_min_samples) as usize - ptr as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_min_samples)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_clip_state) as usize - ptr as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_clip_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_constant_buffer) as usize - ptr as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_constant_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_inlinable_constants) as usize - ptr as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_inlinable_constants)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_framebuffer_state) as usize - ptr as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_framebuffer_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_sample_locations) as usize - ptr as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_sample_locations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_polygon_stipple) as usize - ptr as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_polygon_stipple)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_scissor_states) as usize - ptr as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_scissor_states)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_window_rectangles) as usize - ptr as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_window_rectangles)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_viewport_states) as usize - ptr as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_viewport_states)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_sampler_views) as usize - ptr as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_sampler_views)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_tess_state) as usize - ptr as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_tess_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_patch_vertices) as usize - ptr as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_patch_vertices)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_debug_callback) as usize - ptr as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_debug_callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_shader_buffers) as usize - ptr as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_shader_buffers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_hw_atomic_buffers) as usize - ptr as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_hw_atomic_buffers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_shader_images) as usize - ptr as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_shader_images)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_vertex_buffers) as usize - ptr as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_vertex_buffers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_stream_output_target) as usize - ptr as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_stream_output_target)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).stream_output_target_destroy) as usize - ptr as usize
        },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(stream_output_target_destroy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_stream_output_targets) as usize - ptr as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_stream_output_targets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stream_output_target_offset) as usize - ptr as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(stream_output_target_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_frontend_noop) as usize - ptr as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_frontend_noop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).resource_copy_region) as usize - ptr as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(resource_copy_region)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blit) as usize - ptr as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(blit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clear) as usize - ptr as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(clear)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clear_render_target) as usize - ptr as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(clear_render_target)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clear_depth_stencil) as usize - ptr as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(clear_depth_stencil)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clear_texture) as usize - ptr as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(clear_texture)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clear_buffer) as usize - ptr as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(clear_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).evaluate_depth_buffer) as usize - ptr as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(evaluate_depth_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush) as usize - ptr as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(flush)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_fence_fd) as usize - ptr as usize },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_fence_fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fence_server_sync) as usize - ptr as usize },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(fence_server_sync)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fence_server_signal) as usize - ptr as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(fence_server_signal)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_sampler_view) as usize - ptr as usize },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_sampler_view)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sampler_view_destroy) as usize - ptr as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(sampler_view_destroy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_surface) as usize - ptr as usize },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_surface)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).surface_destroy) as usize - ptr as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(surface_destroy)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_map) as usize - ptr as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(buffer_map)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).transfer_flush_region) as usize - ptr as usize },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(transfer_flush_region)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_unmap) as usize - ptr as usize },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(buffer_unmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texture_map) as usize - ptr as usize },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(texture_map)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texture_unmap) as usize - ptr as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(texture_unmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_subdata) as usize - ptr as usize },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(buffer_subdata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texture_subdata) as usize - ptr as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(texture_subdata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).texture_barrier) as usize - ptr as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(texture_barrier)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory_barrier) as usize - ptr as usize },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(memory_barrier)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).resource_commit) as usize - ptr as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(resource_commit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_video_codec) as usize - ptr as usize },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_video_codec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_video_buffer) as usize - ptr as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_video_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_compute_state) as usize - ptr as usize },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_compute_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_compute_state) as usize - ptr as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(bind_compute_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_compute_state) as usize - ptr as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_compute_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_compute_state_info) as usize - ptr as usize },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_compute_state_info)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).get_compute_state_subgroup_size) as usize - ptr as usize
        },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_compute_state_subgroup_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_compute_resources) as usize - ptr as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_compute_resources)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_global_binding) as usize - ptr as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_global_binding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).launch_grid) as usize - ptr as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(launch_grid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).draw_mesh_tasks) as usize - ptr as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(draw_mesh_tasks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).svm_migrate) as usize - ptr as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(svm_migrate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_sample_position) as usize - ptr as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_sample_position)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_timestamp) as usize - ptr as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_timestamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_resource) as usize - ptr as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(flush_resource)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).invalidate_resource) as usize - ptr as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(invalidate_resource)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_device_reset_status) as usize - ptr as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(get_device_reset_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_device_reset_callback) as usize - ptr as usize },
        1104usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_device_reset_callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dump_debug_state) as usize - ptr as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(dump_debug_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_log_context) as usize - ptr as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_log_context)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).emit_string_marker) as usize - ptr as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(emit_string_marker)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).generate_mipmap) as usize - ptr as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(generate_mipmap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_texture_handle) as usize - ptr as usize },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_texture_handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_texture_handle) as usize - ptr as usize },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_texture_handle)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).make_texture_handle_resident) as usize - ptr as usize
        },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(make_texture_handle_resident)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create_image_handle) as usize - ptr as usize },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_image_handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).delete_image_handle) as usize - ptr as usize },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(delete_image_handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).make_image_handle_resident) as usize - ptr as usize },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(make_image_handle_resident)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        1192usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(callback)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_context_param) as usize - ptr as usize },
        1200usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(set_context_param)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).create_video_buffer_with_modifiers) as usize - ptr as usize
        },
        1208usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(create_video_buffer_with_modifiers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).video_buffer_from_handle) as usize - ptr as usize },
        1216usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(video_buffer_from_handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ml_subgraph_create) as usize - ptr as usize },
        1224usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(ml_subgraph_create)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ml_subgraph_invoke) as usize - ptr as usize },
        1232usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(ml_subgraph_invoke)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ml_subgraph_read_output) as usize - ptr as usize },
        1240usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(ml_subgraph_read_output)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ml_subgraph_destroy) as usize - ptr as usize },
        1248usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_context),
            "::",
            stringify!(ml_subgraph_destroy)
        )
    );
}
impl Default for pipe_context {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct tgsi_token {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_tgsi_token() {
    assert_eq!(
        ::std::mem::size_of::<tgsi_token>(),
        4usize,
        concat!("Size of: ", stringify!(tgsi_token))
    );
    assert_eq!(
        ::std::mem::align_of::<tgsi_token>(),
        4usize,
        concat!("Alignment of ", stringify!(tgsi_token))
    );
}
impl tgsi_token {
    #[inline]
    pub fn Type(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_Type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn NrTokens(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_NrTokens(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn Padding(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_Padding(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        Type: ::std::os::raw::c_uint,
        NrTokens: ::std::os::raw::c_uint,
        Padding: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let Type: u32 = unsafe { ::std::mem::transmute(Type) };
            Type as u64
        });
        __bindgen_bitfield_unit.set(4usize, 8u8, {
            let NrTokens: u32 = unsafe { ::std::mem::transmute(NrTokens) };
            NrTokens as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let Padding: u32 = unsafe { ::std::mem::transmute(Padding) };
            Padding as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Subregion of 1D/2D/3D image resource."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_box {
    pub x: i32,
    pub width: i32,
    pub y: i32,
    pub height: i32,
    pub z: i16,
    pub depth: i16,
}
#[test]
fn bindgen_test_layout_pipe_box() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_box> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_box>(),
        20usize,
        concat!("Size of: ", stringify!(pipe_box))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_box>(),
        4usize,
        concat!("Alignment of ", stringify!(pipe_box))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_box),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).width) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_box),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).y) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_box),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).height) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_box),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).z) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_box),
            "::",
            stringify!(z)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).depth) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_box),
            "::",
            stringify!(depth)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct pipe_reference {
    pub count: i32,
}
#[test]
fn bindgen_test_layout_pipe_reference() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_reference> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_reference>(),
        4usize,
        concat!("Size of: ", stringify!(pipe_reference))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_reference>(),
        4usize,
        concat!("Alignment of ", stringify!(pipe_reference))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_reference),
            "::",
            stringify!(count)
        )
    );
}
#[doc = " Primitive (point/line/tri) rasterization info"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct pipe_rasterizer_state {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 11usize]>,
    #[doc = " Replace the given TEXCOORD inputs with point coordinates, max. 8 inputs.\n If TEXCOORD (including PCOORD) are unsupported, replace GENERIC inputs\n instead. Max. 9 inputs: 8x GENERIC to emulate TEXCOORD, and 1x GENERIC\n to emulate PCOORD."]
    pub sprite_coord_enable: u16,
    pub line_width: ::std::os::raw::c_float,
    #[doc = "< used when no per-vertex size"]
    pub point_size: ::std::os::raw::c_float,
    pub offset_units: ::std::os::raw::c_float,
    pub offset_scale: ::std::os::raw::c_float,
    pub offset_clamp: ::std::os::raw::c_float,
    pub conservative_raster_dilate: ::std::os::raw::c_float,
}
#[test]
fn bindgen_test_layout_pipe_rasterizer_state() {
    const UNINIT: ::std::mem::MaybeUninit<pipe_rasterizer_state> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pipe_rasterizer_state>(),
        40usize,
        concat!("Size of: ", stringify!(pipe_rasterizer_state))
    );
    assert_eq!(
        ::std::mem::align_of::<pipe_rasterizer_state>(),
        4usize,
        concat!("Alignment of ", stringify!(pipe_rasterizer_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sprite_coord_enable) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(sprite_coord_enable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).line_width) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(line_width)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).point_size) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(point_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset_units) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(offset_units)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset_scale) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(offset_scale)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset_clamp) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(offset_clamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).conservative_raster_dilate) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(pipe_rasterizer_state),
            "::",
            stringify!(conservative_raster_dilate)
        )
    );
}
impl pipe_rasterizer_state {
    #[inline]
    pub fn flatshade(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_flatshade(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn light_twoside(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_light_twoside(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn clamp_vertex_color(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_clamp_vertex_color(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn clamp_fragment_color(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_clamp_fragment_color(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn front_ccw(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_front_ccw(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cull_face(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_cull_face(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, v