
/* Copyright © 2015-2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_entrypoints_gen.py, don't edit directly. */

#include "vn_entrypoints.h"

/* Weak aliases for all potential implementations. These will resolve to
 * NULL if they're not defined, which lets the resolve_entrypoint() function
 * either pick the correct entry point.
 *
 * MSVC uses different decorated names for 32-bit versus 64-bit. Declare
 * all argument sizes for 32-bit because computing the actual size would be
 * difficult.
 */




#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateInstance=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateInstance=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyInstance=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyInstance=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDevices@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumeratePhysicalDevices=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumeratePhysicalDevices=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetInstanceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetInstanceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetInstanceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL vn_GetInstanceProcAddr(VkInstance instance, const char* pName) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceVersion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumerateInstanceVersion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumerateInstanceVersion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumerateInstanceVersion(uint32_t* pApiVersion) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumerateInstanceLayerProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumerateInstanceLayerProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateInstanceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumerateInstanceExtensionProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumerateInstanceExtensionProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAndroidSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateAndroidSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateAndroidSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayPlaneSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDisplayPlaneSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDisplayPlaneSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroySurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroySurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_VI_NN
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateViSurfaceNN@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateViSurfaceNN=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateViSurfaceNN=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWaylandSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateWaylandSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateWaylandSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateWin32SurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateWin32SurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateWin32SurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXlibSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateXlibSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateXlibSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateXcbSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateXcbSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateXcbSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDirectFBSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDirectFBSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDirectFBSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImagePipeSurfaceFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateImagePipeSurfaceFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateImagePipeSurfaceFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateStreamDescriptorSurfaceGGP@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateStreamDescriptorSurfaceGGP=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateStreamDescriptorSurfaceGGP=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateScreenSurfaceQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateScreenSurfaceQNX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateScreenSurfaceQNX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDebugReportCallbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDebugReportCallbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDebugReportCallbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDebugReportCallbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugReportMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DebugReportMessageEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DebugReportMessageEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroups@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumeratePhysicalDeviceGroups=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumeratePhysicalDeviceGroups=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceGroupsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumeratePhysicalDeviceGroupsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumeratePhysicalDeviceGroupsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_IOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateIOSSurfaceMVK=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateIOSSurfaceMVK=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMacOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateMacOSSurfaceMVK=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateMacOSSurfaceMVK=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateMetalSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateMetalSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateMetalSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDebugUtilsMessengerEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDebugUtilsMessengerEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDebugUtilsMessengerEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDebugUtilsMessengerEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SubmitDebugUtilsMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SubmitDebugUtilsMessageEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SubmitDebugUtilsMessageEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateHeadlessSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateHeadlessSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateHeadlessSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif


const struct vk_instance_entrypoint_table vn_instance_entrypoints = {
    .CreateInstance = vn_CreateInstance,
    .DestroyInstance = vn_DestroyInstance,
    .EnumeratePhysicalDevices = vn_EnumeratePhysicalDevices,
    .GetInstanceProcAddr = vn_GetInstanceProcAddr,
    .EnumerateInstanceVersion = vn_EnumerateInstanceVersion,
    .EnumerateInstanceLayerProperties = vn_EnumerateInstanceLayerProperties,
    .EnumerateInstanceExtensionProperties = vn_EnumerateInstanceExtensionProperties,
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .CreateAndroidSurfaceKHR = vn_CreateAndroidSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateAndroidSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_ANDROID_KHR
    .CreateDisplayPlaneSurfaceKHR = vn_CreateDisplayPlaneSurfaceKHR,
    .DestroySurfaceKHR = vn_DestroySurfaceKHR,
#ifdef VK_USE_PLATFORM_VI_NN
    .CreateViSurfaceNN = vn_CreateViSurfaceNN,
#elif defined(_MSC_VER)
    .CreateViSurfaceNN = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .CreateWaylandSurfaceKHR = vn_CreateWaylandSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWaylandSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .CreateWin32SurfaceKHR = vn_CreateWin32SurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWin32SurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .CreateXlibSurfaceKHR = vn_CreateXlibSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXlibSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .CreateXcbSurfaceKHR = vn_CreateXcbSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXcbSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .CreateDirectFBSurfaceEXT = vn_CreateDirectFBSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateDirectFBSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
    .CreateImagePipeSurfaceFUCHSIA = vn_CreateImagePipeSurfaceFUCHSIA,
#elif defined(_MSC_VER)
    .CreateImagePipeSurfaceFUCHSIA = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
    .CreateStreamDescriptorSurfaceGGP = vn_CreateStreamDescriptorSurfaceGGP,
#elif defined(_MSC_VER)
    .CreateStreamDescriptorSurfaceGGP = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .CreateScreenSurfaceQNX = vn_CreateScreenSurfaceQNX,
#elif defined(_MSC_VER)
    .CreateScreenSurfaceQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .CreateDebugReportCallbackEXT = vn_CreateDebugReportCallbackEXT,
    .DestroyDebugReportCallbackEXT = vn_DestroyDebugReportCallbackEXT,
    .DebugReportMessageEXT = vn_DebugReportMessageEXT,
    .EnumeratePhysicalDeviceGroups = vn_EnumeratePhysicalDeviceGroups,
    .EnumeratePhysicalDeviceGroupsKHR = vn_EnumeratePhysicalDeviceGroupsKHR,
#ifdef VK_USE_PLATFORM_IOS_MVK
    .CreateIOSSurfaceMVK = vn_CreateIOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateIOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
    .CreateMacOSSurfaceMVK = vn_CreateMacOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateMacOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
    .CreateMetalSurfaceEXT = vn_CreateMetalSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateMetalSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_METAL_EXT
    .CreateDebugUtilsMessengerEXT = vn_CreateDebugUtilsMessengerEXT,
    .DestroyDebugUtilsMessengerEXT = vn_DestroyDebugUtilsMessengerEXT,
    .SubmitDebugUtilsMessageEXT = vn_SubmitDebugUtilsMessageEXT,
    .CreateHeadlessSurfaceEXT = vn_CreateHeadlessSurfaceEXT,
};



#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceQueueFamilyProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceQueueFamilyProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceMemoryProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceMemoryProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFeatures=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFeatures=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceImageFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceImageFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumerateDeviceLayerProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumerateDeviceLayerProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumerateDeviceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumerateDeviceExtensionProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumerateDeviceExtensionProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSparseImageFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSparseImageFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceDisplayPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceDisplayPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlanePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceDisplayPlanePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceDisplayPlanePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneSupportedDisplaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDisplayPlaneSupportedDisplaysKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDisplayPlaneSupportedDisplaysKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDisplayModePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDisplayModePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDisplayModeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDisplayModeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDisplayModeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDisplayPlaneCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDisplayPlaneCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfaceSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfaceSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfaceCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfaceCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormatsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfaceFormatsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfaceFormatsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfacePresentModesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfacePresentModesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWaylandPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceWaylandPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceWaylandPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vn_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceWin32PresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceWin32PresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceWin32PresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vn_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXlibPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceXlibPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceXlibPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vn_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceXcbPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceXcbPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceXcbPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vn_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDirectFBPresentationSupportEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceDirectFBPresentationSupportEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceDirectFBPresentationSupportEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vn_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceScreenPresentationSupportQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceScreenPresentationSupportQNX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceScreenPresentationSupportQNX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vn_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalImageFormatPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalImageFormatPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalImageFormatPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFeatures2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFeatures2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFeatures2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFeatures2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFeatures2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceImageFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceImageFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceImageFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceImageFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceQueueFamilyProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceQueueFamilyProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceQueueFamilyProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceQueueFamilyProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceMemoryProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceMemoryProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMemoryProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceMemoryProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceMemoryProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSparseImageFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSparseImageFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSparseImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSparseImageFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSparseImageFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalBufferProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalBufferProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalBufferPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalBufferPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalBufferPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphoreProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalSemaphoreProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalSemaphoreProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFenceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalFenceProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalFenceProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceExternalFencePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceExternalFencePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceExternalFencePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ReleaseDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ReleaseDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireXlibDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireXlibDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireXlibDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRandROutputDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRandROutputDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRandROutputDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireWinrtDisplayNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireWinrtDisplayNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetWinrtDisplayNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetWinrtDisplayNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfaceCapabilities2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfaceCapabilities2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDevicePresentRectanglesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDevicePresentRectanglesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDevicePresentRectanglesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceMultisamplePropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceMultisamplePropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceMultisamplePropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfaceCapabilities2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfaceCapabilities2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfaceFormats2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfaceFormats2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfaceFormats2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceDisplayProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceDisplayProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceDisplayPlaneProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceDisplayPlaneProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceDisplayPlaneProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayModeProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDisplayModeProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDisplayModeProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDisplayPlaneCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDisplayPlaneCapabilities2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDisplayPlaneCapabilities2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSurfacePresentModes2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSurfacePresentModes2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceToolProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceToolProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceToolPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceToolPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceToolPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceFragmentShadingRatesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceFragmentShadingRatesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceFragmentShadingRatesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceVideoCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceVideoCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileInfoKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoFormatPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceVideoFormatPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceVideoFormatPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo, VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireDrmDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireDrmDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDrmDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDrmDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceOpticalFlowImageFormatsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceOpticalFlowImageFormatsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceOpticalFlowImageFormatsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, const VkOpticalFlowImageFormatInfoNV* pOpticalFlowImageFormatInfo, uint32_t* pFormatCount, VkOpticalFlowImageFormatPropertiesNV* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesKHR* pProperties) __attribute__ ((weak));

#endif


const struct vk_physical_device_entrypoint_table vn_physical_device_entrypoints = {
    .GetPhysicalDeviceProperties = vn_GetPhysicalDeviceProperties,
    .GetPhysicalDeviceQueueFamilyProperties = vn_GetPhysicalDeviceQueueFamilyProperties,
    .GetPhysicalDeviceMemoryProperties = vn_GetPhysicalDeviceMemoryProperties,
    .GetPhysicalDeviceFeatures = vn_GetPhysicalDeviceFeatures,
    .GetPhysicalDeviceFormatProperties = vn_GetPhysicalDeviceFormatProperties,
    .GetPhysicalDeviceImageFormatProperties = vn_GetPhysicalDeviceImageFormatProperties,
    .CreateDevice = vn_CreateDevice,
    .EnumerateDeviceLayerProperties = vn_EnumerateDeviceLayerProperties,
    .EnumerateDeviceExtensionProperties = vn_EnumerateDeviceExtensionProperties,
    .GetPhysicalDeviceSparseImageFormatProperties = vn_GetPhysicalDeviceSparseImageFormatProperties,
    .GetPhysicalDeviceDisplayPropertiesKHR = vn_GetPhysicalDeviceDisplayPropertiesKHR,
    .GetPhysicalDeviceDisplayPlanePropertiesKHR = vn_GetPhysicalDeviceDisplayPlanePropertiesKHR,
    .GetDisplayPlaneSupportedDisplaysKHR = vn_GetDisplayPlaneSupportedDisplaysKHR,
    .GetDisplayModePropertiesKHR = vn_GetDisplayModePropertiesKHR,
    .CreateDisplayModeKHR = vn_CreateDisplayModeKHR,
    .GetDisplayPlaneCapabilitiesKHR = vn_GetDisplayPlaneCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceSupportKHR = vn_GetPhysicalDeviceSurfaceSupportKHR,
    .GetPhysicalDeviceSurfaceCapabilitiesKHR = vn_GetPhysicalDeviceSurfaceCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceFormatsKHR = vn_GetPhysicalDeviceSurfaceFormatsKHR,
    .GetPhysicalDeviceSurfacePresentModesKHR = vn_GetPhysicalDeviceSurfacePresentModesKHR,
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .GetPhysicalDeviceWaylandPresentationSupportKHR = vn_GetPhysicalDeviceWaylandPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWaylandPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceWin32PresentationSupportKHR = vn_GetPhysicalDeviceWin32PresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWin32PresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .GetPhysicalDeviceXlibPresentationSupportKHR = vn_GetPhysicalDeviceXlibPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXlibPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .GetPhysicalDeviceXcbPresentationSupportKHR = vn_GetPhysicalDeviceXcbPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXcbPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = vn_GetPhysicalDeviceDirectFBPresentationSupportEXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceScreenPresentationSupportQNX = vn_GetPhysicalDeviceScreenPresentationSupportQNX,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceScreenPresentationSupportQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceExternalImageFormatPropertiesNV = vn_GetPhysicalDeviceExternalImageFormatPropertiesNV,
    .GetPhysicalDeviceFeatures2 = vn_GetPhysicalDeviceFeatures2,
    .GetPhysicalDeviceFeatures2KHR = vn_GetPhysicalDeviceFeatures2KHR,
    .GetPhysicalDeviceProperties2 = vn_GetPhysicalDeviceProperties2,
    .GetPhysicalDeviceProperties2KHR = vn_GetPhysicalDeviceProperties2KHR,
    .GetPhysicalDeviceFormatProperties2 = vn_GetPhysicalDeviceFormatProperties2,
    .GetPhysicalDeviceFormatProperties2KHR = vn_GetPhysicalDeviceFormatProperties2KHR,
    .GetPhysicalDeviceImageFormatProperties2 = vn_GetPhysicalDeviceImageFormatProperties2,
    .GetPhysicalDeviceImageFormatProperties2KHR = vn_GetPhysicalDeviceImageFormatProperties2KHR,
    .GetPhysicalDeviceQueueFamilyProperties2 = vn_GetPhysicalDeviceQueueFamilyProperties2,
    .GetPhysicalDeviceQueueFamilyProperties2KHR = vn_GetPhysicalDeviceQueueFamilyProperties2KHR,
    .GetPhysicalDeviceMemoryProperties2 = vn_GetPhysicalDeviceMemoryProperties2,
    .GetPhysicalDeviceMemoryProperties2KHR = vn_GetPhysicalDeviceMemoryProperties2KHR,
    .GetPhysicalDeviceSparseImageFormatProperties2 = vn_GetPhysicalDeviceSparseImageFormatProperties2,
    .GetPhysicalDeviceSparseImageFormatProperties2KHR = vn_GetPhysicalDeviceSparseImageFormatProperties2KHR,
    .GetPhysicalDeviceExternalBufferProperties = vn_GetPhysicalDeviceExternalBufferProperties,
    .GetPhysicalDeviceExternalBufferPropertiesKHR = vn_GetPhysicalDeviceExternalBufferPropertiesKHR,
    .GetPhysicalDeviceExternalSemaphoreProperties = vn_GetPhysicalDeviceExternalSemaphoreProperties,
    .GetPhysicalDeviceExternalSemaphorePropertiesKHR = vn_GetPhysicalDeviceExternalSemaphorePropertiesKHR,
    .GetPhysicalDeviceExternalFenceProperties = vn_GetPhysicalDeviceExternalFenceProperties,
    .GetPhysicalDeviceExternalFencePropertiesKHR = vn_GetPhysicalDeviceExternalFencePropertiesKHR,
    .ReleaseDisplayEXT = vn_ReleaseDisplayEXT,
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .AcquireXlibDisplayEXT = vn_AcquireXlibDisplayEXT,
#elif defined(_MSC_VER)
    .AcquireXlibDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .GetRandROutputDisplayEXT = vn_GetRandROutputDisplayEXT,
#elif defined(_MSC_VER)
    .GetRandROutputDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireWinrtDisplayNV = vn_AcquireWinrtDisplayNV,
#elif defined(_MSC_VER)
    .AcquireWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetWinrtDisplayNV = vn_GetWinrtDisplayNV,
#elif defined(_MSC_VER)
    .GetWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfaceCapabilities2EXT = vn_GetPhysicalDeviceSurfaceCapabilities2EXT,
    .GetPhysicalDevicePresentRectanglesKHR = vn_GetPhysicalDevicePresentRectanglesKHR,
    .GetPhysicalDeviceMultisamplePropertiesEXT = vn_GetPhysicalDeviceMultisamplePropertiesEXT,
    .GetPhysicalDeviceSurfaceCapabilities2KHR = vn_GetPhysicalDeviceSurfaceCapabilities2KHR,
    .GetPhysicalDeviceSurfaceFormats2KHR = vn_GetPhysicalDeviceSurfaceFormats2KHR,
    .GetPhysicalDeviceDisplayProperties2KHR = vn_GetPhysicalDeviceDisplayProperties2KHR,
    .GetPhysicalDeviceDisplayPlaneProperties2KHR = vn_GetPhysicalDeviceDisplayPlaneProperties2KHR,
    .GetDisplayModeProperties2KHR = vn_GetDisplayModeProperties2KHR,
    .GetDisplayPlaneCapabilities2KHR = vn_GetDisplayPlaneCapabilities2KHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsKHR = vn_GetPhysicalDeviceCalibrateableTimeDomainsKHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsEXT = vn_GetPhysicalDeviceCalibrateableTimeDomainsEXT,
    .GetPhysicalDeviceCooperativeMatrixPropertiesNV = vn_GetPhysicalDeviceCooperativeMatrixPropertiesNV,
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfacePresentModes2EXT = vn_GetPhysicalDeviceSurfacePresentModes2EXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceSurfacePresentModes2EXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = vn_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
    .GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = vn_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
    .GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = vn_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
    .GetPhysicalDeviceToolProperties = vn_GetPhysicalDeviceToolProperties,
    .GetPhysicalDeviceToolPropertiesEXT = vn_GetPhysicalDeviceToolPropertiesEXT,
    .GetPhysicalDeviceFragmentShadingRatesKHR = vn_GetPhysicalDeviceFragmentShadingRatesKHR,
    .GetPhysicalDeviceVideoCapabilitiesKHR = vn_GetPhysicalDeviceVideoCapabilitiesKHR,
    .GetPhysicalDeviceVideoFormatPropertiesKHR = vn_GetPhysicalDeviceVideoFormatPropertiesKHR,
    .GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = vn_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR,
    .AcquireDrmDisplayEXT = vn_AcquireDrmDisplayEXT,
    .GetDrmDisplayEXT = vn_GetDrmDisplayEXT,
    .GetPhysicalDeviceOpticalFlowImageFormatsNV = vn_GetPhysicalDeviceOpticalFlowImageFormatsNV,
    .GetPhysicalDeviceCooperativeMatrixPropertiesKHR = vn_GetPhysicalDeviceCooperativeMatrixPropertiesKHR,
};



#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL vn_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceQueue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceQueue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueSubmit=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueSubmit=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DeviceWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DeviceWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AllocateMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AllocateMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_FreeMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_FreeMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_MapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_MapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_UnmapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_UnmapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_FlushMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_FlushMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_InvalidateMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceMemoryCommitment=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindBufferMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindBufferMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindImageMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindImageMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueBindSparse=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueBindSparse=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetFenceStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetFenceStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_WaitForFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_WaitForFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroySemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroySemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetEventStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetEventStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetQueryPoolEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetQueryPoolEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageSubresourceLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageSubresourceLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreatePipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreatePipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyPipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyPipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPipelineCacheData=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPipelineCacheData=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_MergePipelineCaches=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_MergePipelineCaches=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateGraphicsPipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateGraphicsPipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateComputePipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateComputePipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreatePipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreatePipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyPipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyPipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateSampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateSampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroySampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroySampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AllocateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AllocateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_FreeDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_FreeDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_UpdateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_UpdateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRenderAreaGranularity=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRenderAreaGranularity=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRenderingAreaGranularityKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRenderingAreaGranularityKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRenderingAreaGranularityKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfoKHR* pRenderingAreaInfo, VkExtent2D* pGranularity) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AllocateCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AllocateCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_FreeCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_FreeCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BeginCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BeginCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_EndCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_EndCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ResetCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ResetCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAttachmentFeedbackLoopEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetAttachmentFeedbackLoopEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetAttachmentFeedbackLoopEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetAttachmentFeedbackLoopEnableEXT(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetViewport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetViewport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetScissor=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetScissor=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetLineWidth=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetLineWidth=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthBias=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthBias=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetBlendConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetBlendConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthBounds=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthBounds=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilCompareMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilCompareMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilWriteMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilWriteMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilReference=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilReference=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindIndexBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindIndexBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindVertexBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindVertexBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDraw=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDraw=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndexed=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndexed=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMultiEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMultiEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMultiIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndexedIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDispatch=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDispatch=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDispatchIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDispatchIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSubpassShadingHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawClusterHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawClusterHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawClusterIndirectHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawClusterIndirectHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawClusterIndirectHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdatePipelineIndirectBufferNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdUpdatePipelineIndirectBufferNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdUpdatePipelineIndirectBufferNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBlitImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBlitImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyBufferToImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyBufferToImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyImageToBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyImageToBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyMemoryIndirectNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyMemoryIndirectNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToImageIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyMemoryToImageIndirectNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyMemoryToImageIndirectNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdUpdateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdUpdateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdFillBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdFillBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdClearColorImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdClearColorImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdClearDepthStencilImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdClearDepthStencilImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdClearAttachments=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdClearAttachments=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdResolveImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdResolveImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdWaitEvents=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdWaitEvents=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdPipelineBarrier=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdPipelineBarrier=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdWriteTimestamp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdWriteTimestamp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdPushConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdPushConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdNextSubpass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdNextSubpass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdExecuteCommands=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdExecuteCommands=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateSharedSwapchainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateSwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateSwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroySwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroySwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSwapchainImagesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSwapchainImagesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireNextImageKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireNextImageKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueuePresentKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueuePresentKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DebugMarkerSetObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DebugMarkerSetObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDebugMarkerBeginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDebugMarkerEndEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDebugMarkerInsertEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDebugMarkerInsertEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDebugMarkerInsertEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryWin32HandleNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryWin32HandleNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdExecuteGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdExecuteGeneratedCommandsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdExecuteGeneratedCommandsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPreprocessGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdPreprocessGeneratedCommandsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdPreprocessGeneratedCommandsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindPipelineShaderGroupNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindPipelineShaderGroupNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindPipelineShaderGroupNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetGeneratedCommandsMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetGeneratedCommandsMemoryRequirementsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetGeneratedCommandsMemoryRequirementsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateIndirectCommandsLayoutNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateIndirectCommandsLayoutNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyIndirectCommandsLayoutNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyIndirectCommandsLayoutNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdPushDescriptorSetKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdPushDescriptorSetKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_TrimCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_TrimCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_TrimCommandPoolKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_TrimCommandPoolKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_TrimCommandPoolKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryWin32HandlePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryWin32HandlePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryWin32HandlePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryFdPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryFdPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryFdPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryZirconHandleFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryZirconHandleFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryZirconHandlePropertiesFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryZirconHandlePropertiesFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryZirconHandlePropertiesFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryRemoteAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryRemoteAddressNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryRemoteAddressNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSemaphoreWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ImportSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ImportSemaphoreWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSemaphoreFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSemaphoreFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ImportSemaphoreFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ImportSemaphoreFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSemaphoreZirconHandleFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ImportSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ImportSemaphoreZirconHandleFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetFenceWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetFenceWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ImportFenceWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ImportFenceWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetFenceFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetFenceFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ImportFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ImportFenceFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ImportFenceFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DisplayPowerControlEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DisplayPowerControlEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DisplayPowerControlEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDeviceEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_RegisterDeviceEventEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_RegisterDeviceEventEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_RegisterDisplayEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_RegisterDisplayEventEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_RegisterDisplayEventEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainCounterEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSwapchainCounterEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSwapchainCounterEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceGroupPeerMemoryFeatures=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceGroupPeerMemoryFeatures=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPeerMemoryFeaturesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceGroupPeerMemoryFeaturesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceGroupPeerMemoryFeaturesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindBufferMemory2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindBufferMemory2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindBufferMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindBufferMemory2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindBufferMemory2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindImageMemory2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindImageMemory2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindImageMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindImageMemory2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindImageMemory2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDeviceMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDeviceMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDeviceMaskKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDeviceMaskKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDeviceMaskKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupPresentCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceGroupPresentCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceGroupPresentCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceGroupSurfacePresentModesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceGroupSurfacePresentModesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireNextImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireNextImage2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireNextImage2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBase@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDispatchBase=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDispatchBase=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDispatchBaseKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDispatchBaseKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDispatchBaseKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDescriptorUpdateTemplate=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDescriptorUpdateTemplate=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDescriptorUpdateTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDescriptorUpdateTemplate=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDescriptorUpdateTemplate=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDescriptorUpdateTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_UpdateDescriptorSetWithTemplate=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_UpdateDescriptorSetWithTemplate=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UpdateDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_UpdateDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_UpdateDescriptorSetWithTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdPushDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdPushDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdPushDescriptorSetWithTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetHdrMetadataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SetHdrMetadataEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SetHdrMetadataEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainStatusKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSwapchainStatusKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSwapchainStatusKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRefreshCycleDurationGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRefreshCycleDurationGOOGLE=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRefreshCycleDurationGOOGLE=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPastPresentationTimingGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPastPresentationTimingGOOGLE=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPastPresentationTimingGOOGLE=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWScalingNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetViewportWScalingNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetViewportWScalingNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDiscardRectangleEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDiscardRectangleEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDiscardRectangleEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDiscardRectangleEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDiscardRectangleModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDiscardRectangleModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDiscardRectangleModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleLocationsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetSampleLocationsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetSampleLocationsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferMemoryRequirements2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferMemoryRequirements2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferMemoryRequirements2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferMemoryRequirements2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageMemoryRequirements2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageMemoryRequirements2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageMemoryRequirements2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageMemoryRequirements2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageSparseMemoryRequirements2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageSparseMemoryRequirements2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageSparseMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageSparseMemoryRequirements2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageSparseMemoryRequirements2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceBufferMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceBufferMemoryRequirementsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceBufferMemoryRequirementsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceImageMemoryRequirementsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceImageMemoryRequirementsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceImageSparseMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceImageSparseMemoryRequirementsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceImageSparseMemoryRequirementsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateSamplerYcbcrConversion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateSamplerYcbcrConversion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateSamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateSamplerYcbcrConversionKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateSamplerYcbcrConversionKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroySamplerYcbcrConversion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroySamplerYcbcrConversion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroySamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroySamplerYcbcrConversionKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroySamplerYcbcrConversionKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceQueue2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceQueue2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceQueue2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateValidationCacheEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateValidationCacheEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyValidationCacheEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyValidationCacheEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetValidationCacheDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetValidationCacheDataEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetValidationCacheDataEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_MergeValidationCachesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_MergeValidationCachesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_MergeValidationCachesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDescriptorSetLayoutSupport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDescriptorSetLayoutSupport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDescriptorSetLayoutSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDescriptorSetLayoutSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDescriptorSetLayoutSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSwapchainGrallocUsageANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSwapchainGrallocUsageANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSwapchainGrallocUsage2ANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSwapchainGrallocUsage2ANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSwapchainGrallocUsage2ANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireImageANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireImageANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSignalReleaseImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueSignalReleaseImageANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueSignalReleaseImageANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetShaderInfoAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetShaderInfoAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetShaderInfoAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetLocalDimmingAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SetLocalDimmingAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SetLocalDimmingAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetCalibratedTimestampsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetCalibratedTimestampsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetCalibratedTimestampsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetCalibratedTimestampsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetCalibratedTimestampsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SetDebugUtilsObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SetDebugUtilsObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SetDebugUtilsObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SetDebugUtilsObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SetDebugUtilsObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueBeginDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueBeginDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueBeginDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueEndDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueEndDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueEndDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_QueueEndDebugUtilsLabelEXT(VkQueue queue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueInsertDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueInsertDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueInsertDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdInsertDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdInsertDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdInsertDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryHostPointerPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryHostPointerPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryHostPointerPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteBufferMarkerAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdWriteBufferMarkerAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdWriteBufferMarkerAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateRenderPass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateRenderPass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateRenderPass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateRenderPass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginRenderPass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginRenderPass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginRenderPass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginRenderPass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdNextSubpass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdNextSubpass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdNextSubpass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdNextSubpass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdNextSubpass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndRenderPass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndRenderPass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndRenderPass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndRenderPass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSemaphoreCounterValue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSemaphoreCounterValue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetSemaphoreCounterValueKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetSemaphoreCounterValueKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetSemaphoreCounterValueKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphores@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_WaitSemaphores=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_WaitSemaphores=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WaitSemaphoresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_WaitSemaphoresKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_WaitSemaphoresKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SignalSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SignalSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_SignalSemaphoreKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_SignalSemaphoreKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_SignalSemaphoreKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAndroidHardwareBufferPropertiesANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetAndroidHardwareBufferPropertiesANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetAndroidHardwareBufferPropertiesANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetMemoryAndroidHardwareBufferANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetMemoryAndroidHardwareBufferANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetMemoryAndroidHardwareBufferANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndirectCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndirectCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndirectCountKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndirectCountKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectCountAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndirectCountAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndirectCountAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndexedIndirectCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndexedIndirectCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndexedIndirectCountKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndexedIndirectCountKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndexedIndirectCountAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndexedIndirectCountAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndexedIndirectCountAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCheckpointNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetCheckpointNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetCheckpointNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetQueueCheckpointDataNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetQueueCheckpointDataNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetQueueCheckpointDataNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindTransformFeedbackBuffersEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindTransformFeedbackBuffersEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindTransformFeedbackBuffersEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginTransformFeedbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginTransformFeedbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginTransformFeedbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndTransformFeedbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndTransformFeedbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndTransformFeedbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBeginQueryIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBeginQueryIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBeginQueryIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdEndQueryIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdEndQueryIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdEndQueryIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawIndirectByteCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawIndirectByteCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawIndirectByteCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetExclusiveScissorNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetExclusiveScissorNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExclusiveScissorEnableNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetExclusiveScissorEnableNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetExclusiveScissorEnableNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindShadingRateImageNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindShadingRateImageNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindShadingRateImageNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportShadingRatePaletteNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetViewportShadingRatePaletteNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetViewportShadingRatePaletteNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCoarseSampleOrderNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetCoarseSampleOrderNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetCoarseSampleOrderNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMeshTasksNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMeshTasksNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMeshTasksIndirectNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMeshTasksIndirectNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMeshTasksIndirectCountNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMeshTasksIndirectCountNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMeshTasksEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMeshTasksEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMeshTasksEXT(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMeshTasksIndirectEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMeshTasksIndirectEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMeshTasksIndirectEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdDrawMeshTasksIndirectCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdDrawMeshTasksIndirectCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdDrawMeshTasksIndirectCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdDrawMeshTasksIndirectCountEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CompileDeferredNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CompileDeferredNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CompileDeferredNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindInvocationMaskHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindInvocationMaskHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindInvocationMaskHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetAccelerationStructureMemoryRequirementsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetAccelerationStructureMemoryRequirementsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BindAccelerationStructureMemoryNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BindAccelerationStructureMemoryNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BindAccelerationStructureMemoryNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CopyAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CopyAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyAccelerationStructureToMemoryKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyAccelerationStructureToMemoryKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyAccelerationStructureToMemoryKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyAccelerationStructureToMemoryKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CopyAccelerationStructureToMemoryKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CopyAccelerationStructureToMemoryKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdCopyMemoryToAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdCopyMemoryToAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdCopyMemoryToAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CopyMemoryToAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CopyMemoryToAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CopyMemoryToAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdWriteAccelerationStructuresPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdWriteAccelerationStructuresPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdWriteAccelerationStructuresPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdWriteAccelerationStructuresPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdWriteAccelerationStructuresPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBuildAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBuildAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_WriteAccelerationStructuresPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_WriteAccelerationStructuresPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_WriteAccelerationStructuresPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdTraceRaysKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdTraceRaysKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdTraceRaysNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdTraceRaysNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRayTracingShaderGroupHandlesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRayTracingShaderGroupHandlesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupHandlesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRayTracingShaderGroupHandlesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRayTracingShaderGroupHandlesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureHandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetAccelerationStructureHandleNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetAccelerationStructureHandleNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateRayTracingPipelinesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateRayTracingPipelinesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateRayTracingPipelinesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateRayTracingPipelinesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateRayTracingPipelinesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirectKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdTraceRaysIndirectKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdTraceRaysIndirectKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdTraceRaysIndirect2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdTraceRaysIndirect2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdTraceRaysIndirect2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceAccelerationStructureCompatibilityKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceAccelerationStructureCompatibilityKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceAccelerationStructureCompatibilityKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetRayTracingShaderGroupStackSizeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetRayTracingShaderGroupStackSizeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetRayTracingShaderGroupStackSizeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceSize VKAPI_CALL vn_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRayTracingPipelineStackSizeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetRayTracingPipelineStackSizeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetRayTracingPipelineStackSizeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewHandleNVX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageViewHandleNVX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageViewHandleNVX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint32_t VKAPI_CALL vn_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageViewAddressNVX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageViewAddressNVX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageViewAddressNVX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceGroupSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceGroupSurfacePresentModes2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceGroupSurfacePresentModes2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireFullScreenExclusiveModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireFullScreenExclusiveModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireFullScreenExclusiveModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseFullScreenExclusiveModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ReleaseFullScreenExclusiveModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ReleaseFullScreenExclusiveModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquireProfilingLockKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquireProfilingLockKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquireProfilingLockKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleaseProfilingLockKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ReleaseProfilingLockKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ReleaseProfilingLockKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_ReleaseProfilingLockKHR(VkDevice device) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetImageDrmFormatModifierPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetImageDrmFormatModifierPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetImageDrmFormatModifierPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferOpaqueCaptureAddress=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferOpaqueCaptureAddress=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vn_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferOpaqueCaptureAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferOpaqueCaptureAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferOpaqueCaptureAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vn_GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferDeviceAddress=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferDeviceAddress=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vn_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferDeviceAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferDeviceAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vn_GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetBufferDeviceAddressEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetBufferDeviceAddressEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetBufferDeviceAddressEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vn_GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_InitializePerformanceApiINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_InitializePerformanceApiINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_InitializePerformanceApiINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_UninitializePerformanceApiINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_UninitializePerformanceApiINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_UninitializePerformanceApiINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_UninitializePerformanceApiINTEL(VkDevice device) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceMarkerINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPerformanceMarkerINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPerformanceMarkerINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceStreamMarkerINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPerformanceStreamMarkerINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPerformanceStreamMarkerINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPerformanceOverrideINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPerformanceOverrideINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPerformanceOverrideINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_AcquirePerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_AcquirePerformanceConfigurationINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_AcquirePerformanceConfigurationINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_ReleasePerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_ReleasePerformanceConfigurationINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_ReleasePerformanceConfigurationINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_QueueSetPerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_QueueSetPerformanceConfigurationINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_QueueSetPerformanceConfigurationINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPerformanceParameterINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPerformanceParameterINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPerformanceParameterINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceMemoryOpaqueCaptureAddress=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceMemoryOpaqueCaptureAddress=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vn_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeviceMemoryOpaqueCaptureAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeviceMemoryOpaqueCaptureAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeviceMemoryOpaqueCaptureAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vn_GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutablePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPipelineExecutablePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPipelineExecutablePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableStatisticsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPipelineExecutableStatisticsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPipelineExecutableStatisticsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineExecutableInternalRepresentationsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPipelineExecutableInternalRepresentationsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPipelineExecutableInternalRepresentationsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetLineStippleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetLineStippleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLineStippleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetLineStippleEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetLineStippleEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBuildAccelerationStructuresKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBuildAccelerationStructuresKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBuildAccelerationStructuresIndirectKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBuildAccelerationStructuresIndirectKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBuildAccelerationStructuresIndirectKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_BuildAccelerationStructuresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_BuildAccelerationStructuresKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_BuildAccelerationStructuresKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetAccelerationStructureDeviceAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetAccelerationStructureDeviceAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetAccelerationStructureDeviceAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vn_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CreateDeferredOperationKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CreateDeferredOperationKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CreateDeferredOperationKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DestroyDeferredOperationKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DestroyDeferredOperationKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DestroyDeferredOperationKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationMaxConcurrencyKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeferredOperationMaxConcurrencyKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeferredOperationMaxConcurrencyKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint32_t VKAPI_CALL vn_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetDeferredOperationResultKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetDeferredOperationResultKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetDeferredOperationResultKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_DeferredOperationJoinKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_DeferredOperationJoinKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_DeferredOperationJoinKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vn_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPipelineIndirectMemoryRequirementsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPipelineIndirectMemoryRequirementsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_GetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_GetPipelineIndirectDeviceAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_GetPipelineIndirectDeviceAddressNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_GetPipelineIndirectDeviceAddressNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vn_GetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullMode@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetCullMode=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetCullMode=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetCullModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetCullModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetCullModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFace@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetFrontFace=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetFrontFace=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetFrontFaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetFrontFaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetFrontFaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopology@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPrimitiveTopology=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPrimitiveTopology=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveTopologyEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPrimitiveTopologyEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPrimitiveTopologyEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetViewportWithCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetViewportWithCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetViewportWithCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetViewportWithCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetViewportWithCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetScissorWithCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetScissorWithCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetScissorWithCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetScissorWithCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetScissorWithCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindIndexBuffer2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindIndexBuffer2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindIndexBuffer2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindVertexBuffers2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindVertexBuffers2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdBindVertexBuffers2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdBindVertexBuffers2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdBindVertexBuffers2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthTestEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthTestEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthTestEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthTestEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthWriteEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthWriteEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthWriteEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthWriteEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthWriteEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthCompareOp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthCompareOp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthCompareOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthCompareOpEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthCompareOpEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthBoundsTestEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthBoundsTestEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBoundsTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthBoundsTestEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthBoundsTestEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilTestEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilTestEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilTestEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilTestEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilOp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilOp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetStencilOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetStencilOpEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetStencilOpEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPatchControlPointsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPatchControlPointsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPatchControlPointsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetRasterizerDiscardEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetRasterizerDiscardEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizerDiscardEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetRasterizerDiscardEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetRasterizerDiscardEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthBiasEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthBiasEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthBiasEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthBiasEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthBiasEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetLogicOpEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetLogicOpEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPrimitiveRestartEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPrimitiveRestartEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPrimitiveRestartEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPrimitiveRestartEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPrimitiveRestartEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetTessellationDomainOriginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetTessellationDomainOriginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetTessellationDomainOriginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetDepthClampEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetDepthClampEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetDepthClampEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetPolygonModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetPolygonModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetPolygonModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationSamplesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetRasterizationSamplesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetRasterizationSamplesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetSampleMaskEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetSampleMaskEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetSampleMaskEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToCoverageEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetAlphaToCoverageEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetAlphaToCoverageEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetAlphaToOneEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetAlphaToOneEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetAlphaToOneEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetLogicOpEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetLogicOpEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetLogicOpEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetColorBlendEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetColorBlendEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorBlendEquationEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetColorBlendEquationEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetColorBlendEquationEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetColorWriteMaskEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetColorWriteMaskEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetColorWriteMaskEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetRasterizationStreamEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetRasterizationStreamEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetRasterizationStreamEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetConservativeRasterizationModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vn_CmdSetConservativeRasterizationModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#vn_CmdSetConservativeRasterizationModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vn_CmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vn_CmdSetExtraPrimitiveOverestimationSizeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExtraPrimitiveOverestimationSizeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExtraPrimitiveOverestimationSizeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExtraPrimitiveOverestimationSizeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExtraPrimitiveOverestimationSizeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_CmdSetExtraPrimitiveOverestimationSizeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vn_