/* Generated by wayland-scanner 1.22.0 */

#ifndef GAMESCOPE_PIPEWIRE_SERVER_PROTOCOL_H
#define GAMESCOPE_PIPEWIRE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_gamescope_pipewire The gamescope_pipewire protocol
 * gamescope-specific PipeWire protocol
 *
 * @section page_desc_gamescope_pipewire Description
 *
 * This is a private Gamescope protocol. Regular Wayland clients must not use
 * it.
 *
 * @section page_ifaces_gamescope_pipewire Interfaces
 * - @subpage page_iface_gamescope_pipewire - 
 * @section page_copyright_gamescope_pipewire Copyright
 * <pre>
 *
 * Copyright © 2021 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_pipewire;

#ifndef GAMESCOPE_PIPEWIRE_INTERFACE
#define GAMESCOPE_PIPEWIRE_INTERFACE
/**
 * @page page_iface_gamescope_pipewire gamescope_pipewire
 * @section page_iface_gamescope_pipewire_api API
 * See @ref iface_gamescope_pipewire.
 */
/**
 * @defgroup iface_gamescope_pipewire The gamescope_pipewire interface
 */
extern const struct wl_interface gamescope_pipewire_interface;
#endif

/**
 * @ingroup iface_gamescope_pipewire
 * @struct gamescope_pipewire_interface
 */
struct gamescope_pipewire_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define GAMESCOPE_PIPEWIRE_STREAM_NODE 0

/**
 * @ingroup iface_gamescope_pipewire
 */
#define GAMESCOPE_PIPEWIRE_STREAM_NODE_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_pipewire
 */
#define GAMESCOPE_PIPEWIRE_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_pipewire
 * Sends an stream_node event to the client owning the resource.
 * @param resource_ The client's resource
 * @param node_id PipeWire stream node ID
 */
static inline void
gamescope_pipewire_send_stream_node(struct wl_resource *resource_, uint32_t node_id)
{
	wl_resource_post_event(resource_, GAMESCOPE_PIPEWIRE_STREAM_NODE, node_id);
}

#ifdef  __cplusplus
}
#endif

#endif
